/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.isqlviewer.core.CorePlugin;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PluginFactory {
    private static final String MANIFEST_PLUGIN_SECTION = "isql:plugins";
    private static final String CACHE_FILE = "isql-plugins.xml";
    private Hashtable mapPlugins = new Hashtable();
    private ArrayList entryList = new ArrayList();
    private long lastDetection = 0L;
    private boolean isLoaded = false;

    public Collection createTableFilters() {
        return this.createPluginsForType(1);
    }

    public Collection createDataRenderers() {
        return this.createPluginsForType(2);
    }

    public Collection createImportHandlers() {
        return this.createPluginsForType(3);
    }

    public Collection createPluginsForType(int n2) {
        this.checkState();
        HashMap hashMap = (HashMap)this.mapPlugins.get(Integer.toString(n2));
        if (hashMap != null) {
            ArrayList<CorePlugin> arrayList = new ArrayList<CorePlugin>(hashMap.size());
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                PluginEntry pluginEntry = (PluginEntry)hashMap.get(string);
                try {
                    CorePlugin corePlugin = pluginEntry.createInstance(string, true);
                    if (corePlugin == null || corePlugin.getType() != n2) continue;
                    arrayList.add(corePlugin);
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
            }
            return arrayList;
        }
        return Arrays.asList(new CorePlugin[0]);
    }

    public int getCountForType(int n2) {
        this.checkState();
        HashMap hashMap = (HashMap)this.mapPlugins.get(Integer.toString(n2));
        return hashMap.size();
    }

    public CorePlugin pluginForName(int n2, String string) {
        this.checkState();
        HashMap hashMap = (HashMap)this.mapPlugins.get(Integer.toString(n2));
        PluginEntry pluginEntry = (PluginEntry)hashMap.get(string);
        if (pluginEntry != null) {
            return pluginEntry.createInstance(string, true);
        }
        return null;
    }

    public static PluginFactory createInstance() {
        return new PluginFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        File file = new File(PluginFactory.getPluginCacheDirectory(), CACHE_FILE);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.store(fileOutputStream);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            fileOutputStream = null;
        }
        this.destroyEntries();
    }

    private void destroyEntries() {
        Iterator iterator = this.mapPlugins.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap = (HashMap)this.mapPlugins.get(iterator.next());
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                PluginEntry pluginEntry = (PluginEntry)hashMap.get(iterator2.next());
                pluginEntry.pluginLoader = null;
                iterator2.remove();
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        File file = new File(PluginFactory.getPluginCacheDirectory(), CACHE_FILE);
        this.installDefaultPlugins();
        if (file.exists() && file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                XMLReader xMLReader = SystemConfig.getInstance().getXMLReader();
                xMLReader.setContentHandler(new CacheLoader(this));
                xMLReader.parse(new InputSource(fileInputStream));
            }
            catch (Throwable throwable) {
            }
            finally {
                fileInputStream.close();
            }
        } else if (!file.exists()) {
            this.detectPlugins();
        }
        this.isLoaded = true;
    }

    private void checkState() {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (IOException iOException) {
                BasicUtilities.HandleException(iOException);
            }
        }
    }

    private void store(OutputStream outputStream) {
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        printWriter.print("<?xml version=\"1.0\" encoding=\"");
        printWriter.print(charset.name());
        printWriter.println("\" ?>");
        printWriter.print("<");
        printWriter.print(CacheLoader.TAG_ROOT);
        printWriter.print(" ");
        printWriter.print(CacheLoader.ATTR_CACHE_TIMESTAMP);
        printWriter.print("=\"");
        printWriter.print(Long.toString(this.lastDetection));
        printWriter.println("\" >");
        Iterator iterator = this.entryList.iterator();
        while (iterator.hasNext()) {
            PluginEntry pluginEntry = (PluginEntry)iterator.next();
            Collection collection = pluginEntry.getMetadata();
            if (pluginEntry.isInternal() || collection.size() <= 0) continue;
            printWriter.print("\t<");
            printWriter.print(CacheLoader.TAG_PLUGIN);
            printWriter.print(" ");
            printWriter.print(CacheLoader.ATTR_PLUGIN_FILE);
            printWriter.print("=\"");
            printWriter.print(StringUtilities.encodeXMLEntities(pluginEntry.jarLocation.getAbsolutePath()));
            printWriter.println("\" >");
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                PluginMetaInfo pluginMetaInfo = (PluginMetaInfo)iterator2.next();
                printWriter.print("\t\t<");
                printWriter.print(CacheLoader.TAG_ENTRY);
                printWriter.print(" ");
                printWriter.print(CacheLoader.ATTR_PLUGIN_CLASS);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities(pluginMetaInfo.className));
                printWriter.print("\" ");
                printWriter.print(CacheLoader.ATTR_PLUGIN_NAME);
                printWriter.print("=\"");
                printWriter.print(StringUtilities.encodeXMLEntities(pluginMetaInfo.pluginName));
                printWriter.print("\" ");
                printWriter.print(CacheLoader.ATTR_PLUGIN_TYPE);
                printWriter.print("=\"");
                printWriter.print(Integer.toString(pluginMetaInfo.pluginType));
                printWriter.println("\" />");
            }
            if (pluginEntry.classPath.size() > 1) {
                printWriter.print("\t\t<");
                printWriter.print(CacheLoader.TAG_PLUGIN_CLASSPATH);
                printWriter.println(">");
                for (int i2 = 1; i2 < pluginEntry.classPath.size(); ++i2) {
                    URL uRL = (URL)pluginEntry.classPath.get(i2);
                    printWriter.print("\t\t\t<");
                    printWriter.print(CacheLoader.TAG_JAR);
                    printWriter.print(" ");
                    printWriter.print(CacheLoader.ATTR_PLUGIN_FILE);
                    printWriter.print("=\"");
                    printWriter.print(StringUtilities.encodeXMLEntities(uRL.toExternalForm()));
                    printWriter.println("\" />");
                }
                printWriter.print("\t\t</");
                printWriter.print(CacheLoader.TAG_PLUGIN_CLASSPATH);
                printWriter.println(">");
            }
            printWriter.print("\t</");
            printWriter.print(CacheLoader.TAG_PLUGIN);
            printWriter.println(">");
        }
        printWriter.print("</");
        printWriter.print(CacheLoader.TAG_ROOT);
        printWriter.println(">");
        printWriter.flush();
        printWriter.close();
        printWriter = null;
    }

    private void detectPlugins() {
        System.out.println(BasicUtilities.getString("Detecting_Plugins"));
        File[] fileArray = PluginFactory.getPluginFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                JarFile jarFile = new JarFile(fileArray[i2]);
                this.registerEntry(new PluginEntry(fileArray[i2], jarFile, null));
                continue;
            }
            catch (IOException iOException) {
                BasicUtilities.HandleException(iOException);
            }
        }
        this.lastDetection = System.currentTimeMillis();
    }

    private void installDefaultPlugins() {
        this.destroyEntries();
        PluginEntry pluginEntry = new PluginEntry(PluginFactory.getDefaultPlugins(), null);
        this.registerEntry(pluginEntry);
    }

    private void registerEntry(PluginEntry pluginEntry) {
        Collection collection = pluginEntry.getMetadata();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PluginMetaInfo pluginMetaInfo = (PluginMetaInfo)iterator.next();
            String string = Integer.toString(pluginMetaInfo.pluginType);
            HashMap<String, PluginEntry> hashMap = (HashMap<String, PluginEntry>)this.mapPlugins.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, PluginEntry>();
                this.mapPlugins.put(string, hashMap);
            }
            hashMap.put(pluginMetaInfo.className, pluginEntry);
        }
        if (!this.entryList.contains(pluginEntry) && !pluginEntry.isInternal()) {
            this.entryList.add(pluginEntry);
        }
    }

    private static File getPluginDirectory() {
        return SystemConfig.getiSQLSubDir(BasicUtilities.getString("Extension_Folder"));
    }

    private static File getPluginCacheDirectory() {
        File file = new File(SystemConfig.getBaseDirectory(), ".plugin-cache");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static File[] getPluginFiles() {
        JarFileNameFilter jarFileNameFilter = new JarFileNameFilter(null);
        return PluginFactory.getPluginDirectory().listFiles(jarFileNameFilter);
    }

    private static String[] getDefaultPlugins() {
        return new String[]{"org.isqlviewer.core.jetfire.ColumnSkipPlugin", "org.isqlviewer.core.jetfire.MapperPlugin", "org.isqlviewer.core.jetfire.AutovaluePlugin", "org.isqlviewer.core.jetfire.LookupPlugin", "org.isqlviewer.core.filters.CSVTableFilter", "org.isqlviewer.core.filters.ExcelTableFilter", "org.isqlviewer.core.filters.HTMLTableFilter", "org.isqlviewer.core.filters.XMLTableFilter", "org.isqlviewer.core.filters.LOBTableFilter", "org.isqlviewer.core.filters.SolverTableFilter", "org.isqlviewer.core.renderers.BinaryRenderer", "org.isqlviewer.core.renderers.ImageRenderer", "org.isqlviewer.core.renderers.TextRenderer"};
    }

    public static class 1 {
    }

    private static class CacheLoader
    extends DefaultHandler {
        private static String TAG_ROOT = "isql-plugin-cache";
        private static String TAG_PLUGIN = "plugin-entry";
        private static String TAG_ENTRY = "plugin";
        private static String TAG_PLUGIN_CLASSPATH = "classpath";
        private static String TAG_JAR = "jar";
        private static String ATTR_CACHE_TIMESTAMP = "timestamp";
        private static String ATTR_PLUGIN_CLASS = "classname";
        private static String ATTR_PLUGIN_TYPE = "type";
        private static String ATTR_PLUGIN_NAME = "name";
        private static String ATTR_PLUGIN_FILE = "location";
        private PluginFactory instance = null;
        private PluginEntry currentEntry = null;
        private boolean loadOverride = false;

        public void endDocument() {
            if (this.loadOverride) {
                this.instance.installDefaultPlugins();
                this.instance.detectPlugins();
            }
        }

        public CacheLoader(PluginFactory pluginFactory) {
            this.instance = pluginFactory;
        }

        public void endElement(String string, String string2, String string3) {
            if (!this.loadOverride && string2.equalsIgnoreCase(TAG_PLUGIN)) {
                this.instance.registerEntry(this.currentEntry);
                this.currentEntry = null;
            }
        }

        public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) {
            if (string2.equalsIgnoreCase(TAG_ROOT)) {
                long l2 = Long.parseLong(attributes.getValue(ATTR_CACHE_TIMESTAMP));
                this.loadOverride = l2 < PluginFactory.getPluginDirectory().lastModified();
                this.instance.lastDetection = l2;
            } else if (!this.loadOverride) {
                if (string2.equalsIgnoreCase(TAG_PLUGIN)) {
                    String string4 = attributes.getValue(ATTR_PLUGIN_FILE);
                    this.currentEntry = new PluginEntry(string4, null);
                } else if (this.currentEntry != null && string2.equalsIgnoreCase(TAG_ENTRY)) {
                    try {
                        String string5 = attributes.getValue(ATTR_PLUGIN_CLASS);
                        String string6 = attributes.getValue(ATTR_PLUGIN_NAME);
                        int n2 = Integer.parseInt(attributes.getValue(ATTR_PLUGIN_TYPE));
                        PluginMetaInfo pluginMetaInfo = new PluginMetaInfo(null);
                        pluginMetaInfo.className = string5;
                        pluginMetaInfo.pluginType = n2;
                        pluginMetaInfo.pluginName = string6;
                        this.currentEntry.addCachedMetadata(pluginMetaInfo);
                    }
                    catch (Throwable throwable) {}
                } else if (this.currentEntry != null && string2.equalsIgnoreCase(TAG_JAR)) {
                    try {
                        String string7 = attributes.getValue(ATTR_PLUGIN_FILE);
                        this.currentEntry.addCachedURL(new URL(string7));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class JarFileNameFilter
    implements FilenameFilter {
        private JarFileNameFilter() {
        }

        public boolean accept(File file, String string) {
            int n2 = string.lastIndexOf(46) + 1;
            String string2 = string.substring(n2 < 0 ? 0 : n2);
            return string2.equalsIgnoreCase("jar");
        }

        public /* synthetic */ JarFileNameFilter(1 var1_1) {
            this();
        }
    }

    private static class PluginEntry {
        private ClassLoader pluginLoader = null;
        private ArrayList classPath = new ArrayList();
        private ArrayList plugins = new ArrayList();
        private File jarLocation = null;
        static /* synthetic */ Class class$org$isqlviewer$core$PluginFactory$PluginEntry;

        public boolean equals(Object object) {
            if (object instanceof PluginEntry) {
                PluginEntry pluginEntry = (PluginEntry)object;
                if (this.isInternal()) {
                    return this.isInternal() == pluginEntry.isInternal();
                }
                return pluginEntry.jarLocation.equals(this.jarLocation);
            }
            return false;
        }

        public int hashCode() {
            return (this.jarLocation == null ? 0 : this.jarLocation.hashCode()) + (this.isInternal() ? 1 : 0);
        }

        public boolean isInternal() {
            return this.jarLocation == null;
        }

        public Collection getMetadata() {
            return (Collection)this.plugins.clone();
        }

        private PluginEntry(String[] stringArray) {
            Class<?> clazz = class$org$isqlviewer$core$PluginFactory$PluginEntry;
            if (clazz == null) {
                clazz = class$org$isqlviewer$core$PluginFactory$PluginEntry = new PluginEntry[0].getClass().getComponentType();
            }
            this.pluginLoader = clazz.getClassLoader();
            this.addInternalClasses(stringArray);
        }

        private PluginEntry(String string) {
            this.jarLocation = new File(string);
            if (!this.jarLocation.exists() || !this.jarLocation.canRead()) {
                throw new IllegalArgumentException();
            }
            try {
                this.classPath.add(this.jarLocation.toURL());
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                throw new RuntimeException(throwable);
            }
        }

        private PluginEntry(File file, JarFile jarFile) {
            if (file.exists()) {
                try {
                    this.jarLocation = file;
                    this.classPath.add(file.toURL());
                    this.scanManifest(jarFile.getManifest());
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                    throw new RuntimeException(throwable);
                }
            }
        }

        private void addCachedMetadata(PluginMetaInfo pluginMetaInfo) {
            this.plugins.add(pluginMetaInfo);
        }

        private void addCachedURL(URL uRL) {
            this.classPath.add(uRL);
        }

        private void scanManifest(Manifest manifest) {
            Object object;
            int n2 = 0;
            Attributes attributes = manifest.getAttributes(PluginFactory.MANIFEST_PLUGIN_SECTION);
            Iterator<Object> iterator = attributes.keySet().iterator();
            if (attributes.containsKey(Attributes.Name.CLASS_PATH)) {
                try {
                    this.createClasspath(attributes.getValue(Attributes.Name.CLASS_PATH));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            while (iterator.hasNext()) {
                object = (Attributes.Name)iterator.next();
                if (((Attributes.Name)object).equals(Attributes.Name.CLASS_PATH)) continue;
                String string = attributes.getValue((Attributes.Name)object);
                try {
                    CorePlugin corePlugin = this.createInstance(string, false);
                    PluginMetaInfo pluginMetaInfo = new PluginMetaInfo(null);
                    pluginMetaInfo.className = string;
                    pluginMetaInfo.pluginName = corePlugin.getName();
                    pluginMetaInfo.pluginType = corePlugin.getType();
                    this.plugins.add(pluginMetaInfo);
                    corePlugin = null;
                    ++n2;
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, string);
                }
            }
            object = BasicUtilities.getString("Plugins_Found", new String[]{Integer.toString(n2), this.jarLocation.getAbsolutePath()});
            System.out.println((String)object);
        }

        private void addInternalClasses(String[] stringArray) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    CorePlugin corePlugin = this.createInstance(stringArray[i2], false);
                    PluginMetaInfo pluginMetaInfo = new PluginMetaInfo(null);
                    pluginMetaInfo.className = stringArray[i2];
                    pluginMetaInfo.pluginName = corePlugin.getName();
                    pluginMetaInfo.pluginType = corePlugin.getType();
                    this.plugins.add(pluginMetaInfo);
                    corePlugin = null;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public ClassLoader getClassLoader() {
            if (this.pluginLoader == null) {
                try {
                    this.pluginLoader = new URLClassLoader(this.classPath.toArray(new URL[0]));
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                    Class<?> clazz = class$org$isqlviewer$core$PluginFactory$PluginEntry;
                    if (clazz == null) {
                        clazz = class$org$isqlviewer$core$PluginFactory$PluginEntry = new PluginEntry[0].getClass().getComponentType();
                    }
                    this.pluginLoader = clazz.getClassLoader();
                }
            }
            return this.pluginLoader;
        }

        public URL getBaseURL() {
            try {
                return this.jarLocation.toURL();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createClasspath(String string) throws MalformedURLException {
            String string2 = "{0}.jar";
            String string3 = "jar:".concat(this.jarLocation.toURL().toExternalForm()).concat("!/");
            File file = PluginFactory.getPluginCacheDirectory();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;:", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                URL uRL = new URL(string3.concat(string4));
                Object[] objectArray = new Object[]{Long.toHexString(System.currentTimeMillis()).toUpperCase()};
                String string5 = MessageFormat.format(string2, objectArray);
                File file2 = new File(file, string5);
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    if (!file2.createNewFile()) continue;
                    fileOutputStream = new FileOutputStream(file2);
                    inputStream = uRL.openStream();
                    BasicUtilities.copyStream(inputStream, fileOutputStream);
                    this.classPath.add(file2.toURL());
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {}
                    inputStream = null;
                    fileOutputStream = null;
                }
            }
        }

        public CorePlugin createInstance(String string, boolean bl2) {
            try {
                return (CorePlugin)Class.forName(string, bl2, this.getClassLoader()).newInstance();
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable);
                return null;
            }
        }

        public /* synthetic */ PluginEntry(File file, JarFile jarFile, 1 var3_3) {
            this(file, jarFile);
        }

        public /* synthetic */ PluginEntry(String[] stringArray, 1 var2_2) {
            this(stringArray);
        }

        public /* synthetic */ PluginEntry(String string, 1 var2_2) {
            this(string);
        }
    }

    private static class PluginMetaInfo {
        public String className = null;
        public String pluginName = null;
        public int pluginType = -1;

        private PluginMetaInfo() {
        }

        public /* synthetic */ PluginMetaInfo(1 var1_1) {
            this();
        }
    }
}

