/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.TimeSeries;
import org.garret.perst.TimeSeriesBlock;
import org.garret.perst.TimeSeriesTick;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;

public class TimeSeriesImpl
extends PersistentResource
implements TimeSeries {
    private Index index;
    private long maxBlockTimeInterval;
    private String blockClassName;
    private transient Class blockClass;

    public void add(TimeSeriesTick timeSeriesTick) {
        long l2 = timeSeriesTick.getTime();
        Iterator iterator = this.index.iterator(new Key(l2 - this.maxBlockTimeInterval), new Key(l2), 1);
        if (iterator.hasNext()) {
            this.insertInBlock((TimeSeriesBlock)iterator.next(), timeSeriesTick);
        } else {
            this.addNewBlock(timeSeriesTick);
        }
    }

    public Iterator iterator() {
        return this.iterator(null, null, true);
    }

    public Iterator iterator(Date date, Date date2) {
        return this.iterator(date, date2, true);
    }

    public Iterator iterator(boolean bl2) {
        return this.iterator(null, null, bl2);
    }

    public Iterator iterator(Date date, Date date2, boolean bl2) {
        long l2 = date == null ? 0L : date.getTime();
        long l3 = date2 == null ? Long.MAX_VALUE : date2.getTime();
        return bl2 ? new TimeSeriesIterator(l2, l3) : new TimeSeriesReverseIterator(l2, l3);
    }

    public Date getFirstTime() {
        Iterator iterator = this.index.iterator();
        if (iterator.hasNext()) {
            TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)iterator.next();
            return new Date(timeSeriesBlock.timestamp);
        }
        return null;
    }

    public Date getLastTime() {
        Iterator iterator = this.index.iterator(null, null, 1);
        if (iterator.hasNext()) {
            TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)iterator.next();
            return new Date(timeSeriesBlock.getTicks()[timeSeriesBlock.used - 1].getTime());
        }
        return null;
    }

    public int size() {
        return (int)this.countTicks();
    }

    public long countTicks() {
        long l2 = 0L;
        Iterator iterator = this.index.iterator();
        while (iterator.hasNext()) {
            TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)iterator.next();
            l2 += (long)timeSeriesBlock.used;
        }
        return l2;
    }

    public TimeSeriesTick getTick(Date date) {
        long l2 = date.getTime();
        Iterator iterator = this.index.iterator(new Key(l2 - this.maxBlockTimeInterval), new Key(l2), 0);
        while (iterator.hasNext()) {
            TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)iterator.next();
            int n2 = timeSeriesBlock.used;
            TimeSeriesTick[] timeSeriesTickArray = timeSeriesBlock.getTicks();
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                int n5 = n3 + n4 >> 1;
                if (l2 > timeSeriesTickArray[n5].getTime()) {
                    n3 = n5 + 1;
                    continue;
                }
                n4 = n5;
            }
            Assert.that(n3 == n4 && (n3 == n2 || timeSeriesTickArray[n3].getTime() >= l2));
            if (n3 >= n2 || timeSeriesTickArray[n3].getTime() != l2) continue;
            return timeSeriesTickArray[n3];
        }
        return null;
    }

    public boolean has(Date date) {
        return this.getTick(date) != null;
    }

    public long remove(Date date, Date date2) {
        long l2 = date == null ? 0L : date.getTime();
        long l3 = date2 == null ? Long.MAX_VALUE : date2.getTime();
        long l4 = 0L;
        Key key = new Key(l2 - this.maxBlockTimeInterval);
        Key key2 = new Key(l3);
        Iterator iterator = this.index.iterator(key, key2, 0);
        while (iterator.hasNext()) {
            TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)iterator.next();
            int n2 = timeSeriesBlock.used;
            TimeSeriesTick[] timeSeriesTickArray = timeSeriesBlock.getTicks();
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                int n5 = n3 + n4 >> 1;
                if (l2 > timeSeriesTickArray[n5].getTime()) {
                    n3 = n5 + 1;
                    continue;
                }
                n4 = n5;
            }
            Assert.that(n3 == n4 && (n3 == n2 || timeSeriesTickArray[n3].getTime() >= l2));
            while (n4 < n2 && timeSeriesTickArray[n4].getTime() <= l3) {
                ++n4;
                ++l4;
            }
            if (n3 == 0 && n4 == n2) {
                this.index.remove(new Key(timeSeriesBlock.timestamp), (IPersistent)timeSeriesBlock);
                iterator = this.index.iterator(key, key2, 0);
                timeSeriesBlock.deallocate();
                continue;
            }
            if (n3 >= n2 || n3 == n4) continue;
            if (n3 == 0) {
                this.index.remove(new Key(timeSeriesBlock.timestamp), (IPersistent)timeSeriesBlock);
                timeSeriesBlock.timestamp = timeSeriesTickArray[n4].getTime();
                this.index.put(new Key(timeSeriesBlock.timestamp), (IPersistent)timeSeriesBlock);
                iterator = this.index.iterator(key, key2, 0);
            }
            while (n4 < n2) {
                timeSeriesTickArray[n3++] = timeSeriesTickArray[n4++];
            }
            timeSeriesBlock.used = n3;
            timeSeriesBlock.modify();
        }
        return l4;
    }

    private void addNewBlock(TimeSeriesTick timeSeriesTick) {
        TimeSeriesBlock timeSeriesBlock;
        try {
            timeSeriesBlock = (TimeSeriesBlock)this.blockClass.newInstance();
        }
        catch (Exception exception) {
            throw new StorageError(12, this.blockClass, exception);
        }
        timeSeriesBlock.timestamp = timeSeriesTick.getTime();
        timeSeriesBlock.used = 1;
        timeSeriesBlock.getTicks()[0] = timeSeriesTick;
        this.index.put(new Key(timeSeriesBlock.timestamp), (IPersistent)timeSeriesBlock);
    }

    void insertInBlock(TimeSeriesBlock timeSeriesBlock, TimeSeriesTick timeSeriesTick) {
        int n2;
        long l2 = timeSeriesTick.getTime();
        int n3 = timeSeriesBlock.used;
        TimeSeriesTick[] timeSeriesTickArray = timeSeriesBlock.getTicks();
        int n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4 + n5 >> 1;
            if (l2 >= timeSeriesTickArray[n2].getTime()) {
                n4 = n2 + 1;
                continue;
            }
            n5 = n2;
        }
        Assert.that(n4 == n5 && (n4 == n3 || timeSeriesTickArray[n4].getTime() >= l2));
        if (n5 == 0) {
            if (timeSeriesTickArray[n3 - 1].getTime() - l2 > this.maxBlockTimeInterval || n3 == timeSeriesTickArray.length) {
                this.addNewBlock(timeSeriesTick);
                return;
            }
            if (timeSeriesBlock.timestamp != l2) {
                this.index.remove(new Key(timeSeriesBlock.timestamp), (IPersistent)timeSeriesBlock);
                timeSeriesBlock.timestamp = l2;
                this.index.put(new Key(timeSeriesBlock.timestamp), (IPersistent)timeSeriesBlock);
            }
        } else if (n5 == n3 && (l2 - timeSeriesTickArray[0].getTime() > this.maxBlockTimeInterval || n3 == timeSeriesTickArray.length)) {
            this.addNewBlock(timeSeriesTick);
            return;
        }
        if (n3 == timeSeriesTickArray.length) {
            this.addNewBlock(timeSeriesTickArray[n3 - 1]);
            n2 = n3;
            while (--n2 > n5) {
                timeSeriesTickArray[n2] = timeSeriesTickArray[n2 - 1];
            }
        } else {
            for (n2 = n3; n2 > n5; --n2) {
                timeSeriesTickArray[n2] = timeSeriesTickArray[n2 - 1];
            }
            ++timeSeriesBlock.used;
        }
        timeSeriesTickArray[n5] = timeSeriesTick;
        timeSeriesBlock.modify();
    }

    TimeSeriesImpl(Storage storage, Class clazz, long l2) {
        this.blockClass = clazz;
        this.maxBlockTimeInterval = l2;
        this.blockClassName = ClassDescriptor.getClassName(clazz);
        this.index = storage.createIndex(Long.TYPE, false);
    }

    TimeSeriesImpl() {
    }

    public void onLoad() {
        this.blockClass = ClassDescriptor.loadClass(this.getStorage(), this.blockClassName);
    }

    public void deallocate() {
        Iterator iterator = this.index.iterator();
        while (iterator.hasNext()) {
            TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)iterator.next();
            timeSeriesBlock.deallocate();
        }
        this.index.deallocate();
        super.deallocate();
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    class TimeSeriesReverseIterator
    implements Iterator {
        private Iterator blockIterator;
        private TimeSeriesBlock currBlock;
        private int pos = -1;
        private long from;

        TimeSeriesReverseIterator(long l2, long l3) {
            this.from = l2;
            this.blockIterator = TimeSeriesImpl.this.index.iterator(new Key(l2 - TimeSeriesImpl.this.maxBlockTimeInterval), new Key(l3), 1);
            while (this.blockIterator.hasNext()) {
                TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)this.blockIterator.next();
                int n2 = timeSeriesBlock.used;
                TimeSeriesTick[] timeSeriesTickArray = timeSeriesBlock.getTicks();
                int n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    int n5 = n3 + n4 >> 1;
                    if (l3 >= timeSeriesTickArray[n5].getTime()) {
                        n3 = n5 + 1;
                        continue;
                    }
                    n4 = n5;
                }
                Assert.that(n3 == n4 && (n3 == n2 || timeSeriesTickArray[n3].getTime() > l3));
                if (n3 <= 0) continue;
                if (timeSeriesTickArray[n3 - 1].getTime() >= l2) {
                    this.pos = n3 - 1;
                    this.currBlock = timeSeriesBlock;
                }
                return;
            }
        }

        public boolean hasNext() {
            return this.pos >= 0;
        }

        public Object next() {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            TimeSeriesTick timeSeriesTick = this.currBlock.getTicks()[this.pos];
            if (--this.pos < 0) {
                if (this.blockIterator.hasNext()) {
                    this.currBlock = (TimeSeriesBlock)this.blockIterator.next();
                    this.pos = this.currBlock.used - 1;
                } else {
                    this.pos = -1;
                    return timeSeriesTick;
                }
            }
            if (this.currBlock.getTicks()[this.pos].getTime() < this.from) {
                this.pos = -1;
            }
            return timeSeriesTick;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TimeSeriesIterator
    implements Iterator {
        private Iterator blockIterator;
        private TimeSeriesBlock currBlock;
        private int pos = -1;
        private long till;

        TimeSeriesIterator(long l2, long l3) {
            this.till = l3;
            this.blockIterator = TimeSeriesImpl.this.index.iterator(new Key(l2 - TimeSeriesImpl.this.maxBlockTimeInterval), new Key(l3), 0);
            while (this.blockIterator.hasNext()) {
                TimeSeriesBlock timeSeriesBlock = (TimeSeriesBlock)this.blockIterator.next();
                int n2 = timeSeriesBlock.used;
                TimeSeriesTick[] timeSeriesTickArray = timeSeriesBlock.getTicks();
                int n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    int n5 = n3 + n4 >> 1;
                    if (l2 > timeSeriesTickArray[n5].getTime()) {
                        n3 = n5 + 1;
                        continue;
                    }
                    n4 = n5;
                }
                Assert.that(n3 == n4 && (n3 == n2 || timeSeriesTickArray[n3].getTime() >= l2));
                if (n3 >= n2) continue;
                if (timeSeriesTickArray[n3].getTime() <= l3) {
                    this.pos = n3;
                    this.currBlock = timeSeriesBlock;
                }
                return;
            }
        }

        public boolean hasNext() {
            return this.pos >= 0;
        }

        public Object next() {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            TimeSeriesTick timeSeriesTick = this.currBlock.getTicks()[this.pos];
            if (++this.pos == this.currBlock.used) {
                if (this.blockIterator.hasNext()) {
                    this.currBlock = (TimeSeriesBlock)this.blockIterator.next();
                    this.pos = 0;
                } else {
                    this.pos = -1;
                    return timeSeriesTick;
                }
            }
            if (this.currBlock.getTicks()[this.pos].getTime() > this.till) {
                this.pos = -1;
            }
            return timeSeriesTick;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

