/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import org.garret.perst.Assert;
import org.garret.perst.IValue;

public class RectangleR2
implements IValue,
Cloneable {
    private double top;
    private double left;
    private double bottom;
    private double right;

    public final double getTop() {
        return this.top;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getRight() {
        return this.right;
    }

    public final double area() {
        return (this.bottom - this.top) * (this.right - this.left);
    }

    public static double joinArea(RectangleR2 rectangleR2, RectangleR2 rectangleR22) {
        double d2 = rectangleR2.left < rectangleR22.left ? rectangleR2.left : rectangleR22.left;
        double d3 = rectangleR2.right > rectangleR22.right ? rectangleR2.right : rectangleR22.right;
        double d4 = rectangleR2.top < rectangleR22.top ? rectangleR2.top : rectangleR22.top;
        double d5 = rectangleR2.bottom > rectangleR22.bottom ? rectangleR2.bottom : rectangleR22.bottom;
        return (d5 - d4) * (d3 - d2);
    }

    public Object clone() {
        try {
            RectangleR2 rectangleR2 = (RectangleR2)super.clone();
            rectangleR2.top = this.top;
            rectangleR2.left = this.left;
            rectangleR2.bottom = this.bottom;
            rectangleR2.right = this.right;
            return rectangleR2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public RectangleR2(RectangleR2 rectangleR2) {
        this.top = rectangleR2.top;
        this.left = rectangleR2.left;
        this.bottom = rectangleR2.bottom;
        this.right = rectangleR2.right;
    }

    public RectangleR2(double d2, double d3, double d4, double d5) {
        Assert.that(d2 <= d4 && d3 <= d5);
        this.top = d2;
        this.left = d3;
        this.bottom = d4;
        this.right = d5;
    }

    public RectangleR2() {
    }

    public final void join(RectangleR2 rectangleR2) {
        if (this.left > rectangleR2.left) {
            this.left = rectangleR2.left;
        }
        if (this.right < rectangleR2.right) {
            this.right = rectangleR2.right;
        }
        if (this.top > rectangleR2.top) {
            this.top = rectangleR2.top;
        }
        if (this.bottom < rectangleR2.bottom) {
            this.bottom = rectangleR2.bottom;
        }
    }

    public static RectangleR2 join(RectangleR2 rectangleR2, RectangleR2 rectangleR22) {
        RectangleR2 rectangleR23 = new RectangleR2(rectangleR2);
        rectangleR23.join(rectangleR22);
        return rectangleR23;
    }

    public final boolean intersects(RectangleR2 rectangleR2) {
        return this.left <= rectangleR2.right && this.top <= rectangleR2.bottom && this.right >= rectangleR2.left && this.bottom >= rectangleR2.top;
    }

    public final boolean contains(RectangleR2 rectangleR2) {
        return this.left <= rectangleR2.left && this.top <= rectangleR2.top && this.right >= rectangleR2.right && this.bottom >= rectangleR2.bottom;
    }

    public boolean equals(Object object) {
        if (object instanceof RectangleR2) {
            RectangleR2 rectangleR2 = (RectangleR2)object;
            return this.left == rectangleR2.left && this.top == rectangleR2.top && this.right == rectangleR2.right && this.bottom == rectangleR2.bottom;
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.top) ^ Double.doubleToLongBits(this.bottom) << 1 ^ Double.doubleToLongBits(this.left) << 2 ^ Double.doubleToLongBits(this.right) << 3);
    }

    public String toString() {
        return "top=" + this.top + ", left=" + this.left + ", bottom=" + this.bottom + ", right=" + this.right;
    }
}

