/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.substitution;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.gs.digester.substitution.VariableExpander;

public class MultiVariableExpander
implements VariableExpander {
    private int nEntries = 0;
    private ArrayList markers = new ArrayList(2);
    private ArrayList sources = new ArrayList(2);

    public void addSource(String string, Map map) {
        ++this.nEntries;
        this.markers.add(string);
        this.sources.add(map);
    }

    public String expand(String string) {
        for (int i2 = 0; i2 < this.nEntries; ++i2) {
            string = this.expand(string, (String)this.markers.get(i2), (Map)this.sources.get(i2));
        }
        return string;
    }

    public String expand(String string, String string2, Map map) {
        String string3 = string2 + "{";
        int n2 = string3.length();
        int n3 = 0;
        while ((n3 = string.indexOf(string3, n3)) != -1) {
            int n4 = n3 + n2;
            if (n4 > string.length()) {
                throw new IllegalArgumentException("var expression starts at end of string");
            }
            int n5 = string.indexOf("}", n3 + n2);
            if (n5 == -1) {
                throw new IllegalArgumentException("var expression starts but does not end");
            }
            String string4 = string.substring(n3 + n2, n5);
            Object v2 = map.get(string4);
            if (v2 == null) {
                throw new IllegalArgumentException("parameter [" + string4 + "] is not defined.");
            }
            String string5 = v2.toString();
            string = string.substring(0, n3) + string5 + string.substring(n5 + 1);
            n3 += string5.length();
        }
        return string;
    }
}

