/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.plugins;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.plugins.PluginAssertionFailure;
import org.apache.commons.gs.digester.plugins.PluginException;
import org.apache.commons.gs.digester.plugins.PluginManager;
import org.apache.commons.gs.digester.plugins.RuleLoader;

public class Declaration {
    private Class pluginClass;
    private String pluginClassName;
    private String id;
    private Properties properties = new Properties();
    private boolean initialized = false;
    private RuleLoader ruleLoader = null;

    public Declaration(String string) {
        this.pluginClassName = string;
    }

    public Declaration(Class clazz) {
        this.pluginClass = clazz;
        this.pluginClassName = clazz.getName();
    }

    public Declaration(Class clazz, RuleLoader ruleLoader) {
        this.pluginClass = clazz;
        this.pluginClassName = clazz.getName();
        this.ruleLoader = ruleLoader;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public Class getPluginClass() {
        return this.pluginClass;
    }

    public void init(Digester digester, PluginManager pluginManager) throws PluginException {
        Logger logger = digester.getLogger();
        boolean bl2 = logger.isLoggable(Level.FINE);
        if (bl2) {
            logger.fine("init being called!");
        }
        if (this.initialized) {
            throw new PluginAssertionFailure("Init called multiple times.");
        }
        if (this.pluginClass == null && this.pluginClassName != null) {
            try {
                this.pluginClass = digester.getClassLoader().loadClass(this.pluginClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PluginException("Unable to load class " + this.pluginClassName, classNotFoundException);
            }
        }
        if (this.ruleLoader == null) {
            logger.fine("Searching for ruleloader...");
            this.ruleLoader = pluginManager.findLoader(digester, this.id, this.pluginClass, this.properties);
        } else {
            logger.fine("This declaration has an explicit ruleLoader.");
        }
        if (bl2) {
            if (this.ruleLoader == null) {
                logger.fine("No ruleLoader found for plugin declaration id [" + this.id + "]" + ", class [" + this.pluginClass.getClass().getName() + "].");
            } else {
                logger.fine("RuleLoader of type [" + this.ruleLoader.getClass().getName() + "] associated with plugin declaration" + " id [" + this.id + "]" + ", class [" + this.pluginClass.getClass().getName() + "].");
            }
        }
        this.initialized = true;
    }

    public void configure(Digester digester, String string) throws PluginException {
        Logger logger = digester.getLogger();
        boolean bl2 = logger.isLoggable(Level.FINE);
        if (bl2) {
            logger.fine("configure being called!");
        }
        if (!this.initialized) {
            throw new PluginAssertionFailure("Not initialized.");
        }
        if (this.ruleLoader != null) {
            this.ruleLoader.addRules(digester, string);
        }
    }
}

