/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beans;

import com.gigaspaces.converter.ConverterTracer;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.apache.commons.gs.beans.BeanDescriptor;
import org.apache.commons.gs.beans.BeanInfo;
import org.apache.commons.gs.beans.EventSetDescriptor;
import org.apache.commons.gs.beans.FeatureDescriptor;
import org.apache.commons.gs.beans.GenericBeanInfo;
import org.apache.commons.gs.beans.IndexedPropertyDescriptor;
import org.apache.commons.gs.beans.IntrospectionException;
import org.apache.commons.gs.beans.MethodDescriptor;
import org.apache.commons.gs.beans.PropertyDescriptor;

public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static Map declaredMethodCache = Collections.synchronizedMap(new WeakHashMap());
    private static Map beanInfoCache = Collections.synchronizedMap(new WeakHashMap());
    private Class beanClass;
    private BeanInfo explicitBeanInfo;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private boolean propertyChangeSource = false;
    private static Class eventListenerType;
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Map methods;
    private Map properties;
    private Map events;
    private static final String DEFAULT_INFO_PATH = "sun.beans.infos";
    private static String[] searchPath;
    private static final EventSetDescriptor[] EMPTY_EVENTSETDESCRIPTORS;
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String BEANINFO_SUFFIX = "BeanInfo";
    private HashMap pdStore = new HashMap();
    static /* synthetic */ Class class$java$util$EventListener;
    static /* synthetic */ Class class$java$beans$PropertyVetoException;
    static /* synthetic */ Class class$java$util$EventObject;
    static /* synthetic */ Class class$java$util$TooManyListenersException;
    static /* synthetic */ Class class$org$apache$commons$gs$beans$BeanInfo;

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        if (!Introspector.isPackageAccessible(clazz)) {
            return new Introspector(clazz, null, 1).getBeanInfo();
        }
        BeanInfo beanInfo = (BeanInfo)beanInfoCache.get(clazz);
        if (beanInfo == null) {
            beanInfo = new Introspector(clazz, null, 1).getBeanInfo();
            beanInfoCache.put(clazz, beanInfo);
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class clazz, int n2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null, n2);
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, clazz2, 1);
    }

    private static BeanInfo getBeanInfo(Class clazz, Class clazz2, int n2) throws IntrospectionException {
        BeanInfo beanInfo = clazz2 == null && n2 == 1 ? Introspector.getBeanInfo(clazz) : new Introspector(clazz, clazz2, n2).getBeanInfo();
        return beanInfo;
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static synchronized String[] getBeanInfoSearchPath() {
        String[] stringArray = new String[searchPath.length];
        for (int i2 = 0; i2 < searchPath.length; ++i2) {
            stringArray[i2] = searchPath[i2];
        }
        return stringArray;
    }

    public static synchronized void setBeanInfoSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        searchPath = stringArray;
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        declaredMethodCache.clear();
    }

    public static void flushFromCaches(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        beanInfoCache.remove(clazz);
        declaredMethodCache.remove(clazz);
    }

    private Introspector(Class clazz, Class clazz2, int n2) throws IntrospectionException {
        Class clazz3;
        this.beanClass = clazz;
        if (clazz2 != null) {
            boolean bl2 = false;
            for (Class clazz4 = clazz.getSuperclass(); clazz4 != null; clazz4 = clazz4.getSuperclass()) {
                if (clazz4 != clazz2) continue;
                bl2 = true;
            }
            if (!bl2) {
                throw new IntrospectionException(clazz2.getName() + " not superclass of " + clazz.getName());
            }
        }
        if (n2 == 1) {
            this.explicitBeanInfo = Introspector.findExplicitBeanInfo(clazz);
        }
        if ((clazz3 = clazz.getSuperclass()) != clazz2) {
            int n3 = n2;
            if (n3 == 2) {
                n3 = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(clazz3, clazz2, n3);
        }
        if (this.explicitBeanInfo != null) {
            this.additionalBeanInfo = this.explicitBeanInfo.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private BeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor beanDescriptor = this.getTargetBeanDescriptor();
        MethodDescriptor[] methodDescriptorArray = this.getTargetMethodInfo();
        EventSetDescriptor[] eventSetDescriptorArray = this.getTargetEventInfo();
        PropertyDescriptor[] propertyDescriptorArray = this.getTargetPropertyInfo();
        int n2 = this.getTargetDefaultEventIndex();
        int n3 = this.getTargetDefaultPropertyIndex();
        return new GenericBeanInfo(beanDescriptor, eventSetDescriptorArray, n2, propertyDescriptorArray, n3, methodDescriptorArray, this.explicitBeanInfo);
    }

    private static synchronized BeanInfo findExplicitBeanInfo(Class clazz) {
        String string = clazz.getName() + BEANINFO_SUFFIX;
        try {
            return (BeanInfo)Introspector.instantiate(clazz, string);
        }
        catch (Exception exception) {
            try {
                Class<?> clazz2 = class$org$apache$commons$gs$beans$BeanInfo;
                if (clazz2 == null) {
                    clazz2 = class$org$apache$commons$gs$beans$BeanInfo = new BeanInfo[0].getClass().getComponentType();
                }
                if (Introspector.isSubclass(clazz, clazz2)) {
                    return (BeanInfo)clazz.newInstance();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            string = string.substring(string.lastIndexOf(46) + 1);
            for (int i2 = 0; i2 < searchPath.length; ++i2) {
                if (DEFAULT_INFO_PATH.equals(searchPath[i2]) && (!DEFAULT_INFO_PATH.equals(searchPath[i2]) || !"ComponentBeanInfo".equals(string))) continue;
                try {
                    Method method;
                    int n2;
                    FeatureDescriptor[] featureDescriptorArray;
                    String string2 = searchPath[i2] + "." + string;
                    BeanInfo beanInfo = (BeanInfo)Introspector.instantiate(clazz, string2);
                    if (beanInfo.getBeanDescriptor() != null) {
                        if (beanInfo.getBeanDescriptor().getBeanClass() != clazz) continue;
                        return beanInfo;
                    }
                    if (beanInfo.getPropertyDescriptors() != null) {
                        featureDescriptorArray = beanInfo.getPropertyDescriptors();
                        for (n2 = 0; n2 < featureDescriptorArray.length; ++n2) {
                            method = ((PropertyDescriptor)featureDescriptorArray[n2]).getReadMethod();
                            if (method == null) {
                                method = ((PropertyDescriptor)featureDescriptorArray[n2]).getWriteMethod();
                            }
                            if (method == null || method.getDeclaringClass() != clazz) continue;
                            return beanInfo;
                        }
                        continue;
                    }
                    if (beanInfo.getMethodDescriptors() == null) continue;
                    featureDescriptorArray = beanInfo.getMethodDescriptors();
                    for (n2 = 0; n2 < featureDescriptorArray.length; ++n2) {
                        method = ((MethodDescriptor)featureDescriptorArray[n2]).getMethod();
                        if (method == null || method.getDeclaringClass() != clazz) continue;
                        return beanInfo;
                    }
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private PropertyDescriptor[] getTargetPropertyInfo() {
        int n2;
        int n3;
        PropertyDescriptor[] propertyDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            propertyDescriptorArray = this.explicitBeanInfo.getPropertyDescriptors();
            n3 = this.explicitBeanInfo.getDefaultPropertyIndex();
            if (n3 >= 0 && n3 < propertyDescriptorArray.length) {
                this.defaultPropertyName = propertyDescriptorArray[n3].getName();
            }
        }
        if (propertyDescriptorArray == null && this.superBeanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray2 = this.superBeanInfo.getPropertyDescriptors();
            for (n2 = 0; n2 < propertyDescriptorArray2.length; ++n2) {
                this.addPropertyDescriptor(propertyDescriptorArray2[n2]);
            }
            n2 = this.superBeanInfo.getDefaultPropertyIndex();
            if (n2 >= 0 && n2 < propertyDescriptorArray2.length) {
                this.defaultPropertyName = propertyDescriptorArray2[n2].getName();
            }
        }
        for (n3 = 0; n3 < this.additionalBeanInfo.length; ++n3) {
            PropertyDescriptor[] propertyDescriptorArray3 = this.additionalBeanInfo[n3].getPropertyDescriptors();
            if (propertyDescriptorArray3 == null) continue;
            for (int i2 = 0; i2 < propertyDescriptorArray3.length; ++i2) {
                this.addPropertyDescriptor(propertyDescriptorArray3[i2]);
            }
        }
        if (propertyDescriptorArray != null) {
            for (n3 = 0; n3 < propertyDescriptorArray.length; ++n3) {
                this.addPropertyDescriptor(propertyDescriptorArray[n3]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                int n4;
                Method method = methodArray[n2];
                if (method == null || Modifier.isStatic(n4 = method.getModifiers())) continue;
                String string = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                Class<?> clazz = method.getReturnType();
                int n5 = classArray.length;
                PropertyDescriptor propertyDescriptor = null;
                if (string.length() <= 3 && !string.startsWith(IS_PREFIX)) continue;
                try {
                    if (n5 == 0) {
                        if (string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), method, null);
                        } else if (clazz == Boolean.TYPE && string.startsWith(IS_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(2)), method, null);
                        }
                    } else if (n5 == 1) {
                        if (classArray[0] == Integer.TYPE && string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, method, null);
                        } else if (clazz == Void.TYPE && string.startsWith(SET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, method);
                            Class<?> clazz2 = class$java$beans$PropertyVetoException;
                            if (clazz2 == null) {
                                clazz2 = new PropertyVetoException[0].getClass().getComponentType();
                            }
                            if (this.throwsException(method, clazz2)) {
                                propertyDescriptor.setConstrained(true);
                            }
                        }
                    } else if (n5 == 2 && classArray[0] == Integer.TYPE && string.startsWith(SET_PREFIX)) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, null, method);
                        Class<?> clazz3 = class$java$beans$PropertyVetoException;
                        if (clazz3 == null) {
                            clazz3 = new PropertyVetoException[0].getClass().getComponentType();
                        }
                        if (this.throwsException(method, clazz3)) {
                            propertyDescriptor.setConstrained(true);
                        }
                    }
                }
                catch (IntrospectionException introspectionException) {
                    propertyDescriptor = null;
                }
                if (propertyDescriptor == null) continue;
                if (this.propertyChangeSource) {
                    propertyDescriptor.setBound(true);
                }
                this.addPropertyDescriptor(propertyDescriptor);
            }
        }
        this.processPropertyDescriptors();
        PropertyDescriptor[] propertyDescriptorArray4 = new PropertyDescriptor[this.properties.size()];
        propertyDescriptorArray4 = this.properties.values().toArray(propertyDescriptorArray4);
        if (this.defaultPropertyName != null) {
            for (n2 = 0; n2 < propertyDescriptorArray4.length; ++n2) {
                if (!this.defaultPropertyName.equals(propertyDescriptorArray4[n2].getName())) continue;
                this.defaultPropertyIndex = n2;
            }
        }
        return propertyDescriptorArray4;
    }

    private void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getName();
        ArrayList<PropertyDescriptor> arrayList = (ArrayList<PropertyDescriptor>)this.pdStore.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<PropertyDescriptor>();
            this.pdStore.put(string, arrayList);
        }
        arrayList.add(propertyDescriptor);
    }

    private void processPropertyDescriptors() {
        if (this.properties == null) {
            this.properties = new TreeMap();
        }
        Iterator iterator = this.pdStore.values().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            PropertyDescriptor propertyDescriptor;
            block43: {
                Method method;
                int n2;
                propertyDescriptor = null;
                PropertyDescriptor propertyDescriptor2 = null;
                PropertyDescriptor propertyDescriptor3 = null;
                IndexedPropertyDescriptor indexedPropertyDescriptor = null;
                IndexedPropertyDescriptor indexedPropertyDescriptor2 = null;
                IndexedPropertyDescriptor indexedPropertyDescriptor3 = null;
                List list = (List)iterator.next();
                for (n2 = 0; n2 < list.size(); ++n2) {
                    propertyDescriptor = (PropertyDescriptor)list.get(n2);
                    if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                        indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                        if (indexedPropertyDescriptor.getIndexedReadMethod() == null) continue;
                        if (indexedPropertyDescriptor2 != null) {
                            indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor);
                            continue;
                        }
                        indexedPropertyDescriptor2 = indexedPropertyDescriptor;
                        continue;
                    }
                    if (propertyDescriptor.getReadMethod() == null) continue;
                    if (propertyDescriptor2 != null) {
                        method = propertyDescriptor2.getReadMethod();
                        if (method.getName().startsWith(IS_PREFIX)) continue;
                        propertyDescriptor2 = new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
                        continue;
                    }
                    propertyDescriptor2 = propertyDescriptor;
                }
                for (n2 = 0; n2 < list.size(); ++n2) {
                    propertyDescriptor = (PropertyDescriptor)list.get(n2);
                    if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                        indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                        if (indexedPropertyDescriptor.getIndexedWriteMethod() == null) continue;
                        if (indexedPropertyDescriptor2 != null) {
                            if (indexedPropertyDescriptor2.getIndexedPropertyType() != indexedPropertyDescriptor.getIndexedPropertyType()) continue;
                            if (indexedPropertyDescriptor3 != null) {
                                indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                                continue;
                            }
                            indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                            continue;
                        }
                        if (indexedPropertyDescriptor3 != null) {
                            indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                            continue;
                        }
                        indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                        continue;
                    }
                    if (propertyDescriptor.getWriteMethod() == null) continue;
                    if (propertyDescriptor2 != null) {
                        if (propertyDescriptor2.getPropertyType() != propertyDescriptor.getPropertyType()) continue;
                        if (propertyDescriptor3 != null) {
                            propertyDescriptor3 = new PropertyDescriptor(propertyDescriptor3, propertyDescriptor);
                            continue;
                        }
                        propertyDescriptor3 = propertyDescriptor;
                        continue;
                    }
                    propertyDescriptor3 = propertyDescriptor3 != null ? new PropertyDescriptor(propertyDescriptor3, propertyDescriptor) : propertyDescriptor;
                }
                propertyDescriptor = null;
                indexedPropertyDescriptor = null;
                if (indexedPropertyDescriptor2 != null && indexedPropertyDescriptor3 != null) {
                    PropertyDescriptor propertyDescriptor4;
                    PropertyDescriptor propertyDescriptor5;
                    if (propertyDescriptor2 != null && (propertyDescriptor5 = this.mergePropertyDescriptor(indexedPropertyDescriptor2, propertyDescriptor2)) instanceof IndexedPropertyDescriptor) {
                        indexedPropertyDescriptor2 = (IndexedPropertyDescriptor)propertyDescriptor5;
                    }
                    if (propertyDescriptor3 != null && (propertyDescriptor4 = this.mergePropertyDescriptor(indexedPropertyDescriptor3, propertyDescriptor3)) instanceof IndexedPropertyDescriptor) {
                        indexedPropertyDescriptor3 = (IndexedPropertyDescriptor)propertyDescriptor4;
                    }
                    propertyDescriptor = indexedPropertyDescriptor2 == indexedPropertyDescriptor3 ? indexedPropertyDescriptor2 : this.mergePropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor3);
                } else if (propertyDescriptor2 != null && propertyDescriptor3 != null) {
                    propertyDescriptor = propertyDescriptor2 == propertyDescriptor3 ? propertyDescriptor2 : this.mergePropertyDescriptor(propertyDescriptor2, propertyDescriptor3);
                } else if (indexedPropertyDescriptor3 != null) {
                    propertyDescriptor = indexedPropertyDescriptor3;
                    if (propertyDescriptor3 != null) {
                        propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor3, propertyDescriptor3);
                    }
                    if (propertyDescriptor2 != null) {
                        propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor3, propertyDescriptor2);
                    }
                } else if (indexedPropertyDescriptor2 != null) {
                    propertyDescriptor = indexedPropertyDescriptor2;
                    if (propertyDescriptor2 != null) {
                        propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor2, propertyDescriptor2);
                    }
                    if (propertyDescriptor3 != null) {
                        propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor2, propertyDescriptor3);
                    }
                } else if (propertyDescriptor3 != null) {
                    propertyDescriptor = propertyDescriptor3;
                } else if (propertyDescriptor2 != null) {
                    propertyDescriptor = propertyDescriptor2;
                }
                if (propertyDescriptor instanceof IndexedPropertyDescriptor && (indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() == null && indexedPropertyDescriptor.getIndexedWriteMethod() == null) {
                    propertyDescriptor = new PropertyDescriptor(indexedPropertyDescriptor);
                }
                if (indexedPropertyDescriptor instanceof IndexedPropertyDescriptor) continue;
                if (propertyDescriptor != null && propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null) {
                    this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
                    continue;
                }
                if (this.beanClass.getName().equals("java.lang.Object")) continue;
                bl2 = true;
                if (propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() == null) {
                    try {
                        method = this.beanClass.getMethod(SET_PREFIX + propertyDescriptor.getName().substring(0, 1).toUpperCase() + propertyDescriptor.getName().substring(1, propertyDescriptor.getName().length()), propertyDescriptor.getPropertyType());
                        if (method != null) {
                            propertyDescriptor.setWriteMethod(method);
                            break block43;
                        }
                        bl2 = false;
                    }
                    catch (Exception exception) {
                        bl2 = false;
                    }
                } else if (propertyDescriptor.getReadMethod() == null && propertyDescriptor.getWriteMethod() != null) {
                    try {
                        method = this.beanClass.getMethod(GET_PREFIX + propertyDescriptor.getName().substring(0, 1).toUpperCase() + propertyDescriptor.getName().substring(1, propertyDescriptor.getName().length()), null);
                        if (method != null) {
                            propertyDescriptor.setReadMethod(method);
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Exception exception) {
                        bl2 = false;
                    }
                }
            }
            if (!bl2 && ConverterTracer.getLogger().isLoggable(Level.FINE)) {
                ConverterTracer.getLogger().log(Level.FINE, "A getter or setter method for member '" + propertyDescriptor.getName() + "' is missing in POJO '" + this.beanClass.getName() + "'");
            }
            if (!bl2) continue;
            this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
        }
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor, PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor propertyDescriptor2 = null;
        Class clazz = propertyDescriptor.getPropertyType();
        Class clazz2 = indexedPropertyDescriptor.getIndexedPropertyType();
        if (clazz.isArray() && clazz.getComponentType() == clazz2) {
            propertyDescriptor2 = propertyDescriptor.getClass0().isAssignableFrom(indexedPropertyDescriptor.getClass0()) ? new IndexedPropertyDescriptor(propertyDescriptor, indexedPropertyDescriptor) : new IndexedPropertyDescriptor(indexedPropertyDescriptor, propertyDescriptor);
        } else if (propertyDescriptor.getClass0().isAssignableFrom(indexedPropertyDescriptor.getClass0())) {
            propertyDescriptor2 = indexedPropertyDescriptor;
        } else {
            propertyDescriptor2 = propertyDescriptor;
            Method method = propertyDescriptor2.getWriteMethod();
            Method method2 = propertyDescriptor2.getReadMethod();
            if (method2 == null && method != null) {
                try {
                    method2 = Introspector.findMethod(propertyDescriptor2.getClass0(), GET_PREFIX + PropertyDescriptor.capitalize(propertyDescriptor2.getName()), 0);
                }
                catch (Exception exception) {
                    method2 = null;
                }
                if (method2 != null) {
                    try {
                        propertyDescriptor2.setReadMethod(method2);
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
            }
            if (method == null && method2 != null) {
                try {
                    method = Introspector.findMethod(propertyDescriptor2.getClass0(), SET_PREFIX + PropertyDescriptor.capitalize(propertyDescriptor2.getName()), 1, new Class[]{method2.getReturnType()});
                }
                catch (Exception exception) {
                    method = null;
                }
                if (method != null) {
                    try {
                        propertyDescriptor2.setWriteMethod(method);
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
            }
        }
        return propertyDescriptor2;
    }

    private PropertyDescriptor mergePropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor.getClass0().isAssignableFrom(propertyDescriptor2.getClass0())) {
            return new PropertyDescriptor(propertyDescriptor, propertyDescriptor2);
        }
        return new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor, IndexedPropertyDescriptor indexedPropertyDescriptor2) {
        if (indexedPropertyDescriptor.getClass0().isAssignableFrom(indexedPropertyDescriptor2.getClass0())) {
            return new IndexedPropertyDescriptor(indexedPropertyDescriptor, indexedPropertyDescriptor2);
        }
        return new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor);
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        EventSetDescriptor[] eventSetDescriptorArray;
        int n2;
        if (this.events == null) {
            this.events = new HashMap();
        }
        EventSetDescriptor[] eventSetDescriptorArray2 = null;
        if (this.explicitBeanInfo != null) {
            eventSetDescriptorArray2 = this.explicitBeanInfo.getEventSetDescriptors();
            n2 = this.explicitBeanInfo.getDefaultEventIndex();
            if (n2 >= 0 && n2 < eventSetDescriptorArray2.length) {
                this.defaultEventName = eventSetDescriptorArray2[n2].getName();
            }
        }
        if (eventSetDescriptorArray2 == null && this.superBeanInfo != null) {
            int n3;
            EventSetDescriptor[] eventSetDescriptorArray3 = this.superBeanInfo.getEventSetDescriptors();
            for (n3 = 0; n3 < eventSetDescriptorArray3.length; ++n3) {
                this.addEvent(eventSetDescriptorArray3[n3]);
            }
            n3 = this.superBeanInfo.getDefaultEventIndex();
            if (n3 >= 0 && n3 < eventSetDescriptorArray3.length) {
                this.defaultEventName = eventSetDescriptorArray3[n3].getName();
            }
        }
        for (n2 = 0; n2 < this.additionalBeanInfo.length; ++n2) {
            EventSetDescriptor[] eventSetDescriptorArray4 = this.additionalBeanInfo[n2].getEventSetDescriptors();
            if (eventSetDescriptorArray4 == null) continue;
            for (int i2 = 0; i2 < eventSetDescriptorArray4.length; ++i2) {
                this.addEvent(eventSetDescriptorArray4[i2]);
            }
        }
        if (eventSetDescriptorArray2 != null) {
            for (n2 = 0; n2 < eventSetDescriptorArray2.length; ++n2) {
                this.addEvent(eventSetDescriptorArray2[n2]);
            }
        } else {
            Object object;
            GenericDeclaration genericDeclaration;
            Object object2;
            Object object3;
            Object object4;
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            HashMap<Object, Object> hashMap = null;
            HashMap<Object, Object> hashMap2 = null;
            HashMap<Object, Object> hashMap3 = null;
            for (int i3 = 0; i3 < methodArray.length; ++i3) {
                int n4;
                object4 = methodArray[i3];
                if (object4 == null || Modifier.isStatic(n4 = ((Method)object4).getModifiers()) || !((String)(object3 = ((Method)object4).getName())).startsWith(ADD_PREFIX) && !((String)object3).startsWith(REMOVE_PREFIX) && !((String)object3).startsWith(GET_PREFIX)) continue;
                object2 = ((Method)object4).getParameterTypes();
                genericDeclaration = ((Method)object4).getReturnType();
                if (((String)object3).startsWith(ADD_PREFIX) && ((Class<?>[])object2).length == 1 && genericDeclaration == Void.TYPE && Introspector.isSubclass(object2[0], eventListenerType)) {
                    object = ((String)object3).substring(3);
                    if (((String)object).length() <= 0 || !object2[0].getName().endsWith((String)object)) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<Object, Object>();
                    }
                    hashMap.put(object, object4);
                    continue;
                }
                if (((String)object3).startsWith(REMOVE_PREFIX) && ((Class<?>[])object2).length == 1 && genericDeclaration == Void.TYPE && Introspector.isSubclass(object2[0], eventListenerType)) {
                    object = ((String)object3).substring(6);
                    if (((String)object).length() <= 0 || !object2[0].getName().endsWith((String)object)) continue;
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<Object, Object>();
                    }
                    hashMap2.put(object, object4);
                    continue;
                }
                if (!((String)object3).startsWith(GET_PREFIX) || ((Class<?>[])object2).length != 0 || !((Class)genericDeclaration).isArray() || !Introspector.isSubclass(((Class)genericDeclaration).getComponentType(), eventListenerType) || ((String)(object = ((String)object3).substring(3, ((String)object3).length() - 1))).length() <= 0 || !((Class)genericDeclaration).getComponentType().getName().endsWith((String)object)) continue;
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<Object, Object>();
                }
                hashMap3.put(object, object4);
            }
            if (hashMap != null && hashMap2 != null) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object4 = (String)iterator.next();
                    if (hashMap2.get(object4) == null || !((String)object4).endsWith("Listener")) continue;
                    String string = Introspector.decapitalize(((String)object4).substring(0, ((String)object4).length() - 8));
                    object3 = (Method)hashMap.get(object4);
                    object2 = (Method)hashMap2.get(object4);
                    genericDeclaration = null;
                    if (hashMap3 != null) {
                        genericDeclaration = (Method)hashMap3.get(object4);
                    }
                    object = ((Method)object3).getParameterTypes()[0];
                    Method[] methodArray2 = Introspector.getPublicDeclaredMethods((Class)object);
                    ArrayList<Method> arrayList = new ArrayList<Method>(methodArray2.length);
                    for (int i4 = 0; i4 < methodArray2.length; ++i4) {
                        if (methodArray2[i4] == null || !this.isEventHandler(methodArray2[i4])) continue;
                        arrayList.add(methodArray2[i4]);
                    }
                    Method[] methodArray3 = arrayList.toArray(new Method[arrayList.size()]);
                    EventSetDescriptor eventSetDescriptor = new EventSetDescriptor(string, (Class)object, methodArray3, (Method)object3, (Method)object2, (Method)genericDeclaration);
                    Class<?> clazz = class$java$util$TooManyListenersException;
                    if (clazz == null) {
                        clazz = new TooManyListenersException[0].getClass().getComponentType();
                    }
                    if (this.throwsException((Method)object3, clazz)) {
                        eventSetDescriptor.setUnicast(true);
                    }
                    this.addEvent(eventSetDescriptor);
                }
            }
        }
        if (this.events.size() == 0) {
            eventSetDescriptorArray = EMPTY_EVENTSETDESCRIPTORS;
        } else {
            eventSetDescriptorArray = new EventSetDescriptor[this.events.size()];
            eventSetDescriptorArray = this.events.values().toArray(eventSetDescriptorArray);
            if (this.defaultEventName != null) {
                for (int i5 = 0; i5 < eventSetDescriptorArray.length; ++i5) {
                    if (!this.defaultEventName.equals(eventSetDescriptorArray[i5].getName())) continue;
                    this.defaultEventIndex = i5;
                }
            }
        }
        return eventSetDescriptorArray;
    }

    private void addEvent(EventSetDescriptor eventSetDescriptor) {
        EventSetDescriptor eventSetDescriptor2;
        String string = eventSetDescriptor.getName();
        if (eventSetDescriptor.getName().equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((eventSetDescriptor2 = (EventSetDescriptor)this.events.get(string)) == null) {
            this.events.put(string, eventSetDescriptor);
            return;
        }
        EventSetDescriptor eventSetDescriptor3 = new EventSetDescriptor(eventSetDescriptor2, eventSetDescriptor);
        this.events.put(string, eventSetDescriptor3);
    }

    private MethodDescriptor[] getTargetMethodInfo() {
        int n2;
        int n3;
        if (this.methods == null) {
            this.methods = new HashMap(100);
        }
        MethodDescriptor[] methodDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            methodDescriptorArray = this.explicitBeanInfo.getMethodDescriptors();
        }
        if (methodDescriptorArray == null && this.superBeanInfo != null) {
            MethodDescriptor[] methodDescriptorArray2 = this.superBeanInfo.getMethodDescriptors();
            for (n3 = 0; n3 < methodDescriptorArray2.length; ++n3) {
                this.addMethod(methodDescriptorArray2[n3]);
            }
        }
        for (n2 = 0; n2 < this.additionalBeanInfo.length; ++n2) {
            MethodDescriptor[] methodDescriptorArray3 = this.additionalBeanInfo[n2].getMethodDescriptors();
            if (methodDescriptorArray3 == null) continue;
            for (int i2 = 0; i2 < methodDescriptorArray3.length; ++i2) {
                this.addMethod(methodDescriptorArray3[i2]);
            }
        }
        if (methodDescriptorArray != null) {
            for (n2 = 0; n2 < methodDescriptorArray.length; ++n2) {
                this.addMethod(methodDescriptorArray[n2]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n3 = 0; n3 < methodArray.length; ++n3) {
                Method method = methodArray[n3];
                if (method == null) continue;
                MethodDescriptor methodDescriptor = new MethodDescriptor(method);
                this.addMethod(methodDescriptor);
            }
        }
        MethodDescriptor[] methodDescriptorArray4 = new MethodDescriptor[this.methods.size()];
        methodDescriptorArray4 = this.methods.values().toArray(methodDescriptorArray4);
        return methodDescriptorArray4;
    }

    private void addMethod(MethodDescriptor methodDescriptor) {
        String string = methodDescriptor.getName();
        MethodDescriptor methodDescriptor2 = (MethodDescriptor)this.methods.get(string);
        if (methodDescriptor2 == null) {
            this.methods.put(string, methodDescriptor);
            return;
        }
        Class<?>[] classArray = methodDescriptor.getMethod().getParameterTypes();
        Class<?>[] classArray2 = methodDescriptor2.getMethod().getParameterTypes();
        boolean bl2 = false;
        if (classArray.length == classArray2.length) {
            bl2 = true;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (classArray[i2] == classArray2[i2]) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            MethodDescriptor methodDescriptor3 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
            this.methods.put(string, methodDescriptor3);
            return;
        }
        String string2 = this.makeQualifiedMethodName(methodDescriptor);
        methodDescriptor2 = (MethodDescriptor)this.methods.get(string2);
        if (methodDescriptor2 == null) {
            this.methods.put(string2, methodDescriptor);
            return;
        }
        MethodDescriptor methodDescriptor4 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
        this.methods.put(string2, methodDescriptor4);
    }

    private String makeQualifiedMethodName(MethodDescriptor methodDescriptor) {
        Method method = methodDescriptor.getMethod();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append("=");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(":");
            stringBuffer.append(classArray[i2].getName());
        }
        return stringBuffer.toString();
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private BeanDescriptor getTargetBeanDescriptor() {
        BeanDescriptor beanDescriptor;
        if (this.explicitBeanInfo != null && (beanDescriptor = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private boolean isEventHandler(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return false;
        }
        Class<?> clazz = classArray[0];
        Class<?> clazz2 = class$java$util$EventObject;
        if (clazz2 == null) {
            clazz2 = class$java$util$EventObject = new EventObject[0].getClass().getComponentType();
        }
        return Introspector.isSubclass(clazz, clazz2);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        Method[] methodArray = null;
        if (!Introspector.isPackageAccessible(clazz)) {
            return new Method[0];
        }
        final Class clazz2 = clazz;
        Reference reference = (Reference)declaredMethodCache.get(clazz2);
        if (reference != null && (methodArray = (Method[])reference.get()) != null) {
            return methodArray;
        }
        methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz2.getDeclaredMethods();
            }
        });
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            int n2 = method.getModifiers();
            if (Modifier.isPublic(n2)) continue;
            method.setAccessible(true);
        }
        declaredMethodCache.put(clazz2, new SoftReference<Method[]>(methodArray));
        return methodArray;
    }

    private static Method internalFindMethod(Class classArray, String string, int n2, Class[] classArray2) {
        Object object;
        Method method = null;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            Method[] methodArray = Introspector.getPublicDeclaredMethods((Class)object);
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                method = methodArray[i2];
                if (method == null) continue;
                Class<?>[] classArray3 = method.getParameterTypes();
                if (!method.getName().equals(string) || classArray3.length != n2) continue;
                if (classArray2 != null) {
                    boolean bl2 = false;
                    if (n2 > 0) {
                        for (int i3 = 0; i3 < n2; ++i3) {
                            if (classArray3[i3] == classArray2[i3]) continue;
                            bl2 = true;
                        }
                        if (bl2) continue;
                    }
                }
                return method;
            }
        }
        method = null;
        object = classArray.getInterfaces();
        for (int i4 = 0; i4 < ((Class<?>[])object).length && (method = Introspector.internalFindMethod(object[i4], string, n2, null)) == null; ++i4) {
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string, int n2) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = Introspector.findMethod(clazz, string, n2, null);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s).");
    }

    public static Method findMethod(Class clazz, String string, int n2, Class[] classArray) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = Introspector.internalFindMethod(clazz, string, n2, classArray);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s) of matching types.");
    }

    public static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (!clazz2.isInterface()) continue;
            Class<?>[] classArray = clazz3.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (!Introspector.isSubclass(classArray[i2], clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] != clazz) continue;
            return true;
        }
        return false;
    }

    public static Object instantiate(Class clazz, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz2 = classLoader.loadClass(string);
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader != null) {
                Class<?> clazz3 = classLoader.loadClass(string);
                return clazz3.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz4 = classLoader.loadClass(string);
        return clazz4.newInstance();
    }

    public static boolean isPackageAccessible(Class clazz) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                int n2;
                String string = clazz.getName().replace('/', '.');
                if (string.startsWith("[") && (n2 = string.lastIndexOf(91) + 2) > 1 && n2 < string.length()) {
                    string = string.substring(n2);
                }
                if ((n2 = string.lastIndexOf(46)) != -1) {
                    securityManager.checkPackageAccess(string.substring(0, n2));
                }
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    static {
        Class<?> clazz = class$java$util$EventListener;
        if (clazz == null) {
            clazz = class$java$util$EventListener = new EventListener[0].getClass().getComponentType();
        }
        eventListenerType = clazz;
        searchPath = new String[]{DEFAULT_INFO_PATH};
        EMPTY_EVENTSETDESCRIPTORS = new EventSetDescriptor[0];
    }
}

