/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.gw;
import com.j_spaces.obf.li;
import com.j_spaces.tools.spacebrowser.ICreateSpace;
import com.j_spaces.tools.spacebrowser.NewSpaceDialog;
import com.j_spaces.tools.spacebrowser.ProgressMonitorBar;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConfigAdvancedPanel;
import com.j_spaces.tools.spacebrowser.SpaceConfigException;
import com.j_spaces.tools.spacebrowser.SpaceConfigStandardPanel;
import com.j_spaces.tools.spacebrowser.StaleSpaceService;
import com.j_spaces.tools.spacebrowser.XMLFileFilter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class SpaceConfigPanel
extends JPanel
implements ActionListener,
ItemListener {
    private final String MODE_STANDARD = "Standard";
    private final String MODE_ADVANCED = "Advanced";
    private static final String DIALOG_NEWSPACE_CLASSES = "dialog.newspace.rdbms.classes";
    private static final String DIALOG_NEWSPACE_URLS = "dialog.newspace.rdbms.urls";
    private static final String DIALOG_NEWSPACE_URLS_PERSIST = "dialog.newspace.rdbms.urlspesist";
    public static final String MSG_ERROR_SA = "Please define storage adapter class and url value.";
    public static final String MSG_ERROR_CLUSTER_URL = "Please define cluster configuration file name.";
    public static final String MSG_ERROR_CLUSTER_REPLICATION_GROUP = "Please define replication group for dynamic member.";
    private JPanel panNorth = new JPanel();
    private JPanel panAttributes = new JPanel();
    private JPanel panSouth = new JPanel();
    private JPanel panCenter = new JPanel();
    private JLabel labSpaceName = new JLabel();
    private JLabel labSpaceState = new JLabel();
    public JTextField txtfSpaceName = new JTextField();
    private JTextField txtfSpaceState = new JTextField();
    private JComboBox schemasCombo = new JComboBox();
    private JButton butViewMode = new JButton();
    private JButton butReset = new JButton();
    private JButton saveButton = new JButton();
    private JButton saveAsButton = new JButton();
    private JCheckBox chboxPrivate = new JCheckBox();
    public JCheckBox chboxPersistent = new JCheckBox();
    public JCheckBox chboxClustered = new JCheckBox();
    private JCheckBox chboxLoadOnStartup = new JCheckBox();
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout_NorthPanel = new GridBagLayout();
    private GridBagLayout gridBagLayout_AttributesPanel = new GridBagLayout();
    private GridBagLayout gridBagLayout_SouthPanel = new GridBagLayout();
    private CardLayout cardLayout_panCenter = new CardLayout();
    private TitledBorder titledBorder1;
    private JLabel loadFromLabel = new JLabel();
    private SpaceBrowser m_spaceBrowser;
    private ICreateSpace m_createDialog;
    private boolean m_isCreateMode;
    private boolean m_isAdvancedMode;
    public SpaceConfigAdvancedPanel advancedPanel;
    private SpaceConfigStandardPanel standardPanel;
    private String[] storAdapterClasses;
    private String[] storAdapterUrls;
    private String[] storAdapterUrlsPersist;
    private boolean initCombo = false;
    private ComboBoxModel m_modelSAClasses;
    private ComboBoxModel m_modelSAUrls;
    private static final String SPACE_SOURCE_CONFIG_FILE = "Configuration File";
    private static final String SPACE_SOURCE_SCHEMA_FILE = "Schema File";
    public Hashtable conConfigTable = new Hashtable();
    public SpaceConfig m_defaultSpaceConfig;
    private IJSpace m_spaceProxy;
    private SpaceConfig curSpaceConfig;
    private Map curSpaceSchemasMap;
    private boolean isNewSpaceCreationMode = false;
    private JFileChooser fileChooser;
    private static final String SPACE_SCHEMA_POSTFIX_FILE_NAME = "*-space-schema.xml";
    private static final String SPACE_CONFIG_POSTFIX_FILE_NAME = "*.xml";
    private final XMLFileFilter spaceSchemaFileFilter = new XMLFileFilter("Schema File( *-space-schema.xml )");
    private final XMLFileFilter spaceConfigFileFilter = new XMLFileFilter("Configuration File( *.xml )");

    public SpaceConfigPanel(SpaceBrowser spaceBrowser, ICreateSpace iCreateSpace) {
        this.m_spaceBrowser = spaceBrowser;
        this.m_createDialog = iCreateSpace;
        if (this.m_createDialog != null) {
            this.isNewSpaceCreationMode = true;
        }
        this.m_isCreateMode = iCreateSpace != null;
        try {
            this.jbInit();
            this.init();
            this.setFirstEnableComponentsMode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SpaceConfigPanel(SpaceBrowser spaceBrowser) {
        this(spaceBrowser, null);
    }

    private void jbInit() throws Exception {
        this.panNorth.setLayout(this.gridBagLayout_NorthPanel);
        this.panSouth.setLayout(this.gridBagLayout_SouthPanel);
        this.labSpaceName.setText("Space Name:");
        this.labSpaceState.setText("Space State:");
        this.butViewMode.setText("Advanced");
        this.butReset.setText("Reset");
        this.chboxPrivate.setText("Private");
        this.chboxPersistent.setText("Persistent");
        this.chboxClustered.setText("Clustered");
        this.chboxLoadOnStartup.setText("Load On Startup");
        this.chboxLoadOnStartup.setMnemonic('L');
        this.chboxPrivate.setMnemonic('v');
        this.saveButton.setText("Save");
        this.saveAsButton.setText("Save As...");
        this.saveButton.setMnemonic('s');
        this.panNorth.add((Component)this.labSpaceName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panNorth.add((Component)this.txtfSpaceName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        Box box = this.createSchemasBox();
        this.panNorth.add((Component)box, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        if (!this.m_isCreateMode) {
            this.panNorth.add((Component)this.labSpaceState, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panNorth.add((Component)this.txtfSpaceState, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 3), 0, 0));
        }
        this.panNorth.add((Component)this.panAttributes, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panAttributes.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Attributes"));
        this.panAttributes.setLayout(this.gridBagLayout_AttributesPanel);
        this.panAttributes.add((Component)this.chboxPrivate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.chboxPersistent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.chboxClustered, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panAttributes.add((Component)this.chboxLoadOnStartup, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 0.0;
        this.panSouth.add((Component)this.butViewMode, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        if (this.m_isCreateMode) {
            this.panSouth.add((Component)this.butReset, gridBagConstraints);
        } else {
            this.panSouth.add((Component)this.saveButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.panSouth.add((Component)this.saveAsButton, gridBagConstraints);
        }
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Space Configuration - Standard");
        this.setBorder(this.titledBorder1);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.panNorth, "North");
        this.add((Component)this.panSouth, "South");
    }

    private Box createSchemasBox() {
        Box box = new Box(0);
        Dimension dimension = new Dimension(200, 22);
        this.schemasCombo.setPreferredSize(dimension);
        this.schemasCombo.setMaximumSize(dimension);
        this.schemasCombo.addItem("default");
        this.schemasCombo.addItemListener(this);
        JLabel jLabel = new JLabel("Schemas:");
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(23));
        box.add(this.schemasCombo);
        if (!this.isNewSpaceCreationMode) {
            JLabel jLabel2 = new JLabel("Loaded from: ");
            Font font = this.loadFromLabel.getFont();
            Font font2 = new Font(font.getName(), 1, font.getSize());
            this.loadFromLabel.setFont(font2);
            box.add(Box.createHorizontalStrut(15));
            box.add(jLabel2);
            box.add(this.loadFromLabel);
            box.add(Box.createHorizontalGlue());
        }
        return box;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1 && object == this.schemasCombo && !this.initCombo) {
            Object object2 = itemEvent.getItem();
            SpaceConfig spaceConfig = (SpaceConfig)this.curSpaceSchemasMap.get(object2);
            String string = this.txtfSpaceName.getText();
            this.updateDialog(spaceConfig, false);
            this.txtfSpaceName.setText(string);
        }
    }

    public String getSelectedSchemaName() {
        return (String)this.schemasCombo.getSelectedItem();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            this.invokeSave();
        } else if (object == this.saveAsButton) {
            this.invokeSaveAs();
        }
    }

    public void setLoadOnStartupCheckBoxSelected(boolean bl2) {
        this.chboxLoadOnStartup.setSelected(bl2);
    }

    private void init() throws Exception {
        this.storAdapterClasses = SpaceBrowser.getResources(DIALOG_NEWSPACE_CLASSES);
        this.storAdapterUrls = SpaceBrowser.getResources(DIALOG_NEWSPACE_URLS);
        this.storAdapterUrlsPersist = SpaceBrowser.getResources(DIALOG_NEWSPACE_URLS_PERSIST);
        this.advancedPanel = new SpaceConfigAdvancedPanel(this, this.m_spaceBrowser, this.m_isCreateMode);
        this.standardPanel = new SpaceConfigStandardPanel(this, this.m_spaceBrowser, this.m_isCreateMode);
        this.m_modelSAClasses = new DefaultComboBoxModel<String>(this.storAdapterClasses);
        this.m_modelSAUrls = new DefaultComboBoxModel<String>(this.storAdapterUrls);
        this.advancedPanel.setModelForSAComboxBoxes(this.m_modelSAClasses, this.m_modelSAUrls);
        this.standardPanel.setModelForSAComboxBoxes(this.m_modelSAClasses, this.m_modelSAUrls);
        this.advancedPanel.cmboxSAClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceConfigPanel.this.comboBoxAction(actionEvent, SpaceConfigPanel.this.advancedPanel);
            }
        });
        this.standardPanel.cmboxSAClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceConfigPanel.this.comboBoxAction(actionEvent, SpaceConfigPanel.this.advancedPanel);
            }
        });
        this.panCenter.setLayout(this.cardLayout_panCenter);
        this.panCenter.add("Standard", this.standardPanel);
        this.panCenter.add("Advanced", this.advancedPanel);
        this.add((Component)this.panCenter, "Center");
        this.saveButton.addActionListener(this);
        this.saveAsButton.addActionListener(this);
        this.chboxClustered.setMnemonic(84);
        this.chboxClustered.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = SpaceConfigPanel.this.chboxClustered.isSelected();
                SpaceConfigPanel.this.advancedPanel.setClusterTabEnabled(bl2, true);
                SpaceConfigPanel.this.standardPanel.setClusterEnabled(bl2);
            }
        });
        this.chboxPersistent.setMnemonic(80);
        this.chboxPersistent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SpaceConfigPanel.this.m_isCreateMode) {
                    SpaceConfigPanel.this.chboxPersistent.setSelected(!SpaceConfigPanel.this.chboxPersistent.isSelected());
                } else {
                    boolean bl2 = SpaceConfigPanel.this.chboxPersistent.isSelected();
                    SpaceConfigPanel.this.advancedPanel.setPersistenceTabEnabled(bl2, true);
                    SpaceConfigPanel.this.standardPanel.setPersistenceEnabled(bl2);
                }
            }
        });
        this.butViewMode.setMnemonic(65);
        this.butViewMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SpaceConfigPanel.this.butViewMode.getText();
                SpaceConfigPanel.this.cardLayout_panCenter.show(SpaceConfigPanel.this.panCenter, string);
                String string2 = string.equals("Standard") ? "Advanced" : "Standard";
                SpaceConfigPanel.this.butViewMode.setText(string2);
                SpaceConfigPanel.this.titledBorder1.setTitle("Space Configuration - " + string);
                SpaceConfigPanel.this.m_isAdvancedMode = !SpaceConfigPanel.this.m_isAdvancedMode;
                if (string.equals("Standard")) {
                    SpaceConfigPanel.this.advancedPanel.copySettingsTo(SpaceConfigPanel.this.standardPanel);
                } else {
                    SpaceConfigPanel.this.standardPanel.copySettingsTo(SpaceConfigPanel.this.advancedPanel);
                }
                SpaceConfigPanel.this.validate();
                SpaceConfigPanel.this.repaint();
            }
        });
        this.butReset.setMnemonic(82);
        this.butReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SpaceConfigPanel.this.m_createDialog != null) {
                    SpaceConfigPanel.this.m_createDialog.cleanup();
                }
                if (SpaceConfigPanel.this.m_defaultSpaceConfig != null) {
                    try {
                        SpaceConfig spaceConfig = (SpaceConfig)SpaceConfigPanel.this.m_defaultSpaceConfig.clone();
                        spaceConfig.setStorageAdapterClass((String)SpaceConfigPanel.this.m_modelSAClasses.getElementAt(0));
                        spaceConfig.setStorageAdapterURL((String)SpaceConfigPanel.this.m_modelSAUrls.getElementAt(0));
                        SpaceConfigPanel.this.updateDialog(spaceConfig, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SpaceConfigPanel.this.txtfSpaceName.requestFocus();
            }
        });
        this.chboxPrivate.setToolTipText("A private space is a space that does not allow users to access it using an rmi or Jini address.");
        this.chboxPersistent.setToolTipText("A persistent space keeps its data in a persistent backend and can therefore survive server crashes.");
        this.chboxClustered.setToolTipText("Allows building clustered spaces with Replication, Fail Over and Load Balancing schemes.");
        this.chboxLoadOnStartup.setToolTipText("Automatically start up space within container when container starts");
    }

    public void setDefaultSpaceConfig(SpaceConfig spaceConfig, Map map) {
        this.m_defaultSpaceConfig = spaceConfig;
        this.curSpaceSchemasMap = map;
        this.updateSchemasCombo();
    }

    private void updateSchemasCombo() {
        Object object;
        Set set = this.curSpaceSchemasMap.keySet();
        Iterator iterator = set.iterator();
        Vector vector = new Vector(this.curSpaceSchemasMap.size());
        while (iterator.hasNext()) {
            object = iterator.next();
            vector.add(object);
        }
        Collections.sort(vector);
        object = new DefaultComboBoxModel(vector);
        this.initCombo = true;
        this.schemasCombo.setModel(object);
        this.initCombo = false;
        String string = (String)this.schemasCombo.getSelectedItem();
        if (string != null) {
            SpaceConfig spaceConfig = (SpaceConfig)this.curSpaceSchemasMap.get(string);
            this.updateDialog(spaceConfig, false);
        }
    }

    private void setFirstEnableComponentsMode() {
        this.txtfSpaceName.setEditable(this.m_isCreateMode);
        this.txtfSpaceState.setEditable(false);
        this.schemasCombo.setEnabled(this.m_isCreateMode);
        this.advancedPanel.setPersistenceTabEnabled(this.chboxPersistent.isSelected(), false);
        this.standardPanel.setPersistenceEnabled(this.chboxPersistent.isSelected());
        this.advancedPanel.setClusterTabEnabled(this.chboxClustered.isSelected(), false);
        this.standardPanel.setClusterEnabled(this.chboxClustered.isSelected());
    }

    public void setGenericPrincipal(GenericPrincipal[] genericPrincipalArray) {
        this.advancedPanel.setGenericPrincipal(genericPrincipalArray);
    }

    public SpaceConfig getConfig() {
        return this.getConfig(null);
    }

    public SpaceConfig getConfig(String string) {
        SpaceConfig spaceConfig = null;
        try {
            if (!this.m_isAdvancedMode) {
                this.standardPanel.copySettingsTo(this.advancedPanel);
            }
            spaceConfig = this.advancedPanel.getConfig(string);
            if (!this.m_isAdvancedMode) {
                this.standardPanel.updateConfig(spaceConfig);
            }
        }
        catch (SpaceConfigException spaceConfigException) {
            JOptionPane.showMessageDialog(this, spaceConfigException.getMessage());
            this.saveButton.setEnabled(true);
            this.saveAsButton.setEnabled(true);
            return null;
        }
        spaceConfig.setPrivate(this.chboxPrivate.isSelected());
        spaceConfig.setSpaceName(this.txtfSpaceName.getText().trim());
        spaceConfig.setSchemaName(this.curSpaceConfig.getSchemaName());
        spaceConfig.setLoadOnStartup(this.chboxLoadOnStartup.isSelected());
        spaceConfig.setPersistent(this.chboxPersistent.isSelected());
        return spaceConfig;
    }

    public SpaceConfig getSelectedSpaceSchemaConfig() {
        return (SpaceConfig)this.curSpaceSchemasMap.get(this.schemasCombo.getSelectedItem());
    }

    public SpaceConfigAdvancedPanel getAdvanced() {
        return this.advancedPanel;
    }

    public SpaceConfigStandardPanel getStandard() {
        return this.standardPanel;
    }

    public void updateComboBoxModel(JComboBox jComboBox) {
        String string = (String)jComboBox.getEditor().getItem();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        if (string != null && string.length() > 0 && defaultComboBoxModel.getIndexOf(string) == -1) {
            jComboBox.addItem(string);
            jComboBox.setSelectedItem(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSaveAs() {
        Object object;
        if (this.fileChooser == null) {
            this.m_spaceBrowser.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.addChoosableFileFilter(this.spaceSchemaFileFilter);
                this.fileChooser.addChoosableFileFilter(this.spaceConfigFileFilter);
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.setFileFilter(this.spaceSchemaFileFilter);
                this.fileChooser.setDialogTitle("Save Space As");
                object = new File(li.b());
                this.fileChooser.setCurrentDirectory((File)object);
            }
            finally {
                this.m_spaceBrowser.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.fileChooser.showSaveDialog(this.m_spaceBrowser);
        object = this.fileChooser.getFileFilter();
        File file = this.fileChooser.getSelectedFile();
        String string = null;
        if (file != null) {
            String string2 = file.getPath();
            boolean bl2 = true;
            String string3 = "";
            if (object.equals(this.spaceSchemaFileFilter)) {
                string2 = string2 + "-space-schema.xml";
                string = this.txtfSpaceName.getText();
                string3 = file.getName();
            } else if (object.equals(this.spaceConfigFileFilter)) {
                string2 = string2 + ".xml";
                bl2 = false;
                string = file.getName();
                string3 = "";
            }
            SpaceConfig spaceConfig = this.getConfig(string);
            ((JSpaceAttributes)spaceConfig).setProperty("space-config.schema", string3);
            spaceConfig.setSchemaName(string3);
            file = new File(string2);
            gw.a(file, bl2, string, spaceConfig);
        }
    }

    private void invokeSave() {
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin;
        Object object;
        int n2;
        String string = this.curSpaceConfig.getSchemaName();
        if (!JSpaceUtilities.isEmpty(string) && (n2 = JOptionPane.showConfirmDialog(this.m_spaceBrowser, object = "Save operation will update '" + string + "' schema.\nDo you want to continue?", "Update Schema", 0, 2)) == 1) {
            return;
        }
        this.saveButton.setEnabled(false);
        object = (DefaultMutableTreeNode)this.m_spaceBrowser.getSelectedTreeNode();
        if (object == null) {
            return;
        }
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 instanceof StaleSpaceService) {
            return;
        }
        IJSpace iJSpace = (IJSpace)((JSpaceProxyWrapper)object2).proxy();
        try {
            iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
        }
        catch (RemoteException remoteException) {
            SpaceBrowser.expDialog.showException("Updating space configuration", remoteException);
            return;
        }
        SpaceConfig spaceConfig = this.getConfig();
        if (spaceConfig != null) {
            Thread thread = new Thread(new ConfigUpdater((DefaultMutableTreeNode)object, iRemoteJSpaceAdmin, spaceConfig, null));
            thread.start();
        }
    }

    public void updateDialog(String string, IJSpace iJSpace) {
        this.updateDialog(string, iJSpace, true);
    }

    public void updateDialog(String string, IJSpace iJSpace, boolean bl2) {
        this.m_spaceProxy = iJSpace;
        this.saveButton.setEnabled(true);
        this.saveAsButton.setEnabled(true);
        try {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            String string2 = iJSpace.getName();
            Hashtable<String, SpaceConfig> hashtable = (Hashtable<String, SpaceConfig>)this.conConfigTable.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable<String, SpaceConfig>();
                this.conConfigTable.put(string, hashtable);
            }
            SpaceConfig spaceConfig = (SpaceConfig)hashtable.get(string2);
            if (!bl2 || spaceConfig == null) {
                spaceConfig = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getConfig();
                hashtable.put(string2, spaceConfig);
            }
            if (!this.m_isCreateMode && iJSpace != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_spaceBrowser.m_proxyServiceTable.get(iJSpace)) != null && (object = defaultMutableTreeNode.getUserObject()) instanceof JSpaceProxyWrapper) {
                this.updateSpaceState(null, ((JSpaceProxyWrapper)object).getState());
            }
            this.updateDialog(spaceConfig, false);
            this.advancedPanel.setCurContainerName(string);
        }
        catch (Exception exception) {
            this.saveButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            SpaceBrowser.expDialog.showException("updating space configuration", exception);
        }
    }

    public IJSpace getSpaceProxy() {
        return this.m_spaceProxy;
    }

    public void updateSpaceState(String string, int n2) {
        if (string == null || this.txtfSpaceName.getText().trim().equals(string)) {
            this.txtfSpaceState.setText(JSpaceState.convertToString(new Integer(n2)));
        }
    }

    public String getSpaceName() {
        return this.txtfSpaceName.getText();
    }

    public void updateDialog(SpaceConfig spaceConfig, boolean bl2) {
        try {
            this.curSpaceConfig = spaceConfig;
            this.txtfSpaceName.setText(spaceConfig.getSpaceName());
            this.chboxPrivate.setSelected(spaceConfig.isPrivate());
            this.chboxClustered.setSelected(spaceConfig.isClustered());
            if (this.m_createDialog == null || !(this.m_createDialog instanceof NewSpaceDialog)) {
                this.chboxLoadOnStartup.setSelected(spaceConfig.isLoadOnStartup());
            }
            this.chboxPersistent.setSelected(spaceConfig.isPersistent() ? !bl2 : false);
            String string = spaceConfig.getSchemaName();
            if (string != null) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.schemasCombo.getModel();
                boolean bl3 = defaultComboBoxModel.getIndexOf(string) != -1;
                this.initCombo = true;
                if (!bl3) {
                    this.schemasCombo.addItem(string);
                }
                this.schemasCombo.setSelectedItem(string);
                this.initCombo = false;
                this.loadFromLabel.setText(SPACE_SOURCE_SCHEMA_FILE);
            } else {
                this.loadFromLabel.setText(SPACE_SOURCE_CONFIG_FILE);
                this.saveAsButton.setEnabled(false);
            }
            this.advancedPanel.updateSettings(spaceConfig, bl2);
            this.standardPanel.updateSettings(spaceConfig, bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cleanup() {
        this.conConfigTable.clear();
        this.advancedPanel.cleanup();
        this.standardPanel.cleanup();
        this.txtfSpaceName.setText("");
        this.txtfSpaceState.setText("");
        JSpaceUtilities.cleanAWTContainer(this.panAttributes);
        this.saveButton.setEnabled(false);
        this.saveAsButton.setEnabled(false);
        this.schemasCombo.removeAllItems();
    }

    private void comboBoxAction(ActionEvent actionEvent, SpaceConfigAdvancedPanel spaceConfigAdvancedPanel) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            String string = (String)spaceConfigAdvancedPanel.cmboxSAClass.getSelectedItem();
            if (string.endsWith("JDBCStorageAdapter")) {
                this.updateSaUrl(spaceConfigAdvancedPanel, this.storAdapterUrls);
                spaceConfigAdvancedPanel.cmboxSAClass.setToolTipText("JDBC interface with the database");
            } else {
                this.advancedPanel.rbutCachePolicyLRU.setSelected(true);
                this.advancedPanel.setMemoryManagementCompEnabled(true);
                this.updateSaUrl(spaceConfigAdvancedPanel, this.storAdapterUrlsPersist);
                spaceConfigAdvancedPanel.cmboxSAClass.setToolTipText("Generic interface with the database");
            }
        }
    }

    private void updateSaUrl(SpaceConfigAdvancedPanel spaceConfigAdvancedPanel, String[] stringArray) {
        spaceConfigAdvancedPanel.cmboxSAUrl.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            spaceConfigAdvancedPanel.cmboxSAUrl.addItem(stringArray[i2]);
        }
    }

    private final class ConfigUpdater
    implements Runnable {
        private DefaultMutableTreeNode spaceNode;
        private IRemoteJSpaceAdmin spaceAdmin;
        private SpaceConfig config;
        private ProgressMonitorBar progressBar;

        private ConfigUpdater(DefaultMutableTreeNode defaultMutableTreeNode, IRemoteJSpaceAdmin iRemoteJSpaceAdmin, SpaceConfig spaceConfig) {
            this.spaceNode = defaultMutableTreeNode;
            this.spaceAdmin = iRemoteJSpaceAdmin;
            this.config = spaceConfig;
            this.progressBar = new ProgressMonitorBar(SpaceConfigPanel.this.m_spaceBrowser, "Updating space configuration:", defaultMutableTreeNode.toString());
            this.progressBar.start();
        }

        public void run() {
            block7: {
                String string = null;
                try {
                    String string2 = this.spaceNode.getParent().toString();
                    string = this.spaceNode.toString();
                    this.spaceAdmin.setConfig(this.config);
                    Thread.sleep(2000L);
                    Hashtable hashtable = (Hashtable)SpaceConfigPanel.this.conConfigTable.get(string2);
                    hashtable.put(string, this.config);
                    this.progressBar.terminate();
                    if (this.spaceAdmin.getState() != 0) {
                        SpaceConfigPanel.this.m_spaceBrowser.showStatus("Configuration of " + this.spaceNode + " space updated successfully!");
                        int n2 = JOptionPane.showConfirmDialog(SpaceConfigPanel.this.m_spaceBrowser, this.spaceNode + " space updated successfully!" + "\nYou can restart this space in order for the new configuration to take effect.", "Updating space configuration...", 2);
                        if (n2 == 0) {
                            this.spaceAdmin.restart();
                            JOptionPane.showMessageDialog(SpaceConfigPanel.this.m_spaceBrowser, this.spaceNode + " restarted sucessfully.");
                        }
                    } else {
                        String string3 = "Configuration of " + this.spaceNode + " space was updated successfully.";
                        SpaceConfigPanel.this.m_spaceBrowser.showStatus(string3);
                        JOptionPane.showMessageDialog(SpaceConfigPanel.this.m_spaceBrowser, string3);
                    }
                }
                catch (Exception exception) {
                    Throwable throwable;
                    String string4;
                    boolean bl2 = false;
                    if (exception instanceof RemoteException && (string4 = (throwable = ((RemoteException)exception).detail).getMessage()).indexOf("Access is denied") != -1) {
                        bl2 = true;
                        this.progressBar.terminate();
                        String string5 = null;
                        String string6 = this.config.getSchemaName();
                        String string7 = "Do you want to save space configuration locally?";
                        string5 = string6 != null ? "Unable to change space schema file '" + string6 + "-space-schema.xml" + "'\nsince it has read-only permission." : "Unable to change space configuration file '" + string + ".xml'\nsince it has read-only permission.";
                        int n3 = JOptionPane.showConfirmDialog(SpaceConfigPanel.this.m_spaceBrowser, string5 + "\n" + "Do you want to save space configuration locally?", "Access is denied", 0, 2);
                        if (n3 == 0) {
                            SpaceConfigPanel.this.invokeSaveAs();
                        }
                    }
                    if (bl2) break block7;
                    SpaceConfigPanel.this.m_spaceBrowser.showStatus("Updating configuration of " + this.spaceNode + " space failed: " + exception.getMessage());
                    this.progressBar.terminate();
                    SpaceBrowser.expDialog.showException("updating configuration of " + this.spaceNode + " space", exception);
                }
            }
            SpaceConfigPanel.this.saveButton.setEnabled(true);
            SpaceConfigPanel.this.saveAsButton.setEnabled(true);
        }

        public /* synthetic */ ConfigUpdater(DefaultMutableTreeNode defaultMutableTreeNode, IRemoteJSpaceAdmin iRemoteJSpaceAdmin, SpaceConfig spaceConfig, 1 var5_5) {
            this(defaultMutableTreeNode, iRemoteJSpaceAdmin, spaceConfig);
        }
    }
}

