/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.utils.ComboItemWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DistributedCachePanel
extends JPanel {
    public JLabel labConfigName = new JLabel();
    public JLabel labDelayBetweenRetries = new JLabel();
    public JLabel labUpdatePolicy = new JLabel();
    public JLabel labMaxObjectsInCache = new JLabel();
    public JLabel labMaxObjectTimeout = new JLabel();
    public JLabel labHighWatermarkPercentage = new JLabel();
    public JLabel labLowWatermarkPercentage = new JLabel();
    public JLabel labEvictionBatchSize = new JLabel();
    public JTextField txtfConfigName = new JTextField();
    public JTextField txtfMaxObjectsInCache = new WholeNumberField();
    public JTextField txtfDelayBetweenRetries = new WholeNumberField();
    public JTextField txtfRetryConnections = new WholeNumberField();
    public JTextField txtfMaxObjectTimeout = new WholeNumberField();
    public JTextField txtfHighWatermarkPercentage = new WholeNumberField(false);
    public JTextField txtfLowWatermarkPercentage = new WholeNumberField(false);
    public JTextField txtfEvictionBatchSize = new WholeNumberField();
    public JButton butConfigFile = new JButton();
    private JCheckBox chboxVersionedCache = new JCheckBox();
    private JCheckBox chboxMemoryUsageEnable = new JCheckBox();
    private JCheckBox chBoxMulticastNotify = new JCheckBox("Multicast Notify");
    private JCheckBox chBoxPutFirst = new JCheckBox("Put First");
    private JComboBox cmboxUpdatePolicy;
    private JComboBox cmboxEvictionPolicy;
    private JComboBox cmboxEvictionStrategy;
    private JComboBox cmboxCompression;
    private String UPDATE_POLICY_PULL = "Pull";
    private String UPDATE_POLICY_PUSH = "Push";
    private String EVICTION_POLICY_LRU = "LRU";
    private String EVICTION_POLICY_ALL_IN_CACHE = "All in Cache";
    public GridBagLayout gridBagLayout1 = new GridBagLayout();
    public GridBagLayout gridBagLayout2 = new GridBagLayout();
    public GridBagLayout gridBagLayout4 = new GridBagLayout();
    private ComboItemWrapper compressionComboItemNone;
    private ComboItemWrapper compressionComboItemZip;
    private Vector evictionStartegyItemsVector;
    private static final int comboHeight = 25;

    public DistributedCachePanel() {
        try {
            this.cmboxUpdatePolicy = new JComboBox<Object>(new Object[]{this.UPDATE_POLICY_PULL, this.UPDATE_POLICY_PUSH});
            this.cmboxEvictionPolicy = new JComboBox<Object>(new Object[]{this.EVICTION_POLICY_LRU, this.EVICTION_POLICY_ALL_IN_CACHE});
            this.evictionStartegyItemsVector = this.getEvictionStrategyClassesVector();
            this.cmboxEvictionStrategy = new JComboBox(this.evictionStartegyItemsVector);
            this.cmboxCompression = new JComboBox(this.getCompressionComboValues());
            Dimension dimension = new Dimension(90, 25);
            this.cmboxEvictionPolicy.setPreferredSize(dimension);
            Dimension dimension2 = new Dimension(300, 25);
            this.cmboxEvictionStrategy.setPreferredSize(dimension2);
            Dimension dimension3 = new Dimension(50, 25);
            this.cmboxUpdatePolicy.setPreferredSize(dimension3);
            Dimension dimension4 = new Dimension(65, 25);
            this.cmboxCompression.setPreferredSize(dimension4);
            this.jbInit();
            this.createListeners();
            this.clean();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Vector getEvictionStrategyClassesVector() {
        String string = "com.j_spaces.map.eviction";
        Vector<String> vector = new Vector<String>(11);
        vector.add("com.j_spaces.map.eviction.AgeEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.FBREvictionStrategy");
        vector.add("com.j_spaces.map.eviction.FIFOEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.GDSFEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.IdleEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.LFUEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.LIFOEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.LRUEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.MRUEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.NoneEvictionStrategy");
        vector.add("com.j_spaces.map.eviction.SizeEvictionStrategy");
        return vector;
    }

    private Vector getCompressionComboValues() {
        Vector<ComboItemWrapper> vector = new Vector<ComboItemWrapper>(2);
        this.compressionComboItemNone = new ComboItemWrapper("None", 0);
        this.compressionComboItemZip = new ComboItemWrapper("Zip", 1);
        vector.add(this.compressionComboItemNone);
        vector.add(this.compressionComboItemZip);
        return vector;
    }

    private void createListeners() {
        this.cmboxEvictionPolicy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = DistributedCachePanel.this.cmboxEvictionPolicy.getSelectedItem().equals(DistributedCachePanel.this.EVICTION_POLICY_LRU);
                DistributedCachePanel.this.setMemoryUtilizationCompEditable(bl2);
            }
        });
        this.chboxMemoryUsageEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DistributedCachePanel.this.setMemoryUsageCompEnable(DistributedCachePanel.this.chboxMemoryUsageEnable.isSelected());
            }
        });
    }

    private void setMemoryUtilizationCompEditable(boolean bl2) {
        this.txtfMaxObjectsInCache.setEditable(bl2);
        this.txtfLowWatermarkPercentage.setEditable(bl2);
        this.txtfEvictionBatchSize.setEditable(bl2);
    }

    private void setMemoryUsageCompEnable(boolean bl2) {
        this.labHighWatermarkPercentage.setEnabled(bl2);
        this.labLowWatermarkPercentage.setEnabled(bl2);
        this.labEvictionBatchSize.setEnabled(bl2);
        this.txtfHighWatermarkPercentage.setEnabled(bl2);
        this.txtfLowWatermarkPercentage.setEnabled(bl2);
        this.txtfEvictionBatchSize.setEnabled(bl2);
    }

    public void jbInit() throws Exception {
        this.labConfigName.setText("Configuration Name:");
        this.butConfigFile.setText("...");
        this.chboxVersionedCache.setText("Versioned Cache");
        this.labUpdatePolicy.setText("Update Policy:");
        this.labMaxObjectsInCache.setText("Maximum Number of Objects in the Cache:");
        this.labMaxObjectTimeout.setText("Maximum Object Timeout:");
        this.labHighWatermarkPercentage.setText("High Watermark Percentage:");
        this.labLowWatermarkPercentage.setText("Low Watermark Percentage:");
        this.labEvictionBatchSize.setText("Eviction Batch Size:");
        JPanel jPanel = this.createCommunicationPanel();
        this.labDelayBetweenRetries.setText("Delay Between Retries:");
        this.chboxMemoryUsageEnable.setText("Memory Usage Control");
        JPanel jPanel2 = this.createMemoryUtilizationPanel();
        JPanel jPanel3 = this.createStandardCachePanel();
        JPanel jPanel4 = this.createLightCachePanel();
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.labConfigName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 2), 0, 0));
        this.add((Component)this.txtfConfigName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 0, 0));
        this.add((Component)this.chboxVersionedCache, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.labUpdatePolicy, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
        this.add((Component)this.cmboxUpdatePolicy, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, -4));
        this.add((Component)jPanel3, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createMemoryUtilizationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Memory Utilization"));
        jPanel.setLayout(this.gridBagLayout2);
        jPanel.add((Component)this.labMaxObjectsInCache, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0));
        jPanel.add((Component)this.txtfMaxObjectsInCache, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)this.labMaxObjectTimeout, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfMaxObjectTimeout, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)this.chboxMemoryUsageEnable, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.labHighWatermarkPercentage, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfHighWatermarkPercentage, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)this.labLowWatermarkPercentage, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfLowWatermarkPercentage, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)this.labEvictionBatchSize, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfEvictionBatchSize, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        return jPanel;
    }

    private JPanel createCommunicationPanel() {
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(border, "Communication");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText("Retry Connections:");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfRetryConnections, new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)this.labDelayBetweenRetries, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.txtfDelayBetweenRetries, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        return jPanel;
    }

    private JPanel createStandardCachePanel() {
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(border, "Standard Cache");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText("Eviction Policy:");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.cmboxEvictionPolicy, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 19, 2, 0), 0, -4));
        return jPanel;
    }

    private JPanel createLightCachePanel() {
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        TitledBorder titledBorder = new TitledBorder(border, "Light Cache");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Eviction Strategy:");
        JLabel jLabel2 = new JLabel("Multicast Notify:");
        JLabel jLabel3 = new JLabel("Put First:");
        JLabel jLabel4 = new JLabel("Compression:");
        jPanel.add((Component)this.chBoxMulticastNotify, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        jPanel.add((Component)this.chBoxPutFirst, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.cmboxCompression, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 2, 0), 0, -4));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.cmboxEvictionStrategy, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 5, 2, 0), 0, -4));
        return jPanel;
    }

    public void clean() {
        JSpaceUtilities.cleanAWTContainer(this);
        this.txtfConfigName.setText("DefaultConfig");
    }

    public JSpaceAttributes getConfig() {
        JSpaceAttributes jSpaceAttributes = new JSpaceAttributes();
        JSpaceAttributes jSpaceAttributes2 = new JSpaceAttributes();
        jSpaceAttributes.setDCacheConfigName(this.txtfConfigName.getText().trim());
        jSpaceAttributes2.setProperty("space-config.dist-cache.versioned", String.valueOf(this.chboxVersionedCache.isSelected()));
        jSpaceAttributes2.setProperty("space-config.dist-cache.update-mode", String.valueOf(this.cmboxUpdatePolicy.getSelectedIndex() + 1));
        jSpaceAttributes2.setProperty("space-config.engine.cache_size", this.txtfMaxObjectsInCache.getText().trim());
        jSpaceAttributes2.setProperty("space-config.dist-cache.max-object-timeout", this.txtfMaxObjectTimeout.getText().trim());
        jSpaceAttributes2.setProperty("space-config.engine.memory_usage.high_watermark_percentage", this.txtfHighWatermarkPercentage.getText().trim());
        jSpaceAttributes2.setProperty("space-config.engine.memory_usage.low_watermark_percentage", this.txtfLowWatermarkPercentage.getText().trim());
        jSpaceAttributes2.setProperty("space-config.engine.cache_policy", String.valueOf(this.cmboxEvictionPolicy.getSelectedIndex()));
        jSpaceAttributes2.setProperty("space-config.dist-cache.retry-connections", this.txtfRetryConnections.getText().trim());
        jSpaceAttributes2.setProperty("space-config.dist-cache.delay-between-retries", this.txtfDelayBetweenRetries.getText().trim());
        jSpaceAttributes2.setProperty("space-config.engine.memory_usage.eviction_batch_size", this.txtfEvictionBatchSize.getText().trim());
        jSpaceAttributes2.setProperty("space-config.engine.memory_usage.enabled", String.valueOf(this.chboxMemoryUsageEnable.isSelected()));
        jSpaceAttributes2.setProperty("space-config.dist-cache.compression", String.valueOf(((ComboItemWrapper)this.cmboxCompression.getSelectedItem()).getValue()));
        jSpaceAttributes2.setProperty("space-config.dist-cache.eviction-strategy", this.cmboxEvictionStrategy.getSelectedItem().toString());
        jSpaceAttributes2.setProperty("space-config.dist-cache.multicast-notify", String.valueOf(this.chBoxMulticastNotify.isSelected()));
        jSpaceAttributes2.setProperty("space-config.dist-cache.put-first", String.valueOf(this.chBoxPutFirst.isSelected()));
        jSpaceAttributes.setDCacheProperties(jSpaceAttributes2);
        return jSpaceAttributes;
    }

    public void setConfig(JSpaceAttributes jSpaceAttributes) {
        JSpaceAttributes jSpaceAttributes2 = jSpaceAttributes.getDCacheProperties();
        this.txtfConfigName.setText(jSpaceAttributes.getDCacheConfigName());
        this.txtfDelayBetweenRetries.setText(jSpaceAttributes2.getProperty("space-config.dist-cache.delay-between-retries"));
        this.txtfMaxObjectsInCache.setText(jSpaceAttributes2.getProperty("space-config.engine.cache_size"));
        this.txtfMaxObjectTimeout.setText(jSpaceAttributes2.getProperty("space-config.dist-cache.max-object-timeout"));
        this.txtfHighWatermarkPercentage.setText(jSpaceAttributes2.getProperty("space-config.engine.memory_usage.high_watermark_percentage"));
        this.txtfLowWatermarkPercentage.setText(jSpaceAttributes2.getProperty("space-config.engine.memory_usage.low_watermark_percentage"));
        this.txtfRetryConnections.setText(jSpaceAttributes2.getProperty("space-config.dist-cache.retry-connections"));
        this.chboxVersionedCache.setSelected(new Boolean(jSpaceAttributes2.getProperty("space-config.dist-cache.versioned")));
        this.chboxMemoryUsageEnable.setSelected(new Boolean(jSpaceAttributes2.getProperty("space-config.engine.memory_usage.enabled")));
        this.txtfEvictionBatchSize.setText(jSpaceAttributes2.getProperty("space-config.engine.memory_usage.eviction_batch_size"));
        String string = jSpaceAttributes2.getProperty("space-config.dist-cache.multicast-notify");
        String string2 = jSpaceAttributes2.getProperty("space-config.dist-cache.put-first");
        this.chBoxMulticastNotify.setSelected(new Boolean(string));
        this.chBoxPutFirst.setSelected(new Boolean(string2));
        this.initCompressionCombo(jSpaceAttributes);
        this.initEvictionStrategyClassCombo(jSpaceAttributes);
        this.setMemoryUsageCompEnable(this.chboxMemoryUsageEnable.isSelected());
        int n2 = 0;
        try {
            n2 = Integer.parseInt(jSpaceAttributes2.getProperty("space-config.engine.cache_policy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.cmboxEvictionPolicy.setSelectedIndex(n2);
        n2 = 0;
        try {
            n2 = Integer.parseInt(jSpaceAttributes2.getProperty("space-config.dist-cache.update-mode")) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.cmboxUpdatePolicy.setSelectedIndex(n2);
    }

    private void initCompressionCombo(JSpaceAttributes jSpaceAttributes) {
        String string = jSpaceAttributes.getDCacheProperties().getProperty("space-config.dist-cache.compression");
        if (string == null) {
            this.cmboxCompression.setSelectedIndex(0);
            return;
        }
        int n2 = Integer.parseInt(string);
        switch (n2) {
            case 0: {
                this.cmboxCompression.setSelectedItem(this.compressionComboItemNone);
                break;
            }
            case 1: {
                this.cmboxCompression.setSelectedItem(this.compressionComboItemZip);
                break;
            }
            default: {
                this.cmboxCompression.setSelectedIndex(0);
            }
        }
    }

    private void initEvictionStrategyClassCombo(JSpaceAttributes jSpaceAttributes) {
        String string = jSpaceAttributes.getDCacheProperties().getProperty("space-config.dist-cache.eviction-strategy");
        int n2 = this.evictionStartegyItemsVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.evictionStartegyItemsVector.get(i2).equals(string)) continue;
            this.cmboxEvictionStrategy.setSelectedItem(string);
            break;
        }
    }
}

