/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SecurityContext;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SecureSpaceNode;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceTreeNode;
import com.j_spaces.tools.spacebrowser.StaleSpaceService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class BrowserLoginDialog
extends JDialog {
    private JPanel topPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel buttomPanel = new JPanel();
    private JPanel innerButtonPanel = new JPanel();
    private JPanel helpPanel = new JPanel();
    private JPanel userPanel = new JPanel();
    private JPanel passwordPanel = new JPanel();
    private JPanel picturePanel = new JPanel();
    private JButton cancelButton = new JButton();
    private JButton helpButton = new JButton();
    private JButton loginButton = new JButton();
    private JTextPane descTP = new JTextPane();
    private JLabel userNameL = new JLabel();
    private JLabel passwordL = new JLabel();
    private JPasswordField passTF = new JPasswordField();
    private JComboBox userNameCB = new JComboBox();
    private SpaceBrowser m_browser;
    private DefaultMutableTreeNode m_secureNode;
    private JLabel loginIcon = new JLabel();

    public BrowserLoginDialog(SpaceBrowser spaceBrowser) {
        super(spaceBrowser, "Login to Space...", true);
        this.m_browser = spaceBrowser;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.cancelButton.setText("Cancel");
        this.loginButton.setText("OK");
        this.descTP.setText("Please enter security information.");
        this.userNameL.setText("User Name: ");
        this.passwordL.setText("Password:  ");
        this.descTP.setEnabled(false);
        this.descTP.setBorder(null);
        this.descTP.setBackground(this.loginButton.getBackground());
        this.descTP.setEditable(false);
        this.centerPanel.setLayout(new VerticalFlowLayout());
        this.userPanel.setLayout(new BorderLayout());
        this.passwordPanel.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.userNameCB.setPreferredSize(new Dimension(4, 21));
        this.userNameCB.setEditable(true);
        this.picturePanel.setLayout(new BoxLayout2());
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.picturePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), BorderFactory.createEmptyBorder(5, 3, 5, 5)));
        this.loginIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.buttomPanel.setLayout(new BorderLayout());
        this.helpButton.setText("Help");
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 7, 0));
        this.topPanel.add((Component)this.picturePanel, "Center");
        this.picturePanel.add((Component)this.loginIcon, null);
        this.picturePanel.add((Component)this.descTP, null);
        this.loginIcon.setIcon(new ImageIcon(this.getClass().getResource("/image/browser/loginSpace.gif")));
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.buttomPanel, "South");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.buttomPanel.add((Component)this.innerButtonPanel, "Center");
        this.innerButtonPanel.add((Component)this.loginButton, null);
        this.innerButtonPanel.add((Component)this.cancelButton, null);
        this.centerPanel.add((Component)this.userPanel, null);
        this.centerPanel.add((Component)this.passwordPanel, null);
        this.userPanel.add((Component)this.userNameCB, "Center");
        this.userPanel.add((Component)this.userNameL, "West");
        this.passwordPanel.add((Component)this.passTF, "Center");
        this.passwordPanel.add((Component)this.passwordL, "West");
        JSpaceUtilities.setLocationRelativeTo(this, this.m_browser);
        this.setResizable(false);
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserLoginDialog.this.loginToSpace();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserLoginDialog.this.dispose();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)BrowserLoginDialog.this.m_secureNode.getParent();
                BrowserLoginDialog.this.m_browser.setSelectedTreeNode(defaultMutableTreeNode, true, false);
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof JSpaceProxyWrapper) {
                    JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)object;
                    object = jSpaceProxyWrapper.proxy();
                }
                BrowserLoginDialog.this.m_browser.updateContainerConfig((IJSpaceContainerAdmin)object);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BrowserLoginDialog.this.dispose();
            }
        });
        this.pack();
    }

    private void loginToSpace() {
        try {
            String string;
            IJSpace iJSpace = null;
            Object object = this.m_secureNode.getUserObject();
            String string2 = (String)this.userNameCB.getSelectedItem();
            String string3 = new String(this.passTF.getPassword());
            if (JSpaceUtilities.isEmpty(string2, true)) {
                JOptionPane.showMessageDialog(this, "Please enter the Username.");
                return;
            }
            if (object instanceof SecureSpaceNode) {
                iJSpace = ((SecureSpaceNode)object).getSpaceProxy();
                string = ((SecureSpaceNode)object).getContainerName();
            } else {
                if (object instanceof StaleSpaceService) {
                    this.dispose();
                    throw new RemoteException("Connection with space lost.Reason: Container was shutdowned or Space was destroyed.");
                }
                iJSpace = (IJSpace)((JSpaceProxyWrapper)object).proxy();
                string = ((DefaultMutableTreeNode)this.m_secureNode.getParent()).toString();
            }
            iJSpace.setSecurityContext(new SecurityContext(string2, string3));
            iJSpace.getAdmin();
            this.m_secureNode.setUserObject(new SpaceTreeNode(iJSpace, iJSpace.getContainer()));
            this.m_browser.setSelectedTreeNode(this.m_secureNode);
            this.m_browser.updateSpaceConfig(string, iJSpace);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.userNameCB.getModel();
            if (defaultComboBoxModel.getIndexOf(string2) == -1) {
                this.userNameCB.addItem(string2);
            }
            this.dispose();
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.getMessage(), "Connection refused", 0);
        }
        catch (SpaceSecurityException spaceSecurityException) {
            JOptionPane.showMessageDialog(this, spaceSecurityException.getMessage(), "Login failed", 0);
        }
    }

    public void showDialog(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_browser.setEnable(this.m_browser.spaceEnableComp, false);
        this.m_browser.setEnable(this.m_browser.containerEnableComp, false);
        this.m_secureNode = defaultMutableTreeNode;
        this.userNameCB.setSelectedItem("");
        this.passTF.setText("");
        this.descTP.setText("Please specify [" + this.m_browser.getContainerConfigPanel().getContainerName() + "] \ncontainer administrator user \nname and password");
        this.pack();
        this.show();
    }
}

