/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupFailOverPanel;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.GroupLBPanel;
import com.j_spaces.tools.cluster.GroupReplicationPanel;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.MemberTransmissionPanel;
import com.j_spaces.tools.cluster.view.MembersGraphPanel;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceRuntimePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;

public class GroupPanel
extends JPanel {
    private ClusterViewDlg m_owner;
    private GroupInfo m_groupInfo;
    private MembersGraphPanel m_memGraphPanel;
    private MembersLegend m_legend;
    private JTabbedPane m_tabPanel;
    private GroupReplicationPanel m_replPanel;
    private MemberTransmissionPanel m_transmPanel;
    private GroupLBPanel m_lbPanel;
    private GroupFailOverPanel m_failOverPanel;
    private SpaceRuntimePanel m_runtimePanel;
    private JPanel members;
    private JPanel membersPanel;
    private JTabbedPane replTabPanel;
    private JSplitPane splitPan;
    private JSplitPane legendSplitPane;
    private boolean isSetLegendSplitSize;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public GroupPanel(ClusterViewDlg clusterViewDlg) {
        block2: {
            this.isSetLegendSplitSize = true;
            this.m_owner = clusterViewDlg;
            try {
                this.init();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void clearCurGroupInfo() {
        this.m_groupInfo = null;
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        if (this.m_groupInfo == null || this.m_groupInfo != groupInfo) {
            this.m_groupInfo = groupInfo;
            this.m_memGraphPanel.init(this.m_groupInfo.groupMembers);
            this.m_transmPanel.init(this.m_groupInfo);
            this.m_replPanel.init(this.m_groupInfo);
            this.m_lbPanel.init(this.m_groupInfo.loadBalInfo, this.m_owner.getAllMembers());
            this.m_failOverPanel.init(this.m_groupInfo, this.m_owner.getAllGroups());
            this.m_tabPanel.setEnabledAt(0, this.m_groupInfo.repInfo != null);
            this.m_tabPanel.setEnabledAt(1, this.m_groupInfo.loadBalInfo != null);
            this.m_tabPanel.setEnabledAt(2, this.m_groupInfo.failOverInfo != null);
            this.m_tabPanel.setSelectedIndex(this.getEnabledTabIndex(this.m_tabPanel));
            if (this.isSetLegendSplitSize) {
                this.legendSplitPane.setDividerLocation(0.8);
                this.isSetLegendSplitSize = false;
            }
        }
    }

    public void setSpaceIDToNode(ServiceID serviceID, String string) {
        this.m_memGraphPanel.setSpaceIDToNode(serviceID, string);
    }

    public void setPanelEnabled(boolean bl2) {
        this.setComponentsEnabled(this.m_tabPanel, bl2);
    }

    private void setComponentsEnabled(Container container, boolean bl2) {
        if (container.equals(this.m_runtimePanel) || container.equals(this.m_transmPanel)) {
            return;
        }
        int n2 = container.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            if (component instanceof Container) {
                this.setComponentsEnabled((Container)component, bl2);
            }
            if (!bl2 && (bl2 || component instanceof JLabel || component instanceof JTabbedPane || component instanceof JScrollPane || component instanceof JSplitPane)) continue;
            component.setEnabled(bl2);
        }
    }

    private void init() throws Exception {
        this.m_legend = new MembersLegend(this);
        this.m_runtimePanel = new SpaceRuntimePanel(this.m_owner.getBrowser(), false);
        this.members = new JPanel(new BorderLayout());
        this.membersPanel = new JPanel(new BorderLayout());
        this.replTabPanel = new JTabbedPane();
        this.m_tabPanel = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.m_memGraphPanel = new MembersGraphPanel(this, null);
        this.m_transmPanel = new MemberTransmissionPanel(null);
        this.members.add((Component)this.m_memGraphPanel, "Center");
        Dimension dimension = new Dimension(70, 250);
        this.m_legend.setPreferredSize(dimension);
        this.m_legend.setMaximumSize(dimension);
        this.m_legend.setMinimumSize(dimension);
        this.members.setPreferredSize(new Dimension(500, 600));
        this.legendSplitPane = new JSplitPane(1, this.members, this.m_legend);
        this.legendSplitPane.setDividerSize(8);
        this.legendSplitPane.setOneTouchExpandable(true);
        this.membersPanel.add((Component)this.legendSplitPane, "Center");
        SpaceBrowser spaceBrowser = this.m_owner.getBrowser();
        this.m_replPanel = new GroupReplicationPanel(null, spaceBrowser, null);
        this.replTabPanel.add("Table", this.m_transmPanel);
        this.replTabPanel.add("Settings", new JScrollPane(this.m_replPanel));
        this.m_lbPanel = new GroupLBPanel(true);
        this.m_failOverPanel = new GroupFailOverPanel(this.m_owner, null, this.m_owner.getAllGroups());
        this.m_tabPanel.add("Replication", this.replTabPanel);
        this.m_tabPanel.add("LoadBalancing", this.m_lbPanel);
        this.m_tabPanel.add("Fail Over", this.m_failOverPanel);
        this.m_tabPanel.add("Classes", this.m_runtimePanel);
        JComponent jComponent = spaceBrowser.isCreatedWithinAnotherGUIAppl() ? new JScrollPane(this.m_tabPanel) : this.m_tabPanel;
        this.splitPan = new JSplitPane(0, this.membersPanel, jComponent);
        this.splitPan.setOneTouchExpandable(true);
        this.splitPan.setDividerSize(8);
        this.splitPan.setOneTouchExpandable(true);
        this.add((Component)this.splitPan, "Center");
        this.m_tabPanel.setEnabledAt(0, false);
        this.m_tabPanel.setEnabledAt(1, false);
        this.m_tabPanel.setEnabledAt(2, false);
        this.m_tabPanel.setSelectedIndex(this.getEnabledTabIndex(this.m_tabPanel));
    }

    public void performActionOnMember(TreePath treePath, String string) {
        String string2 = JSpaceUtilities.createClusterGuiId(treePath);
        this.m_memGraphPanel.performNodeAction(string2);
        this.m_transmPanel.updateTransmTable(string);
    }

    public void clearReplicationDetails() {
        this.m_memGraphPanel.clearEdgesList();
        this.getTrasmissionPanel().clearTransmDetails();
    }

    public void setMemberForRuntimePanel(String string) {
        ServiceManagerImpl.ClusterMember clusterMember = this.m_owner.getServiceManager().getClusterMember(string);
        if (clusterMember != null) {
            this.m_runtimePanel.setSpaceAdmin(clusterMember.getSpaceRemoteRef(), clusterMember.getServiceID());
        }
    }

    public void addRuntimePanel() {
        if (this.m_tabPanel.indexOfComponent(this.m_runtimePanel) == -1) {
            this.m_tabPanel.add("Classes", this.m_runtimePanel);
        }
    }

    public void removeRunimePanel() {
        this.m_tabPanel.remove(this.m_runtimePanel);
    }

    public boolean isReplicationGroup() {
        return this.m_groupInfo.repInfo != null;
    }

    public GroupInfo.ReplicationInfo getReplicationInfo() {
        return this.m_groupInfo.repInfo;
    }

    public MemberTransmissionPanel getTrasmissionPanel() {
        return this.m_transmPanel;
    }

    public IRefreshable getGraphPanel() {
        return this.m_memGraphPanel;
    }

    public void increaseZoom() {
        this.m_memGraphPanel.increaseZoom();
    }

    public void decreaseZoom() {
        this.m_memGraphPanel.decreaseZoom();
    }

    public void setClusterTreeNode(String string) {
        this.m_owner.setClusterTreeNode(string);
    }

    private int getEnabledTabIndex(JTabbedPane jTabbedPane) {
        int n2 = -1;
        for (int i2 = 0; i2 < jTabbedPane.getTabCount(); ++i2) {
            if (!jTabbedPane.isEnabledAt(i2)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public void repaint() {
        super.repaint();
        if (this.m_legend != null) {
            this.m_legend.repaint();
        }
    }

    public void addClusterMember(ClusterMemberInfo clusterMemberInfo) {
        this.m_memGraphPanel.addClusterMember(clusterMemberInfo);
        this.m_transmPanel.addClusterMember(clusterMemberInfo);
    }

    public void removeClusterMember() {
    }
}

