/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.obf.ds;
import com.j_spaces.obf.li;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.ClusterTopologiesPanel;
import com.j_spaces.tools.cluster.CreateGroups;
import com.j_spaces.tools.cluster.CreateMembers;
import com.j_spaces.tools.cluster.DescEventListener;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ListItemAlreadyExistsException;
import com.j_spaces.tools.cluster.ReportErrors;
import com.j_spaces.tools.cluster.ResourcesInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.w3c.dom.Document;

public class NewCluster
extends JDialog {
    public Component parent;
    public JPanel descPanel = new JPanel();
    public JPanel mainPanel = new JPanel();
    public JPanel topPanel = new JPanel();
    public JPanel optionPanel = new JPanel();
    public JPanel logoPanel = new JPanel();
    public JPanel mainButtonPanel = new JPanel();
    public JPanel buttonPanel = new JPanel();
    public JPanel innerButtonPanel = new JPanel();
    public JPanel exitPanel = new JPanel();
    public JPanel separatorPanel = new JPanel();
    public JPanel sepPanel = new JPanel();
    public JButton finishButton = new JButton();
    public JButton exitButton = new JButton();
    public JButton nextButton = new JButton();
    public JButton backButton = new JButton();
    public JButton newFileButton = new JButton();
    public JLabel clusterNameLabel;
    public JLabel stepDescLabel = new JLabel();
    public JLabel fileNameLabel = new JLabel();
    public JLabel logoLabel = new JLabel();
    public JLabel dcacheConfigNameLabel = new JLabel();
    public JTextField clusterNameTF;
    public JTextField clusterFileTF = new JTextField();
    public JTextField dcacheConfigNameTF = new JTextField();
    public JTextPane descArea = new JTextPane();
    public JSeparator separator = new JSeparator(0);
    private JFileChooser fileChooser;
    public ArrayList listDialogs = new ArrayList();
    public int stepNumber = 0;
    public String clusterConfigDirectory;
    public ClusterTopologiesPanel topologiesPanel;
    public CreateMembers createMembers;
    public CreateGroups createGroups;
    public ReportErrors reportErrors;
    public JSpaceAttributes dcacheConfig = new JSpaceAttributes();
    public String dcacheConfigName;
    private String dcacheConfigURL;
    public DescEventListener nextButtonStepEvent;
    public DescEventListener backButtonStepEvent;
    public DescEventListener finishButtonStepEvent;
    public Hashtable m_SpaceBrowserInfo;
    public Object[] stepResource;
    public Object[] newClusterInfo;
    public Object[] modifyClusterInfo;
    public EditCluster editCluster;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public NewCluster(Component component) {
        super((Frame)((JFrame)component), true);
        this.parent = component;
        this.jbInit();
        JSpaceUtilities.setLocationRelativeTo(this, component);
    }

    public void jbInit() {
        this.topologiesPanel = new ClusterTopologiesPanel();
        this.clusterNameLabel = this.topologiesPanel.labClusterName;
        this.clusterNameTF = this.topologiesPanel.txtfClusterName;
        ResourcesInfo resourcesInfo = new ResourcesInfo();
        this.newClusterInfo = new Object[]{this.getImage("NewCluster.gif"), ResourcesInfo.newCluster.getAboutStep(), ResourcesInfo.newCluster.getStepDescription()[0], ResourcesInfo.newCluster.getStepDescription()[1], ResourcesInfo.newCluster.getStepDescription()[2]};
        this.modifyClusterInfo = new Object[]{this.getImage("ModifyCluster.gif"), ResourcesInfo.modifyCluster.getAboutStep(), ResourcesInfo.newCluster.getStepDescription()[0], ResourcesInfo.newCluster.getStepDescription()[1], ResourcesInfo.newCluster.getStepDescription()[2]};
        Object[] objectArray = new Object[]{this.getImage("CreateMembers.gif"), ResourcesInfo.createMembers.getAboutStep(), ResourcesInfo.createMembers.getStepDescription()[0], ResourcesInfo.createMembers.getStepDescription()[1], ResourcesInfo.createMembers.getStepDescription()[2]};
        Object[] objectArray2 = new Object[]{this.getImage("CreateGroups.gif"), ResourcesInfo.createGroup.getAboutStep(), ResourcesInfo.createGroup.getStepDescription()[0], ResourcesInfo.createGroup.getStepDescription()[1], ResourcesInfo.createGroup.getStepDescription()[2]};
        Object[] objectArray3 = new Object[]{this.getImage("VerifyCluster.gif"), ResourcesInfo.reportError.getAboutStep(), ResourcesInfo.reportError.getStepDescription()[0], ResourcesInfo.reportError.getStepDescription()[1], ResourcesInfo.reportError.getStepDescription()[2]};
        this.stepResource = new Object[]{this.newClusterInfo, objectArray, objectArray2, objectArray3};
        this.getContentPane().setLayout(new BorderLayout());
        this.separatorPanel.setLayout(new BorderLayout());
        this.sepPanel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.logoPanel.setLayout(new BoxLayout2());
        this.mainButtonPanel.setLayout(new VerticalFlowLayout());
        this.descPanel.setLayout(new VerticalFlowLayout());
        this.optionPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new BorderLayout());
        this.separator.setForeground(Color.gray);
        this.stepDescLabel.setFont(new Font("Dialog", 0, 12));
        this.stepDescLabel.setForeground(Color.darkGray);
        this.stepDescLabel.setPreferredSize(new Dimension(156, 18));
        this.nextButton.setRequestFocusEnabled(false);
        this.exitButton.setRequestFocusEnabled(false);
        this.backButton.setRequestFocusEnabled(false);
        this.finishButton.setRequestFocusEnabled(false);
        this.descArea.setEnabled(false);
        this.descArea.setEditable(false);
        this.descArea.setForeground(new Color(102, 102, 153));
        this.descArea.setFont(new Font("Serif", 0, 14));
        this.descArea.setBackground(UIManager.getColor("Button.background"));
        this.descPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), BorderFactory.createEmptyBorder(0, 0, 0, 2)));
        this.sepPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.mainButtonPanel.setBorder(BorderFactory.createEmptyBorder(15, 3, 0, 3));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(4, 2, 10, 2));
        this.logoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
        this.setDefaultCloseOperation(2);
        this.logoLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.newFileButton.setRequestFocusEnabled(false);
        this.newFileButton.setVerticalTextPosition(1);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.logoPanel, "West");
        this.logoPanel.add((Component)this.logoLabel, null);
        this.topPanel.add((Component)this.descPanel, "Center");
        this.descPanel.add((Component)this.descArea, null);
        this.optionPanel.add((Component)this.topologiesPanel, "North");
        this.mainPanel.add((Component)this.mainButtonPanel, "South");
        this.mainButtonPanel.add((Component)this.stepDescLabel, null);
        this.mainButtonPanel.add((Component)this.buttonPanel, null);
        this.buttonPanel.add((Component)this.innerButtonPanel, "East");
        this.innerButtonPanel.add((Component)this.backButton, null);
        this.innerButtonPanel.add((Component)this.nextButton, null);
        this.innerButtonPanel.add((Component)this.finishButton, null);
        this.buttonPanel.add((Component)this.exitPanel, "West");
        this.exitPanel.add((Component)this.exitButton, null);
        this.buttonPanel.add((Component)this.separatorPanel, "North");
        this.separatorPanel.add((Component)this.sepPanel, "Center");
        this.sepPanel.add((Component)this.separator, "Center");
        this.mainPanel.add((Component)this.optionPanel, "Center");
        this.nextButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.setTitle("GigaSpaces Cluster Wizard");
        String[] stringArray = ResourcesInfo.newCluster.getButtons();
        ImageIcon imageIcon = this.getImage("browse.gif");
        this.newFileButton.setText(stringArray[0]);
        this.newFileButton.setIcon(imageIcon);
        this.exitButton.setText(stringArray[1]);
        this.backButton.setText(stringArray[2]);
        this.nextButton.setText(stringArray[3]);
        this.finishButton.setText("Finish");
        this.exitButton.setMnemonic('c');
        this.backButton.setMnemonic('b');
        this.nextButton.setMnemonic('n');
        this.finishButton.setMnemonic('f');
        this.nextButtonStepEvent = new DescEventListener(this.stepDescLabel, "");
        this.backButtonStepEvent = new DescEventListener(this.stepDescLabel, "");
        this.finishButtonStepEvent = new DescEventListener(this.stepDescLabel, "");
        this.nextButton.addMouseListener(this.nextButtonStepEvent);
        this.backButton.addMouseListener(this.backButtonStepEvent);
        this.finishButton.addMouseListener(this.finishButtonStepEvent);
        String string = ResourcesInfo.newCluster.getAboutStep();
        String[] stringArray2 = ResourcesInfo.newCluster.getStepDescription();
        this.setStepInfo((Object[])this.stepResource[0]);
        String[] stringArray3 = ResourcesInfo.newCluster.getToolTips();
        this.clusterNameTF.addMouseListener(new DescEventListener(this.stepDescLabel, stringArray3[0]));
        this.clusterFileTF.addMouseListener(new DescEventListener(this.stepDescLabel, stringArray3[1]));
        this.newFileButton.addMouseListener(new DescEventListener(this.stepDescLabel, stringArray3[2]));
        this.exitButton.addMouseListener(new DescEventListener(this.stepDescLabel, stringArray3[3]));
        String[] stringArray4 = ResourcesInfo.newCluster.getLabels();
        this.clusterNameLabel.setText(stringArray4[1]);
        this.fileNameLabel.setText(stringArray4[2]);
        this.dcacheConfigNameLabel.setText(stringArray4[3]);
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCluster.this.exitWizard();
            }
        });
        this.newFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCluster.this.selectClusterFile();
            }
        });
        this.clusterNameTF.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (NewCluster.this.clusterNameTF.getText().trim().length() == 0) {
                    NewCluster.this.nextButton.setEnabled(false);
                    NewCluster.this.finishButton.setEnabled(false);
                } else if (NewCluster.this.clusterNameTF.getText().trim().length() > 0) {
                    NewCluster.this.nextButton.setEnabled(true);
                    NewCluster.this.finishButton.setEnabled(true);
                } else {
                    NewCluster.this.nextButton.setEnabled(false);
                    NewCluster.this.finishButton.setEnabled(false);
                }
            }
        });
        this.clusterFileTF.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl2 = NewCluster.this.clusterFileTF.getText().trim().length() > 0;
                NewCluster.this.nextButton.setEnabled(bl2);
                NewCluster.this.dcacheConfigNameTF.setEnabled(bl2);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCluster.this.nextStep();
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCluster.this.finishStep();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCluster.this.backStep();
            }
        });
        this.dcacheConfigNameTF.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl2 = NewCluster.this.dcacheConfigNameTF.getText().trim().length() > 0;
                NewCluster.this.nextButton.setEnabled(bl2);
            }
        });
        this.pack();
        this.initDialogs();
    }

    public static void main(String[] stringArray) {
        block2: {
            NewCluster newCluster = null;
            try {
                newCluster = new NewCluster(null);
                newCluster.createEditInfo(stringArray[0], true, null);
                newCluster.setSize(450, 550);
                newCluster.showClusterDialog();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void initDialogs() {
        this.createMembers = new CreateMembers(this);
        this.createGroups = new CreateGroups(this.createMembers);
        this.reportErrors = new ReportErrors(this.createGroups);
        this.listDialogs.add(this.optionPanel);
        this.listDialogs.add(this.createMembers);
        this.listDialogs.add(this.createGroups);
        this.listDialogs.add(this.reportErrors);
    }

    public void createEditInfo(String string, boolean bl2, Hashtable hashtable) throws Exception {
        EditCluster editCluster;
        this.m_SpaceBrowserInfo = hashtable;
        this.reset();
        if (hashtable != null) {
            this.setLiveMemberItem(hashtable);
        }
        if ((editCluster = new EditCluster(string)).useClusterSchema()) {
            this.topologiesPanel.setEnabled(true);
            this.topologiesPanel.setEnabledMembersPanel(editCluster.isGenerateMembersDynamically());
            this.topologiesPanel.setSelectedTopology(editCluster.getClusterSchemaName());
            this.topologiesPanel.setNumOfMembers(editCluster.getPrimaryMemers().length);
            this.topologiesPanel.setNumOfBackups(editCluster.getBackupsPerMember());
        } else {
            this.topologiesPanel.setEnabled(false);
        }
        if (bl2) {
            this.finishButton.setEnabled(editCluster.useClusterSchema());
            this.nextButton.setEnabled(true);
            this.newFileButton.setEnabled(false);
            this.clusterFileTF.setEnabled(false);
            this.clusterFileTF.setText(string);
            this.dcacheConfigNameTF.setEnabled(true);
            this.stepResource[0] = this.modifyClusterInfo;
            this.setStepInfo(this.modifyClusterInfo);
        } else {
            this.setStepInfo((Object[])this.stepResource[this.stepNumber]);
        }
        this.setEditCluster(editCluster);
    }

    private void setEditCluster(EditCluster editCluster) throws CreateException {
        this.editCluster = editCluster;
        this.clusterNameTF.setText(editCluster.getClusterName());
        this.dcacheConfigName = editCluster.createClusterPolicy((String)editCluster.getClusterMembers()[0].memberName).m_DCacheConfigName;
        if (this.dcacheConfigName != null) {
            this.dcacheConfigNameTF.setText(this.dcacheConfigName);
        }
        this.createMembers.clearAllMemberInfo();
        ClusterMemberInfo[] clusterMemberInfoArray = editCluster.getClusterMembers();
        for (int i2 = 0; i2 < clusterMemberInfoArray.length; ++i2) {
            try {
                this.createMembers.addMemberInfo(clusterMemberInfoArray[i2]);
                continue;
            }
            catch (ListItemAlreadyExistsException listItemAlreadyExistsException) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, listItemAlreadyExistsException.toString(), listItemAlreadyExistsException);
            }
        }
        this.createGroups.clearAllGroupInfo();
        GroupInfo[] groupInfoArray = editCluster.getClusterGroups();
        for (int i3 = 0; i3 < groupInfoArray.length; ++i3) {
            try {
                this.createGroups.isGroupExists(groupInfoArray[i3].groupName);
                this.createGroups.setGroupInfo(groupInfoArray[i3], false);
                continue;
            }
            catch (ListItemAlreadyExistsException listItemAlreadyExistsException) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, listItemAlreadyExistsException.toString(), listItemAlreadyExistsException);
            }
        }
    }

    public void reset() {
        Component component = (Component)this.listDialogs.get(this.stepNumber);
        this.mainPanel.remove(component);
        this.mainPanel.add((Component)this.optionPanel, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
        this.stepNumber = 0;
        this.stepResource[0] = this.newClusterInfo;
        this.setStepInfo(this.newClusterInfo);
        this.editCluster = null;
        this.finishButton.setEnabled(false);
        this.newFileButton.setEnabled(true);
        this.clusterFileTF.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.clusterFileTF.setText("");
        this.clusterNameTF.setText("");
        this.dcacheConfigNameTF.setText("");
        this.nextButton.setText("Next >");
        this.createMembers.clearAllMemberInfo();
        this.createGroups.clearAllGroupInfo();
        this.topologiesPanel.reset();
        this.dcacheConfigNameTF.setText("DefaultConfig");
        this.dcacheConfigNameTF.setEnabled(false);
        this.reportErrors.reset();
        this.setControlButtonsVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Hashtable getSpaceBrowserInfo() {
        return this.m_SpaceBrowserInfo;
    }

    public String getClusterName() {
        return this.clusterNameTF.getText().trim();
    }

    private ImageIcon getImage(String string) {
        return new ImageIcon(this.getClass().getResource("/image/cluster-wizard/" + string));
    }

    public String getClusterFilePath() {
        return this.clusterFileTF.getText().trim();
    }

    public String getClusterFileName() {
        String string = this.getClusterFilePath();
        return string.substring(string.lastIndexOf(File.separatorChar) + 1, string.length());
    }

    private boolean createClusterFile() {
        String string = this.getClusterFilePath();
        if (string == null || string.length() <= 0) {
            this.selectClusterFile();
            string = this.getClusterFilePath();
            if (string == null || string.length() <= 0) {
                return false;
            }
        }
        try {
            if (this.reportErrors.createFile(string)) {
                this.setCursor(new Cursor(0));
                JOptionPane.showConfirmDialog(this, "Cluster file: " + this.getClusterFilePath() + " save successfully.", "Information Message", -1, 1, ResourcesInfo.INFO_ICON);
            } else {
                this.setCursor(new Cursor(0));
                JOptionPane.showConfirmDialog(this, "Cluster Wizard has finish successfully.", "Information Message", -1, 1, ResourcesInfo.INFO_ICON);
            }
        }
        catch (IOException iOException) {
            this.setCursor(new Cursor(0));
            JOptionPane.showConfirmDialog(this, iOException.getClass().getName() + " " + iOException.getMessage(), "Error", -1, 0, ResourcesInfo.WARNING_ICON);
            return false;
        }
        return true;
    }

    private void updateDCacheConfigFile() {
        block4: {
            try {
                if (this.dcacheConfigURL != null) {
                    ds ds2 = new ds(this.dcacheConfigURL);
                    Iterator<Object> iterator = this.dcacheConfig.getDCacheProperties().keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        ds2.c(string, this.dcacheConfig.getDCacheProperties().getProperty(string));
                    }
                    ds2.a();
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public String getDCacheConfigName() {
        return this.dcacheConfigNameTF.getText().trim();
    }

    private void setStepInfo(Object[] objectArray) {
        this.logoLabel.setIcon((ImageIcon)objectArray[0]);
        this.descArea.setText((String)objectArray[1]);
        this.backButtonStepEvent.setStepName((String)objectArray[2]);
        this.nextButtonStepEvent.setStepName((String)objectArray[3]);
        this.finishButtonStepEvent.setStepName((String)objectArray[4]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextStep() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.nextButton.getText().equalsIgnoreCase("Close")) {
                this.dispose();
                return;
            }
            Component component = (Component)this.listDialogs.get(this.stepNumber++);
            Component component2 = (Component)this.listDialogs.get(this.stepNumber);
            if (component2 instanceof CreateMembers) {
                if (this.topologiesPanel != null && this.topologiesPanel.isEnabled()) {
                    try {
                        if (this.editCluster == null || this.editCluster.isGenerateMembersDynamically()) {
                            this.setEditCluster(new EditCluster(this.topologiesPanel.getNumOfMembers(), this.topologiesPanel.getNumOfBackups(), this.topologiesPanel.getSelectedTopology(), this.getClusterName(), this.dcacheConfigName, "DefaultConfig"));
                        }
                    }
                    catch (Exception exception) {
                        _logger.log(Level.SEVERE, exception.toString(), exception);
                        --this.stepNumber;
                        JOptionPane.showMessageDialog(this, exception.toString(), "Warning", 2);
                        this.finishButton.setEnabled(false);
                        this.setCursor(new Cursor(0));
                        return;
                    }
                }
                boolean bl2 = this.editCluster != null ? this.editCluster.useClusterSchema() : false;
                this.finishButton.setEnabled(bl2);
            } else if (component2 instanceof CreateGroups) {
                CreateMembers createMembers = (CreateMembers)component;
                if (!this.isMembersCountValid(createMembers, true)) {
                    return;
                }
                this.finishButton.setEnabled(false);
            } else if (component2 instanceof ReportErrors) {
                CreateGroups createGroups = (CreateGroups)component;
                if (createGroups.getGroupModel().size() < 1) {
                    --this.stepNumber;
                    JOptionPane.showConfirmDialog(this, "You should create at least 1 group.", "Warning", -1, 2, ResourcesInfo.WARNING_ICON);
                    return;
                }
                ReportErrors reportErrors = (ReportErrors)component2;
                this.nextButton.setEnabled(false);
                try {
                    boolean bl3 = reportErrors.validateClusterConfiguration();
                    this.finishButton.setEnabled(!bl3);
                }
                catch (Exception exception) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, exception.toString(), exception);
                    }
                    this.finishButton.setEnabled(false);
                    this.mainPanel.remove(component);
                    this.mainPanel.add(component2, "Center");
                    this.mainPanel.validate();
                    this.mainPanel.repaint();
                    this.setCursor(new Cursor(0));
                    return;
                }
            }
            this.backButton.setEnabled(true);
            this.setStepInfo((Object[])this.stepResource[this.stepNumber]);
            this.mainPanel.remove(component);
            this.mainPanel.add(component2, "Center");
            this.mainPanel.validate();
            this.mainPanel.repaint();
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private boolean isMembersCountValid(CreateMembers createMembers, boolean bl2) {
        if (createMembers.getMemberListModel().size() < 2) {
            if (bl2) {
                --this.stepNumber;
            }
            JOptionPane.showConfirmDialog(this, "You should create at least 2 members.", "Warning", -1, 2, ResourcesInfo.WARNING_ICON);
            return false;
        }
        return true;
    }

    private void backStep() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.stepNumber <= 0) {
            this.backButton.setEnabled(false);
            return;
        }
        this.nextButton.setEnabled(true);
        Component component = (Component)this.listDialogs.get(this.stepNumber);
        Component component2 = (Component)this.listDialogs.get(--this.stepNumber);
        this.mainPanel.remove(component);
        this.mainPanel.add(component2, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
        if (component2 instanceof CreateGroups) {
            this.finishButton.setEnabled(false);
        } else if (this.stepNumber <= 2) {
            this.finishButton.setEnabled(this.editCluster.useClusterSchema());
        }
        this.setStepInfo((Object[])this.stepResource[this.stepNumber]);
        if (this.stepNumber <= 0) {
            this.backButton.setEnabled(false);
        }
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStep() {
        try {
            Component component;
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.stepNumber == 3 && (component = (Component)this.listDialogs.get(this.stepNumber)) instanceof ReportErrors) {
                if (this.createClusterFile()) {
                    this.updateDCacheConfigFile();
                    this.dispose();
                }
                return;
            }
            component = (Component)this.listDialogs.get(this.stepNumber);
            if (component instanceof CreateMembers && !this.isMembersCountValid((CreateMembers)component, false)) {
                return;
            }
            Document document = null;
            document = this.editCluster != null && !this.editCluster.isGenerateMembersDynamically() ? JSpaceUtilities.buildClusterXMLDom(this.createMembers.getMembers(), this.topologiesPanel.getSelectedTopology(), this.getClusterName(), this.dcacheConfigName, "DefaultConfig") : JSpaceUtilities.buildClusterXMLDom(this.topologiesPanel.getNumOfMembers(), this.topologiesPanel.getNumOfBackups(), this.topologiesPanel.getSelectedTopology(), this.getClusterName(), this.dcacheConfigName, "DefaultConfig", null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JSpaceUtilities.domWriter(document.getFirstChild(), new PrintStream(byteArrayOutputStream), "");
            File file = new File(li.a() + File.separator + "config" + File.separator + this.topologiesPanel.getClusterName() + "-cluster.xml");
            if (file.exists() && JOptionPane.showConfirmDialog(this, "The " + file.getName() + " file is already exists, would you like to override it?", "Confirmation", 0) == 1) {
                return;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.close();
                this.setCursor(new Cursor(0));
                JOptionPane.showMessageDialog(this, "The cluster configuration has been saved successfully to " + file.getPath());
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
                JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
        this.dispose();
    }

    private void exitWizard() {
        Object[] objectArray = new Object[]{"Continue", "Yes"};
        int n2 = JOptionPane.showOptionDialog(this, "Press Yes to terminate Cluster Wizard.", "Warning", -1, 3, ResourcesInfo.QUESTION_ICON, objectArray, objectArray[0]);
        if (n2 == 1) {
            this.dispose();
        }
    }

    public void setLiveMemberItem(Hashtable hashtable) {
        this.createMembers.m_newMemberDialog.setLiveMembers(hashtable);
    }

    private void selectClusterFile() {
        Object object;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setApproveButtonText("Save");
            this.fileChooser.setDialogTitle("Save");
            FileFilterExt fileFilterExt = new FileFilterExt("xml", "Cluster XML file");
            object = li.c();
            this.fileChooser.setCurrentDirectory(new File((String)object));
            this.fileChooser.addChoosableFileFilter(fileFilterExt);
        }
        int n2 = this.fileChooser.showOpenDialog(this);
        object = this.fileChooser.getSelectedFile();
        if (object != null && n2 == 0) {
            String string = ((File)object).getPath();
            if (!string.endsWith(".xml")) {
                string = string + ".xml";
            }
            this.clusterFileTF.setText(string);
            this.dcacheConfigNameTF.setEnabled(true);
            this.clusterConfigDirectory = ((File)object).getParent();
            if (this.clusterNameTF.getText().trim().length() > 0) {
                this.nextButton.setEnabled(true);
                this.finishButton.setEnabled(true);
            }
        }
    }

    private void setControlButtonsVisible(boolean bl2) {
        this.nextButton.setVisible(bl2);
        this.backButton.setVisible(bl2);
        this.finishButton.setVisible(bl2);
        this.exitButton.setVisible(bl2);
    }

    public void verifyClusterFile(String string) throws Exception {
        this.createEditInfo(string, true, null);
        this.reportErrors.validateClusterConfiguration();
        this.nextButton.setText("Close");
        this.setControlButtonsVisible(false);
        this.nextButton.setVisible(true);
        Component component = (Component)this.listDialogs.get(this.stepNumber);
        this.mainPanel.remove(component);
        this.mainPanel.add((Component)this.reportErrors, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
        this.stepNumber = this.listDialogs.size() - 1;
        this.setStepInfo((Object[])this.stepResource[this.stepNumber]);
        this.nextButtonStepEvent.setStepName("Click to finish...");
    }

    public void showClusterDialog(boolean bl2) {
        if (bl2) {
            this.reset();
        }
        this.showClusterDialog();
    }

    public void showClusterDialog() {
        JSpaceUtilities.setLocationRelativeTo(this, this.parent);
        this.setSize(450, 570);
        super.show();
    }
}

