/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.CreateException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.dynamic.IMemberData;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.sf.retrotranslator.runtime.java.lang._Boolean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditCluster {
    private Document rootDoc;
    private String clusterConfigFile;
    private String clusterName;
    private ClusterMemberInfo[] clusterMembers;
    private ClusterMemberInfo[] primaryMembers;
    private ClusterMemberInfo[] backupsMembers;
    private int backupsPerMember;
    private GroupInfo[] clusterGroups;
    private ClusterXML clusterXML;
    private long creationTime;
    private ReplicationPolicy.MirrorServiceConfig _mirrorServiceConfig;
    private ClusterMemberInfo _mirrorMemInfo;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public EditCluster(String string) throws Exception {
        this(string, null, null);
    }

    public EditCluster(String string, Document document, ClusterPolicy clusterPolicy) throws Exception {
        this.clusterXML = document == null ? new ClusterXML(string) : new ClusterXML(document, "remote location");
        if (clusterPolicy != null && clusterPolicy.m_ReplicationPolicy != null) {
            this._mirrorServiceConfig = clusterPolicy.m_ReplicationPolicy.getMirrorServiceConfig();
        }
        this.init();
    }

    public EditCluster(int n2, int n3, String string, String string2, String string3, String string4) throws Exception {
        this.clusterXML = new ClusterXML(n2, n3, string, string2, string3, string4, null);
        this.init();
    }

    private void init() throws Exception {
        this.clusterConfigFile = this.clusterXML.getClusterFileURL();
        this.rootDoc = this.clusterXML.getXMLRootDocument();
        this.clusterName = ClusterXML.getNodeValueIfExists((Element)this.rootDoc.getFirstChild(), "cluster-name");
        this.clusterMembers = this.createClusterMemberProperties(this.clusterName);
        this.clusterGroups = this.createClusterGroups(this.clusterName);
        this.creationTime = System.currentTimeMillis();
    }

    public String getClusterSchemaName() {
        return this.clusterXML != null ? this.clusterXML.getClusterSchemaName() : null;
    }

    public boolean useClusterSchema() {
        return this.clusterXML != null ? this.clusterXML.useClusterSchema() : false;
    }

    public boolean isGenerateMembersDynamically() {
        return this.clusterXML != null ? this.clusterXML.isGenerateMembersDynamically() : false;
    }

    public String toString() {
        return this.clusterName;
    }

    public ClusterMemberInfo[] getClusterMembers() {
        return this.clusterMembers;
    }

    public ClusterMemberInfo[] getPrimaryMemers() {
        return this.primaryMembers;
    }

    public ClusterMemberInfo[] getBackupsMemers() {
        return this.backupsMembers;
    }

    public int getBackupsPerMember() {
        return this.backupsPerMember;
    }

    public GroupInfo[] getClusterGroups() {
        return this.clusterGroups;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterFile() {
        return this.clusterConfigFile;
    }

    private ClusterMemberInfo[] createClusterMemberProperties(String string) throws CreateException {
        Vector vector;
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        Vector<Object> vector4 = new Vector<Object>();
        Object object = null;
        this.backupsPerMember = 0;
        NodeList nodeList = this.rootDoc.getElementsByTagName("cluster-members");
        if (nodeList.getLength() == 0) {
            throw new CreateException("<cluster-members> tag not found in " + this.clusterConfigFile + " cluster config file.");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName("member");
        for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
            Object object2;
            int n2;
            vector = new Vector();
            String string2 = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), "member-name");
            String string3 = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), "member-url");
            SpaceURL spaceURL = null;
            try {
                spaceURL = SpaceURLParser.parseURL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                _logger.log(Level.SEVERE, malformedURLException.toString(), malformedURLException);
            }
            NodeList nodeList3 = ((Element)nodeList2.item(i2)).getElementsByTagName("param");
            for (n2 = 0; n2 < nodeList3.getLength(); ++n2) {
                String string4 = ClusterXML.getNodeValueIfExists((Element)nodeList3.item(n2), "param-name");
                object2 = ClusterXML.getNodeValueIfExists((Element)nodeList3.item(n2), "param-value");
                if (string4 == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + string2 + " member name. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (object2 == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + string2 + " member name. Check " + this.clusterConfigFile + " cluster config file.");
                }
                Vector<Object> vector5 = new Vector<Object>();
                vector5.add(string4);
                vector5.add(object2);
                vector.add(vector5);
            }
            n2 = 0;
            int n3 = string2.indexOf(95);
            if (n3 != -1 && string2.indexOf(95, n3 + 1) != -1) {
                n2 = 1;
                object2 = string2.substring(0, string2.indexOf(95, n3 + 1));
                if (object == null) {
                    object = object2;
                    ++this.backupsPerMember;
                } else if (((String)object).equals(object2)) {
                    ++this.backupsPerMember;
                }
            }
            object2 = new ClusterMemberInfo(string2, spaceURL, string, null, vector, n2 != 0, null, false);
            vector2.add(object2);
            if (((ClusterMemberInfo)object2).isBackup) {
                vector4.add(object2);
                continue;
            }
            vector3.add(object2);
        }
        Vector vector6 = new Vector(1);
        vector = new Vector(1);
        vector6.add(vector);
        if (this._mirrorServiceConfig != null) {
            this._mirrorMemInfo = this.createMirrorClusterMember();
            vector2.add(this._mirrorMemInfo);
            vector3.add(this._mirrorMemInfo);
        }
        this.primaryMembers = vector3.toArray(new ClusterMemberInfo[vector3.size()]);
        this.backupsMembers = vector4.toArray(new ClusterMemberInfo[vector4.size()]);
        return vector2.toArray(new ClusterMemberInfo[0]);
    }

    private ClusterMemberInfo createMirrorClusterMember() {
        Object object;
        SpaceURL spaceURL = this._mirrorServiceConfig.serviceURL;
        String string = spaceURL.getURL();
        if (spaceURL != null) {
            String string2;
            object = spaceURL.getContainerName();
            string = string2 = spaceURL.getSpaceName();
            if (object != null) {
                string = (String)object + ":" + string2;
            }
        }
        object = new ClusterMemberInfo(string, spaceURL, this.clusterName, null, new Vector(1), false, null, true);
        return object;
    }

    private GroupInfo[] createClusterGroups(String string) throws CreateException {
        Vector<GroupInfo> vector = new Vector<GroupInfo>();
        NodeList nodeList = this.rootDoc.getElementsByTagName("group");
        if (nodeList.getLength() == 0) {
            throw new CreateException("<group> tag not found in " + this.clusterConfigFile + " cluster config file.");
        }
        block0: for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element element = (Element)nodeList.item(i2);
            NodeList nodeList2 = element.getElementsByTagName("member-name");
            if (nodeList2.getLength() <= 0) continue;
            String string2 = ClusterXML.getNodeValueIfExists(element, "group-name");
            ClusterMemberInfo[] clusterMemberInfoArray = this.createGroupMembers(element, string2);
            GroupInfo.ReplicationInfo replicationInfo = this.createReplicationGroup(string2, clusterMemberInfoArray[0].memberName);
            GroupInfo.LoadBalancingInfo loadBalancingInfo = this.createLoadBalancingGroup(element);
            FailOverPolicy failOverPolicy = this.createFailOverGroup(string2, clusterMemberInfoArray[0].memberName);
            GroupInfo groupInfo = new GroupInfo(replicationInfo, loadBalancingInfo, failOverPolicy, string2, string);
            groupInfo.groupMembers = clusterMemberInfoArray;
            vector.add(groupInfo);
            if (replicationInfo == null) continue;
            for (int i3 = 0; i3 < clusterMemberInfoArray.length; ++i3) {
                if ((clusterMemberInfoArray[i3].m_replTransmissionPolicies == null || clusterMemberInfoArray[i3].m_replTransmissionPolicies.size() <= 0) && clusterMemberInfoArray[i3].m_replFilters == null && clusterMemberInfoArray[i3].m_replRecovery == null) continue;
                replicationInfo.m_TransmissionMatrix = true;
                continue block0;
            }
        }
        return vector.toArray(new GroupInfo[vector.size()]);
    }

    private ClusterMemberInfo[] createGroupMembers(Element element, String string) throws CreateException {
        ClusterMemberInfo clusterMemberInfo;
        ClusterMemberInfo clusterMemberInfo2;
        int n2;
        Vector<ClusterMemberInfo> vector = new Vector<ClusterMemberInfo>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        HashMap<String, ClusterMemberInfo> hashMap = new HashMap<String, ClusterMemberInfo>(this.clusterMembers.length);
        for (int i2 = 0; i2 < this.clusterMembers.length; ++i2) {
            ClusterMemberInfo clusterMemberInfo3 = this.clusterMembers[i2];
            clusterMemberInfo3.setGroupName(string);
            hashMap.put(clusterMemberInfo3.memberName, (ClusterMemberInfo)clusterMemberInfo3.clone());
        }
        NodeList nodeList = element.getElementsByTagName("member-name");
        if (nodeList.getLength() <= 1) {
            throw new CreateException("The group: " + string + " should contain at least 2 cluster members.");
        }
        int n3 = nodeList.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = nodeList.item(n2).getFirstChild().getNodeValue();
            clusterMemberInfo2 = (ClusterMemberInfo)hashMap.get(string2);
            if (clusterMemberInfo2 == null) continue;
            vector.add(clusterMemberInfo2);
            arrayList.add(clusterMemberInfo2.memberName);
            arrayList2.add(nodeList.item(n2).getParentNode());
        }
        if (this._mirrorMemInfo != null && (clusterMemberInfo = (ClusterMemberInfo)hashMap.get(this._mirrorMemInfo.memberName)) != null) {
            vector.add(clusterMemberInfo);
            arrayList.add(clusterMemberInfo.memberName);
            arrayList2.add(nodeList.item(0).getParentNode());
        }
        n2 = vector.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            clusterMemberInfo2 = (ClusterMemberInfo)vector.get(i3);
            ReplicationPolicy.ReplicationPolicyDescription replicationPolicyDescription = this.clusterXML.createReplDescPolicy(clusterMemberInfo2.memberName, (Element)arrayList2.get(i3), arrayList);
            ClusterMemberInfo.ReplFilters replFilters = null;
            ClusterMemberInfo.ReplRecovery replRecovery = null;
            if (replicationPolicyDescription.inputReplicationFilterClassName != null) {
                replFilters = new ClusterMemberInfo.ReplFilters();
                replFilters.inputReplicationFilterClassName = replicationPolicyDescription.inputReplicationFilterClassName;
                if (replicationPolicyDescription.inputReplicationFilterParamUrl != null) {
                    replFilters.inputReplicationFilterParamUrl = replicationPolicyDescription.inputReplicationFilterParamUrl;
                }
            }
            if (replicationPolicyDescription.outputReplicationFilterClassName != null) {
                if (replFilters == null) {
                    replFilters = new ClusterMemberInfo.ReplFilters();
                }
                replFilters.outputReplicationFilterClassName = replicationPolicyDescription.outputReplicationFilterClassName;
                if (replicationPolicyDescription.outputReplicationFilterParamUrl != null) {
                    replFilters.outputReplicationFilterParamUrl = replicationPolicyDescription.outputReplicationFilterParamUrl;
                }
            }
            if (replicationPolicyDescription.sourceMemberRecovery != null) {
                String string3 = replicationPolicyDescription.sourceMemberRecovery == null ? "First available member" : replicationPolicyDescription.sourceMemberRecovery;
                replRecovery = new ClusterMemberInfo.ReplRecovery(replicationPolicyDescription.memberRecovery, string3);
            }
            clusterMemberInfo2.createClusterMemberAttributes(replicationPolicyDescription.replTransmissionPolicies, replFilters, replRecovery);
        }
        return vector.toArray(new ClusterMemberInfo[vector.size()]);
    }

    private GroupInfo.LoadBalancingInfo createLoadBalancingGroup(Element element) throws CreateException {
        GroupInfo.LoadBalancingInfo loadBalancingInfo = null;
        NodeList nodeList = element.getElementsByTagName("load-bal-policy");
        if (nodeList.getLength() > 0) {
            loadBalancingInfo = new GroupInfo.LoadBalancingInfo();
            Element element2 = (Element)nodeList.item(0);
            loadBalancingInfo.m_ImplementationClassName = ClusterXML.getNodeValueIfExists(element2, "load-bal-impl-class");
            String string = ClusterXML.getNodeValueIfExists(element2, "apply-ownership");
            loadBalancingInfo.setApplyOwnership(string != null ? _Boolean.parseBoolean(string) : false);
            String string2 = ClusterXML.getNodeValueIfExists(element2, "disable-parallel-scattering");
            loadBalancingInfo.setDisableParallelScattering(string2 != null ? _Boolean.parseBoolean(string2) : false);
            String string3 = ClusterXML.getNodeValueIfExists(element2, "proxy-broadcast-threadpool-min-size");
            loadBalancingInfo.setProxyBroadcatThreadpoolMinSize(string3 != null && string3.length() != 0 ? Integer.parseInt(string3) : 0);
            String string4 = ClusterXML.getNodeValueIfExists(element2, "proxy-broadcast-threadpool-max-size");
            loadBalancingInfo.setProxyBroadcatThreadpoolMaxSize(string4 != null && string4.length() != 0 ? Integer.parseInt(string4) : 0);
            loadBalancingInfo.m_WriteOperationsPolicy = this.createLoadBalancingDescPolicy(element2, "write");
            loadBalancingInfo.m_ReadOperationsPolicy = this.createLoadBalancingDescPolicy(element2, "read");
            loadBalancingInfo.m_TakeOperationsPolicy = this.createLoadBalancingDescPolicy(element2, "take");
            loadBalancingInfo.m_NotifyOperationsPolicy = this.createLoadBalancingDescPolicy(element2, "notify");
            loadBalancingInfo.m_DefaultPolicy = this.createLoadBalancingDescPolicy(element2, "default");
        }
        return loadBalancingInfo;
    }

    private GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription createLoadBalancingDescPolicy(Element element, String string) throws CreateException {
        GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription loadBalancingPolicyDescription = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Vector vector = new Vector();
            Element element2 = (Element)nodeList.item(0);
            String string2 = ClusterXML.getNodeValueIfExists(element2, "policy-type");
            String string3 = ClusterXML.getNodeValueIfExists(element2, "broadcast-condition");
            if (string2 == null) {
                throw new CreateException("\"policy-type\" tag or value not exists for [" + string + "] operation under " + "load-bal-policy" + " tag.");
            }
            NodeList nodeList2 = element2.getElementsByTagName("param");
            for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
                String string4 = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), "param-name");
                String string5 = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), "param-value");
                if (string4 == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + string + " operation name under " + "load-bal-policy" + " tag. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (string5 == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + string + " operation name under " + "load-bal-policy" + " tag. Check " + this.clusterConfigFile + " cluster config file.");
                }
                Vector<String> vector2 = new Vector<String>();
                vector2.add(string4);
                vector2.add(string5);
                vector.add(vector2);
            }
            loadBalancingPolicyDescription = new GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription();
            loadBalancingPolicyDescription.m_PolicyType = string2;
            Vector vector3 = loadBalancingPolicyDescription.m_paramTable = vector.size() > 0 ? vector : null;
            if (string3 == null) {
                string3 = string.equals("write") || string.equals("notify") ? "broadcast-disabled" : "broadcast-if-null-values";
            }
            loadBalancingPolicyDescription.setBroadcastCondition(string3);
        }
        return loadBalancingPolicyDescription;
    }

    private GroupInfo.ReplicationInfo createReplicationGroup(String string, String string2) throws CreateException {
        ReplicationPolicy replicationPolicy = null;
        try {
            replicationPolicy = this.clusterXML.createClusterPolicy((String)string2).m_ReplicationPolicy;
        }
        catch (NullPointerException nullPointerException) {
            _logger.log(Level.SEVERE, nullPointerException.toString(), nullPointerException);
            return null;
        }
        if (replicationPolicy == null || !replicationPolicy.m_ReplicationGroupName.equals(string)) {
            return null;
        }
        GroupInfo.ReplicationInfo replicationInfo = new GroupInfo.ReplicationInfo();
        replicationInfo.m_PolicyType = replicationPolicy.m_PolicyType;
        replicationInfo.m_MemoryRecovery = replicationPolicy.m_Recovery;
        replicationInfo.m_ReplicateNotifyTemplates = replicationPolicy.m_ReplicateNotifyTemplates;
        replicationInfo.m_TriggerNotifyTemplates = replicationPolicy.m_TriggerNotifyTemplates;
        boolean bl2 = false;
        replicationInfo.m_SpaceFinderTimeout = String.valueOf(replicationPolicy.m_SpaceFinderTimeout);
        replicationInfo.m_SyncOnCommit = replicationPolicy.m_SyncOnCommit;
        replicationInfo.m_ReplicateOriginalState = replicationPolicy.isReplicateOriginalState();
        replicationInfo.m_SyncOnCommitTimeOut = String.valueOf(replicationPolicy.m_SyncOnCommitTimeout);
        replicationInfo.m_ReplicationChunkSize = String.valueOf(replicationPolicy.m_ReplicationChunkSize);
        replicationInfo.m_ReplicationIntervalMillis = String.valueOf(replicationPolicy.m_ReplicationIntervalMillis);
        replicationInfo.m_ReplicationIntervalOperations = String.valueOf(replicationPolicy.m_ReplicationIntervalOperations);
        replicationInfo.m_ReplicationMode = replicationPolicy.m_ReplicationMode;
        replicationInfo.m_CommunicationMode = replicationPolicy.getCommunicationMode();
        replicationInfo.m_TodoQueueTimeout = String.valueOf(replicationPolicy.m_SyncReplPolicy.getTodoQueueTimeout());
        replicationInfo.m_MinUnicastWorkingThreads = String.valueOf(replicationPolicy.m_SyncReplPolicy.getUnicastMinThreadPoolSize());
        replicationInfo.m_MaxUnicastWorkingThreads = String.valueOf(replicationPolicy.m_SyncReplPolicy.getUnicastMaxThreadPoolSize());
        replicationInfo.m_MinMulticastWorkingThreads = String.valueOf(replicationPolicy.m_SyncReplPolicy.getMulticastMinThreadPoolSize());
        replicationInfo.m_MaxMulticastWorkingThreads = String.valueOf(replicationPolicy.m_SyncReplPolicy.getMulticastMaxThreadPoolSize());
        replicationInfo.m_IpGroup = String.valueOf(replicationPolicy.m_SyncReplPolicy.getMulticastIpGroup());
        replicationInfo.m_Port = String.valueOf(replicationPolicy.m_SyncReplPolicy.getMulticastPort());
        replicationInfo.m_TTL = ClusterXML.TTL_DEFAULT_VALUE;
        replicationInfo.m_ReplFindReportInterval = ClusterXML.REPL_FIND_REPORT_INTERVAL_DEFAULT_VALUE;
        replicationInfo.m_RedoLogCapacity = ClusterXML.REPL_REDO_LOG_CAPACITY_DEFAULT_VALUE;
        replicationInfo.m_RecoveryChunkSize = ClusterXML.RECOVERY_CHUNK_SIZE_DEFAULT_VALUE;
        return replicationInfo;
    }

    private FailOverPolicy createFailOverGroup(String string, String string2) throws CreateException {
        FailOverPolicy failOverPolicy = null;
        try {
            failOverPolicy = this.clusterXML.createClusterPolicy((String)string2).m_FailOverPolicy;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        if (failOverPolicy != null && failOverPolicy.failOverGroupName.equals(string)) {
            return failOverPolicy;
        }
        return null;
    }

    public ClusterPolicy createClusterPolicy(String string) throws CreateException {
        return this.clusterXML.createClusterPolicy(string);
    }

    public void setSpaceIDToMember(ServiceID serviceID, String string) {
        this.setSpaceIDToMember(this.primaryMembers, serviceID, string);
        this.setSpaceIDToMember(this.clusterMembers, serviceID, string);
        this.setSpaceIDToMember(this.backupsMembers, serviceID, string);
        GroupInfo[] groupInfoArray = this.clusterGroups;
        int n2 = groupInfoArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            GroupInfo groupInfo = groupInfoArray[i2];
            this.setSpaceIDToMember(groupInfo.groupMembers, serviceID, string);
        }
    }

    private void setSpaceIDToMember(ClusterMemberInfo[] clusterMemberInfoArray, ServiceID serviceID, String string) {
        if (clusterMemberInfoArray == null) {
            return;
        }
        ClusterMemberInfo[] clusterMemberInfoArray2 = clusterMemberInfoArray;
        int n2 = clusterMemberInfoArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ClusterMemberInfo clusterMemberInfo = clusterMemberInfoArray2[i2];
            if (!clusterMemberInfo.memberName.equals(string)) continue;
            clusterMemberInfo.setSpaceID(serviceID);
            break;
        }
    }

    public void updateClusterActiveMembers(List list) {
        Object object;
        Object object2;
        HashMap<String, ClusterMemberInfo[]> hashMap = new HashMap<String, ClusterMemberInfo[]>(list.size());
        boolean bl2 = false;
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (ClusterMemberInfo[])object3.next();
            hashMap.put(object2.getName(), (ClusterMemberInfo[])object2);
        }
        object3 = new HashMap(this.clusterMembers.length);
        object2 = this.clusterMembers;
        int n2 = ((ClusterMemberInfo[])object2).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = object2[i2];
            if (hashMap.get(((ClusterMemberInfo)object).memberName) != null) {
                object3.put(((ClusterMemberInfo)object).memberName, object);
                continue;
            }
            bl2 = true;
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            IMemberData iMemberData = (IMemberData)object2.next();
            String string = iMemberData.getName();
            object = iMemberData.getServiceID();
            ClusterMemberInfo clusterMemberInfo = null;
            if (object3.get(string) != null) continue;
            clusterMemberInfo = this.createClusterMemberInfo(string, iMemberData.getURL(), this.clusterName, this.clusterGroups[0].groupName, (ServiceID)object, iMemberData.isMirror());
            object3.put(string, clusterMemberInfo);
            bl2 = true;
        }
        if (bl2) {
            this.clusterMembers = object3.values().toArray(new ClusterMemberInfo[object3.size()]);
            this.clusterGroups[0].groupMembers = this.clusterMembers;
        }
    }

    private ClusterMemberInfo createClusterMemberInfo(String string, SpaceURL spaceURL, String string2, String string3, ServiceID serviceID, boolean bl2) {
        return new ClusterMemberInfo(string, spaceURL, string2, string3, serviceID, bl2);
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

