/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.core.client.ClientUIDHandler;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.ExternalEntryPool;
import com.j_spaces.jdbc.QPConstants;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.SelectQuery;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class InsertQuery
extends AbstractDMLQuery {
    private ArrayList a;
    private SelectQuery b = null;
    private static final Logger c = Logger.getLogger("com.gigaspaces.persistent");

    public void setQuery(SelectQuery selectQuery) {
        this.b = selectQuery;
    }

    public ResponsePacket executeOnSpace(IJSpace iJSpace, Transaction transaction, Hashtable hashtable) {
        ResponsePacket responsePacket = new ResponsePacket();
        try {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)hashtable.get(this.tableName);
            if (basicTypeInfo == null) {
                basicTypeInfo = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getClassTypeInfo(this.tableName);
                if (basicTypeInfo == null) {
                    throw new SQLException("Table [" + this.tableName + "] does not exist!", "GSP", -102);
                }
                hashtable.put(this.tableName, basicTypeInfo);
            }
            this.setTableInfos(hashtable);
            if (this.b == null) {
                String[] stringArray;
                Object[] objectArray;
                if (this.isPrepared) {
                    objectArray = this.a.toArray();
                    int n2 = 0;
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        if (objectArray[i2] != null) continue;
                        objectArray[i2] = this.preparedValues[n2++];
                    }
                } else {
                    if (this.a == null || this.getQueryColumns() != null && this.a.size() != this.getQueryColumns().size()) {
                        responsePacket.setException(new SQLException("All values must be set ", "GSP", -126));
                        return responsePacket;
                    }
                    objectArray = this.a.toArray();
                }
                if (this.getQueryColumns() != null) {
                    stringArray = new String[this.getQueryColumns().size()];
                    this.getQueryColumns().toArray(stringArray);
                } else {
                    stringArray = basicTypeInfo.getFieldsNames();
                    if (stringArray.length != objectArray.length) {
                        responsePacket.setException(new SQLException("All values must be set", "GSP", -126));
                        return responsePacket;
                    }
                }
                String string = null;
                String[] stringArray2 = new String[objectArray.length];
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    String string2 = stringArray2[i3] = objectArray[i3] == null ? basicTypeInfo.getFieldsTypes()[i3] : objectArray[i3].getClass().getName();
                    if (stringArray2[i3].endsWith(".Blob") || stringArray2[i3].endsWith(".Clob")) {
                        if (string == null) {
                            string = ClientUIDHandler.createUIDFromName(String.valueOf(Math.random()), stringArray2[i3]);
                        }
                        ((ObjectWithUID)objectArray[i3]).setEntryUID(string);
                        ((ObjectWithUID)objectArray[i3]).setObjectIndex(i3);
                    }
                    if (basicTypeInfo.getFieldsTypes()[i3].equals(stringArray2[i3])) continue;
                    try {
                        objectArray[i3] = SQLUtil.cast(basicTypeInfo, stringArray[i3], objectArray[i3]);
                        continue;
                    }
                    catch (Exception exception) {
                        SQLException sQLException = new SQLException("Wrong type for given column " + basicTypeInfo.getFieldsNames()[i3] + " " + basicTypeInfo.getFieldsTypes()[i3] + " vs " + stringArray2[i3], "GSP", -127);
                        sQLException.initCause(exception);
                        responsePacket.setException(sQLException);
                        return responsePacket;
                    }
                }
                ExternalEntry externalEntry = ExternalEntryPool.getExternalEntry(this.getTableName(), objectArray, stringArray);
                externalEntry.m_FieldsTypes = stringArray2;
                if (string != null) {
                    externalEntry.setUID(string);
                }
                iJSpace.write(externalEntry, transaction, QPConstants.SPACE_WRITE_LEASE);
                ExternalEntryPool.release(externalEntry);
                responsePacket.setIntResult(1);
            } else {
                int n3;
                String[] stringArray;
                int[] nArray;
                this.b.setSession(this.getSession());
                ResponsePacket responsePacket2 = this.b.executeOnSpace(iJSpace, transaction, hashtable);
                if (responsePacket2.getException() != null) {
                    responsePacket.setException(responsePacket2.getException());
                    return responsePacket;
                }
                ResultEntry resultEntry = responsePacket2.getResultEntry();
                if (resultEntry == null) {
                    responsePacket.setIntResult(_Integer.valueOf(0));
                    return responsePacket;
                }
                if (this.getQueryColumns() != null) {
                    if (this.getQueryColumns().size() != resultEntry.getFieldNames().length) {
                        responsePacket.setException(new SQLException("Incorrect number of values to insert", "GSP", -128));
                        return responsePacket;
                    }
                    nArray = new int[this.getQueryColumns().size()];
                    stringArray = new String[this.getQueryColumns().size()];
                    Iterator iterator = this.getQueryColumns().iterator();
                    int n4 = 0;
                    block7: while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        for (int i4 = 0; i4 < basicTypeInfo.m_FieldsNames.length; ++i4) {
                            if (!basicTypeInfo.m_FieldsNames[i4].equalsIgnoreCase(string)) continue;
                            nArray[n4] = i4;
                            stringArray[n4] = basicTypeInfo.m_FieldsTypes[i4];
                            ++n4;
                            continue block7;
                        }
                    }
                } else {
                    if (basicTypeInfo.m_FieldsNames.length != resultEntry.getFieldNames().length) {
                        responsePacket.setException(new SQLException("Incorrect number of values to insert", "GSP", -128));
                        return responsePacket;
                    }
                    nArray = new int[basicTypeInfo.m_FieldsNames.length];
                    for (int i5 = 0; i5 < nArray.length; ++i5) {
                        nArray[i5] = i5;
                    }
                    stringArray = basicTypeInfo.getFieldsTypes();
                }
                for (int i6 = 0; i6 < nArray.length; ++i6) {
                    if (basicTypeInfo.m_FieldsTypes[nArray[i6]].equals(resultEntry.getFieldValues(1)[i6].getClass().getName())) continue;
                    responsePacket.setException(new SQLException("Type mismatch in nested query", "GSP", -129));
                    return responsePacket;
                }
                Entry[] entryArray = new ExternalEntry[resultEntry.getRowNumber()];
                String[] stringArray3 = new String[nArray.length];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    stringArray3[n3] = basicTypeInfo.m_FieldsNames[nArray[n3]];
                }
                for (n3 = 0; n3 < entryArray.length; ++n3) {
                    ExternalEntry externalEntry = new ExternalEntry(this.getTableName(), resultEntry.getFieldValues(n3 + 1), stringArray3);
                    externalEntry.m_FieldsTypes = stringArray;
                    entryArray[n3] = externalEntry;
                }
                Lease[] leaseArray = iJSpace.writeMultiple(entryArray, transaction, QPConstants.SPACE_WRITE_LEASE);
                responsePacket.setIntResult(_Integer.valueOf(leaseArray.length));
            }
        }
        catch (SQLException sQLException) {
            responsePacket.setException(sQLException);
        }
        catch (Exception exception) {
            if (c.isLoggable(Level.SEVERE)) {
                c.log(Level.SEVERE, exception.getMessage(), exception);
            }
            SQLException sQLException = new SQLException("Remote Exception occurred, Entry insert failed!", "GSP", -106);
            sQLException.initCause(exception);
            responsePacket.setException(sQLException);
        }
        return responsePacket;
    }

    public void setValues(ArrayList arrayList) {
        this.a = arrayList;
    }

    public Object clone() {
        return this;
    }

    public void validateQuery(IJSpace iJSpace, Hashtable hashtable) throws SQLException {
        try {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)hashtable.get(this.tableName);
            if (basicTypeInfo == null && (basicTypeInfo = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getClassTypeInfo(this.tableName)) != null) {
                hashtable.put(this.tableName, basicTypeInfo);
            }
            if (basicTypeInfo == null) {
                throw new SQLException("Table does not exist!", "GSP", -105);
            }
            this.setTableInfos(hashtable);
        }
        catch (RemoteException remoteException) {
            SQLException sQLException = new SQLException("RemoteException occurred", "GSP", -106);
            sQLException.initCause(remoteException);
            throw sQLException;
        }
        if (!this.isPrepared && this.b == null && (this.a == null || this.getQueryColumns() != null && this.a.size() != this.getQueryColumns().size())) {
            throw new SQLException("All values must be set", "GSP", -126);
        }
        if (this.b != null) {
            this.b.validateQuery(iJSpace, hashtable);
        }
    }
}

