/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.lrmi;

import com.gigaspaces.transport.GenericExporter;
import com.gigaspaces.transport.nio.NIOConfiguration;
import com.j_spaces.core.Constants;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.StubHandlerImpl;
import com.j_spaces.kernel.log.JProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEventListener;
import net.sf.retrotranslator.runtime.java.lang._Boolean;

public class LRMIStubHandlerImpl
implements IStubHandler {
    private static final long serialVersionUID = 2L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private NIOConfiguration _exporterConfig;
    private String _clientPort = "0";
    private boolean _slowConsumer;
    private transient GenericExporter _exporter;
    private IStubHandler _rmiStubHandler;

    public void init(String string) {
        String string2 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.protocol-name", "NIO").toUpperCase();
        if (string2.equals("RMI")) {
            this._rmiStubHandler = new StubHandlerImpl();
            this._rmiStubHandler.init(string);
            return;
        }
        String string3 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.server-port", "0");
        this._clientPort = JProperties.getSpaceProperty(string, "lrmi-stub-handler.client-port", "0");
        String string4 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.min-worker-threads", "1");
        String string5 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.max-worker-threads", "64");
        String string6 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.is-multiplex-connection", Constants.LRMIStubHandler.MULTIPLEX_DEFAULT_CONNECTION);
        String string7 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.max-pool-connections", "20");
        String string8 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.worker-threads-queue-size", Constants.LRMIStubHandler.LRMI_DEFAULT_WORKER_THREADS_QUEUE_SIZE);
        String string9 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.slowconsumer.throughput", "0");
        int n2 = Integer.parseInt(string9);
        this._slowConsumer = n2 > 0;
        String string10 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.slowconsumer.latency", "100");
        String string11 = JProperties.getSpaceProperty(string, "lrmi-stub-handler.slowconsumer.retries", "3");
        this._exporterConfig = new NIOConfiguration(Integer.parseInt(string4), Integer.parseInt(string5), Integer.parseInt(string7), _Boolean.parseBoolean(string6), null, Integer.parseInt(string3), Integer.parseInt(string8), Integer.parseInt(string9), Integer.parseInt(string10), Integer.parseInt(string11));
        this._exporter = new GenericExporter(this._exporterConfig);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[" + string + "] space initialized [" + this.getClass().getName() + "] with the following configuration: " + this._exporterConfig);
        }
    }

    public Remote exportObject(Remote remote) throws RemoteException {
        NIOConfiguration nIOConfiguration = this._exporterConfig;
        if (remote instanceof RemoteEventListener && this._slowConsumer) {
            nIOConfiguration = this._exporterConfig.clone();
            nIOConfiguration.setBlockingConnection(false);
        }
        if (this._rmiStubHandler != null) {
            return this._rmiStubHandler.exportObject(remote);
        }
        return this._exporter.export(remote, nIOConfiguration);
    }

    public void unexportObject(Remote remote, boolean bl2) throws RemoteException {
        if (this._rmiStubHandler != null) {
            this._rmiStubHandler.unexportObject(remote, bl2);
        } else {
            this._exporter.unexport(remote, bl2);
        }
    }

    public String getProtocolName() {
        if (this._rmiStubHandler != null) {
            return this._rmiStubHandler.getProtocolName();
        }
        return this._exporterConfig.getProtocolName();
    }

    public boolean isStub(Remote remote) {
        if (this._rmiStubHandler != null) {
            return this._rmiStubHandler.isStub(remote);
        }
        return this._exporter.isExported(remote);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._rmiStubHandler == null) {
            this._exporterConfig.setBindPort(Integer.parseInt(this._clientPort));
            this._exporter = new GenericExporter(this._exporterConfig);
        }
    }
}

