/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.core.cluster.sync_replication.SyncReplPolicy;
import com.j_spaces.core.cluster.sync_replication.UnicastProtocolAdaptor;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class ReplicationPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UNICAST_COMMUNICATION_MODE = "unicast";
    public static final String MULTICAST_COMMUNICATION_MODE = "multicast";
    public static final int UNICAST = 0;
    public static final int MULTICAST = 1;
    public static final String ASYNC_REPLICATION_MODE = "async";
    public static final String SYNC_REPLICATION_MODE = "sync";
    public static final String SYNC_REC_ACK_REPLICATION_MODE = "sync-rec-ack";
    public static final String ASYNC_REC_ACK_REPLICATION_MODE = "async-rec-ack";
    public static final int FULL_REPLICATION = 0;
    public static final int PARTIAL_REPLICATION = 1;
    public static final String DEFAULT_REPL_ORIGINAL_STATE = "false";
    public static final int DEFAULT_REPL_CHUNK_SIZE = 100;
    public static final int DEFAULT_REPL_INTERVAL_MILLIS = 3000;
    public static final int DEFAULT_REPL_INTERVAL_OPERS = 100;
    public static final int DEFAULT_REPL_SPACE_FINDER_TIMEOUT = 2000;
    public static final int DEFAULT_REPL_SPACE_FINDER_REPORT_INTERVAL = 30000;
    public static final int DEFAULT_SYNC_ON_COMMIT_TIMEOUT = 300000;
    public String m_OwnMemberName;
    public String m_ReplicationGroupName;
    public List m_ReplicationGroupMembersNames;
    public List m_ReplicationGroupMembersURLs;
    public boolean m_ReplicateNotifyTemplates = false;
    public boolean m_TriggerNotifyTemplates = false;
    private boolean m_ReplicateOriginalState = false;
    public boolean m_SyncOnCommit = false;
    public String m_ReplicationMode;
    public int m_PolicyType = 0;
    public int m_ReplicationChunkSize = 100;
    public long m_ReplicationIntervalMillis = 3000L;
    public int m_ReplicationIntervalOperations = 100;
    public long m_SpaceFinderTimeout = 2000L;
    public long m_SpaceFinderReportInterval = 30000L;
    public long m_SyncOnCommitTimeout = 300000L;
    public boolean m_Recovery = false;
    public Hashtable m_ReplMemberPolicyDescTable;
    public boolean isOneWayReplication = false;
    public boolean m_IsSyncReplicationEnabled;
    public SyncReplPolicy m_SyncReplPolicy;
    public String protocolAdaptorClass;
    public String communicationMode;
    public long maxRedoLogCapacity;
    private int recoveryChunkSize;
    public String clusterName;
    private MirrorServiceConfig _mirrorServiceConfig;
    public static final String DEFAULT_MIRROR_SERVICE_NAME = "MIRROR_SERVICE";
    public static final String DEFAULT_MIRROR_SERVICE_CONNECTOR_NAME = "Mirror Service Connector";
    static /* synthetic */ Class class$com$j_spaces$core$cluster$sync_replication$UnicastProtocolAdaptor;

    public void setMirrorServiceConfig(MirrorServiceConfig mirrorServiceConfig) {
        this._mirrorServiceConfig = mirrorServiceConfig;
    }

    public MirrorServiceConfig getMirrorServiceConfig() {
        return this._mirrorServiceConfig;
    }

    public boolean isMirrorServiceEnabled() {
        return this._mirrorServiceConfig != null;
    }

    public void setMaxRedoLogCapacity(long l2) {
        this.maxRedoLogCapacity = l2;
    }

    public long getMaxRedoLogCapacity() {
        return this.maxRedoLogCapacity;
    }

    public boolean isOwnerMemberHasSyncReplication() {
        ReplicationPolicyDescription replicationPolicyDescription;
        boolean bl2 = this.m_IsSyncReplicationEnabled;
        if (!bl2 && (replicationPolicyDescription = (ReplicationPolicyDescription)this.m_ReplMemberPolicyDescTable.get(this.m_OwnMemberName)) != null && replicationPolicyDescription.replTransmissionPolicies != null) {
            Iterator iterator = replicationPolicyDescription.replTransmissionPolicies.iterator();
            while (iterator.hasNext()) {
                ReplicationTransmissionPolicy replicationTransmissionPolicy = (ReplicationTransmissionPolicy)iterator.next();
                if (replicationTransmissionPolicy.m_DisableTransmission || !replicationTransmissionPolicy.isSyncReplication()) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public List getRecoverableTargets() {
        LinkedList<SpaceURL> linkedList = new LinkedList<SpaceURL>();
        boolean bl2 = false;
        SpaceURL spaceURL = null;
        ReplicationPolicyDescription replicationPolicyDescription = (ReplicationPolicyDescription)this.m_ReplMemberPolicyDescTable.get(this.m_OwnMemberName);
        for (int i2 = 0; i2 < this.m_ReplicationGroupMembersNames.size(); ++i2) {
            String string = (String)this.m_ReplicationGroupMembersNames.get(i2);
            if (string.equals(this.m_OwnMemberName)) continue;
            SpaceURL spaceURL2 = (SpaceURL)((SpaceURL)this.m_ReplicationGroupMembersURLs.get(i2)).clone();
            if (replicationPolicyDescription.sourceMemberRecovery != null) {
                if (!replicationPolicyDescription.sourceMemberRecovery.equalsIgnoreCase(string)) continue;
                linkedList.add(spaceURL2);
                return linkedList;
            }
            if (spaceURL2.getProtocol().equalsIgnoreCase("jini:")) {
                if (!bl2) {
                    bl2 = true;
                    spaceURL = (SpaceURL)spaceURL2.clone();
                    spaceURL.setPropertiesPrefix("jini:", "*", "*", "*");
                    spaceURL.setProperty("clustername", this.clusterName);
                    spaceURL.setProperty("clustergroup", this.m_ReplicationGroupName);
                    spaceURL.setProperty("state", JSpaceState.convertToString(_Integer.valueOf(1)));
                    linkedList.addFirst(spaceURL);
                }
                if (spaceURL2.getProperty("host") == null || "*".equals(spaceURL2.getProperty("host"))) continue;
                spaceURL2.setProperty("clustername", this.clusterName);
                spaceURL2.setProperty("clustergroup", this.m_ReplicationGroupName);
                spaceURL2.setProperty("state", JSpaceState.convertToString(_Integer.valueOf(1)));
                linkedList.add(spaceURL2);
                continue;
            }
            linkedList.add(spaceURL2);
        }
        return linkedList;
    }

    public boolean isMulticast() {
        return this.communicationMode.equals(MULTICAST_COMMUNICATION_MODE);
    }

    public String getCommunicationMode() {
        return this.communicationMode;
    }

    public void setCommunicationMode(String string) {
        this.communicationMode = string;
    }

    public String getProtocolAdaptorClass() {
        return this.protocolAdaptorClass;
    }

    public void setProtocolAdaptorClass(String string) {
        this.protocolAdaptorClass = string;
    }

    public ReplicationPolicy() {
        Class<?> clazz = class$com$j_spaces$core$cluster$sync_replication$UnicastProtocolAdaptor;
        if (clazz == null) {
            clazz = class$com$j_spaces$core$cluster$sync_replication$UnicastProtocolAdaptor = new UnicastProtocolAdaptor[0].getClass().getComponentType();
        }
        this.protocolAdaptorClass = clazz.getName();
        this.communicationMode = UNICAST_COMMUNICATION_MODE;
        this.maxRedoLogCapacity = -1L;
        this.recoveryChunkSize = 1000;
        this.m_ReplicationChunkSize = 100;
        this.m_ReplicationIntervalMillis = 3000L;
        this.m_SpaceFinderTimeout = 2000L;
        this.m_SpaceFinderReportInterval = 30000L;
        this.m_ReplicationIntervalOperations = 100;
    }

    public int getSpaceMemberPosition(String string) {
        int n2 = 0;
        Iterator iterator = this.m_ReplicationGroupMembersNames.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int getRecoveryChunkSize() {
        return this.recoveryChunkSize;
    }

    public void setRecoveryChunkSize(int n2) {
        this.recoveryChunkSize = n2;
    }

    public final boolean isReplicateOriginalState() {
        return this.m_IsSyncReplicationEnabled || this.m_ReplicateOriginalState;
    }

    public void setReplicatedOriginalState(boolean bl2) {
        this.m_ReplicateOriginalState = bl2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n------------ Replication Policy ---------\n");
        stringBuffer.append("Member Name -\t" + this.m_OwnMemberName + "\n");
        stringBuffer.append("Replication Group Name -\t" + this.m_ReplicationGroupName + "\n");
        stringBuffer.append("Replication Group Members Name List -\t" + this.m_ReplicationGroupMembersNames + "\n");
        stringBuffer.append("Replication Group Members URL -\t" + this.m_ReplicationGroupMembersURLs + "\n");
        stringBuffer.append("Is Replicate Notify Templates -\t" + this.m_ReplicateNotifyTemplates + "\n");
        stringBuffer.append("Is Trigger Notify Templates -\t" + this.m_TriggerNotifyTemplates + "\n");
        stringBuffer.append("Is Replicate Original State -\t" + this.m_ReplicateOriginalState + "\n");
        stringBuffer.append("Is Sync On Commit -\t" + this.m_SyncOnCommit + "\n");
        stringBuffer.append("Replication Mode -\t" + this.m_ReplicationMode + "\n");
        stringBuffer.append("Policy Type -\t");
        if (this.m_PolicyType == 0) {
            stringBuffer.append("Full Replication\n");
        } else if (this.m_PolicyType == 1) {
            stringBuffer.append("Partial Replication\n");
        } else {
            stringBuffer.append("UNKNOWN\n");
        }
        stringBuffer.append("Replication Chunk Size -\t" + this.m_ReplicationChunkSize + "\n");
        stringBuffer.append("Replication Interval Millis -\t" + this.m_ReplicationIntervalMillis + "\n");
        stringBuffer.append("Replication Interval Operations -\t" + this.m_ReplicationIntervalOperations + "\n");
        stringBuffer.append("Space Finder Timeout -\t" + this.m_SpaceFinderTimeout + "\n");
        stringBuffer.append("SpaceFinder Report Interval -\t" + this.m_SpaceFinderReportInterval + "\n");
        stringBuffer.append("Sync On Commit Timeout -\t" + this.m_SyncOnCommitTimeout + "\n");
        stringBuffer.append("Is recovery -\t" + this.m_Recovery + "\n");
        stringBuffer.append("Cluster Name -\t" + this.clusterName + "\n");
        stringBuffer.append("Max Redo Log Capacity -\t" + this.maxRedoLogCapacity + "\n");
        stringBuffer.append("Recovery Chunk Size -\t" + this.recoveryChunkSize + "\n");
        stringBuffer.append("Is One Way Replication -\t" + this.isOneWayReplication + "\n");
        stringBuffer.append("Is SyncReplication Enabled -\t" + this.m_IsSyncReplicationEnabled + "\n");
        stringBuffer.append("Communication Mode -\t" + this.communicationMode + "\n");
        stringBuffer.append("Sync Replication Policy -\n\t" + this.m_SyncReplPolicy + "\n");
        stringBuffer.append("Replication Policy Desc Table -\n\t" + this.m_ReplMemberPolicyDescTable + "\n");
        stringBuffer.append("Protocol Adaptor Class -\t" + this.protocolAdaptorClass + "\n");
        stringBuffer.append("Mirror Service Config -\t" + this._mirrorServiceConfig + "\n");
        return stringBuffer.toString();
    }

    public static class ReplicationPolicyDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public List replTransmissionPolicies;
        public String sourceMemberRecovery;
        public boolean memberRecovery;
        public String inputReplicationFilterClassName;
        public String inputReplicationFilterParamUrl;
        public String outputReplicationFilterClassName;
        public String outputReplicationFilterParamUrl;
        public boolean activeWhenBackup = true;
        public boolean shutdownSpaceOnInitFailure;

        public ReplicationTransmissionPolicy getTargetTransmissionMatrix(String string) {
            if (this.replTransmissionPolicies == null) {
                return null;
            }
            Iterator iterator = this.replTransmissionPolicies.iterator();
            while (iterator.hasNext()) {
                ReplicationTransmissionPolicy replicationTransmissionPolicy = (ReplicationTransmissionPolicy)iterator.next();
                if (!replicationTransmissionPolicy.m_TargetSpace.equals(string)) continue;
                return replicationTransmissionPolicy;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n ReplTransmissionPolicies -\t" + this.replTransmissionPolicies);
            stringBuffer.append("\n Source Member Recovery -\t" + this.sourceMemberRecovery);
            stringBuffer.append("\n Member Recovery -\t" + this.memberRecovery);
            stringBuffer.append("\n Input Replication Filter Class Name -\t" + this.inputReplicationFilterClassName);
            stringBuffer.append("\n Input Replication Filter Param Url -\t" + this.inputReplicationFilterParamUrl);
            stringBuffer.append("\n Output Replication Filter Class Name -\t" + this.outputReplicationFilterClassName);
            stringBuffer.append("\n Output Replication Filter Param Url -\t" + this.outputReplicationFilterParamUrl);
            stringBuffer.append("\n Active when backup -\t" + this.activeWhenBackup);
            stringBuffer.append("\n Shutdown space on init failure -\t" + this.shutdownSpaceOnInitFailure);
            return stringBuffer.toString();
        }
    }

    public static final class MirrorServiceConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public SpaceURL serviceURL;
        public String memberName;
        public int bulkSize = 100;
        public long intervalMillis = 3000L;
        public int intervalOpers = 100;

        public boolean isMirrorTarget(String string) {
            return this.memberName.equals(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-----------MirrorServiceConfig-------------\n");
            stringBuffer.append("Service URL -\t" + this.serviceURL + "\n");
            stringBuffer.append("Member Name -\t" + this.memberName + "\n");
            stringBuffer.append("Bulk Size -\t" + this.bulkSize + "\n");
            stringBuffer.append("Interval Millis -\t" + this.intervalMillis + "\n");
            stringBuffer.append("Interval Operations -\t" + this.intervalOpers + "\n");
            return stringBuffer.toString();
        }
    }
}

