/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.LoadBalancingPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ClusterPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int _logicMembers;
    public int _logicCopies;
    public String m_ClusterSchemaName;
    public String m_ClusterName;
    public boolean m_NotifyRecovery;
    public CacheLoaderConfig m_CacheLoaderConfig;
    public String m_ClusterGroupMember;
    public boolean m_Replicated;
    public ReplicationPolicy m_ReplicationPolicy;
    public FailOverPolicy m_FailOverPolicy;
    public LoadBalancingPolicy m_LoadBalancingPolicy;
    public List m_ReplicationGroups;
    public List m_AllClusterMemberList;
    public HashMap m_ClusterMembersProperties;
    public JSpaceAttributes m_DCacheAttributes;
    public String m_DCacheConfigName;
    public Properties m_jmsProperties;
    public String m_jmsConfigName;

    public boolean isDynamicCluster() {
        return this._logicCopies > 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n------------- CLUSTER POLICY RUNTIME CONFIGURATIONS REPORT ----------\n\n");
        stringBuffer.append("Cluster schema name -\t" + this.m_ClusterSchemaName + "\n");
        stringBuffer.append("Cluster name -\t" + this.m_ClusterName + "\n");
        stringBuffer.append("Is logic members number -\t" + this._logicMembers + "\n");
        stringBuffer.append("Is logic copies number -\t" + this._logicCopies + "\n");
        stringBuffer.append("Is notify recovery -\t" + this.m_NotifyRecovery + "\n");
        stringBuffer.append("Cluster group member -\t" + this.m_ClusterGroupMember + "\n");
        stringBuffer.append("Is replicated -\t" + this.m_Replicated + "\n");
        stringBuffer.append("DCache config name -\t" + this.m_DCacheConfigName + "\n");
        stringBuffer.append("JMS config name -\t" + this.m_jmsConfigName + "\n");
        stringBuffer.append("JMS properties -\n\t" + JSpaceUtilities.getPropertiesPresentation(this.m_jmsProperties) + "\n");
        stringBuffer.append("DCache attributes -\n\t" + JSpaceUtilities.getPropertiesPresentation(this.m_DCacheAttributes) + "\n");
        stringBuffer.append("Cluster members list -\t" + this.m_AllClusterMemberList + "\n");
        stringBuffer.append("Replication groups -\t" + this.m_ReplicationGroups + "\n");
        stringBuffer.append("CacheLoader config -\t" + this.m_CacheLoaderConfig + "\n");
        stringBuffer.append("Replication Policy -\t" + this.m_ReplicationPolicy + "\n");
        stringBuffer.append("FailOver Policy -\t" + this.m_FailOverPolicy + "\n");
        stringBuffer.append("Load Balancing Policy -\t" + this.m_LoadBalancingPolicy + "\n");
        stringBuffer.append("\n\n------------- END REPORT OF CLUSTER POLICY RUNTIME CONFIGURATIONS ----------\n");
        return stringBuffer.toString();
    }

    public static final class CacheLoaderConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean externalDataSource = CacheLoaderConfig.externalDataSourceDefault();
        public boolean centralDataSource = CacheLoaderConfig.centralDataSourceDefault();

        public static boolean externalDataSourceDefault() {
            return false;
        }

        public static boolean centralDataSourceDefault() {
            return false;
        }

        public String toString() {
            return "\n-----CacheLoaderConfig------\nExternal Data Source -\t" + this.externalDataSource + "\nCentral Data Source -\t" + this.centralDataSource + "\n";
        }
    }
}

