/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.NotifyDelegatorListener;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.time.SystemTime;
import com.j_spaces.worker.multicast.MulticastCommandEntry;
import java.rmi.MarshalledObject;
import java.util.List;
import java.util.Vector;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.UnknownLeaseException;

public class MulticastTemplateContext
extends NotifyDelegatorListener {
    public MulticastCommandEntry commandEntry;
    public List eventQueue;
    public IJSpace spaceProxy;
    public MarshalledObject handback;
    public long absExprTime;
    public long seqNumOffset;
    public EventRegistration eventRegistration;

    public MulticastTemplateContext(IJSpace iJSpace, MulticastCommandEntry multicastCommandEntry, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, boolean bl2, long l2) {
        super(iJSpace.getReferentUuid(), remoteEventListener, bl2, l2);
        this.spaceProxy = iJSpace;
        this.commandEntry = multicastCommandEntry;
        this.handback = marshalledObject;
        this.seqNumOffset = l2;
        this._filterID = multicastCommandEntry.filterID;
        this.setLease(multicastCommandEntry.getTemplateLease());
        this.eventQueue = new Vector();
    }

    public String getTemplateID() {
        return this.commandEntry.templateID;
    }

    public boolean isValid(String string) throws UnknownLeaseException {
        if (string.equals(this.commandEntry.templateID)) {
            if (SystemTime.timeMillis() > this.absExprTime) {
                throw new UnknownLeaseException("TemplateID : " + this.getTemplateID() + " lease expired.");
            }
            return true;
        }
        return false;
    }

    public void setLease(long l2) {
        if (l2 == Long.MAX_VALUE || l2 == -1L || l2 < 0L) {
            this.absExprTime = Long.MAX_VALUE;
        } else {
            this.absExprTime = SystemTime.timeMillis() + l2;
            if (this.absExprTime < 0L) {
                this.absExprTime = Long.MAX_VALUE;
            }
        }
    }

    public void cancelLease() {
        this.absExprTime = 0L;
    }

    public void addEvent(EntryArrivedRemoteEvent entryArrivedRemoteEvent) {
        if (entryArrivedRemoteEvent.getSequenceNumber() < this.seqNumOffset) {
            return;
        }
        entryArrivedRemoteEvent = entryArrivedRemoteEvent.cloneEvent(this.spaceProxy, this.handback);
        this.eventQueue.add(entryArrivedRemoteEvent);
    }

    public void addEvent(Object object) {
        if (object instanceof EntryArrivedRemoteEvent) {
            this.addEvent((EntryArrivedRemoteEvent)object);
        } else {
            EntryArrivedRemoteEvent[] entryArrivedRemoteEventArray = (EntryArrivedRemoteEvent[])object;
            for (int i2 = 0; i2 < entryArrivedRemoteEventArray.length; ++i2) {
                this.addEvent(entryArrivedRemoteEventArray[i2]);
            }
        }
    }

    public void notifyEvents() {
        while (!this.eventQueue.isEmpty()) {
            try {
                EntryArrivedRemoteEvent entryArrivedRemoteEvent = (EntryArrivedRemoteEvent)this.eventQueue.remove(0);
                this.notify(entryArrivedRemoteEvent);
            }
            catch (Exception exception) {
                System.err.println("Notification failed for " + this.commandEntry.templateID + " Exception : " + JSpaceUtilities.getStackTrace(exception));
            }
        }
    }

    public EventRegistration getEventRegistration() {
        return this.eventRegistration;
    }

    public void setEventRegistration(EventRegistration eventRegistration) {
        this.eventRegistration = eventRegistration;
    }

    public boolean equals(Object object) {
        if (object instanceof MulticastTemplateContext) {
            MulticastTemplateContext multicastTemplateContext = (MulticastTemplateContext)object;
            return multicastTemplateContext.commandEntry.getCommandUUID().equals(this.commandEntry.getCommandUUID());
        }
        return false;
    }

    public int hashCode() {
        return this.commandEntry.getCommandUUID().hashCode();
    }
}

