/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.client.MulticastTemplateContext;
import com.j_spaces.worker.multicast.MulticastCommandEntry;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

public class MulticastLeaseProxy
implements Lease,
Serializable {
    public static final long LEASE_CONFIRMATION_TIMEOUT = 5000L;
    public transient MulticastTemplateContext _templateContext;
    public transient Lease _commandTemplateLease;

    public MulticastLeaseProxy(Lease lease, MulticastTemplateContext multicastTemplateContext) {
        this._templateContext = multicastTemplateContext;
        this._commandTemplateLease = lease;
    }

    public long getExpiration() {
        this.isLeaseValid();
        return this._commandTemplateLease.getExpiration();
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        this.isLeaseValid();
        this._templateContext.cancelLease();
        this._commandTemplateLease.cancel();
        MulticastCommandEntry multicastCommandEntry = MulticastCommandEntry.createCommand(MulticastCommandEntry.NOTIFY_LEASE_CONFIRMATION, this._templateContext.commandEntry.uuid);
        try {
            Entry entry = this._templateContext.spaceProxy.take(multicastCommandEntry, null, 5000L);
            if (entry == null) {
                throw new UnknownLeaseException("Template " + this._templateContext.getEventRegistration().getID() + " was already canceled or expired.");
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Failed to cancel template lease EventID : " + this._templateContext.getEventRegistration().getID(), exception);
        }
    }

    public void renew(long l2) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.isLeaseValid();
        this._commandTemplateLease.renew(l2);
        this._templateContext.setLease(l2);
    }

    public void setSerialFormat(int n2) {
        this.isLeaseValid();
        this._commandTemplateLease.setSerialFormat(n2);
    }

    public int getSerialFormat() {
        this.isLeaseValid();
        return this._commandTemplateLease.getSerialFormat();
    }

    public LeaseMap createLeaseMap(long l2) {
        this.isLeaseValid();
        return this._commandTemplateLease.createLeaseMap(l2);
    }

    public boolean canBatch(Lease lease) {
        this.isLeaseValid();
        return this._commandTemplateLease.canBatch(lease);
    }

    private void isLeaseValid() {
        if (this._templateContext == null) {
            throw new UnsupportedOperationException("MulticastNotifyDelegator template lease doesn't support serialization.( The Lease is valid only in VM where MulticastNotifyDelegator was initialized. )");
        }
    }

    public Lease getMulticastCommandLease() {
        return this._commandTemplateLease;
    }
}

