/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SecurityContext;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopySpace
implements GS.OptionHandler,
Constants {
    private SpaceURL a;
    private SpaceURL b;
    private Map c;
    private static Logger d = Logger.getLogger("com.gigaspaces.admin");
    private OptionHandler e;
    public static final String OPERATION_NAME = "copy";

    public CopySpace() {
        String[] stringArray = new String[]{"h", "help", "login", "u1", "p1", "u2", "p2", "move"};
        this.e = new OptionHandler(Formatter.fromArray((String[])stringArray));
    }

    public String process(String string, BufferedReader bufferedReader) {
        IJSpace iJSpace = null;
        IJSpace iJSpace2 = null;
        try {
            Map map = this.e.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            this.c = map;
            String[] stringArray = OptionHandler.getCommandParameters(string);
            if (stringArray.length < 2) {
                return this.getUsage();
            }
            this.a = SpaceURLParser.parseURL(stringArray[0]);
            this.b = SpaceURLParser.parseURL(stringArray[1]);
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            System.out.println("Look up for " + this.a);
            try {
                iJSpace = (IJSpace)CLIFinder.find(this.a, 1);
            }
            catch (Exception exception) {
                CLIUtilities.printWrongSpaceURLMessage(this.a.getURL());
                return "";
            }
            if (iJSpace == null) {
                CLIUtilities.printWrongSpaceURLMessage(this.a.getURL());
                return "";
            }
            System.out.println("Look up for " + this.b);
            try {
                iJSpace2 = (IJSpace)CLIFinder.find(this.b, 1);
            }
            catch (Exception exception) {
                CLIUtilities.printWrongSpaceURLMessage(this.b.getURL());
                return "";
            }
            if (iJSpace2 == null) {
                CLIUtilities.printWrongSpaceURLMessage(this.b.getURL());
                return "";
            }
            this.copy(iJSpace2);
            if (map.containsKey("move")) {
                iJSpace.clean();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (SecurityException securityException) {
            if (this.c.containsKey("login")) {
                try {
                    if (iJSpace.isSecured()) {
                        this.login(iJSpace);
                    }
                    if (iJSpace2.isSecured()) {
                        this.login(iJSpace2);
                    }
                    this.copy(iJSpace2);
                }
                catch (Exception exception) {
                    d.log(Level.SEVERE, securityException.toString(), exception);
                }
                return "";
            }
            if (this.c.containsKey("u1") && this.c.containsKey("p1")) {
                try {
                    if (iJSpace.isSecured()) {
                        this.login(iJSpace, (String)this.c.get("u1"), (String)this.c.get("p1"));
                    }
                    if (iJSpace2.isSecured()) {
                        this.login(iJSpace2, (String)this.c.get("u2"), (String)this.c.get("p2"));
                    }
                    this.copy(iJSpace2);
                }
                catch (Exception exception) {
                    d.log(Level.SEVERE, exception.toString(), exception);
                }
                return "";
            }
            if (this.c.containsKey("u2") && this.c.containsKey("p2")) {
                try {
                    if (iJSpace.isSecured()) {
                        this.login(iJSpace, (String)this.c.get("u1"), (String)this.c.get("p1"));
                    }
                    if (iJSpace2.isSecured()) {
                        this.login(iJSpace2, (String)this.c.get("u2"), (String)this.c.get("p2"));
                    }
                    this.copy(iJSpace2);
                }
                catch (Exception exception) {
                    d.log(Level.SEVERE, exception.toString(), exception);
                }
                return "";
            }
            d.log(Level.SEVERE, securityException.toString(), securityException);
        }
        catch (Exception exception) {
            d.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    public void copy(IJSpace iJSpace) throws SecurityException, RemoteException {
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
        SpaceCopyStatus spaceCopyStatus = iRemoteJSpaceAdmin.spaceCopy(this.a.getURL(), null, false, 1000);
        System.out.println("Loaded objects: " + spaceCopyStatus);
    }

    public void login(IJSpace iJSpace) throws SecurityException, Exception {
        BufferedReader bufferedReader = null;
        SecurityContext securityContext = null;
        String string = null;
        String string2 = null;
        bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nLogin to " + iJSpace.getName());
        System.out.println("User name: ");
        string = bufferedReader.readLine();
        System.out.println("Password: ");
        string2 = bufferedReader.readLine();
        securityContext = new SecurityContext(string, string2);
        iJSpace.setSecurityContext(securityContext);
        System.out.println("OK.");
    }

    public void login(IJSpace iJSpace, String string, String string2) throws SecurityException, Exception {
        SecurityContext securityContext = new SecurityContext(string, string2);
        iJSpace.setSecurityContext(securityContext);
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n\n");
        stringBuffer.append("Usage: space copy [source-space-url]");
        stringBuffer.append(" [destination-space-url] [options]\n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help  (help)     This help\n");
        stringBuffer.append("\t-login  (login)    Enter user name and password for secure space in run-time mode\n");
        stringBuffer.append("\t-u1 (user1)    Set user name for source secure space\n");
        stringBuffer.append("\t-p1 (pass1)    Set password for source secure space\n");
        stringBuffer.append("\t-u2 (user2)    Set user name for source destination space\n");
        stringBuffer.append("\t-p2 (pass2)    Set password for source destination secure space\n");
        stringBuffer.append("\nUsage example :\n");
        stringBuffer.append("\tspace copy [source-space-url]");
        stringBuffer.append(" [destination-space-url] -login\n");
        stringBuffer.append("Usage example :\n");
        stringBuffer.append("\tspace copy [source-space-url]");
        stringBuffer.append(" [destination-space-url] -u1 USER1 -p1 PASS1\n");
        stringBuffer.append("Usage example :\n");
        stringBuffer.append("\tspace copy [source-space-url]");
        stringBuffer.append(" [destination-space-url] -u1 USER1 -p1 PASS1 -u2 USER2 -p2 PASS2\n");
        stringBuffer.append("\n*****************************************************\n\n");
        return stringBuffer.toString();
    }
}

