/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.AbstractSpaceCommand;
import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.OptionHandler;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;

public class CleanSpace
extends AbstractSpaceCommand {
    private OptionHandler a;
    public static final String OPERATION_NAME = "clean";

    public CleanSpace() {
        String[] stringArray = new String[]{"h", "help", "url", "template", "c", "cluster"};
        this.a = new OptionHandler(Formatter.fromArray((String[])stringArray));
        this.operationName = OPERATION_NAME;
        this.searchedSpaceState = 1;
    }

    public String getUsage() {
        StringBuffer stringBuffer = this.getBasicUsage();
        stringBuffer.append("\t-template    class template\n");
        stringBuffer.append("\n*****************************************************\n");
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            ClusterPolicy clusterPolicy;
            Map map = this.a.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            if (!map.containsKey("url")) {
                IJSpace[] iJSpaceArray = this.getSelectedSpaceProxies(bufferedReader);
                this.a(iJSpaceArray, map);
                return "";
            }
            String string2 = (String)map.get("url");
            if (JSpaceUtilities.isEmpty(string2, true)) {
                CLIUtilities.printMissingValueMessage("url");
                return "";
            }
            Object object = null;
            try {
                object = this.find(string2);
            }
            catch (FinderException finderException) {
                return "";
            }
            if (object == null) {
                CLIUtilities.printWrongServiceURLMessage(string2);
                return "";
            }
            IJSpace iJSpace = null;
            if (object instanceof IJSpaceContainer) {
                SpaceURL spaceURL = SpaceURLParser.parseURL(string2);
                ServiceItem[] serviceItemArray = this.getContainerSpaces((IJSpaceContainer)object, spaceURL.getProtocol());
                IJSpace[] iJSpaceArray = this.getSelectedFromListSpaceProxies(serviceItemArray, bufferedReader);
                this.a(iJSpaceArray, map);
                return "";
            }
            if (object instanceof IJSpace) {
                iJSpace = (IJSpace)object;
            }
            if ((clusterPolicy = this.getClusterPolicy(iJSpace)) != null) {
                if (map.containsKey("c") || map.containsKey("cluster")) {
                    System.out.println("Attempting to receive cluster members...");
                    ExternalEntry externalEntry = null;
                    if (map.containsKey("template")) {
                        externalEntry = this.a((String)map.get("template"), iJSpace);
                    }
                    this.a(clusterPolicy, externalEntry);
                } else {
                    IJSpace[] iJSpaceArray = this.getAllClusterMembers(clusterPolicy, bufferedReader);
                    if (iJSpaceArray == null) {
                        return "No cluster members found.";
                    }
                    this.a(iJSpaceArray, map);
                }
            } else {
                String string3 = iJSpace.getName();
                System.out.println("Started to clean <" + string3 + "> space...");
                ExternalEntry externalEntry = null;
                if (map.containsKey("template")) {
                    externalEntry = this.a((String)map.get("template"), iJSpace);
                }
                this.a(iJSpace, externalEntry);
                System.out.println("The <" + string3 + "> space cleaned successfully.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ClusterPolicy clusterPolicy, Entry entry) throws RemoteException, FinderException, NoSuchNameException {
        Map map = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy);
        Set set = map.entrySet();
        int n2 = map.size();
        System.out.println("There are " + n2 + " cluster spaces to be cleaned.");
        int n3 = 0;
        String string = entry == null ? "Clean" : "Clear";
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry2 = iterator.next();
            IJSpace iJSpace = (IJSpace)entry2.getValue();
            String string2 = (String)entry2.getKey();
            try {
                System.out.print(" " + string + " of <" + string2 + "> cluster member (" + (n3 + 1) + " of " + n2 + ")... ");
                this.a(iJSpace, entry);
                System.out.println(" successful");
            }
            catch (Exception exception) {
                System.out.println(" fail");
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
            finally {
                ++n3;
            }
        }
    }

    private void a(IJSpace[] iJSpaceArray, Map map) throws RemoteException {
        if (iJSpaceArray != null) {
            int n2 = iJSpaceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ExternalEntry externalEntry = null;
                if (map.containsKey("template")) {
                    externalEntry = this.a((String)map.get("template"), iJSpaceArray[i2]);
                }
                String string = iJSpaceArray[i2].getName();
                System.out.print("Started to clean <" + string + "> space (" + (i2 + 1) + " of " + n2 + ")...");
                try {
                    this.a(iJSpaceArray[i2], (Entry)externalEntry);
                    System.out.println(" successful");
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(" fail");
                    _logger.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }
    }

    private void a(IJSpace iJSpace, Entry entry) throws Exception {
        if (entry != null) {
            iJSpace.clear(entry, null);
        } else {
            iJSpace.clean();
        }
    }

    private ExternalEntry a(String string, IJSpace iJSpace) throws RemoteException {
        ExternalEntry externalEntry = null;
        if (string != null && string.trim().length() > 0) {
            BasicTypeInfo basicTypeInfo = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getClassTypeInfo(string);
            String[] stringArray = basicTypeInfo.getFieldsNames();
            externalEntry = new ExternalEntry(string, new Object[stringArray.length]);
            externalEntry.m_FieldsNames = stringArray;
            externalEntry.m_FieldsTypes = basicTypeInfo.getFieldsTypes();
        }
        return externalEntry;
    }
}

