/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class MD5
extends MessageDigestSpi
implements Cloneable {
    private byte[] digestBits;
    private String algorithm;
    private int[] state;
    private long count;
    private byte[] buffer;
    private int[] transformBuffer;
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;
    private static final int MD5_LENGTH = 16;

    public MD5() {
        this.init();
    }

    private MD5(MD5 mD5) {
        this();
        this.state = (int[])mD5.state.clone();
        this.transformBuffer = (int[])mD5.transformBuffer.clone();
        this.buffer = (byte[])mD5.buffer.clone();
        this.digestBits = (byte[])mD5.digestBits.clone();
        this.count = mD5.count;
    }

    private int FF(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n3 & n4 | ~n3 & n5) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private int GG(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n3 & n5 | n4 & ~n5) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private int HH(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n3 ^ n4 ^ n5) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private int II(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n4 ^ (n3 | ~n5)) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    void transform(byte[] byArray, int n2) {
        int[] nArray = this.transformBuffer;
        int n3 = this.state[0];
        int n4 = this.state[1];
        int n5 = this.state[2];
        int n6 = this.state[3];
        int n7 = 0;
        while (n7 < 16) {
            nArray[n7] = byArray[n7 * 4 + n2] & 0xFF;
            int n8 = 1;
            while (n8 < 4) {
                int n9 = n7;
                nArray[n9] = nArray[n9] + ((byArray[n7 * 4 + n8 + n2] & 0xFF) << n8 * 8);
                ++n8;
            }
            ++n7;
        }
        n3 = this.FF(n3, n4, n5, n6, nArray[0], 7, -680876936);
        n6 = this.FF(n6, n3, n4, n5, nArray[1], 12, -389564586);
        n5 = this.FF(n5, n6, n3, n4, nArray[2], 17, 606105819);
        n4 = this.FF(n4, n5, n6, n3, nArray[3], 22, -1044525330);
        n3 = this.FF(n3, n4, n5, n6, nArray[4], 7, -176418897);
        n6 = this.FF(n6, n3, n4, n5, nArray[5], 12, 1200080426);
        n5 = this.FF(n5, n6, n3, n4, nArray[6], 17, -1473231341);
        n4 = this.FF(n4, n5, n6, n3, nArray[7], 22, -45705983);
        n3 = this.FF(n3, n4, n5, n6, nArray[8], 7, 1770035416);
        n6 = this.FF(n6, n3, n4, n5, nArray[9], 12, -1958414417);
        n5 = this.FF(n5, n6, n3, n4, nArray[10], 17, -42063);
        n4 = this.FF(n4, n5, n6, n3, nArray[11], 22, -1990404162);
        n3 = this.FF(n3, n4, n5, n6, nArray[12], 7, 1804603682);
        n6 = this.FF(n6, n3, n4, n5, nArray[13], 12, -40341101);
        n5 = this.FF(n5, n6, n3, n4, nArray[14], 17, -1502002290);
        n4 = this.FF(n4, n5, n6, n3, nArray[15], 22, 1236535329);
        n3 = this.GG(n3, n4, n5, n6, nArray[1], 5, -165796510);
        n6 = this.GG(n6, n3, n4, n5, nArray[6], 9, -1069501632);
        n5 = this.GG(n5, n6, n3, n4, nArray[11], 14, 643717713);
        n4 = this.GG(n4, n5, n6, n3, nArray[0], 20, -373897302);
        n3 = this.GG(n3, n4, n5, n6, nArray[5], 5, -701558691);
        n6 = this.GG(n6, n3, n4, n5, nArray[10], 9, 38016083);
        n5 = this.GG(n5, n6, n3, n4, nArray[15], 14, -660478335);
        n4 = this.GG(n4, n5, n6, n3, nArray[4], 20, -405537848);
        n3 = this.GG(n3, n4, n5, n6, nArray[9], 5, 568446438);
        n6 = this.GG(n6, n3, n4, n5, nArray[14], 9, -1019803690);
        n5 = this.GG(n5, n6, n3, n4, nArray[3], 14, -187363961);
        n4 = this.GG(n4, n5, n6, n3, nArray[8], 20, 1163531501);
        n3 = this.GG(n3, n4, n5, n6, nArray[13], 5, -1444681467);
        n6 = this.GG(n6, n3, n4, n5, nArray[2], 9, -51403784);
        n5 = this.GG(n5, n6, n3, n4, nArray[7], 14, 1735328473);
        n4 = this.GG(n4, n5, n6, n3, nArray[12], 20, -1926607734);
        n3 = this.HH(n3, n4, n5, n6, nArray[5], 4, -378558);
        n6 = this.HH(n6, n3, n4, n5, nArray[8], 11, -2022574463);
        n5 = this.HH(n5, n6, n3, n4, nArray[11], 16, 1839030562);
        n4 = this.HH(n4, n5, n6, n3, nArray[14], 23, -35309556);
        n3 = this.HH(n3, n4, n5, n6, nArray[1], 4, -1530992060);
        n6 = this.HH(n6, n3, n4, n5, nArray[4], 11, 1272893353);
        n5 = this.HH(n5, n6, n3, n4, nArray[7], 16, -155497632);
        n4 = this.HH(n4, n5, n6, n3, nArray[10], 23, -1094730640);
        n3 = this.HH(n3, n4, n5, n6, nArray[13], 4, 681279174);
        n6 = this.HH(n6, n3, n4, n5, nArray[0], 11, -358537222);
        n5 = this.HH(n5, n6, n3, n4, nArray[3], 16, -722521979);
        n4 = this.HH(n4, n5, n6, n3, nArray[6], 23, 76029189);
        n3 = this.HH(n3, n4, n5, n6, nArray[9], 4, -640364487);
        n6 = this.HH(n6, n3, n4, n5, nArray[12], 11, -421815835);
        n5 = this.HH(n5, n6, n3, n4, nArray[15], 16, 530742520);
        n4 = this.HH(n4, n5, n6, n3, nArray[2], 23, -995338651);
        n3 = this.II(n3, n4, n5, n6, nArray[0], 6, -198630844);
        n6 = this.II(n6, n3, n4, n5, nArray[7], 10, 1126891415);
        n5 = this.II(n5, n6, n3, n4, nArray[14], 15, -1416354905);
        n4 = this.II(n4, n5, n6, n3, nArray[5], 21, -57434055);
        n3 = this.II(n3, n4, n5, n6, nArray[12], 6, 1700485571);
        n6 = this.II(n6, n3, n4, n5, nArray[3], 10, -1894986606);
        n5 = this.II(n5, n6, n3, n4, nArray[10], 15, -1051523);
        n4 = this.II(n4, n5, n6, n3, nArray[1], 21, -2054922799);
        n3 = this.II(n3, n4, n5, n6, nArray[8], 6, 1873313359);
        n6 = this.II(n6, n3, n4, n5, nArray[15], 10, -30611744);
        n5 = this.II(n5, n6, n3, n4, nArray[6], 15, -1560198380);
        n4 = this.II(n4, n5, n6, n3, nArray[13], 21, 1309151649);
        n3 = this.II(n3, n4, n5, n6, nArray[4], 6, -145523070);
        n6 = this.II(n6, n3, n4, n5, nArray[11], 10, -1120210379);
        n5 = this.II(n5, n6, n3, n4, nArray[2], 15, 718787259);
        n4 = this.II(n4, n5, n6, n3, nArray[9], 21, -343485551);
        this.state[0] = this.state[0] + n3;
        this.state[1] = this.state[1] + n4;
        this.state[2] = this.state[2] + n5;
        this.state[3] = this.state[3] + n6;
    }

    public void init() {
        this.state = new int[4];
        this.transformBuffer = new int[16];
        this.buffer = new byte[64];
        this.digestBits = new byte[16];
        this.count = 0L;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        int n2 = 0;
        while (n2 < this.digestBits.length) {
            this.digestBits[n2] = 0;
            ++n2;
        }
    }

    protected void engineReset() {
        this.init();
    }

    protected int engineGetDigestLength() {
        return 16;
    }

    protected synchronized void engineUpdate(byte by2) {
        int n2 = (int)(this.count >>> 3 & 0x3FL);
        this.count += 8L;
        this.buffer[n2] = by2;
        if (n2 >= 63) {
            this.transform(this.buffer, 0);
        }
    }

    protected synchronized void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n3 > 0) {
            int n5 = (int)(this.count >>> 3 & 0x3FL);
            if (n5 == 0 && n3 > 64) {
                this.count += 512L;
                this.transform(byArray, n4);
                n3 -= 64;
                n4 += 64;
                continue;
            }
            this.count += 8L;
            this.buffer[n5] = byArray[n4];
            if (n5 >= 63) {
                this.transform(this.buffer, 0);
            }
            ++n4;
            --n3;
        }
    }

    private void finish() {
        byte[] byArray = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray[n2] = (byte)(this.count >>> n2 * 8 & 0xFFL);
            ++n2;
        }
        int n3 = (int)(this.count >> 3) & 0x3F;
        int n4 = n3 < 56 ? 56 - n3 : 120 - n3;
        byte[] byArray2 = new byte[n4];
        byArray2[0] = -128;
        this.engineUpdate(byArray2, 0, byArray2.length);
        this.engineUpdate(byArray, 0, byArray.length);
        n2 = 0;
        while (n2 < 4) {
            int n5 = 0;
            while (n5 < 4) {
                this.digestBits[n2 * 4 + n5] = (byte)(this.state[n2] >>> n5 * 8 & 0xFF);
                ++n5;
            }
            ++n2;
        }
    }

    protected byte[] engineDigest() {
        this.finish();
        byte[] byArray = new byte[16];
        System.arraycopy(this.digestBits, 0, byArray, 0, 16);
        this.init();
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        this.finish();
        if (n3 < 16) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n2 < 16) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(this.digestBits, 0, byArray, n2, 16);
        this.init();
        return 16;
    }

    public Object clone() {
        MD5 mD5 = null;
        try {
            mD5 = (MD5)super.clone();
            mD5.state = (int[])this.state.clone();
            mD5.transformBuffer = (int[])this.transformBuffer.clone();
            mD5.buffer = (byte[])this.buffer.clone();
            mD5.digestBits = (byte[])this.digestBits.clone();
            mD5.count = this.count;
            return mD5;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return mD5;
        }
    }
}

