/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.isqlviewer.swing.JNumberEditor;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class ProxyPropertyPage
extends AbstractPropertyPage
implements ActionListener {
    private JCheckBox chkDisable = new JCheckBox();
    private JCheckBox chkEnable = new JCheckBox();
    private JTextField txtUsername = new JTextField();
    private JTextField txtPassword = new JPasswordField();
    private JTextField txtHost = new JTextField();
    private JTextField txtPort = new JNumberEditor(80);
    private ButtonGroup bg = new ButtonGroup();

    public ProxyPropertyPage() {
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "PropertiesProxy::initUI()");
        }
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("WebComponent16");
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("Proxy_Property_Page");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl2 = this.chkEnable.isSelected();
        this.txtHost.setEnabled(bl2);
        this.txtPort.setEnabled(bl2);
        this.txtPassword.setEnabled(bl2);
        this.txtUsername.setEnabled(bl2);
    }

    public void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkDisable.setText(BasicUtilities.getString("Proxy_Disable"));
        this.chkEnable.setText(BasicUtilities.getString("Proxy_Enable"));
        this.chkEnable.addActionListener(this);
        this.chkDisable.addActionListener(this);
        this.chkDisable.setToolTipText(BasicUtilities.getString("Proxy_Disable_Tip"));
        this.chkEnable.setToolTipText(BasicUtilities.getString("Proxy_Enable_Tip"));
        this.txtHost.setToolTipText(BasicUtilities.getString("Proxy_Host_Tip"));
        this.txtPort.setToolTipText(BasicUtilities.getString("Proxy_Port_Tip"));
        this.txtUsername.setToolTipText(BasicUtilities.getString("Proxy_User_Tip"));
        this.txtPassword.setToolTipText(BasicUtilities.getString("Proxy_Password_Tip"));
        this.setPropertyForComponent(this.txtHost, "advanced.httpproxy-host");
        this.setPropertyForComponent(this.txtPort, "advanced.httpproxy-port");
        this.setPropertyForComponent(this.txtUsername, "advanced.httpproxy-user");
        this.setPropertyForComponent(this.txtPassword, "advanced.httpproxy-pass");
        this.bg.add(this.chkDisable);
        this.bg.add(this.chkEnable);
        ProxyPropertyPage.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(0, 0, 1, 7, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 1, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkDisable, UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 2, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkEnable, UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 3, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Proxy_Host", null), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(2, 3, 2, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtHost, UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 4, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Proxy_Port", null), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(2, 4, 2, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtPort, UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 5, 3, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 5, 3, 1, 0.9, 0.0, 17, 2);
        this.add(ProxyPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 6, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Proxy_User", null), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(2, 6, 2, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtUsername, UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 7, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Proxy_Password", null), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(2, 7, 2, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtPassword, UI_CONSTRAINT);
        ProxyPropertyPage.constrain(1, 8, 3, 1, 0.0, 1.0, 10, 3);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        ProxyPropertyPage.constrain(4, 0, 1, 7, 1.0, 0.0, 10, 2);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }

    public void updatePage() {
        super.updatePage();
        boolean bl2 = Boolean.getBoolean("httpProxySet");
        if (bl2) {
            this.chkEnable.setSelected(true);
        } else {
            this.chkDisable.setSelected(true);
        }
        this.actionPerformed(null);
    }

    public void applyChanges() {
        super.applyChanges();
        if (this.chkDisable.isSelected()) {
            Properties properties = System.getProperties();
            properties.setProperty("httpProxySet", "false");
            properties.setProperty("http.proxyHost", "");
            properties.setProperty("http.proxyPort", "");
            properties.setProperty("http.proxyUser", "");
            properties.setProperty("http.proxyPassword", "");
            prefs.clear("advanced.httpproxy-host");
            prefs.clear("advanced.httpproxy-pass");
            prefs.clear("advanced.httpproxy-port");
            prefs.clear("advanced.httpproxy-user");
        }
    }
}

