/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.swing.print.DefaultPaperComponent;
import org.isqlviewer.swing.print.JImagePaper;
import org.isqlviewer.swing.print.JTablePaper;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.util.BasicUtilities;

public final class PrinterPreview
extends JDialog
implements ActionListener {
    private static SystemConfig config;
    private static final Hashtable PAPER_MAP;
    private JButton actionZoomIn = new JButton(BasicUtilities.loadToolbarIconResource("ZoomIn"));
    private JButton actionZoomOut = new JButton(BasicUtilities.loadToolbarIconResource("ZoomOut"));
    private JButton actionPrint = new JButton(BasicUtilities.loadToolbarIconResource("Print"));
    private JButton actionPageSetup = new JButton(BasicUtilities.loadToolbarIconResource("PageSetup"));
    private JButton actionHome = new JButton(BasicUtilities.loadToolbarIconResource("Home"));
    private JButton actionEditPrefs = new JButton(BasicUtilities.loadToolbarIconResource("Preferences"));
    private JButton actionPageUp = new JButton(BasicUtilities.loadIconResource("Up16"));
    private JButton actionPageDown = new JButton(BasicUtilities.loadIconResource("Down16"));
    private JButton actionRefresh = new JButton(BasicUtilities.loadToolbarIconResource("Refresh"));
    private JLabel StatusBar = new JLabel();
    private JScrollPane pageContainer = null;
    private UserKeyHandler inputHandler = new UserKeyHandler(null);
    private NumberFormat nf = NumberFormat.getPercentInstance();
    private DefaultPaperComponent ppane = new JTablePaper();
    private double currentScale = 1.0;
    private double zoomFactor = 0.1;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$javax$swing$table$TableModel;
    static /* synthetic */ Class class$java$lang$Object;

    private static DefaultPaperComponent getPaperforObject(Object object) {
        Class<?> clazz = object.getClass();
        if (!PAPER_MAP.containsKey(clazz)) {
            Iterator iterator = PAPER_MAP.keySet().iterator();
            while (iterator.hasNext()) {
                Class clazz2 = (Class)iterator.next();
                Class<?> clazz3 = class$java$lang$Object;
                if (clazz3 == null) {
                    clazz3 = new Object[0].getClass().getComponentType();
                }
                if (clazz2.equals(clazz3) || !clazz2.isInstance(object)) continue;
                return (DefaultPaperComponent)PAPER_MAP.get(clazz2);
            }
            Class<?> clazz4 = class$java$lang$Object;
            if (clazz4 == null) {
                clazz4 = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            return (DefaultPaperComponent)PAPER_MAP.get(clazz4);
        }
        return (DefaultPaperComponent)PAPER_MAP.get(clazz);
    }

    public PrinterPreview(Object object, Dialog dialog) {
        super(dialog, BasicUtilities.getString("Print_Preview_Title"), true);
        this.enableEvents(8L);
        this.nf.setMaximumFractionDigits(2);
        try {
            this.ppane = PrinterPreview.getPaperforObject(object);
            this.ppane.addPropertyChangeListener(new PaperPropertyListener());
            this.ppane.configure(config.getPreferences());
            this.ppane.setContent(object);
            this.ppane.setZoomLevel(1.0);
            this.initUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateTree();
    }

    public PrinterPreview(Object object, Frame frame) {
        super(frame, BasicUtilities.getString("Print_Preview_Title"), true);
        this.enableEvents(8L);
        this.nf.setMaximumFractionDigits(2);
        try {
            this.ppane = PrinterPreview.getPaperforObject(object);
            this.ppane.addPropertyChangeListener(new PaperPropertyListener());
            this.ppane.configure(config.getPreferences());
            this.ppane.setContent(object);
            this.ppane.setZoomLevel(1.0);
            this.initUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateTree();
    }

    public static final int print(Object object, String string) {
        DefaultPaperComponent defaultPaperComponent = PrinterPreview.getPaperforObject(object);
        SystemConfig systemConfig = SystemConfig.getInstance();
        defaultPaperComponent.setTitleString(string);
        defaultPaperComponent.setContent(object);
        defaultPaperComponent.configure(systemConfig.getPreferences());
        defaultPaperComponent.print();
        return 1;
    }

    public static final int showPrintPreviewDialog(Frame frame, Object object, String string) {
        PrinterPreview printerPreview = new PrinterPreview(object, frame);
        printerPreview.ppane.setTitleString(string);
        printerPreview.setDefaultCloseOperation(2);
        printerPreview.pack();
        printerPreview.setSize(new Dimension(640, 480));
        printerPreview.setLocationRelativeTo(frame);
        printerPreview.show();
        return 1;
    }

    public static final int showPrintPreviewDialog(Dialog dialog, Object object, String string) {
        PrinterPreview printerPreview = new PrinterPreview(object, dialog);
        printerPreview.ppane.setTitleString(string);
        printerPreview.setDefaultCloseOperation(2);
        printerPreview.pack();
        printerPreview.setSize(new Dimension(640, 480));
        printerPreview.setLocationRelativeTo(dialog);
        printerPreview.show();
        return 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (Integer.parseInt(actionEvent.getActionCommand())) {
            case 0: {
                this.currentScale += this.zoomFactor;
                if (this.currentScale >= 3.0) {
                    this.currentScale = 3.0;
                }
                this.ppane.setZoomLevel(this.currentScale);
                break;
            }
            case 1: {
                this.currentScale -= this.zoomFactor;
                if (this.currentScale <= 0.5) {
                    this.currentScale = 0.5;
                }
                this.ppane.setZoomLevel(this.currentScale);
                break;
            }
            case 2: {
                this.ppane.setZoomLevel(1.0);
                this.ppane.print();
                break;
            }
            case 3: {
                this.ppane.setPageNumber(this.ppane.getPage() - 1);
                break;
            }
            case 4: {
                this.ppane.setPageNumber(this.ppane.getPage() + 1);
                break;
            }
            case 5: {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                this.ppane.setPageFormat(printerJob.pageDialog(this.ppane.getPageFormat()));
                break;
            }
            case 6: {
                this.ppane.setPageNumber(0);
                break;
            }
            case 7: {
                PreferencesEditor.showDialog(this, 0);
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.ppane.configure(config.getPreferences());
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 8: {
                this.pageContainer.getViewport().remove(this.ppane);
                this.ppane.configure(config.getPreferences());
                this.pageContainer.setViewportView(this.ppane);
                this.pageContainer.getViewport().invalidate();
            }
        }
        this.StatusBar.setText(this.getStatusText());
    }

    private void initUI() throws Exception {
        ActionToolBar actionToolBar = ActionToolBar.createNullInstance();
        this.addKeyListener(this.inputHandler);
        actionToolBar.setOrientation(0);
        actionToolBar.setFloatable(false);
        ((Container)actionToolBar).add(this.actionPrint);
        ((Container)actionToolBar).add(this.actionPageSetup);
        ((Container)actionToolBar).add(this.actionEditPrefs);
        ((Container)actionToolBar).add(Box.createHorizontalStrut(32));
        ((Container)actionToolBar).add(this.actionHome);
        ((Container)actionToolBar).add(this.actionRefresh);
        ((Container)actionToolBar).add(Box.createHorizontalStrut(32));
        ((Container)actionToolBar).add(this.actionZoomIn);
        ((Container)actionToolBar).add(this.actionZoomOut);
        this.actionPrint.addActionListener(this);
        this.actionPageSetup.addActionListener(this);
        this.actionEditPrefs.addActionListener(this);
        this.actionZoomIn.addActionListener(this);
        this.actionZoomIn.setToolTipText(BasicUtilities.getString("Zoom_In_By", this.nf.format(this.zoomFactor)));
        this.actionZoomOut.addActionListener(this);
        this.actionZoomOut.setToolTipText(BasicUtilities.getString("Zoom_Out_By", this.nf.format(this.zoomFactor)));
        this.actionPageUp.addActionListener(this);
        this.actionPageUp.setToolTipText(BasicUtilities.getString("View_Prev"));
        this.actionPageDown.addActionListener(this);
        this.actionPageDown.setToolTipText(BasicUtilities.getString("View_Next"));
        this.actionRefresh.addActionListener(this);
        this.actionRefresh.setToolTipText(BasicUtilities.getString("Print_Refresh_Tip"));
        this.actionHome.addActionListener(this);
        this.actionHome.setActionCommand("6");
        this.actionPrint.setActionCommand("2");
        this.actionPageUp.setActionCommand("3");
        this.actionZoomIn.setActionCommand("0");
        this.actionZoomOut.setActionCommand("1");
        this.actionPageDown.setActionCommand("4");
        this.actionPageSetup.setActionCommand("5");
        this.actionEditPrefs.setActionCommand("7");
        this.actionRefresh.setActionCommand("8");
        this.pageContainer = new JScrollPane(this.ppane, 22, 32);
        this.pageContainer.setColumnHeaderView(Box.createVerticalStrut(16));
        this.pageContainer.setCorner("UPPER_RIGHT_CORNER", this.actionPageUp);
        this.pageContainer.setCorner("LOWER_RIGHT_CORNER", this.actionPageDown);
        this.actionPageDown.setBorderPainted(!BasicUtilities.isMac());
        this.actionPageUp.setBorderPainted(!BasicUtilities.isMac());
        WizardPanel wizardPanel = new WizardPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)actionToolBar, "North");
        jPanel.add((Component)this.pageContainer, "Center");
        jPanel.add((Component)this.StatusBar, "South");
        wizardPanel.add(jPanel);
        wizardPanel.showCard(jPanel);
        this.setContentPane(wizardPanel);
        this.StatusBar.setText(this.getStatusText());
        this.validateTree();
    }

    private String getStatusText() {
        return BasicUtilities.getString("Print_Preview_Status", new String[]{"" + (this.ppane.getPage() + 1), "" + this.ppane.getPageCount(), this.nf.format(this.ppane.getZoomLevel())});
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        switch (windowEvent.getID()) {
            case 205: {
                this.validateTree();
                break;
            }
        }
    }

    static {
        Class<?> clazz;
        Class<?> clazz2;
        config = SystemConfig.getInstance();
        PAPER_MAP = new Hashtable();
        Class<?> clazz3 = class$javax$swing$JTable;
        if (clazz3 == null) {
            clazz3 = class$javax$swing$JTable = new JTable[0].getClass().getComponentType();
        }
        PAPER_MAP.put(clazz3, new JTablePaper());
        Class<?> clazz4 = class$javax$swing$table$TableModel;
        if (clazz4 == null) {
            clazz4 = class$javax$swing$table$TableModel = new TableModel[0].getClass().getComponentType();
        }
        if ((clazz2 = class$javax$swing$JTable) == null) {
            clazz2 = class$javax$swing$JTable = new JTable[0].getClass().getComponentType();
        }
        PAPER_MAP.put(clazz4, PAPER_MAP.get(clazz2));
        Class<?> clazz5 = class$javax$swing$JLabel;
        if (clazz5 == null) {
            clazz5 = class$javax$swing$JLabel = new JLabel[0].getClass().getComponentType();
        }
        PAPER_MAP.put(clazz5, new JImagePaper());
        Class<?> clazz6 = class$javax$swing$ImageIcon;
        if (clazz6 == null) {
            clazz6 = class$javax$swing$ImageIcon = new ImageIcon[0].getClass().getComponentType();
        }
        if ((clazz = class$javax$swing$JLabel) == null) {
            clazz = class$javax$swing$JLabel = new JLabel[0].getClass().getComponentType();
        }
        PAPER_MAP.put(clazz6, PAPER_MAP.get(clazz));
    }

    public static class 1 {
    }

    private class UserKeyHandler
    extends KeyAdapter {
        private UserKeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if ((keyStroke.getModifiers() & BasicUtilities.CMD_MASK) == BasicUtilities.CMD_MASK) {
                switch (keyStroke.getKeyCode()) {
                    case 36: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "6"));
                        break;
                    }
                    case 61: 
                    case 107: 
                    case 521: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "0"));
                        break;
                    }
                    case 45: 
                    case 109: 
                    case 523: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "1"));
                        break;
                    }
                    case 34: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "4"));
                        break;
                    }
                    case 33: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "3"));
                    }
                }
            }
        }

        public /* synthetic */ UserKeyHandler(1 var2_2) {
            this();
        }
    }

    private class PaperPropertyListener
    implements PropertyChangeListener {
        private JLabel lbl = new JLabel(BasicUtilities.getString("Print_Format_Wait_Mesg"), BasicUtilities.loadIconResource("PrintPreview24"), 0);

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("init")) {
                boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                if (bl2) {
                    PrinterPreview.this.pageContainer.getViewport().add((Component)this.lbl, 0);
                } else {
                    PrinterPreview.this.pageContainer.getViewport().add((Component)PrinterPreview.this.ppane, 0);
                    PrinterPreview.this.StatusBar.setText(PrinterPreview.this.getStatusText());
                }
            }
        }
    }
}

