/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.util.BasicUtilities;

public abstract class JDBCUtilities {
    private static final String RESULT_RESERVED_CHARS = "srctfzwCST";
    static /* synthetic */ Class class$java$lang$UnsupportedOperationException;
    static /* synthetic */ Class class$java$sql$Types;
    static /* synthetic */ Class class$java$lang$AbstractMethodError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Collection getSingleColumn(ResultSet resultSet, int n2, ResultSetViewer resultSetViewer) {
        ArrayList<String> arrayList;
        block60: {
            if (resultSet == null) {
                return null;
            }
            boolean bl2 = false;
            try {
                int n3 = resultSet.getType();
                bl2 = n3 == 1004 || n3 == 1005;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl2) {
                try {
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException) {
                    if (resultSetViewer != null) {
                        resultSetViewer.handleSQLException(resultSet, sQLException);
                    } else {
                        JDBCUtilities.addWarning(resultSet, sQLException);
                    }
                    return new ArrayList();
                }
                catch (AbstractMethodError abstractMethodError) {
                    JDBCUtilities.addWarning(resultSet, abstractMethodError.getClass().getName(), "ResultSet:beforeFirst()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    JDBCUtilities.addWarning(resultSet, unsupportedOperationException.getClass().getName(), "ResultSet:beforeFirst()");
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "ResultSet:beforeFirst()");
                    return new ArrayList();
                }
            }
            arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                try {
                    String string = resultSet.getString(n2);
                    if (!arrayList.contains(string) || !resultSet.wasNull()) {
                        arrayList.add(string);
                    }
                }
                catch (SQLException sQLException) {
                    if (resultSetViewer != null) {
                        resultSetViewer.handleSQLException(resultSet, sQLException);
                    }
                    JDBCUtilities.addWarning(resultSet, sQLException);
                }
                if (resultSetViewer == null) continue;
                try {
                    resultSetViewer.recieveResultsetWarnings(resultSet, resultSet.getWarnings());
                }
                catch (Throwable throwable) {}
            }
            if (!bl2) break block60;
            try {
                resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                if (resultSetViewer != null) {
                    resultSetViewer.handleSQLException(resultSet, sQLException);
                    break block60;
                }
                JDBCUtilities.addWarning(resultSet, sQLException);
            }
            catch (AbstractMethodError abstractMethodError) {
                Class<?> clazz = class$java$lang$AbstractMethodError;
                if (clazz == null) {
                    clazz = class$java$lang$AbstractMethodError = new AbstractMethodError[0].getClass().getComponentType();
                }
                JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Class<?> clazz = class$java$lang$UnsupportedOperationException;
                if (clazz == null) {
                    clazz = class$java$lang$UnsupportedOperationException = new UnsupportedOperationException[0].getClass().getComponentType();
                }
                JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ResultSet:beforeFirst()");
            }
            break block60;
            catch (SQLException sQLException) {
                if (resultSetViewer != null) {
                    resultSetViewer.handleSQLException(resultSet, sQLException);
                } else {
                    JDBCUtilities.addWarning(resultSet, sQLException);
                }
                if (!bl2) break block60;
                try {
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException2) {
                    if (resultSetViewer != null) {
                        resultSetViewer.handleSQLException(resultSet, sQLException2);
                        break block60;
                    }
                    JDBCUtilities.addWarning(resultSet, sQLException2);
                }
                catch (AbstractMethodError abstractMethodError) {
                    Class<?> clazz = class$java$lang$AbstractMethodError;
                    if (clazz == null) {
                        clazz = class$java$lang$AbstractMethodError = new AbstractMethodError[0].getClass().getComponentType();
                    }
                    JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Class<?> clazz = class$java$lang$UnsupportedOperationException;
                    if (clazz == null) {
                        clazz = class$java$lang$UnsupportedOperationException = new UnsupportedOperationException[0].getClass().getComponentType();
                    }
                    JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "ResultSet:beforeFirst()");
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ResultSetUtilites::getSingleColumn(ResultSet,int)");
                if (!bl2) break block60;
                {
                    catch (Throwable throwable2) {
                        if (bl2) {
                            try {
                                resultSet.beforeFirst();
                            }
                            catch (SQLException sQLException2) {
                                if (resultSetViewer != null) {
                                    resultSetViewer.handleSQLException(resultSet, sQLException2);
                                } else {
                                    JDBCUtilities.addWarning(resultSet, sQLException2);
                                }
                            }
                            catch (AbstractMethodError abstractMethodError) {
                                Class<?> clazz = class$java$lang$AbstractMethodError;
                                if (clazz == null) {
                                    clazz = class$java$lang$AbstractMethodError = new AbstractMethodError[0].getClass().getComponentType();
                                }
                                JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                Class<?> clazz = class$java$lang$UnsupportedOperationException;
                                if (clazz == null) {
                                    clazz = class$java$lang$UnsupportedOperationException = new UnsupportedOperationException[0].getClass().getComponentType();
                                }
                                JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
                            }
                            catch (Throwable throwable3) {
                                BasicUtilities.HandleException(throwable3, "ResultSet:beforeFirst()");
                            }
                        }
                        throw throwable2;
                    }
                }
                try {
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException3) {
                    if (resultSetViewer != null) {
                        resultSetViewer.handleSQLException(resultSet, sQLException3);
                        break block60;
                    }
                    JDBCUtilities.addWarning(resultSet, sQLException3);
                }
                catch (AbstractMethodError abstractMethodError) {
                    Class<?> clazz = class$java$lang$AbstractMethodError;
                    if (clazz == null) {
                        clazz = class$java$lang$AbstractMethodError = new AbstractMethodError[0].getClass().getComponentType();
                    }
                    JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Class<?> clazz = class$java$lang$UnsupportedOperationException;
                    if (clazz == null) {
                        clazz = class$java$lang$UnsupportedOperationException = new UnsupportedOperationException[0].getClass().getComponentType();
                    }
                    JDBCUtilities.addWarning(resultSet, clazz.getName(), "ResultSet:beforeFirst()");
                }
                catch (Throwable throwable4) {
                    BasicUtilities.HandleException(throwable4, "ResultSet:beforeFirst()");
                }
            }
        }
        return arrayList;
    }

    public static Object[] getSingleColumn(ResultSet resultSet, String string, ResultSetViewer resultSetViewer) {
        if (resultSet == null) {
            return null;
        }
        try {
            int n2 = resultSet.findColumn(string);
            return JDBCUtilities.getSingleColumn(resultSet, n2, resultSetViewer).toArray();
        }
        catch (SQLException sQLException) {
            if (resultSetViewer != null) {
                resultSetViewer.handleSQLException(resultSet, sQLException);
            } else {
                JDBCUtilities.addWarning(resultSet, sQLException);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "JDBCUtilities::getSingleColumn(ResultSet, String, ResultSetViewer");
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getSingleRow(ResultSet resultSet, int n2, ResultSetViewer resultSetViewer) {
        if (resultSet == null) {
            return null;
        }
        boolean bl2 = false;
        try {
            int n3 = resultSet.getType();
            bl2 = n3 != 1003;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl2) {
            try {
                resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                if (resultSetViewer != null) {
                    resultSetViewer.handleSQLException(resultSet, sQLException);
                } else {
                    JDBCUtilities.addWarning(resultSet, sQLException);
                }
                return new ArrayList();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                JDBCUtilities.addWarning(resultSet, unsupportedOperationException.getClass().getName(), "ResultSet:first()");
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ResultSet:first()");
                return new ArrayList();
            }
        } else {
            try {
                if (!resultSet.isBeforeFirst()) {
                    JDBCUtilities.addWarning(resultSet, "JDBCUtilities:getSingleRow(" + n2 + ")", "ResultSet:!isBeforefirst()");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            int n4 = 1;
            int n5 = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                if (n4++ != n2) continue;
                for (int i2 = 1; i2 <= n5; ++i2) {
                    arrayList.add(resultSet.getObject(i2));
                }
            }
        }
        catch (SQLException sQLException) {
            if (resultSetViewer != null) {
                resultSetViewer.handleSQLException(resultSet, sQLException);
            } else {
                JDBCUtilities.addWarning(resultSet, sQLException);
            }
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ResultSetUtilites::getSingleRow(ResultSet,int,ResultSetViewer)");
        }
        finally {
            if (bl2) {
                try {
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException) {
                    if (resultSetViewer != null) {
                        resultSetViewer.handleSQLException(resultSet, sQLException);
                    } else {
                        JDBCUtilities.addWarning(resultSet, sQLException);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    JDBCUtilities.addWarning(resultSet, unsupportedOperationException.getClass().getName(), "ResultSet:first()");
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "ResultSet:first()");
                }
            }
        }
        return arrayList;
    }

    public static void addWarning(ResultSet resultSet, String string, String string2) {
        try {
            string = string == null ? "" : string;
            string2 = string2 == null ? "" : string2;
            SQLWarning sQLWarning = resultSet.getWarnings();
            if (sQLWarning == null) {
                throw new SQLException(string, string2);
            }
            SQLWarning sQLWarning2 = new SQLWarning(string, "ISQLV-" + string2, 74615);
            sQLWarning.setNextWarning(sQLWarning2);
        }
        catch (SQLException sQLException) {
            BasicUtilities.HandleException(sQLException);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "JDBCUtilities::addWarning(" + string + ", " + string2 + ")");
        }
    }

    public static void addWarning(ResultSet resultSet, SQLException sQLException) {
        JDBCUtilities.addWarning(resultSet, sQLException.getMessage(), sQLException.getSQLState());
    }

    public static boolean isUpdatable(ResultSet resultSet) {
        try {
            int n2 = resultSet.getConcurrency();
            int n3 = resultSet.getType();
            boolean bl2 = n2 == 1008;
            boolean bl3 = n3 == 1004 || n3 == 1005;
            return bl2 && bl3;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isDateType(int n2) {
        switch (n2) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringType(int n2) {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanType(int n2) {
        switch (n2) {
            case -7: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumberType(int n2) {
        switch (n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static String getResultString(String string, ResultSet resultSet, DatabaseConnection databaseConnection, EnhancedTableModel enhancedTableModel) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = stringBuffer.toString();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = string2.lastIndexOf(37);
        if (n2 >= 0 && (resultSet != null || databaseConnection != null)) {
            while (n3 < n2) {
                n3 = string2.indexOf(37, n4);
                if ((n4 = n3 + 1) >= string2.length()) {
                    n4 = string2.length() - 1;
                }
                if (RESULT_RESERVED_CHARS.indexOf(string2.charAt(n4)) < 0) continue;
                try {
                    char c2 = '\u0000';
                    c2 = string2.charAt(n3 + 1);
                    String string3 = "";
                    switch (c2) {
                        case 'C': {
                            try {
                                string3 = resultSet.getMetaData().getCatalogName(1);
                            }
                            catch (Throwable throwable) {
                                string3 = "null";
                            }
                            break;
                        }
                        case 'T': {
                            try {
                                string3 = resultSet.getMetaData().getTableName(1);
                            }
                            catch (Throwable throwable) {
                                string3 = "null";
                            }
                            break;
                        }
                        case 'S': {
                            try {
                                string3 = resultSet.getMetaData().getSchemaName(1);
                            }
                            catch (Throwable throwable) {
                                string3 = "null";
                            }
                            break;
                        }
                        case 's': {
                            string3 = databaseConnection.getConnectionName();
                            break;
                        }
                        case 'r': {
                            if (enhancedTableModel != null) {
                                string3 = Integer.toString(enhancedTableModel.getTrueRowCount());
                                break;
                            }
                            string3 = "-1";
                            break;
                        }
                        case 'c': {
                            if (enhancedTableModel != null) {
                                string3 = Integer.toString(enhancedTableModel.getColumnCount());
                                break;
                            }
                            string3 = "-1";
                            break;
                        }
                        case 't': {
                            try {
                                string3 = Integer.toString(resultSet.getType());
                            }
                            catch (Throwable throwable) {
                                string3 = Integer.toString(-1);
                            }
                            break;
                        }
                        case 'f': {
                            try {
                                string3 = Integer.toString(resultSet.getFetchDirection());
                            }
                            catch (Throwable throwable) {
                                string3 = Integer.toString(1002);
                            }
                            break;
                        }
                        case 'x': {
                            try {
                                string3 = resultSet.getCursorName();
                            }
                            catch (Throwable throwable) {
                                string3 = "null";
                            }
                        }
                        case 'z': {
                            try {
                                string3 = Integer.toString(resultSet.getFetchSize());
                            }
                            catch (Throwable throwable) {
                                string3 = Integer.toString(-1);
                            }
                            break;
                        }
                    }
                    if (n4 + 1 >= stringBuffer.length()) {
                        n4 = stringBuffer.length() - 1;
                    }
                    if (string3 == null) {
                        stringBuffer.replace(n3, n4 + 1, "");
                    } else {
                        stringBuffer.replace(n3, n4 + 1, string3);
                    }
                    string2 = stringBuffer.toString();
                    n2 = string2.lastIndexOf(37);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        stringBuffer.replace(n3, n4, "");
                        string2 = stringBuffer.toString();
                        n2 = string2.lastIndexOf(37);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return stringBuffer.toString().trim();
    }

    public static Object convertValue(Object object, int n2, Format format) throws ParseException {
        if (object == null && n2 != 0) {
            throw new IllegalArgumentException("null (" + JDBCUtilities.getTypeforValue(n2) + ")");
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: 
            case 12: {
                return object.toString();
            }
            case -6: {
                if (object instanceof Number) {
                    if (object instanceof Byte) {
                        return object;
                    }
                    Number number = (Number)object;
                    return new Byte(number.byteValue());
                }
                String string = object.toString().trim();
                if (string.length() == 0) {
                    string = "0";
                }
                try {
                    byte by2 = Byte.parseByte(string);
                    return new Byte(by2);
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString());
                    }
                    Number number = (Number)format.parseObject(object.toString());
                    return new Byte(number.byteValue());
                }
            }
            case 5: {
                if (object instanceof Number) {
                    if (object instanceof Short) {
                        return object;
                    }
                    Number number = (Number)object;
                    return new Short(number.shortValue());
                }
                String string = object.toString().trim();
                if (string.length() == 0) {
                    string = "0";
                }
                try {
                    short s2 = Short.parseShort(string);
                    return new Short(s2);
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString());
                    }
                    Number number = (Number)format.parseObject(object.toString());
                    return new Short(number.shortValue());
                }
            }
            case 4: {
                if (object instanceof Number) {
                    if (object instanceof Integer) {
                        return object;
                    }
                    Number number = (Number)object;
                    return new Integer(number.intValue());
                }
                String string = object.toString().trim();
                if (string.length() == 0) {
                    string = "0";
                }
                try {
                    int n3 = Integer.parseInt(string);
                    return new Integer(n3);
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString().trim());
                    }
                    Number number = (Number)format.parseObject(object.toString());
                    return new Integer(number.intValue());
                }
            }
            case -5: {
                if (object instanceof Number) {
                    if (object instanceof Long) {
                        return object;
                    }
                    Number number = (Number)object;
                    return new Long(number.longValue());
                }
                String string = object.toString().trim();
                if (string.length() == 0) {
                    string = "0";
                }
                try {
                    long l2 = Long.parseLong(string);
                    return new Long(l2);
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString());
                    }
                    Number number = (Number)format.parseObject(object.toString());
                    return new Long(number.longValue());
                }
            }
            case 6: 
            case 8: {
                if (object instanceof Number) {
                    if (object instanceof Double) {
                        return object;
                    }
                    Number number = (Number)object;
                    return new Double(number.doubleValue());
                }
                String string = object.toString().trim();
                if (string.length() == 0) {
                    string = "0";
                }
                try {
                    double d2 = Double.parseDouble(string);
                    return new Double(d2);
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString());
                    }
                    Number number = (Number)format.parseObject(object.toString());
                    return new Double(number.doubleValue());
                }
            }
            case 2: 
            case 3: {
                if (object instanceof Number) {
                    if (object instanceof BigDecimal) {
                        return object;
                    }
                    Number number = (Number)object;
                    return new BigDecimal(number.doubleValue());
                }
                String string = object.toString().trim();
                if (string.length() == 0) {
                    string = "0";
                }
                try {
                    return new BigDecimal(string);
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString());
                    }
                    Number number = (Number)format.parseObject(object.toString());
                    return new BigDecimal(number.doubleValue());
                }
            }
            case -7: 
            case 16: {
                if (object instanceof Boolean) {
                    return object;
                }
                try {
                    return Boolean.valueOf(object.toString());
                }
                catch (Throwable throwable) {
                    if (format == null) {
                        throw new IllegalArgumentException(object.toString());
                    }
                    return (Boolean)format.parseObject(object.toString());
                }
            }
            case -4: 
            case -3: 
            case 2004: {
                if (object instanceof byte[]) {
                    return new ByteArrayBlob((byte[])object);
                }
                if (object instanceof Blob) {
                    byte[] byArray = null;
                    try {
                        Blob blob = (Blob)object;
                        byArray = blob.getBytes(0L, (int)blob.length());
                    }
                    catch (SQLException sQLException) {
                        byArray = object.toString().getBytes();
                    }
                    return new ByteArrayBlob(byArray);
                }
                if (object instanceof Clob) {
                    byte[] byArray = null;
                    try {
                        Clob clob = (Clob)object;
                        byArray = clob.getSubString(0L, (int)clob.length()).getBytes();
                    }
                    catch (SQLException sQLException) {
                        byArray = object.toString().getBytes();
                    }
                    return new ByteArrayBlob(byArray);
                }
                if (format == null) {
                    return object.toString().getBytes();
                }
                return (byte[])format.parseObject(object.toString());
            }
            case -1: 
            case 2005: {
                try {
                    if (object instanceof Clob) {
                        Clob clob = (Clob)object;
                        try {
                            return new ByteArrayClob(clob.getSubString(0L, (int)clob.length()));
                        }
                        catch (SQLException sQLException) {
                            throw new ParseException(sQLException.getMessage(), 0);
                        }
                    }
                    if (object instanceof char[]) {
                        return new ByteArrayClob((char[])object);
                    }
                    if (object instanceof String) {
                        return new ByteArrayClob(object.toString());
                    }
                    if (object instanceof Blob) {
                        String string = null;
                        try {
                            Blob blob = (Blob)object;
                            string = new String(blob.getBytes(0L, (int)blob.length()));
                        }
                        catch (SQLException sQLException) {
                            string = object.toString();
                        }
                        return new ByteArrayClob(string);
                    }
                    if (format == null) {
                        return new ByteArrayClob(object.toString());
                    }
                    return (Clob)format.parseObject(object.toString());
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 91: {
                if (object instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)object;
                    return new Date(date.getTime());
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    return new Date(number.longValue());
                }
                if (format == null) {
                    throw new IllegalArgumentException(object.toString());
                }
                java.util.Date date = (java.util.Date)format.parseObject(object.toString());
                return new Date(date.getTime());
            }
            case 92: {
                if (object instanceof Time) {
                    return object;
                }
                if (object instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)object;
                    return new Time(date.getTime());
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    return new Time(number.longValue());
                }
                if (format == null) {
                    throw new IllegalArgumentException(object.toString());
                }
                java.util.Date date = (java.util.Date)format.parseObject(object.toString());
                return new Time(date.getTime());
            }
            case 93: {
                if (object instanceof Time) {
                    return object;
                }
                if (object instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)object;
                    return new Timestamp(date.getTime());
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    return new Timestamp(number.longValue());
                }
                if (format == null) {
                    throw new IllegalArgumentException(object.toString());
                }
                java.util.Date date = (java.util.Date)format.parseObject(object.toString());
                return new Timestamp(date.getTime());
            }
        }
        return object;
    }

    public static int getTypeforName(String string) {
        try {
            Class<?> clazz = class$java$sql$Types;
            if (clazz == null) {
                clazz = class$java$sql$Types = new Types[0].getClass().getComponentType();
            }
            Class<?> clazz2 = clazz;
            return clazz2.getField(string.toUpperCase()).getInt(null);
        }
        catch (Exception exception) {
            return 12;
        }
    }

    public static String getTypeforValue(int n2) {
        try {
            Class<?> clazz = class$java$sql$Types;
            if (clazz == null) {
                clazz = class$java$sql$Types = new Types[0].getClass().getComponentType();
            }
            Class<?> clazz2 = clazz;
            Field[] fieldArray = clazz2.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                Field field = fieldArray[i2];
                if (field.getInt(null) != n2) continue;
                return field.getName();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getSQLTypes(boolean bl2) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            Object[] objectArray2 = class$java$sql$Types;
            if (class$java$sql$Types == null) {
                objectArray2 = class$java$sql$Types = new Types[0].getClass().getComponentType();
            }
            objectArray = objectArray2;
            Field[] fieldArray = objectArray.getFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                try {
                    vector.add(fieldArray[i2].getName());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        objectArray = vector.toArray(new String[0]);
        if (bl2) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getNativeTypeMap(DatabaseMetaData databaseMetaData) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTypeInfo();
            while (resultSet.next()) {
                String string = resultSet.getString("TYPE_NAME");
                Integer n2 = new Integer(resultSet.getInt("DATA_TYPE"));
                hashMap.put(string, n2);
            }
        }
        catch (Throwable throwable) {
            hashMap.clear();
            BasicUtilities.HandleException(throwable);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
        return hashMap;
    }

    public static String generatePreparedInsertRequest(String string, String[] stringArray) {
        if (stringArray.length >= 1 && string != null) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(string);
            stringBuffer.append(" (");
            for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            stringBuffer.append(") VALUES (");
            for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                stringBuffer.append("?, ");
            }
            stringBuffer.append("?)");
            return stringBuffer.toString();
        }
        return null;
    }

    public static String generatePreparedUpdateRequest(String string, String[] stringArray, String string2) {
        try {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(string);
            stringBuffer.append(" SET (");
            for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                stringBuffer.append(stringArray[i2]);
                stringBuffer.append("=?, ");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            stringBuffer.append("=?)");
            if (string2 != null && string2.trim().length() >= 1) {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            return null;
        }
    }

    public static void configurePreparedStatement(PreparedStatement preparedStatement, Object[] objectArray, int[] nArray, boolean bl2) throws SQLException {
        if (objectArray == null || nArray == null) {
            throw new NullPointerException();
        }
        if (objectArray.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            JDBCUtilities.configurePreparedStatement(preparedStatement, i2 + 1, objectArray[i2], nArray[i2], bl2);
        }
    }

    public static void configurePreparedStatement(PreparedStatement preparedStatement, int n2, Object object, int n3, boolean bl2) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n2, n3);
            return;
        }
        if (bl2) {
            try {
                JDBCUtilities.convertValue(object, n3, null);
            }
            catch (ParseException parseException) {
                throw new SQLException(parseException.getMessage());
            }
        }
        switch (n3) {
            case 1: 
            case 12: {
                preparedStatement.setString(n2, (String)object);
                break;
            }
            case -6: {
                preparedStatement.setByte(n2, ((Number)object).byteValue());
                break;
            }
            case 5: {
                preparedStatement.setShort(n2, ((Number)object).shortValue());
                break;
            }
            case 4: {
                preparedStatement.setInt(n2, ((Number)object).intValue());
                break;
            }
            case 7: {
                preparedStatement.setFloat(n2, ((Number)object).floatValue());
                break;
            }
            case -5: {
                preparedStatement.setLong(n2, ((Number)object).longValue());
                break;
            }
            case 6: 
            case 8: {
                preparedStatement.setDouble(n2, ((Number)object).doubleValue());
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(n2, (BigDecimal)object);
                break;
            }
            case -7: 
            case 16: {
                preparedStatement.setBoolean(n2, (Boolean)object);
                break;
            }
            case 2004: {
                preparedStatement.setBlob(n2, (Blob)object);
                break;
            }
            case 2005: {
                preparedStatement.setClob(n2, (Clob)object);
                break;
            }
            case 91: {
                preparedStatement.setDate(n2, (Date)object);
                break;
            }
            case 92: {
                preparedStatement.setTime(n2, (Time)object);
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(n2, (Timestamp)object);
                break;
            }
            case -4: 
            case -3: {
                ByteArrayBlob byteArrayBlob = (ByteArrayBlob)object;
                preparedStatement.setBinaryStream(n2, byteArrayBlob.getBinaryStream(), (int)byteArrayBlob.length());
                break;
            }
            case -1: {
                ByteArrayClob byteArrayClob = (ByteArrayClob)object;
                preparedStatement.setCharacterStream(n2, byteArrayClob.getCharacterStream(), (int)byteArrayClob.length());
                break;
            }
            default: {
                preparedStatement.setObject(n2, object);
            }
        }
    }

    public static Object getValueForType(ResultSet resultSet, int n2, int n3) throws SQLException {
        Object object = null;
        try {
            switch (n2) {
                case 91: {
                    object = resultSet.getDate(n3);
                    break;
                }
                case -6: {
                    object = new Byte(resultSet.getByte(n3));
                    break;
                }
                case 5: {
                    object = new Short(resultSet.getShort(n3));
                    break;
                }
                case 93: {
                    object = resultSet.getTimestamp(n3);
                    break;
                }
                case 92: {
                    object = resultSet.getTime(n3);
                    break;
                }
                case 4: {
                    object = new Integer(resultSet.getInt(n3));
                    break;
                }
                case 2: 
                case 3: {
                    object = resultSet.getBigDecimal(n3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    object = new Double(resultSet.getDouble(n3));
                    break;
                }
                case -5: {
                    object = new Long(resultSet.getLong(n3));
                    break;
                }
                case -7: 
                case 16: {
                    object = new Boolean(resultSet.getBoolean(n3));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = new ByteArrayBlob(resultSet.getBytes(n3));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object = resultSet.getString(n3);
                    break;
                }
                case 2004: {
                    object = resultSet.getBlob(n3);
                    break;
                }
                case 2005: {
                    object = resultSet.getClob(n3);
                    break;
                }
                case 2006: {
                    object = resultSet.getRef(n3);
                    break;
                }
                case 2003: {
                    object = resultSet.getArray(n3);
                }
                case 2001: {
                    object = resultSet.getObject(n3);
                    break;
                }
                default: {
                    object = resultSet.getObject(n3);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            String[] stringArray = new String[]{Integer.toString(n3), JDBCUtilities.getTypeforValue(n2), sQLException.getMessage()};
            String string = BasicUtilities.getString("Resultset_Pull_Error", stringArray);
            System.err.println(string);
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        try {
            if (resultSet.wasNull()) {
                object = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object;
    }
}

