/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.UnsupportedEncodingException;
import javax.swing.table.AbstractTableModel;
import org.isqlviewer.util.BasicUtilities;

public class HexViewTableModel
extends AbstractTableModel {
    public StringBuffer s = new StringBuffer("");
    public Integer[][] data;
    public String[] rowString;
    public String byterefs;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public static byte[] getLongBytes(Long l2) {
        long l3 = l2;
        byte[] byArray = new byte[]{(byte)(l3 >>> 56), (byte)(l3 >>> 48), (byte)(l3 >>> 40), (byte)(l3 >>> 32), (byte)(l3 >>> 24), (byte)(l3 >>> 16), (byte)(l3 >>> 8), (byte)(l3 >>> 0)};
        return byArray;
    }

    public static byte[] getShortBytes(Short s2) {
        short s3 = s2;
        byte[] byArray = new byte[]{(byte)(s3 >>> 8), (byte)(s3 >>> 0)};
        return byArray;
    }

    public static byte[] getBooleanBytes(Boolean bl2) {
        return new byte[]{bl2 != false ? (byte)1 : 0};
    }

    public static byte[] getDoubleBytes(Double d2) {
        return HexViewTableModel.getLongBytes(new Long(Double.doubleToRawLongBits(d2)));
    }

    public static byte[] getFloatBytes(Float f2) {
        return HexViewTableModel.getIntBytes(new Integer(Float.floatToIntBits(f2.floatValue())));
    }

    public static byte[] getIntBytes(Integer n2) {
        int n3 = n2;
        byte[] byArray = new byte[]{(byte)(n3 >>> 24), (byte)(n3 >>> 16), (byte)(n3 >>> 8), (byte)(n3 >>> 0)};
        return byArray;
    }

    public HexViewTableModel(String string) {
        this(string.getBytes());
    }

    public void setData(String string) {
        this.setData(string, null);
    }

    public void setData(String string, String string2) {
        if (string2 != null) {
            try {
                this.setData(string.getBytes(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BasicUtilities.HandleException(unsupportedEncodingException);
            }
        } else {
            this.setData(string.getBytes());
        }
    }

    public void clear() {
        this.setData("");
    }

    public void setData(byte[] byArray) {
        if (byArray.length == 0) {
            this.data = new Integer[0][0];
            this.byterefs = new String("");
            this.rowString = new String[0];
            return;
        }
        this.data = new Integer[byArray.length / 16 + 1][16];
        this.byterefs = new String(byArray);
        this.rowString = new String[this.getRowCount()];
        try {
            int n2 = this.getRowCount() == 1 ? byArray.length : 16;
            for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                this.s.setLength(0);
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n3;
                    if (i2 == 0) {
                        n3 = byArray[(i2 == 0 ? 0 : i2 + 1) * i3 + i3];
                    } else {
                        try {
                            n3 = byArray[i2 * 16 + i3];
                        }
                        catch (Exception exception) {
                            n3 = 0;
                        }
                    }
                    if (n3 < 32 || n3 > 127) {
                        this.s.append('.');
                    } else {
                        this.s.append((char)n3);
                    }
                    this.s.append(' ');
                    this.data[i2][i3] = new Integer(n3 & 0xFF);
                }
                this.rowString[i2] = this.s.toString().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableDataChanged();
    }

    public HexViewTableModel(byte[] byArray) {
        this.setData(byArray);
    }

    public int getColumnCount() {
        return 19;
    }

    public String toString() {
        return this.byterefs;
    }

    public Object getValueAt(int n2, int n3) {
        if (n3 == 18) {
            return this.rowString[n2];
        }
        if (n3 == 0) {
            this.s.setLength(0);
            this.s.replace(0, 7, "00000000");
            String string = Integer.toHexString(n2 * 16);
            this.s.replace(this.s.length() - 1 - string.length(), 8, string);
            return this.s.toString().toUpperCase();
        }
        if (n3 == 9) {
            return "-";
        }
        if (--n3 > 8) {
            --n3;
        }
        return this.data[n2][n3];
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int n2) {
        if (n2 == 18) {
            return "Data";
        }
        if (n2 == 0) {
            return "Offset";
        }
        if (n2 == 9) {
            return " - ";
        }
        if (--n2 > 8) {
            --n2;
        }
        return "" + n2;
    }

    public Class getColumnClass(int n2) {
        if (n2 == 9 || n2 == 18 || n2 == 0) {
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            return clazz;
        }
        Class<?> clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        return clazz;
    }

    public void setValueAt(Object object, int n2, int n3) {
    }
}

