/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.RowComparator;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.Sortable;
import org.isqlviewer.util.UserPreferences;

public class EnhancedTableModel
implements Cloneable,
Sortable,
TableModel,
Transferable {
    public static final DataFlavor FLAVOR_OBJECT;
    public static final DataFlavor FLAVOR_TAB_STRINGS;
    public ArrayList dataStore = new ArrayList();
    public ArrayList columns = new ArrayList();
    public transient ArrayList listeners = null;
    public int pageSize = 4096;
    public int pageOffset = 0;
    public HashMap classMappings = new HashMap();
    private ArrayList filteredRows = new ArrayList();
    private String lastFilterPattern = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$isqlviewer$core$model$EnhancedTableModel;
    static /* synthetic */ Class class$java$lang$Object;

    public EnhancedTableModel() {
        this(null);
    }

    public EnhancedTableModel(String[] stringArray) {
        this.setColumns(stringArray);
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        this.setPageSize(userPreferences.getInt("general.tablepage-size"));
    }

    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (FLAVOR_OBJECT.equals(dataFlavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor) || FLAVOR_TAB_STRINGS.equals(dataFlavor)) {
            return this.toString();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{FLAVOR_OBJECT, FLAVOR_TAB_STRINGS, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return FLAVOR_OBJECT.equals(dataFlavor) || FLAVOR_TAB_STRINGS.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n2, int n3) {
        int n4 = this.translateRow(n2);
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.dataStore.get(n4);
            arrayList2.set(n3, object);
        }
        this.fireTableCellUpdated(n2, n3);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        int n2;
        int n3 = n2 = this.filteredRows.isEmpty() ? this.dataStore.size() : this.filteredRows.size();
        if (n2 <= this.getPageSize()) {
            return n2;
        }
        if (this.getPageOffset() == this.getPageCount() - 1) {
            return n2 - this.getPageOffset() * this.getPageSize();
        }
        return this.getPageSize();
    }

    public Object getValueAt(int n2, int n3) {
        try {
            ArrayList arrayList = this.getRow(n2);
            return arrayList.get(n3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTableModelListener(TableModelListener tableModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(tableModelListener)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(tableModelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModelListener(TableModelListener tableModelListener) {
        if (this.listeners != null && this.listeners.contains(tableModelListener)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(tableModelListener);
            }
        }
    }

    public String getColumnName(int n2) {
        try {
            return (String)this.columns.get(n2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Class getColumnClass(int n2) {
        if (this.classMappings.containsKey(Integer.toString(n2))) {
            return (Class)this.classMappings.get(Integer.toString(n2));
        }
        try {
            ArrayList arrayList = (ArrayList)this.dataStore.get(0);
            Class<?> clazz = arrayList.get(n2).getClass();
            return clazz;
        }
        catch (Throwable throwable) {
            Class<?> clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            return clazz;
        }
    }

    public int getIndexOfColumnName(String string) {
        try {
            return this.columns.indexOf(string);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(int n2, boolean bl2) {
        if (n2 >= 0 && n2 < this.getColumnCount()) {
            try {
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    ArrayList[] arrayListArray = this.dataStore.toArray(new ArrayList[0]);
                    this.clearData();
                    ArrayList arrayList2 = this.dataStore;
                    synchronized (arrayList2) {
                        Arrays.sort(arrayListArray, new RowComparator(n2, bl2));
                        this.dataStore.addAll(Arrays.asList(arrayListArray));
                    }
                }
                this.applyFilter(this.lastFilterPattern);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "EnhancedTableModel::sort(" + n2 + " , " + bl2 + ")");
            }
            finally {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }
    }

    public boolean canSort(int n2, boolean bl2) {
        return n2 >= 0 && n2 < this.columns.size() && this.dataStore.size() >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        EnhancedTableModel enhancedTableModel = new EnhancedTableModel(this.getColumns());
        enhancedTableModel.dataStore = new ArrayList();
        if (this.filteredRows.isEmpty()) {
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                Iterator iterator = this.dataStore.iterator();
                while (iterator.hasNext()) {
                    ArrayList arrayList2 = (ArrayList)iterator.next();
                    enhancedTableModel.dataStore.add(arrayList2.clone());
                }
            }
        }
        ArrayList arrayList = this.filteredRows;
        synchronized (arrayList) {
            Iterator iterator = this.filteredRows.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                ArrayList arrayList3 = this.dataStore;
                synchronized (arrayList3) {
                    ArrayList arrayList4 = (ArrayList)this.dataStore.get(n2);
                    enhancedTableModel.dataStore.add(arrayList4.clone());
                }
            }
        }
        enhancedTableModel.classMappings = (HashMap)this.classMappings.clone();
        enhancedTableModel.pageOffset = this.pageOffset;
        enhancedTableModel.pageSize = this.pageSize;
        return enhancedTableModel;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = 0; i3 < this.getColumnCount(); ++i3) {
                stringBuffer2.append(this.getValueAt(i2, i3));
                stringBuffer2.append("\t");
            }
            if (stringBuffer2.toString().trim().length() >= 1) {
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(System.getProperty("line.seperator", "\n"));
            }
            stringBuffer2.setLength(0);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassforColumn(int n2, Class clazz) {
        HashMap hashMap = this.classMappings;
        synchronized (hashMap) {
            this.classMappings.put(Integer.toString(n2), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int n2) {
        try {
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                this.dataStore.remove(this.translateRow(n2));
            }
            this.fireTableRowsDeleted(n2, n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean pageUp() {
        if (this.pageOffset > 0) {
            --this.pageOffset;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean pageDown() {
        if (this.pageOffset < this.getPageCount() - 1) {
            ++this.pageOffset;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        double d2 = this.getTrueRowCount();
        double d3 = this.getPageSize();
        return (int)Math.ceil(d2 / d3);
    }

    public boolean setPageSize(int n2) {
        if (n2 >= 0 && n2 != this.pageSize) {
            if (n2 <= this.getTrueRowCount()) {
                n2 = this.getTrueRowCount();
            }
            int n3 = this.pageSize;
            this.pageSize = n2;
            if (this.pageSize < n3) {
                this.fireTableRowsDeleted(this.pageSize, n3 - 1);
            } else {
                this.fireTableRowsInserted(n3, this.pageSize - 1);
            }
            return true;
        }
        return false;
    }

    public int getTrueRowCount() {
        return this.dataStore.size();
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public EnhancedTableModel subModel(int[] nArray, int[] nArray2) {
        Serializable serializable;
        int n2;
        int n3;
        EnhancedTableModel enhancedTableModel = new EnhancedTableModel(new String[0]);
        String[] stringArray = new String[nArray2.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            serializable = this.getRow(n2);
            ArrayList arrayList = new ArrayList(nArray2.length);
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n4 = nArray2[i2];
                arrayList.add(((ArrayList)serializable).get(n4));
            }
            enhancedTableModel.addRow(arrayList);
        }
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            n2 = nArray2[n3];
            stringArray[n3] = this.getColumnName(n2);
            serializable = (Class)this.classMappings.get(new Integer(n2));
            if (serializable == null) continue;
            enhancedTableModel.setClassforColumn(n3, (Class)serializable);
        }
        enhancedTableModel.setColumns(stringArray);
        return enhancedTableModel;
    }

    public void clear() {
        this.clearData();
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this.clearAllData();
        this.fireTableStructureChanged();
    }

    public boolean isEmpty() {
        return this.dataStore.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        ArrayList arrayList2 = this.dataStore;
        synchronized (arrayList2) {
            this.dataStore.add(arrayList.clone());
        }
        this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowCount(int n2) {
        int n3 = this.getRowCount();
        if (n2 <= n3) {
            for (int i2 = n3; i2 > n2; ++i2) {
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    this.dataStore.remove(i2);
                    continue;
                }
            }
        }
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.ensureCapacity(n2);
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnCount(int n2) {
        Iterator iterator = this.dataStore.iterator();
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            int n3;
            ArrayList arrayList2 = this.columns;
            synchronized (arrayList2) {
                try {
                    if (this.columns.size() > n2) {
                        for (n3 = this.columns.size(); n3 > n2; --n3) {
                            this.columns.remove(n3);
                        }
                        this.columns.trimToSize();
                    } else {
                        for (n3 = this.columns.size(); n3 < n2; ++n3) {
                            this.columns.add(Integer.toString(n3));
                        }
                    }
                }
                catch (Throwable throwable) {
                    return;
                }
            }
            while (iterator.hasNext()) {
                try {
                    arrayList2 = (ArrayList)iterator.next();
                    if (arrayList2.size() > n2) {
                        for (n3 = this.columns.size(); n3 > n2; --n3) {
                            this.columns.remove(n3);
                        }
                        arrayList2.trimToSize();
                        continue;
                    }
                    Object object = new Object();
                    for (int i2 = arrayList2.size(); i2 < n2; ++i2) {
                        this.columns.add(object);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnName(int n2, String string) {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            try {
                this.columns.set(n2, string);
                this.fireTableStructureChanged();
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumns() {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            return this.columns.toArray(new String[0]);
        }
    }

    public Map getRowMap(int n2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            hashMap.put(this.getColumnName(i2), this.getValueAt(n2, i2));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(int n2) {
        Iterator iterator = this.dataStore.iterator();
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            try {
                this.columns.remove(n2);
            }
            catch (Throwable throwable) {
                return;
            }
            while (iterator.hasNext()) {
                try {
                    ArrayList arrayList2 = (ArrayList)iterator.next();
                    arrayList2.remove(n2);
                }
                catch (Throwable throwable) {}
            }
        }
        this.fireTableStructureChanged();
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, -1, 1));
    }

    public void fireTableRowsUpdated(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, -1, 0));
    }

    public void fireTableRowsDeleted(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, -1, -1));
    }

    public void fireTableCellUpdated(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n2, n3));
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TableModelListener tableModelListener = (TableModelListener)iterator.next();
                try {
                    tableModelListener.tableChanged(tableModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public int findColumn(String string) {
        if (string != null) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                if (!string.equals(this.getColumnName(i2))) continue;
                return i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int applyFilter(String string) {
        if (string != null && string.length() != 0) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(string, 66);
                this.filteredRows.clear();
                this.lastFilterPattern = string;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return -1;
            }
            block5: for (int i2 = 0; i2 < this.getTrueRowCount(); ++i2) {
                ArrayList arrayList = null;
                Object object = this.dataStore;
                synchronized (object) {
                    arrayList = (ArrayList)this.dataStore.get(i2);
                }
                object = arrayList.iterator();
                int n2 = 0;
                while (object.hasNext()) {
                    Object e2;
                    if (!this.canSearchColumn(n2++) || !this.doFilter(e2 = object.next(), pattern)) continue;
                    this.filteredRows.add(new Integer(i2));
                    this.fireTableDataChanged();
                    continue block5;
                }
            }
            if (this.filteredRows.isEmpty()) {
                this.fireTableDataChanged();
            }
            return this.filteredRows.size();
        }
        this.clearFilter();
        return -1;
    }

    public void clearFilter() {
        if (!this.filteredRows.isEmpty()) {
            this.filteredRows.clear();
            this.fireTableDataChanged();
        }
    }

    public int translateRow(int n2) {
        if (this.filteredRows.isEmpty()) {
            return n2 + this.pageOffset * this.pageSize;
        }
        return (Integer)this.filteredRows.get(n2);
    }

    public boolean doFilter(Object object, Pattern pattern) {
        if (object != null) {
            return pattern.matcher(object.toString()).find();
        }
        return false;
    }

    public boolean canSearchColumn(int n2) {
        return n2 >= 0 && n2 < this.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(String string, Collection collection) {
        Iterator iterator = this.dataStore.iterator();
        Iterator iterator2 = collection.iterator();
        Object object = new Object();
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            this.columns.add(string == null ? "" : string);
        }
        arrayList = this.dataStore;
        synchronized (arrayList) {
            while (iterator.hasNext()) {
                ArrayList arrayList2 = (ArrayList)iterator.next();
                if (iterator2.hasNext()) {
                    arrayList2.add(iterator2.next());
                    continue;
                }
                arrayList2.add(object);
            }
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllData() {
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.clear();
            ArrayList arrayList2 = this.columns;
            synchronized (arrayList2) {
                this.columns.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Collection collection) {
        int n2 = 0;
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.clear();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof ArrayList)) continue;
                ++n2;
                ArrayList arrayList2 = (ArrayList)e2;
                this.dataStore.add(arrayList2);
            }
        }
        this.fireTableRowsInserted(-1, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRow(int n2) {
        try {
            n2 = this.translateRow(n2);
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                return (ArrayList)this.dataStore.get(n2);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(String[] stringArray) {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            this.columns.clear();
            if (stringArray != null) {
                this.columns.addAll(Arrays.asList(stringArray));
            }
        }
        this.fireTableStructureChanged();
    }

    static {
        Class<?> clazz = class$org$isqlviewer$core$model$EnhancedTableModel;
        if (clazz == null) {
            clazz = class$org$isqlviewer$core$model$EnhancedTableModel = new EnhancedTableModel[0].getClass().getComponentType();
        }
        FLAVOR_OBJECT = new DataFlavor(clazz, "java/EnhancedTableModel");
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        FLAVOR_TAB_STRINGS = new DataFlavor(clazz2, "text/tab-separated-values");
    }
}

