/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.isqlviewer.core.ImportPlugin;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImportConfig {
    private String schema = null;
    private String catalog = null;
    private String table = null;
    private boolean useTransaction = false;
    private boolean useBatch = false;
    private HashMap entryMap = new HashMap();
    private static final String TAG_ROOT = "jetfire-script";
    private static final String TAG_ENTRY = "jetfire-entry";
    private static final String TAG_PROPERTY = "jetfire-property";
    private static final String TAG_VALUE = "jetfire-data";
    private static final String ATTR_ROOT_TABLE = "table";
    private static final String ATTR_ROOT_CATALOG = "catalog";
    private static final String ATTR_ROOT_SCHEMA = "schema";
    private static final String ATTR_ROOT_BATCH = "batch";
    private static final String ATTR_ROOT_TRANX = "transaction";
    private static final String ATTR_ENTRY_COLUMN = "column";
    private static final String ATTR_ENTRY_PLUGIN = "plugin";
    private static final String ATTR_PROP_NAME = "name";

    public boolean isUseBatch() {
        return this.useBatch;
    }

    public void setUseBatch(boolean bl2) {
        this.useBatch = bl2;
    }

    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    public void setUseTransaction(boolean bl2) {
        this.useTransaction = bl2;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public Iterator keys() {
        return this.entryMap.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(String string) {
        Object var2_2 = null;
        HashMap hashMap = this.entryMap;
        synchronized (hashMap) {
            var2_2 = this.entryMap.get(string.toUpperCase());
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(String string, Entry entry) {
        try {
            HashMap hashMap = this.entryMap;
            synchronized (hashMap) {
                if (entry == null) {
                    this.entryMap.remove(string.toUpperCase());
                } else {
                    this.entryMap.put(string.toUpperCase(), entry);
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry removeEntry(String string) {
        Object var2_2 = null;
        try {
            HashMap hashMap = this.entryMap;
            synchronized (hashMap) {
                var2_2 = this.entryMap.remove(string.toUpperCase());
            }
            return var2_2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean containsKey(String string) {
        try {
            return this.entryMap.containsKey(string.toUpperCase());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isEmpty() {
        return this.entryMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap hashMap = this.entryMap;
        synchronized (hashMap) {
            this.clearEntries();
        }
    }

    public void store(OutputStream outputStream) {
        Charset charset = Charset.forName("UTF-8");
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, charset), true);
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        printWriter.print("<");
        printWriter.print(TAG_ROOT);
        printWriter.print(" ");
        printWriter.print(ATTR_ROOT_CATALOG);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(this.catalog));
        printWriter.print("\" ");
        printWriter.print(ATTR_ROOT_SCHEMA);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(this.schema));
        printWriter.print("\" ");
        printWriter.print(ATTR_ROOT_TABLE);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(this.table));
        printWriter.print("\" ");
        printWriter.print(ATTR_ROOT_BATCH);
        printWriter.print("=\"");
        printWriter.print(Boolean.toString(this.isUseBatch()));
        printWriter.print("\" ");
        printWriter.print(ATTR_ROOT_TRANX);
        printWriter.print("=\"");
        printWriter.print(Boolean.toString(this.isUseTransaction()));
        printWriter.println("\" >");
        Iterator iterator = this.entryMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Entry entry = (Entry)this.entryMap.get(string);
            if (entry == null) continue;
            this.storeEntry(printWriter, string, entry);
            printWriter.flush();
        }
        printWriter.print("</");
        printWriter.print(TAG_ROOT);
        printWriter.println(">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream) throws IOException {
        XMLReader xMLReader = null;
        SystemConfig systemConfig = SystemConfig.getInstance();
        this.clearEntries();
        try {
            xMLReader = systemConfig.getXMLReader();
            xMLReader.setContentHandler(new ImportParser(this));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
        }
        finally {
            xMLReader = null;
        }
    }

    private void clearEntries() {
        Iterator iterator = this.entryMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Entry entry = (Entry)this.entryMap.get(string);
            if (entry == null) continue;
            entry.clear();
            iterator.remove();
        }
    }

    private void storeEntry(PrintWriter printWriter, String string, Entry entry) {
        printWriter.print("\t<");
        printWriter.print(TAG_ENTRY);
        printWriter.print(" ");
        printWriter.print(ATTR_ENTRY_COLUMN);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(string));
        printWriter.print("\" ");
        printWriter.print(ATTR_ENTRY_PLUGIN);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(entry.plugin));
        printWriter.print("\" ");
        printWriter.println(">");
        Iterator<Object> iterator = entry.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object object = entry.get(string2);
            if (object == null) continue;
            this.storeProperty(string2, object, printWriter);
        }
        printWriter.print("\t</");
        printWriter.print(TAG_ENTRY);
        printWriter.println(">");
    }

    private void storeProperty(String string, Object object, PrintWriter printWriter) {
        printWriter.print("\t\t<");
        printWriter.print(TAG_PROPERTY);
        printWriter.print(" ");
        printWriter.print(ATTR_PROP_NAME);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(string));
        printWriter.println("\" >");
        printWriter.print("\t\t\t<");
        printWriter.print(TAG_VALUE);
        printWriter.println(">");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
        xMLEncoder.setOwner(this);
        xMLEncoder.writeObject(object);
        xMLEncoder.close();
        Base64Encoder base64Encoder = new Base64Encoder(byteArrayOutputStream.toString());
        printWriter.print("\t\t\t ");
        printWriter.println(StringUtilities.formatBreak(80, base64Encoder.processString(), "\t\t\t ", false));
        printWriter.print("\t\t\t</");
        printWriter.print(TAG_VALUE);
        printWriter.println(">");
        printWriter.print("\t\t</");
        printWriter.print(TAG_PROPERTY);
        printWriter.println(">");
        byteArrayOutputStream.reset();
        byteArrayOutputStream = null;
        xMLEncoder = null;
        base64Encoder = null;
    }

    public static class 1 {
    }

    private static class ImportParser
    extends DefaultHandler {
        private ImportConfig owner = null;
        private String currentEntry = null;
        private String currentProperty = null;
        private StringBuffer valueBuffer = new StringBuffer("");
        private boolean done = false;
        private boolean invalue = false;

        public void characters(char[] cArray, int n2, int n3) {
            String string;
            if (!this.done && this.invalue && (string = new String(cArray, n2, n3)).trim().length() >= 1) {
                this.valueBuffer.append(string);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.done) {
                return;
            }
            if (string2.equalsIgnoreCase(ImportConfig.TAG_ROOT)) {
                this.done = true;
            } else if (string2.equalsIgnoreCase(ImportConfig.TAG_ENTRY)) {
                this.currentEntry = null;
            } else if (string2.equalsIgnoreCase(ImportConfig.TAG_PROPERTY) && this.currentEntry != null) {
                this.currentProperty = null;
            } else if (string2.equalsIgnoreCase(ImportConfig.TAG_VALUE) && this.currentProperty != null) {
                Entry entry = this.owner.getEntry(this.currentEntry);
                Base64Decoder base64Decoder = new Base64Decoder(this.valueBuffer.toString());
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(base64Decoder.processString().getBytes());
                    XMLDecoder xMLDecoder = new XMLDecoder(byteArrayInputStream);
                    xMLDecoder.setOwner(this.owner);
                    Object object = xMLDecoder.readObject();
                    entry.put(this.currentProperty, object);
                    xMLDecoder = null;
                    byteArrayInputStream.reset();
                    byteArrayInputStream = null;
                }
                catch (Base64FormatException base64FormatException) {
                    throw new SAXException(base64FormatException);
                }
                base64Decoder = null;
                this.invalue = false;
                this.valueBuffer.setLength(0);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (this.done) {
                return;
            }
            if (string2.equalsIgnoreCase(ImportConfig.TAG_ROOT)) {
                try {
                    this.owner.setCatalog(attributes.getValue(ImportConfig.ATTR_ROOT_CATALOG));
                }
                catch (Throwable throwable) {
                    this.owner.setCatalog(null);
                }
                try {
                    this.owner.setSchema(attributes.getValue(ImportConfig.ATTR_ROOT_SCHEMA));
                }
                catch (Throwable throwable) {
                    this.owner.setSchema(null);
                }
                try {
                    this.owner.setTable(attributes.getValue(ImportConfig.ATTR_ROOT_TABLE));
                }
                catch (Throwable throwable) {
                    this.owner.setTable(null);
                }
                try {
                    this.owner.setUseBatch(Boolean.valueOf(attributes.getValue(ImportConfig.ATTR_ROOT_BATCH)));
                }
                catch (Throwable throwable) {
                    this.owner.setUseBatch(false);
                }
                try {
                    this.owner.setUseTransaction(Boolean.valueOf(attributes.getValue(ImportConfig.ATTR_ROOT_TRANX)));
                }
                catch (Throwable throwable) {
                    this.owner.setUseTransaction(false);
                }
            } else if (string2.equalsIgnoreCase(ImportConfig.TAG_ENTRY)) {
                Entry entry = new Entry(attributes.getValue(ImportConfig.ATTR_ENTRY_PLUGIN), null);
                String string4 = attributes.getValue(ImportConfig.ATTR_ENTRY_COLUMN);
                this.owner.addEntry(string4, entry);
                this.currentEntry = string4;
            } else if (string2.equalsIgnoreCase(ImportConfig.TAG_PROPERTY) && this.currentEntry != null) {
                this.currentProperty = attributes.getValue(ImportConfig.ATTR_PROP_NAME);
            } else if (string2.equalsIgnoreCase(ImportConfig.TAG_VALUE) && this.currentProperty != null) {
                this.invalue = true;
            }
        }

        public ImportParser(ImportConfig importConfig) {
            this.owner = importConfig;
        }
    }

    public static class Entry
    extends Properties {
        private String plugin = "";

        public Entry(ImportPlugin importPlugin) {
            if (importPlugin == null) {
                throw new NullPointerException("ImportConfig.Entry(ImportPlugin)");
            }
            this.plugin = importPlugin.getName();
        }

        private Entry(String string) {
            this.plugin = string;
        }

        public String getPluginName() {
            return this.plugin;
        }

        public /* synthetic */ Entry(String string, 1 var2_2) {
            this(string);
        }
    }
}

