/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SolverTableFilter
extends AbstractTableFilter {
    public FileFilter[] getSupportedFileTypes(int n2) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("Solver_Extension"), this.getString("Solver_Desc"))};
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Solver16");
    }

    public String getName() {
        return BasicUtilities.getString("SolverFilter_Name");
    }

    public boolean isModeSupported(int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int n2) {
        return true;
    }

    public int filterIn(EnhancedTableModel enhancedTableModel, File file, InputStream inputStream) throws IOException, InterruptedException {
        ZipFile zipFile = new ZipFile(file);
        InputStream inputStream2 = zipFile.getInputStream(new ZipEntry("content.xml"));
        this.checkIfCancelled();
        this.readContent(inputStream2, enhancedTableModel);
        return 3;
    }

    public int filterOut(Object object, File file, OutputStream outputStream) {
        return 0;
    }

    public void loadProperties(int n2) {
        String string = null;
        String string2 = null;
        switch (n2) {
            case 0: {
                string = this.getString("Solver_UseSheet_Name");
                string2 = this.getString("Solver_UseSheet_Desc");
                this.addProperty(string, null, "Sheet1", true, string2);
                string = this.getString("Solver_UseRowForColumnNames_Name");
                string2 = this.getString("Solver_UseRowForColumnNames_Desc");
                this.addProperty(string, null, "-1", true, string2);
            }
        }
    }

    private void readContent(InputStream inputStream, EnhancedTableModel enhancedTableModel) throws IOException {
        try {
            XMLReader xMLReader = SystemConfig.getInstance().getXMLReader();
            xMLReader.setContentHandler(new SolverParser(enhancedTableModel));
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (Throwable throwable) {
            this.info(BasicUtilities.getString("Solver_General_Error"), throwable);
            throw new IOException(throwable.getMessage());
        }
    }

    private class SolverParser
    extends DefaultHandler {
        private static final String SHEET_NAME_TAG = "table:table";
        private static final String TABLE_ROW = "table:table-row";
        private static final String TABLE_TEXT = "text:p";
        private static final String SHEET_BODY = "office:body";
        private EnhancedTableModel model = null;
        private boolean inRightSheet = false;
        private boolean inCellText = false;
        private StringBuffer charBuffer = new StringBuffer("");
        private ArrayList currentRow = null;
        private String preferredSheet = "";
        private Preferences prefs = null;

        public void startDocument() {
            String string = null;
            this.prefs = SolverTableFilter.this.getConfiguration(0);
            string = SolverTableFilter.this.getString("Solver_UseSheet_Name");
            this.preferredSheet = this.prefs.get(string, "Sheet1");
        }

        public void characters(char[] cArray, int n2, int n3) {
            if (this.inRightSheet && this.inCellText) {
                this.charBuffer.append(cArray, n2, n3);
            }
        }

        public SolverParser(EnhancedTableModel enhancedTableModel) {
            this.model = enhancedTableModel;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4;
            if (string3.equalsIgnoreCase(TABLE_ROW)) {
                if (this.inRightSheet) {
                    this.model.addRow(this.currentRow);
                    this.model.setColumnCount(this.currentRow.size());
                    this.currentRow = null;
                }
            } else if (string3.equalsIgnoreCase(TABLE_TEXT)) {
                if (this.inCellText && this.inRightSheet) {
                    this.currentRow.add(new String(this.charBuffer.toString()));
                    this.charBuffer.setLength(0);
                    this.inCellText = false;
                }
            } else if (string3.equalsIgnoreCase(SHEET_NAME_TAG)) {
                if (this.inRightSheet) {
                    string4 = BasicUtilities.getString("Solver_Sheet_Finished", this.preferredSheet);
                    SolverTableFilter.this.debug(string4);
                }
            } else if (string3.equalsIgnoreCase(SHEET_BODY) && this.model.isEmpty()) {
                string4 = BasicUtilities.getString("Solver_Sheet_Empty", this.preferredSheet);
                SolverTableFilter.this.info(string4);
            }
            try {
                SolverTableFilter.this.checkIfCancelled();
            }
            catch (InterruptedException interruptedException) {
                throw new SAXException(interruptedException);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equalsIgnoreCase(SHEET_NAME_TAG)) {
                if (this.preferredSheet.equalsIgnoreCase(attributes.getValue(string, "name"))) {
                    this.inRightSheet = true;
                    String string4 = BasicUtilities.getString("Solver_Sheet_Found", this.preferredSheet);
                    SolverTableFilter.this.info(string4);
                }
            } else if (this.inRightSheet) {
                if (string3.equalsIgnoreCase(TABLE_TEXT)) {
                    this.inCellText = true;
                } else if (string3.equalsIgnoreCase(TABLE_ROW)) {
                    this.currentRow = new ArrayList();
                }
            }
        }
    }
}

