/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;

public class CSVTableFilter
extends AbstractTableFilter {
    public FileFilter[] getSupportedFileTypes(int n2) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("TAB_Extension"), this.getString("TAB_Desc")), new ExtensionFileFilter(this.getString("CSV_Extension"), this.getString("CSV_Desc"))};
    }

    public boolean canFilter(int n2, Object object) {
        switch (n2) {
            case 0: {
                return true;
            }
        }
        return object instanceof TableModel;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Csv16");
    }

    public boolean isModeSupported(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int filterIn(EnhancedTableModel enhancedTableModel, File file, InputStream inputStream) throws IOException {
        Object object;
        int n2;
        Preferences preferences = this.getConfiguration(0);
        String string = null;
        Charset charset = this.getPreferredCharset(0);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        int n3 = inputStream.available();
        this.setProgressMax(n3);
        int n4 = 0;
        string = BasicUtilities.getString("ASCII_Delimiter_Name");
        String string2 = StringUtilities.decode(preferences.get(string, ","));
        string = BasicUtilities.getString("ASCII_DblTok_Name");
        boolean bl2 = preferences.getBoolean(string, true);
        string = BasicUtilities.getString("ASCII_1st_Row_Colums");
        boolean bl3 = preferences.getBoolean(string, false);
        string = BasicUtilities.getString("ASCII_Skip_Name");
        int n5 = preferences.getInt(string, 0);
        string = BasicUtilities.getString("ASCII_Quote_Name");
        char c2 = preferences.get(string, "\"").charAt(0);
        string = BasicUtilities.getString("ASCII_Comment_Name");
        char c3 = preferences.get(string, "#").charAt(0);
        StringTokenizer stringTokenizer = new StringTokenizer("", string2, false, !bl2);
        StringBuffer stringBuffer = new StringBuffer("");
        for (n2 = 0; n2 < n5; ++n2) {
            if (!bufferedReader.ready()) {
                return 0;
            }
            this.fireProgressUpdated(n4 += bufferedReader.readLine().getBytes().length);
        }
        if (n5 >= 1) {
            this.info(BasicUtilities.getString("ASCII_Line_Skip", Integer.toString(n5)));
        }
        n2 = n5;
        while (bufferedReader.ready()) {
            Object object2;
            try {
                this.checkIfCancelled();
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                }
                finally {
                    bufferedReader = null;
                }
                enhancedTableModel.clear();
                return 2;
            }
            stringBuffer.setLength(0);
            stringBuffer.append(bufferedReader.readLine());
            ++n2;
            this.fireProgressUpdated(n4 += stringBuffer.toString().getBytes().length);
            if (stringBuffer.charAt(0) == c3) continue;
            stringTokenizer.setString(stringBuffer.toString());
            object = new ArrayList();
            if (!stringTokenizer.hasMoreTokens()) {
                this.info(BasicUtilities.getString("ASCII_NoTokens", Integer.toString(n2)));
                continue;
            }
            while (stringTokenizer.hasMoreTokens()) {
                Object object3;
                object2 = stringTokenizer.nextToken(string2);
                if (object2.length() >= 1 && object2.charAt(0) == c2 && object2.charAt(object2.length() - 1) != c2) {
                    object3 = object2;
                    object2 = ((String)object3).concat(stringTokenizer.nextToken(c2 + System.getProperty("line.seperator", "\n")));
                    stringTokenizer.nextToken(string2);
                }
                if (object2.indexOf(c2) >= 0) {
                    object2 = object2.substring(object2.indexOf(c2) + 1, object2.lastIndexOf(c2)).trim();
                }
                object3 = StringUtilities.decode((String)object2);
                ((ArrayList)object).add(object3);
            }
            if (((ArrayList)object).size() == 1 && enhancedTableModel.getColumnCount() != 1) {
                this.info(BasicUtilities.getString("ASCII_Empty_Line", Integer.toString(n2)));
                continue;
            }
            if (enhancedTableModel.getColumnCount() < ((ArrayList)object).size()) {
                if (enhancedTableModel.getColumnCount() >= 1) {
                    object2 = new String[]{Integer.toString(n2), Integer.toString(((ArrayList)object).size())};
                    this.info(BasicUtilities.getString("ASCII_Token_Warning", object2));
                }
                enhancedTableModel.setColumnCount(((ArrayList)object).size());
            }
            if (bl3) {
                object2 = ((ArrayList)object).iterator();
                int n6 = 0;
                while (object2.hasNext()) {
                    String string3 = (String)object2.next();
                    enhancedTableModel.setColumnName(n6++, StringUtilities.decode(string3));
                }
                bl3 = false;
                ((ArrayList)object).clear();
                object = null;
                continue;
            }
            enhancedTableModel.addRow((ArrayList)object);
            ((ArrayList)object).clear();
            object = null;
        }
        try {
            bufferedReader.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            bufferedReader = null;
        }
        this.fireProgressUpdated(n3);
        object = new String[]{Integer.toString(enhancedTableModel.getTrueRowCount()), Integer.toString(enhancedTableModel.getColumnCount())};
        this.info(BasicUtilities.getString("ASCII_Results", (String[])object));
        return enhancedTableModel.isEmpty() ? 1 : 3;
    }

    public int filterOut(Object object, File file, OutputStream outputStream) throws InterruptedException {
        if (!(object instanceof TableModel)) {
            return 0;
        }
        TableModel tableModel = (TableModel)object;
        Preferences preferences = this.getConfiguration(1);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer("");
        Charset charset = this.getPreferredCharset(1);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, charset), true);
        string = BasicUtilities.getString("ASCII_Delimiter_Name");
        String string2 = StringUtilities.decode(preferences.get(string, ","));
        string = BasicUtilities.getString("ASCII_SmartQuotes_Name");
        boolean bl2 = preferences.getBoolean(string, false);
        string = BasicUtilities.getString("ASCII_IncludeHead_Name");
        boolean bl3 = preferences.getBoolean(string, false);
        string = BasicUtilities.getString("ASCII_Encode_NPC_Name");
        boolean bl4 = preferences.getBoolean(string, false);
        string = BasicUtilities.getString("ASCII_IncludeCols_Name");
        boolean bl5 = preferences.getBoolean(string, false);
        int n2 = 0;
        n2 = tableModel instanceof EnhancedTableModel ? ((EnhancedTableModel)tableModel).getTrueRowCount() : tableModel.getRowCount();
        this.setProgressMax(n2 + (bl3 ? 2 : 0) + (bl5 ? 1 : 0));
        if (bl3) {
            this.fireProgressUpdated(1);
            string = BasicUtilities.getString("ASCII_Header_Name");
            String string3 = preferences.get(string, BasicUtilities.getString("ASCII_Header_Value"));
            printWriter.print("# ");
            printWriter.println(string3);
            this.fireProgressUpdated(2);
            printWriter.print("# ");
            printWriter.println(new Date());
            this.info(BasicUtilities.getString("ASCII_Header_Written"));
        }
        if (bl5) {
            stringBuffer.setLength(0);
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                String string4 = tableModel.getColumnName(i2);
                if (bl2 && string4 != null && (string4.indexOf(string2) >= 0 || string4.indexOf(32) >= 0)) {
                    string4 = "\"" + string4 + "\"";
                }
                if (bl4) {
                    stringBuffer.append(StringUtilities.encode(string4, false, false));
                } else {
                    stringBuffer.append(string4);
                }
                stringBuffer.append(string2);
            }
            printWriter.println(stringBuffer);
            printWriter.flush();
            this.fireProgressUpdated((bl3 ? 2 : 0) + 1);
            this.info(BasicUtilities.getString("ASCII_ColumnHeader_Written"));
        }
        int n3 = (bl3 ? 2 : 0) + (bl5 ? 1 : 0);
        for (int i3 = 0; i3 < n2; ++i3) {
            stringBuffer.setLength(0);
            for (int i4 = 0; i4 < tableModel.getColumnCount(); ++i4) {
                Object object2 = tableModel.getValueAt(i3, i4);
                String string5 = object2 instanceof String ? (String)object2 : (object2 != null ? object2.toString() : "null");
                if (bl2 && string5 != null && (string5.indexOf(string2) >= 0 || string5.indexOf(32) >= 0)) {
                    string5 = "\"" + string5 + "\"";
                }
                if (bl4) {
                    stringBuffer.append(StringUtilities.encode(string5, false, false));
                } else {
                    stringBuffer.append(string5);
                }
                stringBuffer.append(string2);
            }
            printWriter.println(stringBuffer);
            String[] stringArray = new String[]{stringBuffer.toString(), Integer.toString(n3 + (i3 + 1))};
            this.debug(BasicUtilities.getString("ASCII_Line_Written", stringArray));
            printWriter.flush();
            this.fireProgressUpdated(n3 + (i3 + 1));
            this.checkIfCancelled();
        }
        return 1;
    }

    public String getName() {
        return BasicUtilities.getString("ASCII_Handler_Name");
    }

    public boolean isFileRequired(int n2) {
        return true;
    }

    public void loadProperties(int n2) {
        String string = null;
        String string2 = null;
        switch (n2) {
            case 1: {
                string = this.getString("ASCII_Header_Name");
                string2 = this.getString("ASCII_Header_Desc");
                this.addProperty(string, null, " ", true, string2);
                string = this.getString("ASCII_IncludeCols_Name");
                string2 = this.getString("ASCII_IncludeCols_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "false", false, string2);
                string = this.getString("ASCII_IncludeHead_Name");
                string2 = this.getString("ASCII_IncludeHead_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "false", false, string2);
                string = this.getString("ASCII_Encode_NPC_Name");
                string2 = this.getString("ASCII_Encode_NPC_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "true", false, string2);
                string = this.getString("ASCII_SmartQuotes_Name");
                string2 = this.getString("ASCII_SmartQuotes_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "true", false, string2);
                string = this.getString("ASCII_Delimiter_Name");
                string2 = this.getString("ASCII_Delimiter_Desc");
                this.addProperty(string, null, ",", true, string2);
                break;
            }
            case 0: {
                string = this.getString("ASCII_Delimiter_Name");
                string2 = this.getString("ASCII_Delimiter_Desc");
                this.addProperty(string, null, ",", true, string2);
                string = this.getString("ASCII_Skip_Name");
                string2 = this.getString("ASCII_Skip_Desc");
                this.addProperty(string, null, "0", false, string2);
                string = this.getString("ASCII_Quote_Name");
                string2 = this.getString("ASCII_Quote_Desc");
                this.addProperty(string, null, "\"", false, string2);
                string = this.getString("ASCII_Comment_Name");
                string2 = this.getString("ASCII_Comment_Desc");
                this.addProperty(string, null, "#", false, string2);
                string = this.getString("ASCII_1st_Row_Colums");
                string2 = this.getString("ASCII_1st_Row_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "false", false, string2);
                string = this.getString("ASCII_DblTok_Name");
                string2 = this.getString("ASCII_DblTok_Desc");
                this.addProperty(string, CHOICE_BOOLEAN, "false", false, string2);
                break;
            }
        }
    }
}

