/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.garret.perst.impl.PersistentListImpl;

class SubList
extends AbstractList {
    private PersistentListImpl l;
    private int offset;
    private int size;
    private int expectedModCount;

    SubList(PersistentListImpl persistentListImpl, int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n2);
        }
        if (n3 > persistentListImpl.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        this.l = persistentListImpl;
        this.offset = n2;
        this.size = n3 - n2;
        this.expectedModCount = this.l.modCount;
    }

    public Object set(int n2, Object object) {
        this.rangeCheck(n2);
        this.checkForComodification();
        return this.l.set(n2 + this.offset, object);
    }

    public Object get(int n2) {
        this.rangeCheck(n2);
        this.checkForComodification();
        return this.l.get(n2 + this.offset);
    }

    public int size() {
        this.checkForComodification();
        return this.size;
    }

    public void add(int n2, Object object) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForComodification();
        this.l.add(n2 + this.offset, object);
        this.expectedModCount = this.l.modCount;
        ++this.size;
        ++this.modCount;
    }

    public Object remove(int n2) {
        this.rangeCheck(n2);
        this.checkForComodification();
        Object object = this.l.remove(n2 + this.offset);
        this.expectedModCount = this.l.modCount;
        --this.size;
        ++this.modCount;
        return object;
    }

    protected void removeRange(int n2, int n3) {
        this.checkForComodification();
        this.l.removeRange(n2 + this.offset, n3 + this.offset);
        this.expectedModCount = this.l.modCount;
        this.size -= n3 - n2;
        ++this.modCount;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n2, Collection collection) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + n2, collection);
        this.expectedModCount = this.l.modCount;
        this.size += n3;
        ++this.modCount;
        return true;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(final int n2) {
        this.checkForComodification();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        return new ListIterator(){
            private ListIterator i;
            {
                this.i = SubList.this.l.listIterator(n2 + SubList.this.offset);
            }

            public boolean hasNext() {
                return this.nextIndex() < SubList.this.size;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.i.nextIndex() - SubList.this.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - SubList.this.offset;
            }

            public void remove() {
                this.i.remove();
                SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                SubList.this.size--;
                SubList.this.modCount++;
            }

            public void set(Object object) {
                this.i.set(object);
            }

            public void add(Object object) {
                this.i.add(object);
                SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                SubList.this.size++;
                SubList.this.modCount++;
            }
        };
    }

    public List subList(int n2, int n3) {
        return new SubList(this.l, this.offset + n2, this.offset + n3);
    }

    private void rangeCheck(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ",Size: " + this.size);
        }
    }

    private void checkForComodification() {
        if (this.l.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

