/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.RectangleR2;
import org.garret.perst.Storage;

public class RtreeR2Page
extends Persistent {
    static final int card = 113;
    static final int minFill = 56;
    int n;
    RectangleR2[] b;
    Link branch;

    RtreeR2Page(Storage storage, IPersistent iPersistent, RectangleR2 rectangleR2) {
        this.branch = storage.createLink(113);
        this.branch.setSize(113);
        this.b = new RectangleR2[113];
        this.setBranch(0, new RectangleR2(rectangleR2), iPersistent);
        this.n = 1;
        for (int i2 = 1; i2 < 113; ++i2) {
            this.b[i2] = new RectangleR2();
        }
    }

    RtreeR2Page(Storage storage, RtreeR2Page rtreeR2Page, RtreeR2Page rtreeR2Page2) {
        this.branch = storage.createLink(113);
        this.branch.setSize(113);
        this.b = new RectangleR2[113];
        this.n = 2;
        this.setBranch(0, rtreeR2Page.cover(), rtreeR2Page);
        this.setBranch(1, rtreeR2Page2.cover(), rtreeR2Page2);
        for (int i2 = 2; i2 < 113; ++i2) {
            this.b[i2] = new RectangleR2();
        }
    }

    RtreeR2Page() {
    }

    RtreeR2Page insert(Storage storage, RectangleR2 rectangleR2, IPersistent iPersistent, int n2) {
        this.modify();
        if (--n2 != 0) {
            int n3 = 0;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            for (int i2 = 0; i2 < this.n; ++i2) {
                double d4 = this.b[i2].area();
                double d5 = RectangleR2.joinArea(this.b[i2], rectangleR2) - d4;
                if (d5 < d2) {
                    d2 = d5;
                    d3 = d4;
                    n3 = i2;
                    continue;
                }
                if (d5 != d2 || !(d4 < d3)) continue;
                d3 = d4;
                n3 = i2;
            }
            RtreeR2Page rtreeR2Page = (RtreeR2Page)this.branch.get(n3);
            RtreeR2Page rtreeR2Page2 = rtreeR2Page.insert(storage, rectangleR2, iPersistent, n2);
            if (rtreeR2Page2 == null) {
                this.b[n3].join(rectangleR2);
                return null;
            }
            this.setBranch(n3, rtreeR2Page.cover(), rtreeR2Page);
            return this.addBranch(storage, rtreeR2Page2.cover(), rtreeR2Page2);
        }
        return this.addBranch(storage, new RectangleR2(rectangleR2), iPersistent);
    }

    int remove(RectangleR2 rectangleR2, IPersistent iPersistent, int n2, ArrayList arrayList) {
        if (--n2 != 0) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                RtreeR2Page rtreeR2Page;
                int n3;
                if (!rectangleR2.intersects(this.b[i2]) || (n3 = (rtreeR2Page = (RtreeR2Page)this.branch.get(i2)).remove(rectangleR2, iPersistent, n2, arrayList)) < 0) continue;
                if (rtreeR2Page.n >= 56) {
                    this.setBranch(i2, rtreeR2Page.cover(), rtreeR2Page);
                    this.modify();
                } else {
                    arrayList.add(rtreeR2Page);
                    n3 = n2 - 1;
                    this.removeBranch(i2);
                }
                return n3;
            }
        } else {
            for (int i3 = 0; i3 < this.n; ++i3) {
                if (!this.branch.containsElement(i3, iPersistent)) continue;
                this.removeBranch(i3);
                return 0;
            }
        }
        return -1;
    }

    void find(RectangleR2 rectangleR2, ArrayList arrayList, int n2) {
        if (--n2 != 0) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                if (!rectangleR2.intersects(this.b[i2])) continue;
                ((RtreeR2Page)this.branch.get(i2)).find(rectangleR2, arrayList, n2);
            }
        } else {
            for (int i3 = 0; i3 < this.n; ++i3) {
                if (!rectangleR2.intersects(this.b[i3])) continue;
                arrayList.add(this.branch.get(i3));
            }
        }
    }

    void purge(int n2) {
        if (--n2 != 0) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                ((RtreeR2Page)this.branch.get(i2)).purge(n2);
            }
        }
        this.deallocate();
    }

    final void setBranch(int n2, RectangleR2 rectangleR2, IPersistent iPersistent) {
        this.b[n2] = rectangleR2;
        this.branch.set(n2, iPersistent);
    }

    final void removeBranch(int n2) {
        --this.n;
        System.arraycopy(this.b, n2 + 1, this.b, n2, this.n - n2);
        this.branch.remove(n2);
        this.branch.setSize(113);
        this.modify();
    }

    final RtreeR2Page addBranch(Storage storage, RectangleR2 rectangleR2, IPersistent iPersistent) {
        if (this.n < 113) {
            this.setBranch(this.n++, rectangleR2, iPersistent);
            return null;
        }
        return this.splitPage(storage, rectangleR2, iPersistent);
    }

    final RtreeR2Page splitPage(Storage storage, RectangleR2 rectangleR2, IPersistent iPersistent) {
        RtreeR2Page rtreeR2Page;
        RectangleR2 rectangleR22;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        double[] dArray = new double[114];
        double d2 = Double.MIN_VALUE;
        dArray[0] = rectangleR2.area();
        for (n3 = 0; n3 < 113; ++n3) {
            dArray[n3 + 1] = this.b[n3].area();
        }
        RectangleR2 rectangleR23 = rectangleR2;
        for (n3 = 0; n3 < 113; ++n3) {
            for (n2 = n3 + 1; n2 <= 113; ++n2) {
                double d3 = RectangleR2.joinArea(rectangleR23, this.b[n2 - 1]) - dArray[n3] - dArray[n2];
                if (!(d3 > d2)) continue;
                d2 = d3;
                n4 = n3;
                n5 = n2;
            }
            rectangleR23 = this.b[n3];
        }
        byte[] byArray = new byte[113];
        byArray[n5 - 1] = 2;
        RectangleR2 rectangleR24 = new RectangleR2(this.b[n5 - 1]);
        if (n4 == 0) {
            rectangleR22 = new RectangleR2(rectangleR2);
            rtreeR2Page = new RtreeR2Page(storage, iPersistent, rectangleR2);
        } else {
            rectangleR22 = new RectangleR2(this.b[n4 - 1]);
            rtreeR2Page = new RtreeR2Page(storage, this.branch.getRaw(n4 - 1), rectangleR22);
            this.setBranch(n4 - 1, rectangleR2, iPersistent);
        }
        int n6 = 1;
        int n7 = 1;
        double d4 = dArray[n4];
        double d5 = dArray[n5];
        while (n7 + n6 < 114 && n7 < 58 && n6 < 58) {
            int n8 = -1;
            int n9 = -1;
            double d6 = -1.0;
            for (n3 = 0; n3 < 113; ++n3) {
                double d7;
                if (byArray[n3] != 0 || !((d7 = RectangleR2.joinArea(rectangleR22, this.b[n3]) - d4 - (RectangleR2.joinArea(rectangleR24, this.b[n3]) - d5)) > d6) && !(-d7 > d6)) continue;
                n9 = n3;
                if (d7 < 0.0) {
                    n8 = 0;
                    d6 = -d7;
                    continue;
                }
                n8 = 1;
                d6 = d7;
            }
            Assert.that(n9 >= 0);
            if (n8 == 0) {
                rectangleR22.join(this.b[n9]);
                d4 = rectangleR22.area();
                byArray[n9] = 1;
                rtreeR2Page.setBranch(n7++, this.b[n9], this.branch.getRaw(n9));
                continue;
            }
            ++n6;
            rectangleR24.join(this.b[n9]);
            d5 = rectangleR24.area();
            byArray[n9] = 2;
        }
        if (n7 + n6 < 114) {
            for (n3 = 0; n3 < 113; ++n3) {
                if (byArray[n3] != 0) continue;
                if (n7 >= n6) {
                    byArray[n3] = 2;
                    ++n6;
                    continue;
                }
                byArray[n3] = 1;
                rtreeR2Page.setBranch(n7++, this.b[n3], this.branch.getRaw(n3));
            }
        }
        rtreeR2Page.n = n7;
        this.n = n6;
        n3 = 0;
        n2 = 0;
        while (n3 < n6) {
            if (byArray[n2] == 2) {
                this.setBranch(n3++, this.b[n2], this.branch.getRaw(n2));
            }
            ++n2;
        }
        return rtreeR2Page;
    }

    final RectangleR2 cover() {
        RectangleR2 rectangleR2 = new RectangleR2(this.b[0]);
        for (int i2 = 1; i2 < this.n; ++i2) {
            rectangleR2.join(this.b[i2]);
        }
        return rectangleR2;
    }
}

