/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.IResource;
import org.garret.perst.PersistentResource;
import org.garret.perst.ReplicationSlaveStorage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;

public abstract class ReplicationSlaveStorageImpl
extends StorageImpl
implements ReplicationSlaveStorage,
Runnable {
    static final int REPL_CLOSE = -1;
    static final int REPL_SYNC = -2;
    protected static final int DB_HDR_CURR_INDEX_OFFSET = 0;
    protected static final int DB_HDR_DIRTY_OFFSET = 1;
    protected static final int DB_HDR_INITIALIZED_OFFSET = 2;
    protected static final int PAGE_DATA_OFFSET = 8;
    public static int LINGER_TIME = 10;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected boolean outOfSync;
    protected boolean initialized;
    protected boolean listening;
    protected Object sync;
    protected Object init;
    protected Object done;
    protected Object commit;
    protected int prevIndex;
    protected IResource lock;
    protected Thread thread;

    public void open(IFile iFile, int n2) {
        if (this.opened) {
            throw new StorageError(2);
        }
        this.initialize(iFile, n2);
        this.lock = new PersistentResource();
        this.init = new Object();
        this.sync = new Object();
        this.done = new Object();
        this.commit = new Object();
        this.listening = true;
        this.connect();
        this.thread = new Thread(this);
        this.thread.start();
        this.waitSynchronizationCompletion();
        this.waitInitializationCompletion();
        this.opened = true;
        this.beginThreadTransaction(3);
        this.reloadScheme();
        this.endThreadTransaction();
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void beginThreadTransaction(int n2) {
        if (n2 != 3) {
            throw new IllegalArgumentException("Illegal transaction mode");
        }
        this.lock.sharedLock();
        Page page = this.pool.getPage(0L);
        this.header.unpack(page.data);
        this.pool.unfix(page);
        this.currIndex = 1 - this.header.curr;
        this.committedIndexSize = this.currIndexSize = this.header.root[1 - this.currIndex].indexUsed;
        this.usedSize = this.header.root[this.currIndex].size;
        this.objectCache.clear();
    }

    public void endThreadTransaction(int n2) {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitSynchronizationCompletion() {
        try {
            Object object = this.sync;
            synchronized (object) {
                while (this.outOfSync) {
                    this.sync.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitInitializationCompletion() {
        try {
            Object object = this.init;
            synchronized (object) {
                while (!this.initialized) {
                    this.init.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForModification() {
        try {
            Object object = this.commit;
            synchronized (object) {
                if (this.socket != null) {
                    this.commit.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean handleError() {
        return this.listener != null ? this.listener.replicationError(null) : false;
    }

    void connect() {
        try {
            this.socket = this.getSocket();
            try {
                this.socket.setSoLinger(true, LINGER_TIME);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.in = this.socket.getInputStream();
            if (this.replicationAck) {
                this.out = this.socket.getOutputStream();
            }
        }
        catch (IOException iOException) {
            this.socket = null;
            this.in = null;
        }
    }

    abstract Socket getSocket() throws IOException;

    void cancelIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = new byte[4104];
        while (this.listening) {
            Object object;
            Object object2;
            int n2 = 0;
            do {
                int n3;
                try {
                    n3 = this.in.read(byArray, n2, byArray.length - n2);
                }
                catch (IOException iOException) {
                    n3 = -1;
                }
                Object object3 = this.done;
                synchronized (object3) {
                    if (!this.listening) {
                        return;
                    }
                }
                if (n3 < 0) {
                    if (this.handleError()) {
                        this.connect();
                        continue;
                    }
                    return;
                }
                n2 += n3;
            } while (n2 < byArray.length);
            long l2 = Bytes.unpack8(byArray, 0);
            boolean bl2 = false;
            if (l2 == 0L) {
                if (this.replicationAck) {
                    try {
                        this.out.write(byArray, 0, 1);
                    }
                    catch (IOException iOException) {
                        this.handleError();
                    }
                }
                if (byArray[8] != this.prevIndex) {
                    this.prevIndex = byArray[8];
                    this.lock.exclusiveLock();
                    bl2 = true;
                }
            } else {
                if (l2 == -2L) {
                    object2 = this.sync;
                    synchronized (object2) {
                        this.outOfSync = false;
                        this.sync.notify();
                        continue;
                    }
                }
                if (l2 == -1L) {
                    object2 = this.commit;
                    synchronized (object2) {
                        this.hangup();
                        this.commit.notifyAll();
                    }
                    return;
                }
            }
            object2 = this.pool.putPage(l2);
            System.arraycopy(byArray, 8, ((Page)object2).data, 0, 4096);
            this.pool.unfix((Page)object2);
            if (l2 != 0L) continue;
            if (!this.initialized && byArray[10] != 0) {
                object = this.init;
                synchronized (object) {
                    this.initialized = true;
                    this.init.notify();
                }
            }
            if (!bl2) continue;
            this.lock.unlock();
            object = this.commit;
            synchronized (object) {
                this.commit.notifyAll();
            }
            this.pool.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.done;
        synchronized (object) {
            this.listening = false;
        }
        this.cancelIO();
        try {
            this.thread.interrupt();
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.hangup();
        this.pool.flush();
        super.close();
    }

    protected void hangup() {
        if (this.socket != null) {
            try {
                this.in.close();
                if (this.out != null) {
                    this.out.close();
                }
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
            this.socket = null;
        }
    }

    protected boolean isDirty() {
        return false;
    }
}

