/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.OSFile;

public class MultiFile
implements IFile {
    MultiFileSegment[] segment;
    long fixedSize;
    int currSeg;
    boolean noFlush;

    long seek(long l2) {
        this.currSeg = 0;
        while (l2 >= this.segment[this.currSeg].size) {
            l2 -= this.segment[this.currSeg].size;
            ++this.currSeg;
        }
        return l2;
    }

    public void write(long l2, byte[] byArray) {
        l2 = this.seek(l2);
        this.segment[this.currSeg].f.write(l2, byArray);
    }

    public int read(long l2, byte[] byArray) {
        l2 = this.seek(l2);
        return this.segment[this.currSeg].f.read(l2, byArray);
    }

    public void sync() {
        if (!this.noFlush) {
            int n2 = this.segment.length;
            while (--n2 >= 0) {
                this.segment[n2].f.sync();
            }
        }
    }

    public boolean tryLock(boolean bl2) {
        return this.segment[0].f.tryLock(bl2);
    }

    public void lock(boolean bl2) {
        this.segment[0].f.lock(bl2);
    }

    public void unlock() {
        this.segment[0].f.unlock();
    }

    public void close() {
        int n2 = this.segment.length;
        while (--n2 >= 0) {
            this.segment[n2].f.close();
        }
    }

    public MultiFile(String[] stringArray, long[] lArray, boolean bl2, boolean bl3) {
        this.noFlush = bl3;
        this.segment = new MultiFileSegment[stringArray.length];
        for (int i2 = 0; i2 < this.segment.length; ++i2) {
            MultiFileSegment multiFileSegment = new MultiFileSegment();
            multiFileSegment.f = new OSFile(stringArray[i2], bl2, bl3);
            multiFileSegment.size = lArray[i2];
            this.fixedSize += multiFileSegment.size;
            this.segment[i2] = multiFileSegment;
        }
        this.fixedSize -= this.segment[this.segment.length - 1].size;
        this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
    }

    public MultiFile(MultiFileSegment[] multiFileSegmentArray) {
        this.segment = multiFileSegmentArray;
        for (int i2 = 0; i2 < multiFileSegmentArray.length; ++i2) {
            this.fixedSize += multiFileSegmentArray[i2].size;
        }
        this.fixedSize -= this.segment[this.segment.length - 1].size;
        this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
    }

    public MultiFile(String string, boolean bl2, boolean bl3) {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new FileReader(string)));
            File file = new File(string).getParentFile();
            this.noFlush = bl3;
            this.segment = new MultiFileSegment[0];
            int n2 = streamTokenizer.nextToken();
            do {
                MultiFileSegment[] multiFileSegmentArray;
                MultiFileSegment multiFileSegment = new MultiFileSegment();
                if (n2 != -3 && n2 != 34) {
                    throw new StorageError(3, "Multifile segment name expected");
                }
                String string2 = streamTokenizer.sval;
                n2 = streamTokenizer.nextToken();
                if (n2 != -1) {
                    if (n2 != -2) {
                        throw new StorageError(3, "Multifile segment size expected");
                    }
                    multiFileSegment.size = (long)streamTokenizer.nval * 1024L;
                    n2 = streamTokenizer.nextToken();
                }
                this.fixedSize += multiFileSegment.size;
                if (file != null && !(multiFileSegmentArray = new File(string2)).isAbsolute()) {
                    multiFileSegmentArray = new File(file, string2);
                    string2 = multiFileSegmentArray.getPath();
                }
                multiFileSegment.f = new OSFile(string2, bl2, bl3);
                multiFileSegmentArray = new MultiFileSegment[this.segment.length + 1];
                System.arraycopy(this.segment, 0, multiFileSegmentArray, 0, this.segment.length);
                multiFileSegmentArray[this.segment.length] = multiFileSegment;
                this.segment = multiFileSegmentArray;
            } while (n2 != -1);
            this.fixedSize -= this.segment[this.segment.length - 1].size;
            this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
        }
        catch (IOException iOException) {
            throw new StorageError(3);
        }
    }

    public long length() {
        return this.fixedSize + this.segment[this.segment.length - 1].f.length();
    }

    public static class MultiFileSegment {
        IFile f;
        long size;
    }
}

