/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.garret.perst.JSQLNullPointerException;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class InvokeNode
extends Node {
    Node target;
    Node[] arguments;
    Method mth;

    public boolean equals(Object object) {
        return object instanceof InvokeNode && InvokeNode.equalObjects(((InvokeNode)object).target, this.target) && Arrays.equals(((InvokeNode)object).arguments, this.arguments) && InvokeNode.equalObjects(((InvokeNode)object).mth, this.mth);
    }

    Class getType() {
        return this.mth.getReturnType();
    }

    String getFieldName() {
        if (this.target != null && this.target.tag != 67) {
            String string = this.target.getFieldName();
            return string != null ? string + "." + this.mth.getName() : null;
        }
        return this.mth.getName();
    }

    Object getTarget(FilterIterator filterIterator) {
        if (this.target == null) {
            return filterIterator.currObj;
        }
        Object object = this.target.evaluateObj(filterIterator);
        if (object == null) {
            throw new JSQLNullPointerException(this.target.getType(), this.mth.toString());
        }
        return object;
    }

    Object[] evaluateArguments(FilterIterator filterIterator) {
        Object[] objectArray = null;
        int n2 = this.arguments.length;
        if (n2 > 0) {
            objectArray = new Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                Node node = this.arguments[i2];
                switch (node.type) {
                    case 1: {
                        object = new Long(node.evaluateInt(filterIterator));
                        break;
                    }
                    case 2: {
                        object = new Double(node.evaluateReal(filterIterator));
                        break;
                    }
                    case 6: {
                        object = node.evaluateStr(filterIterator);
                        break;
                    }
                    case 0: {
                        object = new Boolean(node.evaluateBool(filterIterator));
                        break;
                    }
                    default: {
                        object = node.evaluateObj(filterIterator);
                    }
                }
                objectArray[i2] = object;
            }
        }
        return objectArray;
    }

    long evaluateInt(FilterIterator filterIterator) {
        Object object = this.getTarget(filterIterator);
        Object[] objectArray = this.evaluateArguments(filterIterator);
        try {
            return ((Number)this.mth.invoke(object, objectArray)).longValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    double evaluateReal(FilterIterator filterIterator) {
        Object object = this.getTarget(filterIterator);
        Object[] objectArray = this.evaluateArguments(filterIterator);
        try {
            return ((Number)this.mth.invoke(object, objectArray)).doubleValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    boolean evaluateBool(FilterIterator filterIterator) {
        Object object = this.getTarget(filterIterator);
        Object[] objectArray = this.evaluateArguments(filterIterator);
        try {
            return (Boolean)this.mth.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    String evaluateStr(FilterIterator filterIterator) {
        Object object = this.getTarget(filterIterator);
        Object[] objectArray = this.evaluateArguments(filterIterator);
        try {
            return (String)this.mth.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    Object evaluateObj(FilterIterator filterIterator) {
        Object object = this.getTarget(filterIterator);
        Object[] objectArray = this.evaluateArguments(filterIterator);
        try {
            return this.mth.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    InvokeNode(Node node, Method method, Node[] nodeArray) {
        super(InvokeNode.getFieldType(method.getReturnType()), 71);
        this.target = node;
        this.arguments = nodeArray;
        this.mth = method;
    }
}

