/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Field;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class ElementNode
extends Node {
    String arrayName;
    Field field;
    Class type;

    public boolean equals(Object object) {
        return object instanceof ElementNode && ElementNode.equalObjects(((ElementNode)object).arrayName, this.arrayName) && ElementNode.equalObjects(((ElementNode)object).field, this.field) && ElementNode.equalObjects(((ElementNode)object).type, this.type);
    }

    ElementNode(String string, Field field) {
        super(ElementNode.getFieldType(field.getType()), 112);
        this.arrayName = string;
        this.type = field.getType();
        this.field = field;
    }

    String getFieldName() {
        return this.arrayName != null ? this.arrayName + "." + this.field.getName() : null;
    }

    boolean evaluateBool(FilterIterator filterIterator) {
        try {
            return this.field.getBoolean(filterIterator.containsElem);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError();
        }
    }

    long evaluateInt(FilterIterator filterIterator) {
        try {
            return this.field.getLong(filterIterator.containsElem);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError();
        }
    }

    double evaluateReal(FilterIterator filterIterator) {
        try {
            return this.field.getDouble(filterIterator.containsElem);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError();
        }
    }

    String evaluateStr(FilterIterator filterIterator) {
        try {
            return (String)this.field.get(filterIterator.containsElem);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError();
        }
    }

    Object evaluateObj(FilterIterator filterIterator) {
        try {
            return this.field.get(filterIterator.containsElem);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError();
        }
    }

    Class getType() {
        return this.type;
    }
}

