/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.BitIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.PersistentIterator;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;

class BitIndexImpl
extends Btree
implements BitIndex {
    BitIndexImpl() {
        super(4, true);
    }

    public int get(IPersistent iPersistent) {
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        if (this.root == 0) {
            throw new StorageError(5);
        }
        return BitIndexPage.find(storageImpl, this.root, iPersistent.getOid(), this.height);
    }

    public void put(IPersistent iPersistent, int n2) {
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        if (storageImpl == null) {
            throw new StorageError(16);
        }
        if (!iPersistent.isPersistent()) {
            storageImpl.makePersistent(iPersistent);
        }
        Key key = new Key(n2, iPersistent.getOid());
        if (this.root == 0) {
            this.root = BitIndexPage.allocate(storageImpl, 0, key);
            this.height = 1;
        } else {
            int n3 = BitIndexPage.insert(storageImpl, this.root, key, this.height);
            if (n3 == 1) {
                this.root = BitIndexPage.allocate(storageImpl, this.root, key);
                ++this.height;
            }
        }
        ++this.updateCounter;
        ++this.nElems;
        this.modify();
    }

    public void remove(IPersistent iPersistent) {
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        if (storageImpl == null) {
            throw new StorageError(16);
        }
        if (this.root == 0) {
            throw new StorageError(5);
        }
        int n2 = BitIndexPage.remove(storageImpl, this.root, iPersistent.getOid(), this.height);
        if (n2 == 3) {
            throw new StorageError(5);
        }
        --this.nElems;
        if (n2 == 2) {
            Page page = storageImpl.getPage(this.root);
            if (BitIndexPage.getnItems(page) == 0) {
                int n3 = 0;
                if (this.height != 1) {
                    n3 = BitIndexPage.getItem(page, 1022);
                }
                storageImpl.freePage(this.root);
                this.root = n3;
                --this.height;
            }
            storageImpl.pool.unfix(page);
        }
        ++this.updateCounter;
        this.modify();
    }

    public Iterator iterator() {
        return this.iterator(0, 0);
    }

    public Iterator iterator(int n2, int n3) {
        return new BitIndexIterator(n2, n3);
    }

    static class BitIndexPage
    extends BtreePage {
        static final int max = 511;

        BitIndexPage() {
        }

        static int getItem(Page page, int n2) {
            return Bytes.unpack4(page.data, 4 + n2 * 4);
        }

        static void setItem(Page page, int n2, int n3) {
            Bytes.pack4(page.data, 4 + n2 * 4, n3);
        }

        static int allocate(StorageImpl storageImpl, int n2, Key key) {
            int n3 = storageImpl.allocatePage();
            Page page = storageImpl.putPage(n3);
            BitIndexPage.setnItems(page, 1);
            BitIndexPage.setItem(page, 0, key.key);
            BitIndexPage.setItem(page, 1022, key.oid);
            BitIndexPage.setItem(page, 1021, n2);
            storageImpl.pool.unfix(page);
            return n3;
        }

        static void memcpy(Page page, int n2, Page page2, int n3, int n4) {
            System.arraycopy(page2.data, 4 + n3 * 4, page.data, 4 + n2 * 4, n4 * 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static int find(StorageImpl storageImpl, int n2, int n3, int n4) {
            int n5;
            int n6;
            Page page = storageImpl.getPage(n2);
            try {
                int n7 = BitIndexPage.getnItems(page);
                n6 = 0;
                n5 = n7;
                if (--n4 == 0) {
                    while (true) {
                        if (n6 >= n5) {
                            if (n5 >= n7) throw new StorageError(5);
                            if (BitIndexPage.getItem(page, 1023 - n5 - 1) != n3) throw new StorageError(5);
                            int n8 = BitIndexPage.getItem(page, n5);
                            Object var11_12 = null;
                            if (page == null) return n8;
                            storageImpl.pool.unfix(page);
                            return n8;
                        }
                        int n9 = n6 + n5 >> 1;
                        if (n3 > BitIndexPage.getItem(page, 1022 - n9)) {
                            n6 = n9 + 1;
                            continue;
                        }
                        n5 = n9;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (page == null) throw throwable;
                storageImpl.pool.unfix(page);
                throw throwable;
            }
            while (n6 < n5) {
                int n10 = n6 + n5 >> 1;
                if (n3 > BitIndexPage.getItem(page, n10)) {
                    n6 = n10 + 1;
                    continue;
                }
                n5 = n10;
            }
            int n11 = BitIndexPage.find(storageImpl, BitIndexPage.getItem(page, 1023 - n5 - 1), n3, n4);
            Object var11_13 = null;
            if (page == null) return n11;
            storageImpl.pool.unfix(page);
            return n11;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static int insert(StorageImpl storageImpl, int n2, Key key, int n3) {
            int n4;
            Page page;
            block16: {
                int n5;
                block15: {
                    int n6;
                    page = storageImpl.getPage(n2);
                    int n7 = 0;
                    int n8 = n6 = BitIndexPage.getnItems(page);
                    int n9 = key.oid;
                    try {
                        if (--n3 != 0) {
                            while (n7 < n8) {
                                n5 = n7 + n8 >> 1;
                                if (n9 > BitIndexPage.getItem(page, n5)) {
                                    n7 = n5 + 1;
                                    continue;
                                }
                                n8 = n5;
                            }
                            Assert.that(n7 == n8);
                            n5 = BitIndexPage.insert(storageImpl, BitIndexPage.getItem(page, 1023 - n8 - 1), key, n3);
                            Assert.that(n5 != 3);
                            if (n5 != 1) {
                                int n10 = n5;
                                Object var13_13 = null;
                                if (page == null) return n10;
                                storageImpl.pool.unfix(page);
                                return n10;
                            }
                            ++n6;
                        } else {
                            while (n7 < n8) {
                                n5 = n7 + n8 >> 1;
                                if (n9 > BitIndexPage.getItem(page, 1022 - n5)) {
                                    n7 = n5 + 1;
                                    continue;
                                }
                                n8 = n5;
                            }
                            if (n8 < n6 && n9 == BitIndexPage.getItem(page, 1022 - n8)) {
                                storageImpl.pool.unfix(page);
                                page = null;
                                page = storageImpl.putPage(n2);
                                BitIndexPage.setItem(page, n8, key.key);
                                n5 = 5;
                                Object var13_14 = null;
                                if (page == null) return n5;
                                storageImpl.pool.unfix(page);
                                return n5;
                            }
                        }
                        storageImpl.pool.unfix(page);
                        page = null;
                        page = storageImpl.putPage(n2);
                        if (n6 < 511) {
                            BitIndexPage.memcpy(page, n8 + 1, page, n8, n6 - n8);
                            BitIndexPage.memcpy(page, 1023 - n6 - 1, page, 1023 - n6, n6 - n8);
                            BitIndexPage.setItem(page, n8, key.key);
                            BitIndexPage.setItem(page, 1022 - n8, key.oid);
                            BitIndexPage.setnItems(page, BitIndexPage.getnItems(page) + 1);
                            n5 = 0;
                            break block15;
                        }
                        n2 = storageImpl.allocatePage();
                        Page page2 = storageImpl.putPage(n2);
                        Assert.that(n6 == 511);
                        int n11 = 255;
                        if (n8 < n11) {
                            BitIndexPage.memcpy(page2, 0, page, 0, n8);
                            BitIndexPage.memcpy(page2, n8 + 1, page, n8, n11 - n8 - 1);
                            BitIndexPage.memcpy(page, 0, page, n11 - 1, 511 - n11 + 1);
                            BitIndexPage.memcpy(page2, 1023 - n8, page, 1023 - n8, n8);
                            BitIndexPage.setItem(page2, n8, key.key);
                            BitIndexPage.setItem(page2, 1022 - n8, key.oid);
                            BitIndexPage.memcpy(page2, 1023 - n11, page, 1023 - n11 + 1, n11 - n8 - 1);
                            BitIndexPage.memcpy(page, 512 + n11 - 1, page, 512, 511 - n11 + 1);
                        } else {
                            BitIndexPage.memcpy(page2, 0, page, 0, n11);
                            BitIndexPage.memcpy(page, 0, page, n11, n8 - n11);
                            BitIndexPage.memcpy(page, n8 - n11 + 1, page, n8, 511 - n8);
                            BitIndexPage.memcpy(page2, 1023 - n11, page, 1023 - n11, n11);
                            BitIndexPage.memcpy(page, 1023 - n8 + n11, page, 1023 - n8, n8 - n11);
                            BitIndexPage.setItem(page, n8 - n11, key.key);
                            BitIndexPage.setItem(page, 1022 - n8 + n11, key.oid);
                            BitIndexPage.memcpy(page, 512 + n11 - 1, page, 512, 511 - n8);
                        }
                        key.oid = n2;
                        if (n3 == 0) {
                            key.key = BitIndexPage.getItem(page2, 1023 - n11);
                            BitIndexPage.setnItems(page, 511 - n11 + 1);
                            BitIndexPage.setnItems(page2, n11);
                        } else {
                            key.key = BitIndexPage.getItem(page2, n11 - 1);
                            BitIndexPage.setnItems(page, 511 - n11);
                            BitIndexPage.setnItems(page2, n11 - 1);
                        }
                        storageImpl.pool.unfix(page2);
                        n4 = 1;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        if (page == null) throw throwable;
                        storageImpl.pool.unfix(page);
                        throw throwable;
                    }
                }
                Object var13_15 = null;
                if (page == null) return n5;
                storageImpl.pool.unfix(page);
                return n5;
            }
            Object var13_16 = null;
            if (page == null) return n4;
            storageImpl.pool.unfix(page);
            return n4;
        }

        static int handlePageUnderflow(StorageImpl storageImpl, Page page, int n2, int n3) {
            int n4 = BitIndexPage.getnItems(page);
            Page page2 = storageImpl.putPage(BitIndexPage.getItem(page, 1023 - n2 - 1));
            int n5 = BitIndexPage.getnItems(page2);
            if (n2 < n4) {
                Page page3 = storageImpl.getPage(BitIndexPage.getItem(page, 1023 - n2 - 2));
                int n6 = BitIndexPage.getnItems(page3);
                Assert.that(n6 >= n5);
                if (n3 != 1) {
                    BitIndexPage.memcpy(page2, n5, page, n2, 1);
                    ++n5;
                    ++n6;
                }
                if (n5 + n6 > 511) {
                    int n7 = n6 - (n5 + n6 >> 1);
                    storageImpl.pool.unfix(page3);
                    page3 = storageImpl.putPage(BitIndexPage.getItem(page, 1023 - n2 - 2));
                    BitIndexPage.memcpy(page2, n5, page3, 0, n7);
                    BitIndexPage.memcpy(page3, 0, page3, n7, n6 - n7);
                    BitIndexPage.memcpy(page2, 1023 - n5 - n7, page3, 1023 - n7, n7);
                    BitIndexPage.memcpy(page3, 1023 - n6 + n7, page3, 1023 - n6, n6 - n7);
                    if (n3 != 1) {
                        BitIndexPage.memcpy(page, n2, page2, n5 + n7 - 1, 1);
                    } else {
                        BitIndexPage.memcpy(page, n2, page2, 1023 - n5 - n7, 1);
                    }
                    BitIndexPage.setnItems(page3, BitIndexPage.getnItems(page3) - n7);
                    BitIndexPage.setnItems(page2, BitIndexPage.getnItems(page2) + n7);
                    storageImpl.pool.unfix(page2);
                    storageImpl.pool.unfix(page3);
                    return 0;
                }
                BitIndexPage.memcpy(page2, n5, page3, 0, n6);
                BitIndexPage.memcpy(page2, 1023 - n5 - n6, page3, 1023 - n6, n6);
                storageImpl.freePage(BitIndexPage.getItem(page, 1023 - n2 - 2));
                BitIndexPage.memcpy(page, 1023 - n4, page, 1023 - n4 - 1, n4 - n2 - 1);
                BitIndexPage.memcpy(page, n2, page, n2 + 1, n4 - n2 - 1);
                BitIndexPage.setnItems(page2, BitIndexPage.getnItems(page2) + n6);
                BitIndexPage.setnItems(page, n4 - 1);
                storageImpl.pool.unfix(page2);
                storageImpl.pool.unfix(page3);
                return n4 < 255 ? 2 : 0;
            }
            Page page4 = storageImpl.getPage(BitIndexPage.getItem(page, 1023 - n2));
            int n8 = BitIndexPage.getnItems(page4);
            Assert.that(n8 >= n5);
            if (n3 != 1) {
                ++n5;
                ++n8;
            }
            if (n5 + n8 > 511) {
                int n9 = n8 - (n5 + n8 >> 1);
                storageImpl.pool.unfix(page4);
                page4 = storageImpl.putPage(BitIndexPage.getItem(page, 1023 - n2));
                BitIndexPage.memcpy(page2, n9, page2, 0, n5);
                BitIndexPage.memcpy(page2, 0, page4, n8 - n9, n9);
                BitIndexPage.memcpy(page2, 1023 - n5 - n9, page2, 1023 - n5, n5);
                BitIndexPage.memcpy(page2, 1023 - n9, page4, 1023 - n8, n9);
                if (n3 != 1) {
                    BitIndexPage.memcpy(page2, n9 - 1, page, n2 - 1, 1);
                    BitIndexPage.memcpy(page, n2 - 1, page4, n8 - n9 - 1, 1);
                } else {
                    BitIndexPage.memcpy(page, n2 - 1, page4, 1023 - n8 + n9, 1);
                }
                BitIndexPage.setnItems(page4, BitIndexPage.getnItems(page4) - n9);
                BitIndexPage.setnItems(page2, BitIndexPage.getnItems(page2) + n9);
                storageImpl.pool.unfix(page2);
                storageImpl.pool.unfix(page4);
                return 0;
            }
            BitIndexPage.memcpy(page2, n8, page2, 0, n5);
            BitIndexPage.memcpy(page2, 0, page4, 0, n8);
            BitIndexPage.memcpy(page2, 1023 - n5 - n8, page2, 1023 - n5, n5);
            BitIndexPage.memcpy(page2, 1023 - n8, page4, 1023 - n8, n8);
            if (n3 != 1) {
                BitIndexPage.memcpy(page2, n8 - 1, page, n2 - 1, 1);
            }
            storageImpl.freePage(BitIndexPage.getItem(page, 1023 - n2));
            BitIndexPage.setItem(page, 1023 - n2, BitIndexPage.getItem(page, 1023 - n2 - 1));
            BitIndexPage.setnItems(page2, BitIndexPage.getnItems(page2) + n8);
            BitIndexPage.setnItems(page, n4 - 1);
            storageImpl.pool.unfix(page2);
            storageImpl.pool.unfix(page4);
            return n4 < 255 ? 2 : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int remove(StorageImpl storageImpl, int n2, int n3, int n4) {
            int n5;
            Page page;
            block15: {
                int n6;
                int n7;
                block13: {
                    block14: {
                        page = storageImpl.getPage(n2);
                        int n8 = BitIndexPage.getnItems(page);
                        n7 = 0;
                        n6 = n8;
                        if (--n4 != 0) break block13;
                        while (n7 < n6) {
                            int n9 = n7 + n6 >> 1;
                            if (n3 > BitIndexPage.getItem(page, 1022 - n9)) {
                                n7 = n9 + 1;
                                continue;
                            }
                            n6 = n9;
                        }
                        if (n6 >= n8 || BitIndexPage.getItem(page, 1023 - n6 - 1) != n3) break block14;
                        storageImpl.pool.unfix(page);
                        page = null;
                        page = storageImpl.putPage(n2);
                        BitIndexPage.memcpy(page, n6, page, n6 + 1, n8 - n6 - 1);
                        BitIndexPage.memcpy(page, 1023 - n8 + 1, page, 1023 - n8, n8 - n6 - 1);
                        BitIndexPage.setnItems(page, --n8);
                        int n10 = n8 < 255 ? 2 : 0;
                        Object var12_13 = null;
                        if (page != null) {
                            storageImpl.pool.unfix(page);
                        }
                        return n10;
                    }
                    int n11 = 3;
                    Object var12_14 = null;
                    if (page != null) {
                        storageImpl.pool.unfix(page);
                    }
                    return n11;
                }
                try {
                    while (n7 < n6) {
                        int n12 = n7 + n6 >> 1;
                        if (n3 > BitIndexPage.getItem(page, n12)) {
                            n7 = n12 + 1;
                            continue;
                        }
                        n6 = n12;
                    }
                    n5 = BitIndexPage.remove(storageImpl, BitIndexPage.getItem(page, 1023 - n6 - 1), n3, n4);
                    if (n5 != 2) break block15;
                    storageImpl.pool.unfix(page);
                    page = null;
                    page = storageImpl.putPage(n2);
                    int n13 = BitIndexPage.handlePageUnderflow(storageImpl, page, n6, n4);
                    Object var12_15 = null;
                    if (page != null) {
                        storageImpl.pool.unfix(page);
                    }
                    return n13;
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var12_17 = null;
                        if (page == null) break block16;
                        storageImpl.pool.unfix(page);
                    }
                    throw throwable;
                }
            }
            int n14 = n5;
            Object var12_16 = null;
            if (page != null) {
                storageImpl.pool.unfix(page);
            }
            return n14;
        }
    }

    class BitIndexIterator
    implements PersistentIterator {
        int[] pageStack;
        int[] posStack;
        int sp = 0;
        int set;
        int clear;
        int counter;

        BitIndexIterator(int n2, int n3) {
            Page page;
            this.counter = BitIndexImpl.this.updateCounter;
            if (BitIndexImpl.this.height == 0) {
                return;
            }
            int n4 = BitIndexImpl.this.root;
            StorageImpl storageImpl = (StorageImpl)BitIndexImpl.this.getStorage();
            if (storageImpl == null) {
                throw new StorageError(16);
            }
            int n5 = BitIndexImpl.this.height;
            this.set = n2;
            this.clear = n3;
            this.pageStack = new int[n5];
            this.posStack = new int[n5];
            while (true) {
                this.pageStack[this.sp] = n4;
                page = storageImpl.getPage(n4);
                ++this.sp;
                if (--n5 == 0) break;
                n4 = BitIndexPage.getItem(page, 1022);
                storageImpl.pool.unfix(page);
            }
            this.gotoNextItem(page, 0);
        }

        public boolean hasNext() {
            if (this.counter != BitIndexImpl.this.updateCounter) {
                throw new ConcurrentModificationException();
            }
            return this.sp != 0;
        }

        public Object next() {
            return ((StorageImpl)BitIndexImpl.this.getStorage()).lookupObject(this.nextOid(), null);
        }

        public int nextOid() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageImpl storageImpl = (StorageImpl)BitIndexImpl.this.getStorage();
            int n2 = this.posStack[this.sp - 1];
            Page page = storageImpl.getPage(this.pageStack[this.sp - 1]);
            int n3 = BitIndexPage.getItem(page, 1022 - n2);
            this.gotoNextItem(page, n2 + 1);
            return n3;
        }

        private final void gotoNextItem(Page page, int n2) {
            StorageImpl storageImpl = (StorageImpl)BitIndexImpl.this.getStorage();
            do {
                int n3;
                int n4 = BitIndexPage.getnItems(page);
                while (n2 < n4) {
                    n3 = BitIndexPage.getItem(page, n2);
                    if ((this.set & n3) == this.set && (this.clear & n3) == 0) {
                        this.posStack[this.sp - 1] = n2;
                        storageImpl.pool.unfix(page);
                        return;
                    }
                    ++n2;
                }
                while (--this.sp != 0) {
                    storageImpl.pool.unfix(page);
                    n2 = this.posStack[this.sp - 1];
                    page = storageImpl.getPage(this.pageStack[this.sp - 1]);
                    if (++n2 > BitIndexPage.getnItems(page)) continue;
                    this.posStack[this.sp - 1] = n2;
                    do {
                        n3 = BitIndexPage.getItem(page, 1022 - n2);
                        storageImpl.pool.unfix(page);
                        page = storageImpl.getPage(n3);
                        this.pageStack[this.sp] = n3;
                        n2 = 0;
                        this.posStack[this.sp] = 0;
                    } while (++this.sp < this.pageStack.length);
                }
            } while (this.sp != 0);
            storageImpl.pool.unfix(page);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Key {
        int key;
        int oid;

        Key(int n2, int n3) {
            this.key = n2;
            this.oid = n3;
        }
    }
}

