/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.plugins;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.plugins.Declaration;
import org.apache.commons.gs.digester.plugins.LogUtils;
import org.apache.commons.gs.digester.plugins.PluginContext;
import org.apache.commons.gs.digester.plugins.PluginException;
import org.apache.commons.gs.digester.plugins.RuleFinder;
import org.apache.commons.gs.digester.plugins.RuleLoader;

public class PluginManager {
    private HashMap declarationsByClass = new HashMap();
    private HashMap declarationsById = new HashMap();
    private PluginManager parent;
    private PluginContext pluginContext;

    public PluginManager(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public PluginManager(PluginManager pluginManager) {
        this.parent = pluginManager;
        this.pluginContext = pluginManager.pluginContext;
    }

    public void addDeclaration(Declaration declaration) {
        Logger logger = LogUtils.getLogger(null);
        boolean bl2 = logger.isLoggable(Level.FINE);
        Class clazz = declaration.getPluginClass();
        String string = declaration.getId();
        this.declarationsByClass.put(clazz.getName(), declaration);
        if (string != null) {
            this.declarationsById.put(string, declaration);
            if (bl2) {
                logger.fine("Indexing plugin-id [" + string + "]" + " -> class [" + clazz.getName() + "]");
            }
        }
    }

    public Declaration getDeclarationByClass(String string) {
        Declaration declaration = (Declaration)this.declarationsByClass.get(string);
        if (declaration == null && this.parent != null) {
            declaration = this.parent.getDeclarationByClass(string);
        }
        return declaration;
    }

    public Declaration getDeclarationById(String string) {
        Declaration declaration = (Declaration)this.declarationsById.get(string);
        if (declaration == null && this.parent != null) {
            declaration = this.parent.getDeclarationById(string);
        }
        return declaration;
    }

    public RuleLoader findLoader(Digester digester, String string, Class clazz, Properties properties) throws PluginException {
        Logger logger = LogUtils.getLogger(digester);
        boolean bl2 = logger.isLoggable(Level.FINE);
        logger.fine("scanning ruleFinders to locate loader..");
        List list = this.pluginContext.getRuleFinders();
        RuleLoader ruleLoader = null;
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ruleLoader == null) {
                RuleFinder ruleFinder = (RuleFinder)iterator.next();
                if (bl2) {
                    logger.fine("checking finder of type " + ruleFinder.getClass().getName());
                }
                ruleLoader = ruleFinder.findLoader(digester, clazz, properties);
            }
        }
        catch (PluginException pluginException) {
            throw new PluginException("Unable to locate plugin rules for plugin with id [" + string + "]" + ", and class [" + clazz.getName() + "]" + ":" + pluginException.getMessage(), pluginException.getCause());
        }
        logger.fine("scanned ruleFinders.");
        return ruleLoader;
    }
}

