/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.parser;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XercesParser {
    public static Logger log = Logger.getLogger("org.apache.commons.gs.digester.Digester.sax");
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static String XERCES_DYNAMIC = "http://apache.org/xml/features/validation/dynamic";
    public static String XERCES_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static float version;
    public static String versionNumber;

    private static String getXercesVersion() {
        String string = "1.0";
        try {
            Class<?> clazz = Class.forName("org.apache.xerces.impl.Version");
            Method method = clazz.getMethod("getVersion", null);
            String string2 = (String)method.invoke(null, (Object[])null);
            string = string2.substring("Xerces-J".length(), string2.lastIndexOf("."));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static SAXParser newSAXParser(Properties properties) throws ParserConfigurationException, SAXException, SAXNotSupportedException {
        SAXParserFactory sAXParserFactory = (SAXParserFactory)properties.get("SAXParserFactory");
        if (versionNumber == null) {
            versionNumber = XercesParser.getXercesVersion();
            version = new Float(versionNumber).floatValue();
        }
        if ((double)version > 2.1) {
            XercesParser.configureXerces(sAXParserFactory);
            return sAXParserFactory.newSAXParser();
        }
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XercesParser.configureOldXerces(sAXParser, properties);
        return sAXParser;
    }

    private static void configureOldXerces(SAXParser sAXParser, Properties properties) throws ParserConfigurationException, SAXNotSupportedException {
        String string = (String)properties.get("schemaLocation");
        String string2 = (String)properties.get("schemaLanguage");
        try {
            if (string != null) {
                sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, string2);
                sAXParser.setProperty(JAXP_SCHEMA_SOURCE, string);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            log.info(sAXParser.getClass().getName() + ": " + sAXNotRecognizedException.getMessage() + " not supported.");
        }
    }

    private static void configureXerces(SAXParserFactory sAXParserFactory) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        sAXParserFactory.setFeature(XERCES_DYNAMIC, true);
        sAXParserFactory.setFeature(XERCES_SCHEMA, true);
    }

    static {
        versionNumber = null;
    }
}

