/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.collections;

import java.util.ArrayList;
import java.util.EmptyStackException;
import org.apache.commons.gs.collections.Buffer;
import org.apache.commons.gs.collections.BufferUnderflowException;

public class ArrayStack
extends ArrayList
implements Buffer {
    private static final long serialVersionUID = 2130079159931574599L;

    public ArrayStack() {
    }

    public ArrayStack(int n2) {
        super(n2);
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public Object peek() throws EmptyStackException {
        int n2 = this.size();
        if (n2 <= 0) {
            throw new EmptyStackException();
        }
        return this.get(n2 - 1);
    }

    public Object peek(int n2) throws EmptyStackException {
        int n3 = this.size() - n2 - 1;
        if (n3 < 0) {
            throw new EmptyStackException();
        }
        return this.get(n3);
    }

    public Object pop() throws EmptyStackException {
        int n2 = this.size();
        if (n2 <= 0) {
            throw new EmptyStackException();
        }
        return this.remove(n2 - 1);
    }

    public Object push(Object object) {
        this.add(object);
        return object;
    }

    public int search(Object object) {
        int n2 = this.size() - 1;
        int n3 = 1;
        while (n2 >= 0) {
            Object e2 = this.get(n2);
            if (object == null && e2 == null || object != null && object.equals(e2)) {
                return n3;
            }
            --n2;
            ++n3;
        }
        return -1;
    }

    public Object get() {
        int n2 = this.size();
        if (n2 == 0) {
            throw new BufferUnderflowException();
        }
        return this.get(n2 - 1);
    }

    public Object remove() {
        int n2 = this.size();
        if (n2 == 0) {
            throw new BufferUnderflowException();
        }
        return this.remove(n2 - 1);
    }
}

