/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodUtils {
    private static Logger log;
    private static boolean loggedAccessibleWarning;
    private static final Class[] emptyClassArray;
    private static final Object[] emptyObjectArray;
    private static WeakHashMap cache;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, true);
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            method.setAccessible(true);
            return method;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                if (!Modifier.isPublic(classArray2[i2].getModifiers())) continue;
                try {
                    method = classArray2[i2].getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i2], string, classArray)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String string, Class[] classArray) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Matching name=" + string + " on " + clazz);
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, false);
        try {
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = clazz.getMethod(string, classArray);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found straight match: " + method);
                log.finest("isPublic:" + Modifier.isPublic(method.getModifiers()));
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                if (!loggedAccessibleWarning) {
                    boolean bl2 = false;
                    try {
                        String string2 = System.getProperty("java.specification.version");
                        if (string2.charAt(0) == '1' && (string2.charAt(0) == '0' || string2.charAt(0) == '1' || string2.charAt(0) == '2' || string2.charAt(0) == '3')) {
                            bl2 = true;
                        }
                    }
                    catch (SecurityException securityException2) {
                        bl2 = true;
                    }
                    if (bl2) {
                        log.warning("Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                    }
                    loggedAccessibleWarning = true;
                }
                log.log(Level.FINE, "Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", securityException);
            }
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n2 = classArray.length;
            Method[] methodArray = clazz.getMethods();
            int n3 = methodArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Class<?>[] classArray2;
                int n4;
                if (!methodArray[i2].getName().equals(string)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found matching name:");
                    log.finest(methodArray[i2].toString());
                }
                if ((n4 = (classArray2 = methodArray[i2].getParameterTypes()).length) != n2) continue;
                boolean bl3 = true;
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Param=" + classArray[i3].getName());
                        log.finest("Method=" + classArray2[i3].getName());
                    }
                    if (MethodUtils.isAssignmentCompatible(classArray2[i3], classArray[i3])) continue;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(classArray2[i3] + " is not assignable from " + classArray[i3]);
                    }
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                Method method = MethodUtils.getAccessibleMethod(methodArray[i2]);
                if (method != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(method + " accessible version of " + methodArray[i2]);
                    }
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        if (!loggedAccessibleWarning) {
                            log.warning("Cannot use JVM pre-1.4 access bug workaround due to restrictive security manager.");
                            loggedAccessibleWarning = true;
                        }
                        log.log(Level.FINE, "Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", securityException);
                    }
                    cache.put(methodDescriptor, method);
                    return method;
                }
                log.finest("Couldn't find accessible method.");
            }
            log.finest("No match found.");
            return null;
        }
    }

    public static final boolean isAssignmentCompatible(Class clazz, Class clazz2) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz3 = MethodUtils.getPrimitiveWrapper(clazz)) != null) {
            return clazz3.equals(clazz2);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            Class<?> clazz2 = class$java$lang$Boolean;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
            }
            return clazz2;
        }
        if (Float.TYPE.equals(clazz)) {
            Class<?> clazz3 = class$java$lang$Float;
            if (clazz3 == null) {
                clazz3 = class$java$lang$Float = new Float[0].getClass().getComponentType();
            }
            return clazz3;
        }
        if (Long.TYPE.equals(clazz)) {
            Class<?> clazz4 = class$java$lang$Long;
            if (clazz4 == null) {
                clazz4 = class$java$lang$Long = new Long[0].getClass().getComponentType();
            }
            return clazz4;
        }
        if (Integer.TYPE.equals(clazz)) {
            Class<?> clazz5 = class$java$lang$Integer;
            if (clazz5 == null) {
                clazz5 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            return clazz5;
        }
        if (Short.TYPE.equals(clazz)) {
            Class<?> clazz6 = class$java$lang$Short;
            if (clazz6 == null) {
                clazz6 = class$java$lang$Short = new Short[0].getClass().getComponentType();
            }
            return clazz6;
        }
        if (Byte.TYPE.equals(clazz)) {
            Class<?> clazz7 = class$java$lang$Byte;
            if (clazz7 == null) {
                clazz7 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
            }
            return clazz7;
        }
        if (Double.TYPE.equals(clazz)) {
            Class<?> clazz8 = class$java$lang$Double;
            if (clazz8 == null) {
                clazz8 = class$java$lang$Double = new Double[0].getClass().getComponentType();
            }
            return clazz8;
        }
        if (Character.TYPE.equals(clazz)) {
            Class<?> clazz9 = class$java$lang$Character;
            if (clazz9 == null) {
                clazz9 = class$java$lang$Character = new Character[0].getClass().getComponentType();
            }
            return clazz9;
        }
        return null;
    }

    public static Class getPrimitiveType(Class clazz) {
        Class<?> clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        if (clazz2.equals(clazz)) {
            return Boolean.TYPE;
        }
        Class<?> clazz3 = class$java$lang$Float;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        if (clazz3.equals(clazz)) {
            return Float.TYPE;
        }
        Class<?> clazz4 = class$java$lang$Long;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        if (clazz4.equals(clazz)) {
            return Long.TYPE;
        }
        Class<?> clazz5 = class$java$lang$Integer;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        if (clazz5.equals(clazz)) {
            return Integer.TYPE;
        }
        Class<?> clazz6 = class$java$lang$Short;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        if (clazz6.equals(clazz)) {
            return Short.TYPE;
        }
        Class<?> clazz7 = class$java$lang$Byte;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        if (clazz7.equals(clazz)) {
            return Byte.TYPE;
        }
        Class<?> clazz8 = class$java$lang$Double;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        if (clazz8.equals(clazz)) {
            return Double.TYPE;
        }
        Class<?> clazz9 = class$java$lang$Character;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        if (clazz9.equals(clazz)) {
            return Character.TYPE;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Not a known primitive wrapper class: " + clazz);
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    static {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$MethodUtils;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$MethodUtils = new MethodUtils[0].getClass().getComponentType();
        }
        log = Logger.getLogger(clazz.getName());
        loggedAccessibleWarning = false;
        emptyClassArray = new Class[0];
        emptyObjectArray = new Object[0];
        cache = new WeakHashMap();
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class clazz, String string, Class[] classArray, boolean bl2) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (classArray == null) {
                classArray = emptyClassArray;
            }
            this.cls = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
            this.exact = bl2;
            this.hashCode = string.length();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

