/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.beanutils;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.beans.IndexedPropertyDescriptor;
import org.apache.commons.gs.beans.PropertyDescriptor;
import org.apache.commons.gs.beanutils.BeanUtils;
import org.apache.commons.gs.beanutils.ContextClassLoaderLocal;
import org.apache.commons.gs.beanutils.ConvertUtilsBean;
import org.apache.commons.gs.beanutils.DynaBean;
import org.apache.commons.gs.beanutils.DynaProperty;
import org.apache.commons.gs.beanutils.MappedPropertyDescriptor;
import org.apache.commons.gs.beanutils.PropertyUtilsBean;

public class BeanUtilsBean {
    private static final ContextClassLoaderLocal beansByClassLoader = new ContextClassLoaderLocal(){

        public Object initialValue() {
            return new BeanUtilsBean();
        }
    };
    private Logger log;
    private ConvertUtilsBean convertUtilsBean;
    private PropertyUtilsBean propertyUtilsBean;
    static /* synthetic */ Class class$org$apache$commons$gs$beanutils$BeanUtils;

    public static synchronized BeanUtilsBean getInstance() {
        return (BeanUtilsBean)beansByClassLoader.get();
    }

    public static synchronized void setInstance(BeanUtilsBean beanUtilsBean) {
        beansByClassLoader.set(beanUtilsBean);
    }

    public BeanUtilsBean() {
        this(new ConvertUtilsBean(), new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        Class<?> clazz = class$org$apache$commons$gs$beanutils$BeanUtils;
        if (clazz == null) {
            clazz = class$org$apache$commons$gs$beanutils$BeanUtils = new BeanUtils[0].getClass().getComponentType();
        }
        this.log = Logger.getLogger(clazz.getName());
        this.convertUtilsBean = convertUtilsBean;
        this.propertyUtilsBean = propertyUtilsBean;
    }

    public Object cloneBean(Object object) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Cloning bean: " + object.getClass().getName());
        }
        Class<?> clazz = object.getClass();
        DynaBean dynaBean = null;
        dynaBean = object instanceof DynaBean ? ((DynaBean)object).getDynaClass().newInstance() : (DynaBean)object.getClass().newInstance();
        this.getPropertyUtils().copyProperties(dynaBean, object);
        return dynaBean;
    }

    public void copyProperties(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        if (object == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("BeanUtils.copyProperties(" + object + ", " + object2 + ")");
        }
        if (object2 instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object2).getDynaClass().getDynaProperties();
            for (int i2 = 0; i2 < dynaPropertyArray.length; ++i2) {
                String string = dynaPropertyArray[i2].getName();
                if (!this.getPropertyUtils().isWriteable(object, string)) continue;
                Object object3 = ((DynaBean)object2).get(string);
                this.copyProperty(object, string, object3);
            }
        } else if (object2 instanceof Map) {
            Iterator iterator = ((Map)object2).keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.getPropertyUtils().isWriteable(object, string)) continue;
                Object v2 = ((Map)object2).get(string);
                this.copyProperty(object, string, v2);
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyUtils().getPropertyDescriptors(object2);
            for (int i3 = 0; i3 < propertyDescriptorArray.length; ++i3) {
                String string = propertyDescriptorArray[i3].getName();
                if ("class".equals(string) || !this.getPropertyUtils().isReadable(object2, string) || !this.getPropertyUtils().isWriteable(object, string)) continue;
                try {
                    Object object4 = this.getPropertyUtils().getSimpleProperty(object2, string);
                    this.copyProperty(object, string, object4);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }

    public void copyProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        Object object3;
        int n2;
        Object object4;
        if (this.log.isLoggable(Level.FINEST)) {
            object4 = new StringBuffer("  copyProperty(");
            ((StringBuffer)object4).append(object);
            ((StringBuffer)object4).append(", ");
            ((StringBuffer)object4).append(string);
            ((StringBuffer)object4).append(", ");
            if (object2 == null) {
                ((StringBuffer)object4).append("<NULL>");
            } else if (object2 instanceof String) {
                ((StringBuffer)object4).append((String)object2);
            } else if (object2 instanceof String[]) {
                String[] stringArray = (String[])object2;
                ((StringBuffer)object4).append('[');
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (i2 > 0) {
                        ((StringBuffer)object4).append(',');
                    }
                    ((StringBuffer)object4).append(stringArray[i2]);
                }
                ((StringBuffer)object4).append(']');
            } else {
                ((StringBuffer)object4).append(object2.toString());
            }
            ((StringBuffer)object4).append(')');
            this.log.finest(((StringBuffer)object4).toString());
        }
        object4 = object;
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            try {
                object4 = this.getPropertyUtils().getProperty(object, string.substring(0, n3));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            string = string.substring(n3 + 1);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("    Target bean = " + object4);
                this.log.finest("    Target name = " + string);
            }
        }
        String string2 = null;
        Class clazz = null;
        int n4 = -1;
        String string3 = null;
        string2 = string;
        int n5 = string2.indexOf(91);
        if (n5 >= 0) {
            n2 = string2.indexOf(93);
            try {
                n4 = Integer.parseInt(string2.substring(n5 + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = string2.substring(0, n5);
        }
        if ((n2 = string2.indexOf(40)) >= 0) {
            int n6 = string2.indexOf(41);
            try {
                string3 = string2.substring(n2 + 1, n6);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            string2 = string2.substring(0, n2);
        }
        if (object4 instanceof DynaBean) {
            object3 = ((DynaBean)object4).getDynaClass();
            DynaProperty dynaProperty = object3.getDynaProperty(string2);
            if (dynaProperty == null) {
                return;
            }
            clazz = dynaProperty.getType();
        } else {
            object3 = null;
            try {
                object3 = this.getPropertyUtils().getPropertyDescriptor(object4, string);
                if (object3 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            clazz = ((PropertyDescriptor)object3).getPropertyType();
            if (clazz == null) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("    target type for property '" + string2 + "' is null, so skipping ths setter");
                }
                return;
            }
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("    target propName=" + string2 + ", type=" + clazz + ", index=" + n4 + ", key=" + string3);
        }
        if (n4 >= 0) {
            object3 = this.getConvertUtils().lookup(clazz.getComponentType());
            if (object3 != null) {
                this.log.finest("        USING CONVERTER " + object3);
                object2 = object3.convert(clazz, object2);
            }
            try {
                this.getPropertyUtils().setIndexedProperty(object4, string2, n4, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
            }
        }
        if (string3 != null) {
            try {
                this.getPropertyUtils().setMappedProperty(object4, string2, string3, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
            }
        }
        object3 = this.getConvertUtils().lookup(clazz);
        if (object3 != null) {
            this.log.finest("        USING CONVERTER " + object3);
            object2 = object3.convert(clazz, object2);
        }
        try {
            this.getPropertyUtils().setSimpleProperty(object4, string2, object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
        }
    }

    public Map describe(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            return new HashMap();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Describing bean: " + object.getClass().getName());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object).getDynaClass().getDynaProperties();
            for (int i2 = 0; i2 < dynaPropertyArray.length; ++i2) {
                String string = dynaPropertyArray[i2].getName();
                hashMap.put(string, this.getProperty(object, string));
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyUtils().getPropertyDescriptors(object);
            for (int i3 = 0; i3 < propertyDescriptorArray.length; ++i3) {
                String string = propertyDescriptorArray[i3].getName();
                if (propertyDescriptorArray[i3].getReadMethod() == null) continue;
                hashMap.put(string, this.getProperty(object, string));
            }
        }
        return hashMap;
    }

    public String[] getArrayProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getProperty(object, string);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = ((Collection)object2).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(this.getConvertUtils().convert(e2));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        if (object2.getClass().isArray()) {
            int n2 = Array.getLength(object2);
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = Array.get(object2, i2);
                stringArray[i2] = object3 == null ? null : this.getConvertUtils().convert(object3);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{object2.toString()};
        return stringArray;
    }

    public String getIndexedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getIndexedProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public String getIndexedProperty(Object object, String string, int n2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getIndexedProperty(object, string, n2);
        return this.getConvertUtils().convert(object2);
    }

    public String getMappedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getMappedProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public String getMappedProperty(Object object, String string, String string2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getMappedProperty(object, string, string2);
        return this.getConvertUtils().convert(object2);
    }

    public String getNestedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getNestedProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public String getProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(object, string);
    }

    public String getSimpleProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getSimpleProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public void populate(Object object, Map map) throws IllegalAccessException, InvocationTargetException {
        if (object == null || map == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("BeanUtils.populate(" + object + ", " + map + ")");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            Object v2 = map.get(string);
            this.setProperty(object, string, v2);
        }
    }

    public void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        String[] stringArray;
        Object object3;
        int n2;
        Object object4;
        if (this.log.isLoggable(Level.FINEST)) {
            object4 = new StringBuffer("  setProperty(");
            ((StringBuffer)object4).append(object);
            ((StringBuffer)object4).append(", ");
            ((StringBuffer)object4).append(string);
            ((StringBuffer)object4).append(", ");
            if (object2 == null) {
                ((StringBuffer)object4).append("<NULL>");
            } else if (object2 instanceof String) {
                ((StringBuffer)object4).append((String)object2);
            } else if (object2 instanceof String[]) {
                String[] stringArray2 = (String[])object2;
                ((StringBuffer)object4).append('[');
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    if (i2 > 0) {
                        ((StringBuffer)object4).append(',');
                    }
                    ((StringBuffer)object4).append(stringArray2[i2]);
                }
                ((StringBuffer)object4).append(']');
            } else {
                ((StringBuffer)object4).append(object2.toString());
            }
            ((StringBuffer)object4).append(')');
            this.log.finest(((StringBuffer)object4).toString());
        }
        object4 = object;
        int n3 = this.findLastNestedIndex(string);
        if (n3 >= 0) {
            try {
                object4 = this.getPropertyUtils().getProperty(object, string.substring(0, n3));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            string = string.substring(n3 + 1);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("    Target bean = " + object4);
                this.log.finest("    Target name = " + string);
            }
        }
        String string2 = null;
        Class clazz = null;
        int n4 = -1;
        String string3 = null;
        string2 = string;
        int n5 = string2.indexOf(91);
        if (n5 >= 0) {
            n2 = string2.indexOf(93);
            try {
                n4 = Integer.parseInt(string2.substring(n5 + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = string2.substring(0, n5);
        }
        if ((n2 = string2.indexOf(40)) >= 0) {
            int n6 = string2.indexOf(41);
            try {
                string3 = string2.substring(n2 + 1, n6);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            string2 = string2.substring(0, n2);
        }
        if (object4 instanceof DynaBean) {
            object3 = ((DynaBean)object4).getDynaClass();
            stringArray = object3.getDynaProperty(string2);
            if (stringArray == null) {
                return;
            }
            clazz = stringArray.getType();
        } else {
            object3 = null;
            try {
                object3 = this.getPropertyUtils().getPropertyDescriptor(object4, string);
                if (object3 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            if (object3 instanceof MappedPropertyDescriptor) {
                if (((MappedPropertyDescriptor)object3).getMappedWriteMethod() == null) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((MappedPropertyDescriptor)object3).getMappedPropertyType();
            } else if (object3 instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)object3).getIndexedWriteMethod() == null) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((IndexedPropertyDescriptor)object3).getIndexedPropertyType();
            } else {
                if (((PropertyDescriptor)object3).getWriteMethod() == null) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((PropertyDescriptor)object3).getPropertyType();
            }
        }
        object3 = null;
        if (clazz.isArray() && n4 < 0) {
            if (object2 == null) {
                stringArray = new String[]{(String)object2};
                object3 = this.getConvertUtils().convert(stringArray, clazz);
            } else if (object2 instanceof String) {
                stringArray = new String[]{(String)object2};
                object3 = this.getConvertUtils().convert(stringArray, clazz);
            } else {
                object3 = object2 instanceof String[] ? this.getConvertUtils().convert((String[])object2, clazz) : object2;
            }
        } else {
            object3 = clazz.isArray() ? (object2 instanceof String ? this.getConvertUtils().convert((String)object2, clazz.getComponentType()) : (object2 instanceof String[] ? this.getConvertUtils().convert(((String[])object2)[0], clazz.getComponentType()) : object2)) : (object2 instanceof String || object2 == null ? this.getConvertUtils().convert((String)object2, clazz) : (object2 instanceof String[] ? this.getConvertUtils().convert(((String[])object2)[0], clazz) : (this.getConvertUtils().lookup(object2.getClass()) != null ? this.getConvertUtils().convert(object2.toString(), clazz) : object2)));
        }
        try {
            if (n4 >= 0) {
                this.getPropertyUtils().setIndexedProperty(object4, string2, n4, object3);
            } else if (string3 != null) {
                this.getPropertyUtils().setMappedProperty(object4, string2, string3, object3);
            } else {
                this.getPropertyUtils().setProperty(object4, string2, object3);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
        }
    }

    private int findLastNestedIndex(String string) {
        int n2 = 0;
        block5: for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '.': {
                    if (n2 >= 1) continue block5;
                    return i2;
                }
                case '(': 
                case '[': {
                    --n2;
                    continue block5;
                }
                case ')': 
                case ']': {
                    ++n2;
                }
            }
        }
        return -1;
    }

    public ConvertUtilsBean getConvertUtils() {
        return this.convertUtilsBean;
    }

    public PropertyUtilsBean getPropertyUtils() {
        return this.propertyUtilsBean;
    }
}

