/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceTransactionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.pf.joi.Inspector;

public class LockedObjectsViewPanel
extends JPanel {
    private SpaceBrowser _spaceBrowser;
    private JTable _objectsTable;
    private LockedObjectsTableModel _objectsTableModel;
    private IJSpace _selSpaceProxy;
    private final int CI_UID = 0;
    private final int CI_CLASS_NAME = 1;
    private final int CI_OPERATION_TYPE = 2;
    private final int CI_LOCK_TYPE = 3;
    private JTextField _transactionIDField = new JTextField();
    private JTextField _transactionTypeField = new JTextField();
    private JTextField _transactionStatusField = new JTextField();
    private JTextField _lockedObjectsAmountField = new JTextField();
    private Object obj;

    public LockedObjectsViewPanel(SpaceBrowser spaceBrowser) {
        this._spaceBrowser = spaceBrowser;
        this.initUI();
    }

    private void initUI() {
        this._objectsTableModel = new LockedObjectsTableModel(null);
        this._objectsTable = new JTable(this._objectsTableModel);
        JTableHeader jTableHeader = this._objectsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this._objectsTable.setAutoCreateColumnsFromModel(false);
        this._objectsTable.setSelectionMode(0);
        this._objectsTable.setAutoResizeMode(1);
        this._objectsTable.setAutoscrolls(true);
        TableColumnModel tableColumnModel = this._objectsTable.getColumnModel();
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        tableColumnModel.getColumn(3).setPreferredWidth(100);
        tableColumnModel.getColumn(1).setPreferredWidth(400);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(this._objectsTable);
        Box box = this.createLabelsNorthBox();
        this.setLayout(new BorderLayout());
        this.add((Component)box, "North");
        this.add((Component)jScrollPane, "Center");
        this.addMouseListenerToTable();
        this.setPreferredSize(new Dimension(500, 170));
    }

    private Box createLabelsNorthBox() {
        this._transactionIDField.setEditable(false);
        this._lockedObjectsAmountField.setEditable(false);
        this._transactionStatusField.setEditable(false);
        this._transactionTypeField.setEditable(false);
        Dimension dimension = new Dimension(180, 21);
        this._transactionIDField.setPreferredSize(dimension);
        this._lockedObjectsAmountField.setPreferredSize(dimension);
        this._transactionStatusField.setPreferredSize(dimension);
        this._transactionTypeField.setPreferredSize(dimension);
        Box box = new Box(1);
        JLabel jLabel = new JLabel("Transaction ID:");
        JLabel jLabel2 = new JLabel("Locked Objects:");
        JLabel jLabel3 = new JLabel("Type:");
        JLabel jLabel4 = new JLabel("Status:");
        Dimension dimension2 = new Dimension(81, 21);
        Dimension dimension3 = new Dimension(40, 21);
        jLabel.setPreferredSize(dimension2);
        jLabel2.setPreferredSize(dimension2);
        jLabel3.setPreferredSize(dimension3);
        jLabel4.setPreferredSize(dimension3);
        Box box2 = new Box(0);
        Box box3 = new Box(0);
        box2.add(Box.createHorizontalStrut(3));
        box2.add(jLabel);
        box2.add(Box.createHorizontalStrut(3));
        box2.add(this._transactionIDField);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(jLabel4);
        box2.add(Box.createHorizontalStrut(3));
        box2.add(this._transactionStatusField);
        box2.add(Box.createHorizontalStrut(5));
        box3.add(Box.createHorizontalStrut(3));
        box3.add(jLabel2);
        box3.add(Box.createHorizontalStrut(3));
        box3.add(this._lockedObjectsAmountField);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(jLabel3);
        box3.add(Box.createHorizontalStrut(3));
        box3.add(this._transactionTypeField);
        box3.add(Box.createHorizontalStrut(5));
        box.add(Box.createVerticalStrut(4));
        box.add(box2);
        box.add(Box.createVerticalStrut(4));
        box.add(box3);
        box.add(Box.createVerticalStrut(4));
        return box;
    }

    public void clear() {
        this._transactionIDField.setText("");
        this._transactionTypeField.setText("");
        this._transactionStatusField.setText("");
        this._lockedObjectsAmountField.setText("");
        this._objectsTableModel.clear();
    }

    private void addMouseListenerToTable() {
        this._objectsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n2 = LockedObjectsViewPanel.this._objectsTable.rowAtPoint(mouseEvent.getPoint());
                    UnderTxnLockedObject underTxnLockedObject = LockedObjectsViewPanel.this._objectsTableModel.getLockedObjectAt(n2);
                    if (underTxnLockedObject != null) {
                        final Object object = underTxnLockedObject.getUid();
                        LockedObjectsViewPanel.this.obj = null;
                        try {
                            LockedObjectsViewPanel.this.obj = JSpaceUtilities.getObjectFromSpaceByUid(LockedObjectsViewPanel.this._selSpaceProxy, object.toString());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            JOptionPane.showMessageDialog(SpaceBrowser.getInstance(), "The following class was not found. Please add it to the classpath:\n" + classNotFoundException.getMessage(), "Class Not Found", 2);
                            return;
                        }
                        catch (Exception exception) {
                            SpaceBrowser.showException(exception.toString(), exception);
                            return;
                        }
                        if (LockedObjectsViewPanel.this.obj == null) {
                            JOptionPane.showMessageDialog(LockedObjectsViewPanel.this._spaceBrowser, "Unable to inspect object. It can not be found, probably was already been removed from the space.", "Object not found", 1);
                            return;
                        }
                        final String string = LockedObjectsViewPanel.this.obj.getClass().getName();
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    LockedObjectsViewPanel.this._spaceBrowser.setCursor(Cursor.getPredefinedCursor(3));
                                    Inspector.inspect((String)object.toString(), (Object)LockedObjectsViewPanel.this.obj, null, (String)string);
                                }
                                finally {
                                    LockedObjectsViewPanel.this._spaceBrowser.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void displayLockedObjects(IJSpace iJSpace, List list, TransactionInfo transactionInfo) {
        this._selSpaceProxy = iJSpace;
        this._transactionIDField.setText(transactionInfo.getTxnId().toString());
        this._lockedObjectsAmountField.setText(String.valueOf(list.size()));
        int n2 = transactionInfo.getStatus();
        int n3 = transactionInfo.getType();
        this._transactionTypeField.setText(SpaceTransactionsPanel.getTransactionTypeName(n3));
        this._transactionStatusField.setText(SpaceTransactionsPanel.getTransactionStatusName(n2));
        this._objectsTableModel.setLockedObjectsList(list);
    }

    private class LockedObjectsTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{"UID", "Class Name", "Operation Type", "Lock Type"};
        private List _lockedObjectsList = new ArrayList();

        private LockedObjectsTableModel() {
        }

        public void clear() {
            int n2 = this._lockedObjectsList.size();
            if (n2 > 0) {
                this._lockedObjectsList.clear();
                this.fireTableRowsDeleted(0, n2 - 1);
            }
        }

        public Object getValueAt(int n2, int n3) {
            UnderTxnLockedObject underTxnLockedObject = (UnderTxnLockedObject)this._lockedObjectsList.get(n2);
            if (underTxnLockedObject != null) {
                return this.getCellValue(underTxnLockedObject, n3);
            }
            return null;
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public Class getColumnClass(int n2) {
            Object object = this.getValueAt(0, n2);
            if (object != null) {
                return object.getClass();
            }
            return null;
        }

        public int getRowCount() {
            return this._lockedObjectsList == null ? 0 : this._lockedObjectsList.size();
        }

        public List getLockedObjectsList() {
            return this._lockedObjectsList;
        }

        public UnderTxnLockedObject getLockedObjectAt(int n2) {
            return (UnderTxnLockedObject)this._lockedObjectsList.get(n2);
        }

        public String getCellValue(UnderTxnLockedObject underTxnLockedObject, int n2) {
            switch (n2) {
                case 0: {
                    return String.valueOf(underTxnLockedObject.getUid());
                }
                case 1: {
                    return String.valueOf(underTxnLockedObject.getClassName());
                }
                case 3: {
                    switch (underTxnLockedObject.getLockType()) {
                        case 1: {
                            return "Read Lock";
                        }
                        case 2: {
                            return "Write Lock";
                        }
                    }
                    return " - ";
                }
                case 2: {
                    switch (underTxnLockedObject.getOperationType()) {
                        case 6: {
                            return "Notify";
                        }
                        case 2: {
                            return "Read";
                        }
                        case 3: {
                            return "Read If Exists";
                        }
                        case 4: {
                            return "Take";
                        }
                        case 5: {
                            return "Take If Exists";
                        }
                        case 7: {
                            return "Update";
                        }
                        case 1: {
                            return "Write";
                        }
                    }
                    return " - ";
                }
            }
            return "";
        }

        public void setLockedObjectsList(List list) {
            int n2 = this._lockedObjectsList.size();
            int n3 = list.size();
            if (n2 > 0) {
                this.fireTableRowsDeleted(0, n2 - 1);
            }
            this._lockedObjectsList = list;
            if (n3 > 0) {
                this.fireTableRowsInserted(0, n3 - 1);
            }
        }

        public /* synthetic */ LockedObjectsTableModel(1 var2_2) {
            this();
        }
    }
}

