/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.filters;

import com.j_spaces.core.filters.GenericPrincipal;
import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.components.ItemsControlPanel;
import com.j_spaces.tools.filters.RolesManagerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class UserDefinedRoleDialog
extends JDialog {
    public RolesManagerDialog parentDialog;
    public JLabel labRoleName = new JLabel("Role name:");
    public JTextField txtfRoleName = new JTextField();
    public JCheckBox chboxWriteRole = new JCheckBox("Write");
    public JCheckBox chboxReadRole = new JCheckBox("Read");
    public JButton butOK = new JButton("OK");
    public JButton butCancel = new JButton("Cancel");
    public GrantAccessPanel grantPanel = new GrantAccessPanel();
    public UserDefinedRole delegatedRole;
    public Map attributesDataVectors;

    public UserDefinedRoleDialog(RolesManagerDialog rolesManagerDialog, boolean bl2) {
        super((Dialog)rolesManagerDialog, bl2);
        this.parentDialog = rolesManagerDialog;
        this.init();
        this.pack();
    }

    public void showDialogToAddNewRole() {
        this.setTitle("Add Role");
        this.txtfRoleName.setText("");
        this.txtfRoleName.setEditable(true);
        this.chboxReadRole.setSelected(false);
        this.chboxWriteRole.setSelected(false);
        this.grantPanel.entriesPanel.clean();
        this.grantPanel.attributesPanel.clean();
        this.grantPanel.lastSelectedEntry = null;
        this.attributesDataVectors = new HashMap();
        this.delegatedRole = null;
        this.show();
    }

    public void showDialogToEditRole(UserDefinedRole userDefinedRole) {
        this.delegatedRole = userDefinedRole;
        this.setTitle("Edit Role");
        this.txtfRoleName.setText(userDefinedRole.name);
        this.txtfRoleName.setEditable(false);
        this.chboxReadRole.setSelected(userDefinedRole.inheritRoles.contains("R"));
        this.chboxWriteRole.setSelected(userDefinedRole.inheritRoles.contains("W"));
        this.grantPanel.entriesPanel.clean();
        this.grantPanel.attributesPanel.clean();
        this.grantPanel.lastSelectedEntry = null;
        this.attributesDataVectors = new HashMap();
        Iterator iterator = userDefinedRole.restrictedEntries.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.grantPanel.entriesPanel.addRow(new Object[]{k2});
            Vector vector = new Vector();
            List list = (List)userDefinedRole.restrictedEntries.get(k2);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                GenericPrincipal.Attribute attribute = (GenericPrincipal.Attribute)list.get(i2);
                Vector<Object> vector2 = new Vector<Object>();
                vector2.add(0, attribute.name);
                vector2.add(1, attribute.value);
                vector.add(vector2);
            }
            this.attributesDataVectors.put(k2, vector);
        }
        if (userDefinedRole.restrictedEntries.size() > 0) {
            this.grantPanel.entriesPanel.setSelectedRow(0);
        }
        this.show();
    }

    public UserDefinedRole createUserDefinedRole() {
        Vector<String> vector = new Vector<String>();
        HashMap hashMap = new HashMap();
        if (this.chboxReadRole.isSelected()) {
            vector.add(String.valueOf('R'));
        }
        if (this.chboxWriteRole.isSelected()) {
            vector.add(String.valueOf('W'));
        }
        Iterator iterator = this.attributesDataVectors.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            Vector vector2 = (Vector)this.attributesDataVectors.get(k2);
            Vector<GenericPrincipal.Attribute> vector3 = new Vector<GenericPrincipal.Attribute>();
            for (int i2 = 0; i2 < vector2.size(); ++i2) {
                Vector vector4 = (Vector)vector2.get(i2);
                vector3.add(new GenericPrincipal.Attribute((String)vector4.get(0), vector4.get(1)));
            }
            hashMap.put(k2, vector3);
        }
        if (this.delegatedRole != null) {
            this.delegatedRole.previousName = this.delegatedRole.name;
            this.delegatedRole.name = this.txtfRoleName.getText().trim();
            this.delegatedRole.inheritRoles = vector;
            this.delegatedRole.restrictedEntries = hashMap;
            return this.delegatedRole;
        }
        return new UserDefinedRole(this.txtfRoleName.getText().trim(), vector, hashMap);
    }

    public boolean validateRoleDetails() {
        this.grantPanel.entriesPanel.stopCellEditing();
        this.grantPanel.attributesPanel.stopCellEditing();
        String string = this.txtfRoleName.getText().trim();
        if (string.equalsIgnoreCase(String.valueOf('W')) || string.equalsIgnoreCase(String.valueOf('R')) || string.equalsIgnoreCase(String.valueOf('A'))) {
            JOptionPane.showMessageDialog(this, "Role name should be different from letter W, R or A");
            return false;
        }
        boolean bl2 = false;
        if (this.delegatedRole != null && this.delegatedRole.name.equalsIgnoreCase(string)) {
            bl2 = true;
        }
        if (!bl2 && this.parentDialog.getRoleNamesList().contains(string)) {
            JOptionPane.showMessageDialog(this, "This is role name already exists");
            return false;
        }
        if (!this.chboxReadRole.isSelected() && !this.chboxWriteRole.isSelected()) {
            JOptionPane.showMessageDialog(this, "Please, select at least one of inherited role");
            return false;
        }
        if (!this.grantPanel.hasAtLeastOneClassName()) {
            JOptionPane.showMessageDialog(this, "Please, define at least one class name");
            return false;
        }
        return true;
    }

    private void init() {
        this.butCancel.setMnemonic(67);
        this.butCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDefinedRoleDialog.this.dispose();
            }
        });
        this.butOK.setMnemonic(79);
        this.butOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!UserDefinedRoleDialog.this.validateRoleDetails()) {
                    return;
                }
                UserDefinedRoleDialog.this.parentDialog.fromRoleDialog_pressedOK(UserDefinedRoleDialog.this.createUserDefinedRole());
                UserDefinedRoleDialog.this.dispose();
            }
        });
        this.txtfRoleName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                UserDefinedRoleDialog.this.butOK.setEnabled(UserDefinedRoleDialog.this.txtfRoleName.getText().trim().length() > 0);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Role Name"));
        jPanel.add((Component)this.txtfRoleName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Restrict System Roles"));
        jPanel2.add((Component)this.chboxWriteRole, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.chboxReadRole, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.butOK);
        jPanel4.add(this.butCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "North");
        this.getContentPane().add((Component)this.grantPanel, "Center");
        this.getContentPane().add((Component)jPanel4, "South");
    }

    public void show() {
        this.butOK.setEnabled(this.txtfRoleName.getText().trim().length() > 0);
        JSpaceUtilities.setLocationRelativeTo(this, this.parentDialog);
        super.show();
    }

    public class GrantAccessPanel
    extends JPanel {
        public Object lastSelectedEntry;
        public ItemsControlPanel entriesPanel = new ItemsControlPanel(new Object[]{"Class Name"});
        public ItemsControlPanel attributesPanel = new ItemsControlPanel(new Object[]{"Name", "Value"}, "Entry Attributes");

        public GrantAccessPanel() {
            this.attributesPanel.setDefaulColumnValues(new Object[]{"", ""});
            this.entriesPanel.setEditButtonVisible(false);
            this.attributesPanel.setEditButtonVisible(false);
            this.entriesPanel.getJTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (!listSelectionModel.isSelectionEmpty()) {
                        int n2 = listSelectionModel.getMinSelectionIndex();
                        Vector vector = GrantAccessPanel.this.entriesPanel.getDataModel().getDataVector().elementAt(n2);
                        String string = (String)vector.elementAt(0);
                        Vector vector2 = null;
                        if (string != null && string.trim().length() > 0) {
                            GrantAccessPanel.this.lastSelectedEntry = string;
                            vector2 = (Vector)UserDefinedRoleDialog.this.attributesDataVectors.get(string);
                        } else {
                            vector2 = new Vector();
                        }
                        GrantAccessPanel.this.attributesPanel.getDataModel().setDataVector(vector2, GrantAccessPanel.this.attributesPanel.columnIdentifiers);
                        GrantAccessPanel.this.attributesPanel.getButton("Add").setEnabled(true);
                    }
                }
            });
            this.entriesPanel.getDataModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() == 0) {
                        if (((DefaultTableModel)tableModelEvent.getSource()).getRowCount() <= 0) {
                            UserDefinedRoleDialog.this.attributesDataVectors = new HashMap();
                            GrantAccessPanel.this.attributesPanel.setEnabled(false);
                            GrantAccessPanel.this.attributesPanel.clean();
                        }
                        if (tableModelEvent.getFirstRow() != -1) {
                            Object object = ((DefaultTableModel)tableModelEvent.getSource()).getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                            UserDefinedRoleDialog.this.attributesDataVectors.put(object, GrantAccessPanel.this.attributesPanel.getDataModel().getDataVector());
                        }
                    }
                    if (tableModelEvent.getType() == -1) {
                        UserDefinedRoleDialog.this.attributesDataVectors.remove(GrantAccessPanel.this.lastSelectedEntry);
                        GrantAccessPanel.this.attributesPanel.setEnabled(false);
                        GrantAccessPanel.this.attributesPanel.clean();
                    }
                    if (tableModelEvent.getType() == 1) {
                        // empty if block
                    }
                }
            });
            this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Grant Access"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.entriesPanel, "Center");
            this.add((Component)this.attributesPanel, "South");
        }

        public boolean hasAtLeastOneClassName() {
            Iterator<Vector> iterator = this.entriesPanel.getDataModel().getDataVector().iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next().get(0);
                if (!(e2 instanceof String) || ((String)e2).trim().length() <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

