/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.components;

import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class ItemsControlPanel
extends JPanel {
    public static final String ADD_BUTTON_TEXT = "Add";
    public static final String EDIT_BUTTON_TEXT = "Edit";
    public static final String REMOVE_BUTTON_TEXT = "Remove";
    public static final String REMOVE_ALL_BUTTON_TEXT = "Remove All";
    public Vector columnIdentifiers;
    public Object[] columnDefaultValues;
    public String borderTitle;
    public boolean askConfirmation;
    public boolean actionListenerADD;
    public Map controls = new Hashtable();
    public JButton butAdd = new JButton();
    public JButton butEdit = new JButton();
    public JButton butRemove = new JButton();
    public JButton butRemoveAll = new JButton();
    public JPanel controlsPanel = new JPanel();
    public JTable jtable = new JTable();
    public JScrollPane tableScrollPanel = new JScrollPane();

    public ItemsControlPanel(Object[] objectArray, String string, boolean bl2) {
        this.borderTitle = string;
        this.askConfirmation = true;
        this.actionListenerADD = bl2;
        this.setColumnNames(objectArray);
        this.setDataModel(new DefaultTableModel(objectArray, 0));
        this.columnDefaultValues = new Object[objectArray.length];
        for (int i2 = 0; i2 < this.columnDefaultValues.length; ++i2) {
            this.columnDefaultValues[i2] = "";
        }
        this.init();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ItemsControlPanel(Object[] objectArray, String string) {
        this(objectArray, string, true);
    }

    public ItemsControlPanel(Object[] objectArray) {
        this(objectArray, null);
    }

    public ItemsControlPanel() {
        this(new Object[0], null);
    }

    public void addRow(Object[] objectArray) {
        this.getDataModel().addRow(objectArray);
    }

    public void setColumnNames(Object[] objectArray) {
        this.columnIdentifiers = ItemsControlPanel.convertToVector(objectArray);
    }

    public Object[] getColumnNames() {
        return this.columnIdentifiers.toArray();
    }

    public DefaultTableModel getDataModel() {
        return (DefaultTableModel)this.jtable.getModel();
    }

    public Vector getSelectedRowData() {
        int n2 = this.getJTable().getSelectedRow();
        return this.getDataModel().getDataVector().get(n2);
    }

    public boolean hasSelectedRow() {
        return this.getJTable().getSelectedRow() >= 0;
    }

    public void setSelectedRow(int n2) {
        this.getJTable().getSelectionModel().setSelectionInterval(n2, n2);
    }

    public void clean() {
        this.stopCellEditing();
        this.getDataModel().getDataVector().removeAllElements();
        this.getDataModel().setDataVector(new Object[0][], this.columnIdentifiers.toArray());
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        JSpaceUtilities.setAWTComponentsStatus(this.controlsPanel, bl2);
    }

    public void setDataModel(DefaultTableModel defaultTableModel) {
        this.jtable.setModel(defaultTableModel);
    }

    public void setEditButtonVisible(boolean bl2) {
        this.butEdit.setVisible(bl2);
    }

    public boolean isEditButtonVisible() {
        return this.butEdit.isVisible();
    }

    public JTable getJTable() {
        return this.jtable;
    }

    public void setDefaulColumnValues(Object[] objectArray) {
        this.columnDefaultValues = objectArray;
    }

    public Object[] getDefaulColumnValues() {
        return this.columnDefaultValues;
    }

    public AbstractButton getButton(String string) {
        return (AbstractButton)this.controls.get(string);
    }

    public void setControlsVisible(boolean bl2) {
        this.controlsPanel.setVisible(bl2);
    }

    public void stopCellEditing() {
        if (this.jtable.isEditing()) {
            this.jtable.getCellEditor().stopCellEditing();
        }
    }

    private void init() {
        this.jtable.setAutoscrolls(true);
        this.jtable.setAutoCreateColumnsFromModel(false);
        this.jtable.setSelectionMode(0);
        this.jtable.setPreferredScrollableViewportSize(new Dimension(360, 100));
        this.jtable.getTableHeader().addMouseListener(new ColumnSortListener());
        this.jtable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                boolean bl2 = ItemsControlPanel.this.jtable.getModel().getRowCount() > 0;
                ItemsControlPanel.this.butEdit.setEnabled(bl2);
                ItemsControlPanel.this.butRemove.setEnabled(bl2);
                ItemsControlPanel.this.butRemoveAll.setEnabled(bl2);
            }
        });
        this.jtable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                ItemsControlPanel.this.stopCellEditing();
            }
        });
        if (this.actionListenerADD) {
            this.butAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemsControlPanel.this.getDataModel().addRow(ItemsControlPanel.this.columnDefaultValues);
                }
            });
        }
        this.butRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2;
                if (ItemsControlPanel.this.jtable.isEditing()) {
                    ItemsControlPanel.this.jtable.getCellEditor().stopCellEditing();
                }
                if ((n2 = ItemsControlPanel.this.jtable.getSelectedRow()) != -1) {
                    ItemsControlPanel.this.getDataModel().removeRow(n2);
                }
            }
        });
        this.butRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ItemsControlPanel.this.jtable.isEditing()) {
                    ItemsControlPanel.this.jtable.getCellEditor().stopCellEditing();
                }
                if (ItemsControlPanel.this.askConfirmation && JOptionPane.showConfirmDialog(ItemsControlPanel.this, "Remove all items, are you sure?", "Confirmation", 0) == 1) {
                    return;
                }
                ItemsControlPanel.this.clean();
            }
        });
    }

    private void jbInit() throws Exception {
        this.butAdd.setText(ADD_BUTTON_TEXT);
        this.butRemove.setText(REMOVE_BUTTON_TEXT);
        this.butRemoveAll.setText(REMOVE_ALL_BUTTON_TEXT);
        this.butEdit.setText(EDIT_BUTTON_TEXT);
        this.controls.put(this.butAdd.getText(), this.butAdd);
        this.controls.put(this.butRemove.getText(), this.butRemove);
        this.controls.put(this.butRemoveAll.getText(), this.butRemoveAll);
        this.controls.put(this.butEdit.getText(), this.butEdit);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.controlsPanel.add((Component)this.butAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.controlsPanel.add((Component)this.butRemove, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(15, 2, 2, 2), 0, 0));
        this.controlsPanel.add((Component)this.butRemoveAll, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.controlsPanel.add((Component)this.butEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        if (this.borderTitle != null) {
            this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), this.borderTitle));
        }
        this.tableScrollPanel.getViewport().add((Component)this.jtable, null);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.controlsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tableScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            vector.addElement(objectArray[i2]);
        }
        return vector;
    }
}

