/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.j_spaces.core.EntryPacket;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.IRemoteJSpace;
import com.j_spaces.core.LeaseProxy;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.core.exception.SpaceUnavailableException;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.obf.a;
import com.j_spaces.obf.cj;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.IServiceManager;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.view.ClusterTree;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.sf.retrotranslator.runtime.java.lang._Thread;

public class ServiceManagerImpl
extends Thread
implements IServiceManager {
    public static final String PROPERTY_TIME_INTERVAL = "com.j_spaces.cluster.view.service_manager.interval";
    public static final int UPDATE_SPEED_HIGH = 1000;
    public static final int UPDATE_SPEED_NORMAL = 5000;
    public static final int UPDATE_SPEED_LOW = 10000;
    private static Vector m_membersOnline = new Vector();
    public static Hashtable m_replicationStatus = new Hashtable();
    public static Hashtable m_spacesConfig = new Hashtable();
    public String m_threadName;
    public int m_updateSpeed;
    public boolean m_paused;
    private Hashtable m_clusterSpaces;
    private Hashtable m_servicesID;
    private Hashtable m_leaseEntries;
    public EntryPacket m_pingEntry;
    public IRefreshable[] m_module;
    public ClusterTree m_clusterTree;
    public Vector m_dynamicWaitingForProxy;
    public Vector m_dynamicRegistered;
    public HashSet m_serviceCollector;
    private ClusterMemberInfo[] m_membersInfo;
    private a m_finder;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public ServiceManagerImpl(String string, IRefreshable[] iRefreshableArray) {
        block2: {
            this.m_threadName = string;
            this.m_module = iRefreshableArray;
            this.m_clusterSpaces = new Hashtable();
            this.m_servicesID = new Hashtable();
            this.m_leaseEntries = new Hashtable();
            this.m_dynamicWaitingForProxy = new Vector();
            this.m_dynamicRegistered = new Vector();
            this.m_serviceCollector = new HashSet();
            this.m_paused = true;
            try {
                this.m_updateSpeed = Integer.parseInt(System.getProperty(PROPERTY_TIME_INTERVAL, String.valueOf(5000)));
            }
            catch (Exception exception) {
                this.m_updateSpeed = 5000;
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        this.start();
    }

    public ServiceManagerImpl(String string) {
        this(string, null);
    }

    public ServiceManagerImpl() {
        this("ClusterViewSrvManager");
    }

    public void addService(ServiceItem serviceItem) {
        if (serviceItem.service != null && !this.m_servicesID.containsKey(serviceItem.serviceID)) {
            this.m_serviceCollector.add(serviceItem);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("addService() | " + serviceItem.service);
            }
        }
    }

    private void validateServices() {
        Iterator iterator = this.m_serviceCollector.iterator();
        while (iterator.hasNext()) {
            block14: {
                ServiceItem serviceItem = (ServiceItem)iterator.next();
                try {
                    if (serviceItem.service != null && serviceItem.service instanceof IJSpace) {
                        Entry[] entryArray = serviceItem.attributeSets;
                        String string = null;
                        String string2 = null;
                        String string3 = null;
                        boolean bl2 = false;
                        for (int i2 = 0; entryArray != null && i2 < entryArray.length; ++i2) {
                            if (entryArray[i2] != null && entryArray[i2] instanceof ClusterName && (string3 = ((ClusterName)entryArray[i2]).name) != null && !string3.equals("NONE")) {
                                string2 = string3;
                            }
                            if (entryArray[i2] == null || !(entryArray[i2] instanceof ContainerName)) continue;
                            string = ((ContainerName)entryArray[i2]).name;
                        }
                        if (string2 != null) {
                            IJSpace iJSpace = (IJSpace)serviceItem.service;
                            String string4 = string + ":" + iJSpace.getName();
                            if (this.m_clusterSpaces.containsKey(string4)) {
                                try {
                                    ((ClusterMember)this.m_clusterSpaces.get(string4)).getSpaceRemoteRef().ping();
                                }
                                catch (Exception exception) {
                                    if (_logger.isLoggable(Level.FINE)) {
                                        _logger.log(Level.FINE, "receive expected exception: ", exception);
                                    }
                                    this.addClusterSpace(string4, iJSpace, serviceItem.serviceID);
                                }
                            } else {
                                this.addClusterSpace(string4, iJSpace, serviceItem.serviceID);
                            }
                            if (bl2 && !this.m_dynamicRegistered.contains(string4)) {
                                this.m_dynamicRegistered.add(string4);
                            }
                            if (this.m_pingEntry == null) {
                                this.m_pingEntry = this.createPingEntry((IJSpace)serviceItem.service);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.FINE)) break block14;
                    _logger.log(Level.FINE, exception.toString(), exception);
                }
            }
            iterator.remove();
        }
    }

    private EntryPacket createPingEntry(IJSpace iJSpace) {
        EntryPacket entryPacket = ((IDirectSpaceProxy)iJSpace).constructEntryPacketFromEntry(new PingEntry());
        entryPacket.m_Transient = true;
        return entryPacket;
    }

    private void addClusterSpace(String string, IJSpace iJSpace, ServiceID serviceID) {
        block5: {
            if (this.m_servicesID.containsKey(serviceID) || this.m_clusterSpaces.containsKey(string)) {
                return;
            }
            try {
                IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)((Object)((IDirectSpaceProxy)iJSpace).getRemoteJSpace());
                this.m_clusterSpaces.put(string, new ClusterMember(iRemoteJSpaceAdmin, iJSpace, serviceID));
                this.m_servicesID.put(serviceID, string);
                this.m_leaseEntries.remove(string);
                if (this.m_pingEntry == null) {
                    this.m_pingEntry = this.createPingEntry(iJSpace);
                }
                m_spacesConfig.put(string, iRemoteJSpaceAdmin.getConfig());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("clustered space: " + string);
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(ServiceID serviceID) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removeService() | " + serviceID.toString());
        }
        String string = null;
        string = (String)this.m_servicesID.get(serviceID);
        if (string != null) {
            Hashtable hashtable = this.m_servicesID;
            synchronized (hashtable) {
                this.m_servicesID.remove(serviceID);
            }
            this.removeClusterMemberInfo(string);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("remove clustered space: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        if (!this.m_clusterSpaces.isEmpty()) {
            String string = null;
            IRemoteJSpace iRemoteJSpace = null;
            long l2 = Long.MAX_VALUE;
            Hashtable hashtable = this.m_clusterSpaces;
            synchronized (hashtable) {
                Iterator iterator = this.m_clusterSpaces.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    ClusterMember clusterMember = (ClusterMember)this.m_clusterSpaces.get(string);
                    iRemoteJSpace = (IRemoteJSpace)((Object)clusterMember.getSpaceRemoteRef());
                    try {
                        LeaseProxy leaseProxy = (LeaseProxy)this.m_leaseEntries.get(string);
                        if (!this.isPaused()) {
                            l2 = this.m_updateSpeed + 5000;
                        }
                        if (leaseProxy == null) {
                            leaseProxy = (LeaseProxy)iRemoteJSpace.write(this.m_pingEntry, null, l2, null, 0L);
                            cj.a(leaseProxy, iRemoteJSpace);
                            this.m_leaseEntries.put(string, leaseProxy);
                        }
                        iRemoteJSpace.ping();
                        leaseProxy.renew(l2);
                        if (!m_membersOnline.contains(string)) {
                            m_membersOnline.addElement(string);
                        }
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.fine("ping to " + string + " successful");
                    }
                    catch (Exception exception) {
                        if (exception instanceof InactiveSpaceException) {
                            if (m_membersOnline.contains(string)) continue;
                            m_membersOnline.addElement(string);
                            continue;
                        }
                        if (exception instanceof SpaceUnavailableException) {
                            m_membersOnline.remove(string);
                            m_replicationStatus.remove(string);
                            this.m_leaseEntries.remove(string);
                            continue;
                        }
                        if (exception instanceof UnknownLeaseException) {
                            this.cancelEntriesLease(this.m_leaseEntries);
                            continue;
                        }
                        if (exception instanceof SpaceUnavailableException) {
                            m_membersOnline.remove(string);
                            m_replicationStatus.remove(string);
                            continue;
                        }
                        if (exception instanceof RemoteException || exception instanceof NoSuchObjectException) {
                            iterator.remove();
                            this.m_servicesID.remove(clusterMember.getServiceID());
                            this.removeClusterMemberInfo(string);
                            if (!_logger.isLoggable(Level.FINE)) continue;
                            _logger.fine("ping to " + string + " faild");
                            continue;
                        }
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, exception.toString(), exception);
                    }
                }
            }
        }
    }

    private void removeClusterMemberInfo(String string) {
        this.m_clusterSpaces.remove(string);
        m_membersOnline.remove(string);
        m_replicationStatus.remove(string);
        this.m_leaseEntries.remove(string);
        this.m_dynamicRegistered.remove(string);
    }

    private void cancelEntriesLease(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                ((Lease)map.get(iterator.next())).cancel();
            }
            catch (Exception exception) {}
        }
        map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReplicationsStatus() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("updateReplicationsStatus()");
        }
        String string = null;
        IRemoteJSpaceAdmin iRemoteJSpaceAdmin = null;
        ReplicationStatus replicationStatus = null;
        ReplicationStatus replicationStatus2 = null;
        Hashtable hashtable = this.m_clusterSpaces;
        synchronized (hashtable) {
            if (!this.m_clusterSpaces.isEmpty()) {
                Iterator iterator = this.m_clusterSpaces.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    iRemoteJSpaceAdmin = ((ClusterMember)this.m_clusterSpaces.get(string)).getSpaceRemoteRef();
                    try {
                        if (iRemoteJSpaceAdmin == null || iRemoteJSpaceAdmin.getClusterPolicy() == null || !iRemoteJSpaceAdmin.getClusterPolicy().m_Replicated) continue;
                        replicationStatus2 = (ReplicationStatus)m_replicationStatus.get(string);
                        replicationStatus = new ReplicationStatus(iRemoteJSpaceAdmin.getReplicationStatus());
                        m_replicationStatus.put(string, replicationStatus);
                        if (replicationStatus2 == null || replicationStatus2.equals(replicationStatus)) continue;
                        this.findChangesInReplication(replicationStatus);
                    }
                    catch (Exception exception) {
                        if (exception instanceof SpaceUnavailableException || !_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, exception.toString(), exception);
                    }
                }
            }
        }
    }

    private void findChangesInReplication(ReplicationStatus replicationStatus) {
        String[] stringArray = replicationStatus.targets;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.m_dynamicRegistered.contains(stringArray[i2]) || this.m_dynamicWaitingForProxy.contains(stringArray[i2]) || this.m_clusterTree.isExistMember(stringArray[i2]) || this.m_clusterTree.isExistDynamicMember(stringArray[i2])) continue;
            this.m_dynamicWaitingForProxy.add(stringArray[i2]);
        }
    }

    private void updateDynamicChanges() {
        for (int i2 = 0; i2 < this.m_dynamicWaitingForProxy.size(); ++i2) {
            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = ((ClusterMember)this.m_clusterSpaces.get(this.m_dynamicWaitingForProxy.get(i2))).getSpaceRemoteRef();
            if (this.m_clusterTree == null || iRemoteJSpaceAdmin == null) continue;
            this.m_clusterTree.addDynamicMember(iRemoteJSpaceAdmin);
            this.m_dynamicWaitingForProxy.remove(i2);
        }
    }

    public void setClusterTreeReference(ClusterTree clusterTree) {
        this.m_clusterTree = clusterTree;
    }

    public void setRefreshModules(IRefreshable[] iRefreshableArray) {
        this.m_module = iRefreshableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshing() {
        if (this.m_module == null) return;
        IRefreshable[] iRefreshableArray = this.m_module;
        synchronized (this.m_module) {
            for (int i2 = 0; i2 < this.m_module.length; ++i2) {
                if (!this.m_module[i2].isRunning()) continue;
                this.m_module[i2].refresh();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static SpaceConfig getSpaceConfig(String string) {
        return (SpaceConfig)m_spacesConfig.get(string);
    }

    public static String getMemberStatus(String string, boolean bl2) {
        String string2 = bl2 ? "MirrorAlive" : "Alive";
        String string3 = bl2 ? "MirrorUnreachable" : "Unreachable";
        return m_membersOnline.contains(string) ? string2 : string3;
    }

    public static ReplicationStatus getReplicationStatus(String string) {
        return (ReplicationStatus)m_replicationStatus.get(string);
    }

    public synchronized void paused(boolean bl2, boolean bl3) {
        this.m_paused = bl2;
        if (!bl3) {
            this.notify();
        }
        if (bl2 && !bl3) {
            this.ping();
        }
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    public synchronized void setUpdateSpeed(int n2) {
        this.m_updateSpeed = n2;
        this.m_paused = false;
        this.notify();
    }

    public int getUpdateSpeed() {
        return this.m_updateSpeed;
    }

    public synchronized void shutdown() {
        this.paused(true, true);
        if (this.m_finder != null) {
            this.m_finder.a();
            this.m_finder = null;
        }
        Iterator iterator = this.m_clusterSpaces.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                ((IRemoteJSpace)((Object)((ClusterMember)this.m_clusterSpaces.get(iterator.next())).getSpaceRemoteRef())).clear(this.m_pingEntry, null, null, null, 0L);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, concurrentModificationException.toString(), concurrentModificationException);
                }
                return;
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("run()");
        }
        while (!this.isInterrupted()) {
            try {
                this.validateServices();
                this.ping();
                this.updateReplicationsStatus();
                this.refreshing();
                this.updateDynamicChanges();
                ServiceManagerImpl serviceManagerImpl = this;
                synchronized (serviceManagerImpl) {
                    this.wait(this.m_updateSpeed);
                }
                serviceManagerImpl = this;
                synchronized (serviceManagerImpl) {
                    if (this.m_paused) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, this.getName() + " interrupted.", interruptedException);
                }
                this.interrupt();
                break;
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    public void clearCurMembersInfo() {
        this.m_membersInfo = null;
    }

    public void setStaticClusterMembers(ClusterMemberInfo[] clusterMemberInfoArray) {
        if (this.m_membersInfo != clusterMemberInfoArray) {
            this.m_membersInfo = clusterMemberInfoArray;
            this.m_finder = new a(new FindSpaceTask(null), 2000L, 5000L);
        }
    }

    public ClusterMember getClusterMember(String string) {
        return (ClusterMember)this.m_clusterSpaces.get(string);
    }

    public static class 1 {
    }

    public static class PingEntry
    implements Entry {
        private static final long serialVersionUID = 1L;
        public String str = "PingEntry";
    }

    public static class ReplicationStatus {
        public String[] targets;
        public int[] tstatus;

        public ReplicationStatus(Object[] objectArray) {
            this.targets = (String[])objectArray[0];
            this.tstatus = (int[])objectArray[1];
        }

        public boolean equals(ReplicationStatus replicationStatus) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n2 = 0; n2 < this.targets.length; ++n2) {
                stringBuffer.append(this.targets[n2]);
            }
            for (n2 = 0; n2 < replicationStatus.targets.length; ++n2) {
                stringBuffer2.append(replicationStatus.targets[n2]);
            }
            byte[] byArray = stringBuffer.toString().getBytes();
            byte[] byArray2 = stringBuffer2.toString().getBytes();
            Arrays.sort(byArray);
            Arrays.sort(byArray2);
            return Arrays.equals(byArray, byArray2);
        }

        public String getMemberName(int n2) {
            if (this.targets != null && this.targets.length > 0 && n2 < this.targets.length) {
                return this.targets[n2];
            }
            return "none";
        }

        public void show() {
            for (int i2 = 0; i2 < this.targets.length; ++i2) {
                if (!_logger.isLoggable(Level.INFO)) continue;
                _logger.info(this.targets[i2] + ": " + this.tstatus[i2]);
            }
        }
    }

    public static class ClusterMember {
        private IRemoteJSpaceAdmin spaceRemoteRef = null;
        private IJSpace regularProxy = null;
        private IJSpace clusteredProxy = null;
        private ServiceID serviceID;

        public ClusterMember(IRemoteJSpaceAdmin iRemoteJSpaceAdmin, IJSpace iJSpace, ServiceID serviceID) {
            this.spaceRemoteRef = iRemoteJSpaceAdmin;
            this.serviceID = serviceID;
            if (iJSpace instanceof JSpaceClusteredProxy) {
                this.clusteredProxy = iJSpace;
            } else {
                this.regularProxy = iJSpace;
            }
        }

        public IRemoteJSpaceAdmin getSpaceRemoteRef() {
            return this.spaceRemoteRef;
        }

        public IJSpace getClusteredProxy() {
            return this.clusteredProxy;
        }

        public IJSpace getRegularProxy() {
            if (this.regularProxy == null) {
                this.init();
            }
            return this.regularProxy;
        }

        private void init() {
            block5: {
                if (this.clusteredProxy != null) {
                    try {
                        this.regularProxy = this.clusteredProxy.getContainer().getSpace(this.clusteredProxy.getName(), false);
                    }
                    catch (RemoteException remoteException) {
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.log(Level.SEVERE, remoteException.toString(), remoteException);
                        }
                    }
                    catch (NoSuchNameException noSuchNameException) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block5;
                        _logger.log(Level.SEVERE, noSuchNameException.toString(), noSuchNameException);
                    }
                }
            }
        }

        public ServiceID getServiceID() {
            return this.serviceID;
        }
    }

    private class FindSpaceTask
    implements Runnable {
        private FindSpaceTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ServiceManagerImpl.this.m_membersInfo == null || ServiceManagerImpl.this.m_membersInfo.length <= 0) {
                return;
            }
            ClusterMemberInfo[] clusterMemberInfoArray = ServiceManagerImpl.this.m_membersInfo;
            synchronized (clusterMemberInfoArray) {
                for (int i2 = 0; ServiceManagerImpl.this.m_membersInfo != null && i2 < ServiceManagerImpl.this.m_membersInfo.length; ++i2) {
                    if (ServiceManagerImpl.this.m_membersInfo == null || ServiceManagerImpl.this.m_clusterSpaces.contains(((ServiceManagerImpl)ServiceManagerImpl.this).m_membersInfo[i2].memberName)) continue;
                    try {
                        if (ServiceManagerImpl.this.m_membersInfo == null) continue;
                        IJSpace iJSpace = (IJSpace)SpaceFinder.find(((ServiceManagerImpl)ServiceManagerImpl.this).m_membersInfo[i2].memberURL);
                        Uuid uuid = ((ReferentUuid)((Object)iJSpace)).getReferentUuid();
                        if (ServiceManagerImpl.this.m_membersInfo == null) continue;
                        ServiceManagerImpl.this.addClusterSpace(((ServiceManagerImpl)ServiceManagerImpl.this).m_membersInfo[i2].memberName, iJSpace, new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()));
                        IJSpaceContainer iJSpaceContainer = iJSpace.getContainer();
                        if (SpaceBrowser.getInstance().isProxyExists(iJSpaceContainer)) continue;
                        Uuid uuid2 = ((ReferentUuid)((Object)iJSpaceContainer)).getReferentUuid();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("> ContainerUuid=" + uuid2 + "Thread id:" + _Thread.getId(Thread.currentThread()));
                        }
                        SpaceBrowser.getInstance().addContainerTree(iJSpaceContainer, new ServiceID(uuid2.getMostSignificantBits(), uuid2.getLeastSignificantBits()), false);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, exception.toString(), exception);
                    }
                }
            }
        }

        public /* synthetic */ FindSpaceTask(1 var2_2) {
            this();
        }
    }
}

