/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicClusterRefreshThread
extends Thread {
    private SpaceBrowser spaceBrowserInstance;
    private Map clusteredProxyMap = new HashMap(5);
    private final int updateTimeInterval = 10000;
    private boolean _isPaused = true;

    public DynamicClusterRefreshThread(SpaceBrowser spaceBrowser) {
        this.spaceBrowserInstance = spaceBrowser;
        this.clusteredProxyMap = Collections.synchronizedMap(this.clusteredProxyMap);
    }

    public void addDynamicClusteredProxy(String string, JSpaceClusteredProxy jSpaceClusteredProxy) {
        this.clusteredProxyMap.put(string, jSpaceClusteredProxy);
        if (this.isPaused()) {
            this.setPaused(false);
        }
    }

    public void clearDynamicClusteredProxy(String string) {
        this.clusteredProxyMap.remove(string);
        if (this.clusteredProxyMap.isEmpty()) {
            this.setPaused(true);
        }
    }

    private void updateActiveClusterMembers() {
        Set set = this.clusteredProxyMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            JSpaceClusteredProxy jSpaceClusteredProxy = (JSpaceClusteredProxy)entry.getValue();
            List list = jSpaceClusteredProxy.getActiveSpaces();
            this.spaceBrowserInstance.updateDynamicClusterMembers(string, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.updateActiveClusterMembers();
                    DynamicClusterRefreshThread dynamicClusterRefreshThread = this;
                    synchronized (dynamicClusterRefreshThread) {
                        this.wait(10000L);
                    }
                    dynamicClusterRefreshThread = this;
                    synchronized (dynamicClusterRefreshThread) {
                        if (this._isPaused) {
                            this.wait();
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.spaceBrowserInstance.debug(exception);
                continue;
            }
            break;
        }
    }

    public synchronized void setPaused(boolean bl2) {
        this._isPaused = bl2;
        this.notify();
    }

    public boolean isPaused() {
        return this._isPaused;
    }
}

