/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ISetPanel;
import com.j_spaces.tools.cluster.ISetParam;
import com.j_spaces.tools.cluster.NewGroup;
import com.j_spaces.tools.cluster.SetParamDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class GroupLBPanel
extends JPanel
implements ISetPanel {
    private JTabbedPane lbTabbedPane;
    private JPanel optionPan;
    private JPanel loadBalPanel;
    private JTextField implClassTF;
    private JCheckBox applyOwnershipCB;
    private JCheckBox defaultCB;
    private JCheckBox notifyCB;
    private JCheckBox readCB;
    private JCheckBox takeCB;
    private JCheckBox writeCB;
    private JComboBox readComBox;
    private JComboBox writeComBox;
    private JComboBox defaultComBox;
    private JComboBox notifyComBox;
    private JComboBox takeComBox;
    private LoadBalParamPanel writeLB;
    private LoadBalParamPanel readLB;
    private LoadBalParamPanel takeLB;
    private LoadBalParamPanel notifyLB;
    private LoadBalParamPanel defaultLB;
    private LoadBalParamPanel[] loadBalPanelArr;
    private ClusterMemberInfo[] allMembers;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");
    private boolean _isViewOnlyMode;

    public GroupLBPanel(GroupInfo.LoadBalancingInfo loadBalancingInfo, ClusterMemberInfo[] clusterMemberInfoArray, boolean bl2) {
        block2: {
            this.lbTabbedPane = new JTabbedPane();
            this.optionPan = new JPanel();
            this.loadBalPanel = new JPanel();
            this.implClassTF = new JTextField();
            this.applyOwnershipCB = new JCheckBox("Apply Ownership");
            this.defaultCB = new JCheckBox();
            this.notifyCB = new JCheckBox();
            this.readCB = new JCheckBox();
            this.takeCB = new JCheckBox();
            this.writeCB = new JCheckBox();
            this.readComBox = new JComboBox();
            this.writeComBox = new JComboBox();
            this.defaultComBox = new JComboBox();
            this.notifyComBox = new JComboBox();
            this.takeComBox = new JComboBox();
            this.writeLB = new LoadBalParamPanel(this, 1, null);
            this.readLB = new LoadBalParamPanel(this, 2, null);
            this.takeLB = new LoadBalParamPanel(this, 3, null);
            this.notifyLB = new LoadBalParamPanel(this, 4, null);
            this.defaultLB = new LoadBalParamPanel(this, 5, null);
            this.loadBalPanelArr = new LoadBalParamPanel[]{this.writeLB, this.readLB, this.takeLB, this.notifyLB, this.defaultLB};
            this._isViewOnlyMode = false;
            try {
                this._isViewOnlyMode = bl2;
                this.jbInit();
                this.init(loadBalancingInfo, clusterMemberInfoArray);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void init(GroupInfo.LoadBalancingInfo loadBalancingInfo, ClusterMemberInfo[] clusterMemberInfoArray) {
        this.allMembers = clusterMemberInfoArray;
        this.reset();
        this.updateGroupMembers(clusterMemberInfoArray);
        this.restoreSettings(loadBalancingInfo);
    }

    public GroupLBPanel(boolean bl2) {
        this(null, null, bl2);
    }

    private void jbInit() throws Exception {
        this.defaultCB.setText("Default:");
        this.defaultCB.setRequestFocusEnabled(false);
        this.defaultCB.addActionListener(new CheckBoxActionListener(this.defaultComBox, 4));
        this.optionPan.setLayout(new BorderLayout());
        this.optionPan.setLayout(new GridBagLayout());
        this.notifyCB.setText("Notify:");
        this.notifyCB.setRequestFocusEnabled(false);
        this.notifyCB.addActionListener(new CheckBoxActionListener(this.notifyComBox, 3));
        this.loadBalPanel.setLayout(new BorderLayout());
        this.writeCB.setText("Write:");
        this.writeCB.setRequestFocusEnabled(false);
        this.writeCB.addActionListener(new CheckBoxActionListener(this.writeComBox, 0));
        this.readCB.setText("Read:");
        this.readCB.setRequestFocusEnabled(false);
        this.readCB.addActionListener(new CheckBoxActionListener(this.readComBox, 1));
        this.takeCB.setText("Take:");
        this.takeCB.setRequestFocusEnabled(false);
        this.takeCB.addActionListener(new CheckBoxActionListener(this.takeComBox, 2));
        this.lbTabbedPane.add((Component)this.writeLB, "Write");
        this.lbTabbedPane.add((Component)this.readLB, "Read");
        this.lbTabbedPane.add((Component)this.takeLB, "Take");
        this.lbTabbedPane.add((Component)this.notifyLB, "Notify");
        this.lbTabbedPane.add((Component)this.defaultLB, "Default");
        this.setLoadBalPolicy(this.writeComBox);
        this.setLoadBalPolicy(this.readComBox);
        this.setLoadBalPolicy(this.takeComBox);
        this.setLoadBalPolicy(this.notifyComBox);
        this.setLoadBalPolicy(this.defaultComBox);
        Box box = this.createLoadBalancingMainComponents();
        this.loadBalPanel.add((Component)box, "North");
        this.loadBalPanel.add((Component)this.optionPan, "West");
        this.optionPan.add((Component)this.writeComBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.readComBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.takeComBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.notifyComBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.defaultComBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.defaultCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.notifyCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.takeCB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.readCB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.writeCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.loadBalPanel.add((Component)this.lbTabbedPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.loadBalPanel, "North");
    }

    private Box createLoadBalancingMainComponents() {
        Box box = new Box(1);
        JLabel jLabel = new JLabel("Implement Class Name:");
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(jLabel);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.implClassTF);
        box2.add(Box.createHorizontalGlue());
        Box box3 = new Box(0);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(this.applyOwnershipCB);
        box3.add(Box.createHorizontalGlue());
        box.add(Box.createVerticalStrut(5));
        box.add(box2);
        if (this._isViewOnlyMode) {
            box.add(Box.createVerticalStrut(3));
            box.add(box3);
        }
        box.add(Box.createVerticalGlue());
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3), BorderFactory.createTitledBorder("")));
        this.applyOwnershipCB.setMnemonic('A');
        this.applyOwnershipCB.setEnabled(false);
        return box;
    }

    private void setLoadBalPolicy(JComboBox jComboBox) {
        String[] stringArray = new String[]{"local-space", "round-robin", "fixed-by-hash", "hash-based", "weighted-round-robin", "weighted-hash"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            jComboBox.addItem(stringArray[i2]);
        }
    }

    private GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription createLoadBalancinPolicy(JComboBox jComboBox, Vector vector, String string) {
        GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription loadBalancingPolicyDescription = null;
        if (jComboBox.isEnabled()) {
            loadBalancingPolicyDescription = new GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription();
            loadBalancingPolicyDescription.m_PolicyType = (String)jComboBox.getSelectedItem();
            loadBalancingPolicyDescription.m_paramTable = vector != null && vector.size() > 0 ? vector : null;
            loadBalancingPolicyDescription.setBroadcastCondition(string);
        }
        return loadBalancingPolicyDescription;
    }

    public void reset() {
        int n2;
        this.implClassTF.setText("com.j_spaces.core.cluster.LoadBalanceImpl");
        this.applyOwnershipCB.setSelected(false);
        this.writeCB.setSelected(false);
        this.readCB.setSelected(false);
        this.takeCB.setSelected(false);
        this.notifyCB.setSelected(false);
        this.defaultCB.setSelected(true);
        for (n2 = 0; n2 < this.lbTabbedPane.getTabCount() - 1; ++n2) {
            this.lbTabbedPane.setEnabledAt(n2, false);
        }
        this.lbTabbedPane.setSelectedIndex(this.lbTabbedPane.getTabCount() - 1);
        this.writeComBox.setSelectedIndex(0);
        this.readComBox.setSelectedIndex(0);
        this.takeComBox.setSelectedIndex(0);
        this.notifyComBox.setSelectedIndex(0);
        this.defaultComBox.setSelectedIndex(0);
        for (n2 = 0; n2 < this.loadBalPanelArr.length; ++n2) {
            this.loadBalPanelArr[n2].clearPanel();
        }
        n2 = 0;
        this.writeComBox.setEnabled(n2 != 0 && this.writeCB.isSelected());
        this.readComBox.setEnabled(n2 != 0 && this.readCB.isSelected());
        this.takeComBox.setEnabled(n2 != 0 && this.takeCB.isSelected());
        this.notifyComBox.setEnabled(n2 != 0 && this.notifyCB.isSelected());
        this.defaultComBox.setEnabled(n2 != 0 && this.defaultCB.isSelected());
    }

    private void updateGroupMembers(ClusterMemberInfo[] clusterMemberInfoArray) {
        this.allMembers = clusterMemberInfoArray;
        if (this.allMembers != null) {
            for (int i2 = 0; i2 < this.allMembers.length; ++i2) {
                this.setParamDialogs(this.allMembers[i2].memberName);
            }
        }
    }

    public void setParamDialogs(String string) {
        for (int i2 = 0; i2 < this.loadBalPanelArr.length; ++i2) {
            this.loadBalPanelArr[i2].setParamDialog.setParamName(string);
        }
    }

    public void restoreSettings(Object object) {
        if (object == null) {
            return;
        }
        GroupInfo.LoadBalancingInfo loadBalancingInfo = (GroupInfo.LoadBalancingInfo)object;
        this.implClassTF.setText(loadBalancingInfo.m_ImplementationClassName);
        this.applyOwnershipCB.setSelected(loadBalancingInfo.isApplyOwnership());
        if (loadBalancingInfo.m_WriteOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(0, true);
            this.writeCB.setSelected(true);
            this.writeComBox.setEnabled(true);
            this.writeComBox.setSelectedItem(loadBalancingInfo.m_WriteOperationsPolicy.m_PolicyType);
            this.writeLB.setParam(loadBalancingInfo.m_WriteOperationsPolicy.m_paramTable);
            this.writeLB.setSelectedBroadcastCondition(loadBalancingInfo.m_WriteOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalancingInfo.m_ReadOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(1, true);
            this.readCB.setSelected(true);
            this.readComBox.setEnabled(true);
            this.readComBox.setSelectedItem(loadBalancingInfo.m_ReadOperationsPolicy.m_PolicyType);
            this.readLB.setParam(loadBalancingInfo.m_ReadOperationsPolicy.m_paramTable);
            this.readLB.setSelectedBroadcastCondition(loadBalancingInfo.m_ReadOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalancingInfo.m_TakeOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(2, true);
            this.takeCB.setSelected(true);
            this.takeComBox.setEnabled(true);
            this.takeComBox.setSelectedItem(loadBalancingInfo.m_TakeOperationsPolicy.m_PolicyType);
            this.takeLB.setParam(loadBalancingInfo.m_TakeOperationsPolicy.m_paramTable);
            this.takeLB.setSelectedBroadcastCondition(loadBalancingInfo.m_TakeOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalancingInfo.m_NotifyOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(3, true);
            this.notifyCB.setSelected(true);
            this.notifyComBox.setEnabled(true);
            this.notifyComBox.setSelectedItem(loadBalancingInfo.m_NotifyOperationsPolicy.m_PolicyType);
            this.notifyLB.setParam(loadBalancingInfo.m_NotifyOperationsPolicy.m_paramTable);
            this.notifyLB.setSelectedBroadcastCondition(loadBalancingInfo.m_NotifyOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalancingInfo.m_DefaultPolicy != null) {
            this.lbTabbedPane.setEnabledAt(4, true);
            this.defaultCB.setSelected(true);
            this.defaultComBox.setEnabled(true);
            this.defaultComBox.setSelectedItem(loadBalancingInfo.m_DefaultPolicy.m_PolicyType);
            this.defaultLB.setParam(loadBalancingInfo.m_DefaultPolicy.m_paramTable);
            this.defaultLB.setSelectedBroadcastCondition(loadBalancingInfo.m_DefaultPolicy.getBroadcastCondition());
        } else {
            this.lbTabbedPane.setEnabledAt(4, false);
            this.defaultCB.setSelected(false);
            this.defaultComBox.setEnabled(false);
        }
    }

    public Object saveSettings() {
        GroupInfo.LoadBalancingInfo loadBalancingInfo = new GroupInfo.LoadBalancingInfo();
        loadBalancingInfo.m_ImplementationClassName = this.implClassTF.getText().trim().length() > 0 ? this.implClassTF.getText().trim() : "com.j_spaces.core.cluster.LoadBalanceImpl";
        loadBalancingInfo.setApplyOwnership(this.applyOwnershipCB.isSelected());
        loadBalancingInfo.setProxyBroadcatThreadpoolMinSize(4);
        loadBalancingInfo.setProxyBroadcatThreadpoolMaxSize(64);
        loadBalancingInfo.m_WriteOperationsPolicy = this.createLoadBalancinPolicy(this.writeComBox, this.writeLB.lbModel.getDataVector(), this.writeLB.getSelectedBroadcastCondition());
        loadBalancingInfo.m_ReadOperationsPolicy = this.createLoadBalancinPolicy(this.readComBox, this.readLB.lbModel.getDataVector(), this.readLB.getSelectedBroadcastCondition());
        loadBalancingInfo.m_TakeOperationsPolicy = this.createLoadBalancinPolicy(this.takeComBox, this.takeLB.lbModel.getDataVector(), this.takeLB.getSelectedBroadcastCondition());
        loadBalancingInfo.m_NotifyOperationsPolicy = this.createLoadBalancinPolicy(this.notifyComBox, this.notifyLB.lbModel.getDataVector(), this.notifyLB.getSelectedBroadcastCondition());
        loadBalancingInfo.m_DefaultPolicy = this.createLoadBalancinPolicy(this.defaultComBox, this.defaultLB.lbModel.getDataVector(), this.defaultLB.getSelectedBroadcastCondition());
        return loadBalancingInfo;
    }

    public void setEnableComponentsStatus(boolean bl2) {
        JSpaceUtilities.setAWTComponentsStatus(this, bl2);
        this.writeComBox.setEnabled(bl2 && this.writeCB.isSelected());
        this.readComBox.setEnabled(bl2 && this.readCB.isSelected());
        this.takeComBox.setEnabled(bl2 && this.takeCB.isSelected());
        this.notifyComBox.setEnabled(bl2 && this.notifyCB.isSelected());
        this.defaultComBox.setEnabled(bl2 && this.defaultCB.isSelected());
        this.applyOwnershipCB.setEnabled(false);
    }

    public static class 1 {
    }

    private static class LoadBalParamPanel
    extends JPanel
    implements ISetParam {
        private DefaultTableModel lbModel;
        private JTable lbTable;
        private JButton removeButton = new JButton();
        private JButton addButton = new JButton();
        private JPanel lbButtonPan = new JPanel();
        private SetParamDialog setParamDialog;
        private JComboBox broadcastConditionComboBox = new JComboBox<String>(ClusterXML.BROADCAST_CONDITIONS_ARRAY);
        private short operatiionCode;
        public static final short OP_CODE_WRITE = 1;
        public static final short OP_CODE_READ = 2;
        public static final short OP_CODE_TAKE = 3;
        public static final short OP_CODE_NOTIFY = 4;
        public static final short OP_CODE_DEFAULT = 5;

        private LoadBalParamPanel(Component component, short s2) {
            this.operatiionCode = s2;
            this.setParamDialog = new SetParamDialog(this, new JDialog());
            this.setLayout(new BorderLayout());
            this.lbModel = new DefaultTableModel();
            this.lbTable = new JTable(this.lbModel);
            this.lbModel.addColumn("Param Name");
            this.lbModel.addColumn("Param Value");
            this.lbButtonPan.setLayout(new VerticalFlowLayout());
            this.lbButtonPan.add(this.addButton);
            this.lbButtonPan.add(this.removeButton);
            this.addButton.setText("Add...");
            this.removeButton.setText("Remove");
            this.removeButton.setRequestFocusEnabled(false);
            this.addButton.setRequestFocusEnabled(false);
            this.removeButton.setEnabled(false);
            JPanel jPanel = new JPanel(new BoxLayout2());
            jPanel.add(new JScrollPane(this.lbTable));
            jPanel.setPreferredSize(new Dimension(5, 5));
            this.add((Component)jPanel, "Center");
            this.add((Component)this.lbButtonPan, "East");
            Box box = this.createBroadcastConditionBox();
            this.add((Component)box, "South");
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LoadBalParamPanel.this.removeParams();
                }
            });
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LoadBalParamPanel.this.setParamDialog.showDialog();
                }
            });
        }

        public void setSelectedBroadcastCondition(String string) {
            this.broadcastConditionComboBox.setSelectedItem(string);
        }

        public String getSelectedBroadcastCondition() {
            return (String)this.broadcastConditionComboBox.getSelectedItem();
        }

        private Box createBroadcastConditionBox() {
            Box box = new Box(0);
            JLabel jLabel = new JLabel("Broadcast Condition:");
            this.broadcastConditionComboBox.setPreferredSize(new Dimension(140, 20));
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.broadcastConditionComboBox);
            box.add(Box.createHorizontalGlue());
            box.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 2));
            if (this.operatiionCode == 1 || this.operatiionCode == 4) {
                this.broadcastConditionComboBox.setSelectedItem("broadcast-disabled");
                this.broadcastConditionComboBox.setEnabled(false);
            }
            return box;
        }

        public void setEnabled(boolean bl2) {
            super.setEnabled(bl2);
            if (this.operatiionCode == 1 || this.operatiionCode == 4) {
                this.broadcastConditionComboBox.setEnabled(false);
            }
        }

        private void removeParams() {
            int[] nArray = this.lbTable.getSelectedRows();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.lbModel.removeRow(nArray[i2]);
            }
            this.lbTable.clearSelection();
            if (this.lbTable.getRowCount() <= 0) {
                this.removeButton.setEnabled(false);
            }
        }

        public void setParam(Vector vector) {
            if (vector != null) {
                this.lbModel.setDataVector(vector, ClusterMemberInfo.paramColNames);
                this.removeButton.setEnabled(true);
            }
        }

        public void setParams(String string, String string2) {
            for (int i2 = 0; i2 < this.lbModel.getRowCount(); ++i2) {
                Object object = this.lbModel.getValueAt(i2, 0);
                if (!object.equals(string)) continue;
                return;
            }
            this.lbModel.addRow(new Object[]{string, string2});
            this.removeButton.setEnabled(true);
            this.lbTable.clearSelection();
            if (this.lbTable.getRowCount() <= 0) {
                this.removeButton.setEnabled(false);
            }
        }

        public void clearPanel() {
            this.setParamDialog.comboModel.removeAllElements();
            this.lbModel.setDataVector(new Object[0][0], new Object[]{"Param Name", "Param Value"});
            this.removeButton.setEnabled(false);
            if (this.operatiionCode == 1 || this.operatiionCode == 4) {
                this.broadcastConditionComboBox.setSelectedItem("broadcast-disabled");
            } else {
                this.broadcastConditionComboBox.setSelectedItem("broadcast-if-null-values");
            }
        }

        public /* synthetic */ LoadBalParamPanel(Component component, short s2, 1 var3_3) {
            this(component, s2);
        }
    }

    public class CheckBoxActionListener
    implements ActionListener {
        public JComboBox comBox;
        public int index;

        public CheckBoxActionListener(JComboBox jComboBox, int n2) {
            this.comBox = jComboBox;
            this.index = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(GroupLBPanel.this.writeCB.isSelected() && GroupLBPanel.this.readCB.isSelected() && GroupLBPanel.this.takeCB.isSelected() && GroupLBPanel.this.notifyCB.isSelected())) {
                GroupLBPanel.this.lbTabbedPane.setEnabledAt(GroupLBPanel.this.lbTabbedPane.getTabCount() - 1, true);
                GroupLBPanel.this.lbTabbedPane.setSelectedIndex(this.index);
                GroupLBPanel.this.defaultCB.setSelected(true);
                GroupLBPanel.this.defaultComBox.setEnabled(true);
            }
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.comBox.setEnabled(jCheckBox.isSelected());
            GroupLBPanel.this.lbTabbedPane.setEnabledAt(this.index, jCheckBox.isSelected());
            if (jCheckBox.isSelected()) {
                GroupLBPanel.this.lbTabbedPane.setSelectedIndex(this.index);
            } else {
                GroupLBPanel.this.lbTabbedPane.setSelectedIndex(NewGroup.getEnabledTabIndex(GroupLBPanel.this.lbTabbedPane));
            }
        }
    }
}

