/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.lrmi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class MarshObject
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private byte[] _bytes;
    private int _hashCode;
    private transient Object _obj;

    public MarshObject() {
    }

    public MarshObject(byte[] byArray) {
        this.setBytes(byArray);
    }

    public void setObject(Object object) {
        this._obj = object;
    }

    public Object getObject(Object object) {
        return this._obj;
    }

    public final byte[] getBytes() {
        return this._bytes;
    }

    public final void setBytes(byte[] byArray) {
        this._bytes = byArray;
        this._hashCode = this._bytes == null ? 13 : MarshObject.computeHash(this._bytes);
    }

    public final boolean equals(Object object) {
        if (object instanceof MarshObject) {
            MarshObject marshObject = (MarshObject)object;
            return Arrays.equals(this._bytes, marshObject._bytes);
        }
        return false;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    private static final int computeHash(byte[] byArray) {
        int n2 = 0;
        byte[] byArray2 = byArray;
        int n3 = byArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2 = byArray2[i2];
            n2 = 31 * n2 + by2;
        }
        return n2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.innnerWriteExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.innerReadExternal(objectInput);
    }

    private final void innnerWriteExternal(DataOutput dataOutput) throws IOException {
        if (this._bytes == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(this._bytes.length);
            dataOutput.write(this._bytes);
            dataOutput.writeInt(this._hashCode);
        }
    }

    private final void innerReadExternal(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        if (n2 == -1) {
            this._bytes = null;
            this._hashCode = 13;
        } else {
            this._bytes = new byte[n2];
            dataInput.readFully(this._bytes);
            this._hashCode = dataInput.readInt();
        }
    }
}

