/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformVersion {
    public static String V_NUM = "5.2Cache";
    public static String V_LICENSE_NUM = "5.0Cache";
    public static final String BUILD_NUM = "1708";
    public static final String V_NAME = "GigaSpaces Platform(TM)";
    private static Logger _logger = Logger.getLogger("com.gigaspaces.kernel");

    public static String getOfficialVersion() {
        return "GigaSpaces Platform(TM) " + V_NUM + " Build: " + BUILD_NUM;
    }

    public static void createBuildNumberPropertyFile() {
        FileOutputStream fileOut = null;
        PrintStream ps = null;
        try {
            fileOut = new FileOutputStream("build.properties", true);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        ps = new PrintStream(fileOut);
        ps.println("buildnumber=1708");
        ps.println("tag=" + PlatformVersion.getTag());
        ps.println("versionnumber=" + V_NUM);
        ps.close();
    }

    public static String getTag() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        String date = dateFormat.format(new Date());
        String tag = "build1708_" + date;
        return tag;
    }

    public static String getBuildNumber() {
        return BUILD_NUM;
    }

    public static String getVersionNumber() {
        return V_NUM;
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            PlatformVersion.createBuildNumberPropertyFile();
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("********************************************\n " + PlatformVersion.getOfficialVersion() + "\n********************************************\n");
        }
    }
}

