/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.GSIterator;
import com.j_spaces.jms.GSBytesMessageImpl;
import com.j_spaces.jms.GSMapMessageImpl;
import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSObjectMessageImpl;
import com.j_spaces.jms.GSQueueSessionImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSStreamMessageImpl;
import com.j_spaces.jms.GSTextMessageImpl;
import com.j_spaces.jms.MessagePool;
import com.j_spaces.jms.utils.ByteArray;
import com.j_spaces.jms.utils.ConversionHelper;
import com.j_spaces.kernel.lrmi.MarshObject;
import com.j_spaces.kernel.time.SystemTime;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import net.jini.core.entry.UnusableEntryException;

public class GSQueueBrowserImpl
implements QueueBrowser {
    private GSSessionImpl a;
    private Queue b;
    private String c;
    private boolean d = false;
    private static Logger e = Logger.getLogger("com.gigaspaces.jms");
    private static final int f = Integer.getInteger("com.gs.jms.iterator.buffersize", 1000);
    private GSIterator g;

    public GSQueueBrowserImpl(GSSessionImpl gSSessionImpl, Queue queue, String string) throws JMSException {
        this.a = gSSessionImpl;
        this.b = queue;
        this.c = string;
        if (this.b == null) {
            throw new InvalidDestinationException("GSQueueBrowserImpl Invalid queue: " + this.b);
        }
        ExternalEntry externalEntry = new ExternalEntry(this.b.getQueueName(), new Object[17], GSMessageImpl.m_ExtEntryFieldsNames);
        externalEntry.m_FieldsTypes = GSMessageImpl.m_ExtEntryFieldsTypes;
        externalEntry.setFifo(true);
        externalEntry.setIndexIndicators(MessagePool.extEntryIndexes);
        ArrayList<ExternalEntry> arrayList = new ArrayList<ExternalEntry>(1);
        arrayList.add(externalEntry);
        try {
            this.g = new GSIterator(this.a.getConn().getSpace(), arrayList, f, true, Long.MAX_VALUE);
        }
        catch (RemoteException remoteException) {
            if (e.isLoggable(Level.SEVERE)) {
                e.log(Level.SEVERE, "Exception inside GSQueueBrowserImpl: " + remoteException.toString(), remoteException);
            }
            JMSException jMSException = new JMSException("RemoteException: " + remoteException.getMessage());
            jMSException.setLinkedException(remoteException);
            throw jMSException;
        }
        catch (UnusableEntryException unusableEntryException) {
            if (unusableEntryException instanceof EntryNotInSpaceException) {
                if (e.isLoggable(Level.FINE)) {
                    e.log(Level.FINE, "The Entry " + ((EntryNotInSpaceException)unusableEntryException).getUID() + " is no longer in Space " + unusableEntryException.getCause(), unusableEntryException);
                }
            }
            JMSException jMSException = new JMSException("UnusableEntryException : ");
            jMSException.setLinkedException(unusableEntryException);
            throw jMSException;
        }
    }

    public String toString() {
        return "QueueBrowser for the session:" + this.a.toString();
    }

    public Queue getQueue() throws JMSException {
        if (this.d) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return this.b;
    }

    public String getMessageSelector() throws JMSException {
        if (this.d) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return this.c;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this.d) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return new QueueEnumeration(this.g, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            if (!this.d) {
                if (e.isLoggable(Level.FINE)) {
                    e.fine("GSQueueBrowserImpl.close() closing browser: " + this.toString());
                }
                ((GSQueueSessionImpl)this.a).removeBrower(this);
            }
            this.d = true;
        }
        finally {
            if (null != this.g) {
                this.g.cancel();
                this.g = null;
            }
        }
    }

    private GSMessageImpl a(ExternalEntry externalEntry) {
        GSMessageImpl gSMessageImpl;
        block35: {
            gSMessageImpl = null;
            try {
                Object object;
                Object object2;
                Serializable serializable;
                long l2;
                block34: {
                    l2 = 0L;
                    if (e.isLoggable(Level.FINE)) {
                        l2 = SystemTime.timeMillis();
                    }
                    String string = externalEntry.m_FieldsValues[9].toString();
                    Object object3 = externalEntry.m_FieldsValues[0];
                    if (string.equals("Text")) {
                        if (object3 != null) {
                            serializable = null;
                            if (object3 instanceof MarshObject) {
                                serializable = (MarshObject)object3;
                                object2 = null;
                                try {
                                    object2 = this.a.a((MarshObject)serializable);
                                    gSMessageImpl = (GSTextMessageImpl)this.a.createTextMessage(object2.toString());
                                }
                                catch (IOException iOException) {
                                    if (e.isLoggable(Level.SEVERE)) {
                                        e.log(Level.SEVERE, iOException.toString(), iOException);
                                    }
                                    break block34;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    if (e.isLoggable(Level.SEVERE)) {
                                        e.log(Level.SEVERE, classNotFoundException.toString(), classNotFoundException);
                                    }
                                    break block34;
                                }
                            }
                            gSMessageImpl = (GSTextMessageImpl)this.a.createTextMessage(object3.toString());
                        } else {
                            gSMessageImpl = (GSTextMessageImpl)this.a.createTextMessage(null);
                        }
                    } else if (string.equals("Map")) {
                        gSMessageImpl = (GSMapMessageImpl)this.a.createMapMessage((HashMap)object3);
                    } else if (string.equals("Object")) {
                        gSMessageImpl = (GSObjectMessageImpl)this.a.createObjectMessage((Serializable)object3);
                    } else if (string.equals("Bytes")) {
                        gSMessageImpl = (GSBytesMessageImpl)this.a.createBytesMessage(((ByteArray)object3).getBuf());
                    } else if (string.equals("Stream")) {
                        gSMessageImpl = (GSStreamMessageImpl)this.a.createStreamMessage();
                        ((GSStreamMessageImpl)gSMessageImpl).setStreamBody((ByteArray)object3);
                    } else if (string.equals("Simple")) {
                        gSMessageImpl = (GSMessageImpl)this.a.createMessage();
                    } else {
                        throw new JMSException("An un-supoorted JMS Message Type < " + string + " > was used.");
                    }
                }
                gSMessageImpl.setBodyRO(true);
                serializable = gSMessageImpl.getOptionalHeaders();
                ((HashMap)serializable).put("JMSMessageID", externalEntry.m_FieldsValues[5]);
                gSMessageImpl.setPropertiesRO(false);
                gSMessageImpl.setToDestination((Destination)externalEntry.m_FieldsValues[1]);
                ((HashMap)serializable).put("JMSDestination", externalEntry.m_FieldsValues[1]);
                gSMessageImpl.setJMSDestination((Destination)externalEntry.m_FieldsValues[1]);
                ((HashMap)serializable).put("JMSDeliveryMode", externalEntry.m_FieldsValues[2]);
                gSMessageImpl.m_timeToLive = ConversionHelper.getLong(externalEntry.m_FieldsValues[12]);
                gSMessageImpl.setJMSExpiration(ConversionHelper.getLong(externalEntry.m_FieldsValues[3]));
                ((HashMap)serializable).put("JMSPriority", externalEntry.m_FieldsValues[4]);
                ((HashMap)serializable).put("JMSTimestamp", externalEntry.m_FieldsValues[6]);
                object2 = externalEntry.m_FieldsValues[7];
                if (object2 instanceof byte[]) {
                    gSMessageImpl.setJMSCorrelationIDAsBytes((byte[])object2);
                } else if (object2 instanceof String) {
                    gSMessageImpl.setJMSCorrelationID(object2.toString());
                }
                Object object4 = externalEntry.m_FieldsValues[8];
                if (object4 != null) {
                    gSMessageImpl.setJMSReplyTo((Destination)object4);
                } else {
                    gSMessageImpl.setJMSReplyTo(null);
                }
                Object object5 = externalEntry.m_FieldsValues[10];
                if (object5 == null) {
                    ((HashMap)serializable).put("JMSRedelivered", MessagePool.constBoolValues[0]);
                } else {
                    ((HashMap)serializable).put("JMSRedelivered", object5);
                }
                gSMessageImpl.getOptionalHeaders().putAll(serializable);
                HashMap hashMap = gSMessageImpl.getProperties();
                hashMap.put("JMS_GSProducerKey", externalEntry.m_FieldsValues[11].toString());
                Object object6 = externalEntry.m_FieldsValues[16];
                if (object6 != null) {
                    hashMap.putAll((HashMap)object6);
                }
                hashMap.put("JMSXAppID", this.a.getJMSProviderName());
                hashMap.put("JMSXUserID", externalEntry.m_FieldsValues[15]);
                hashMap.put("JMSXRcvTimestamp", new Long(SystemTime.timeMillis()));
                gSMessageImpl.getProperties().putAll(hashMap);
                Object object7 = externalEntry.m_FieldsValues[13];
                if (object7 != null) {
                    gSMessageImpl.setObjectProperty("JMSXGroupID", object7);
                }
                if ((object = externalEntry.m_FieldsValues[14]) != null) {
                    gSMessageImpl.setObjectProperty("JMSXGroupSeq", object);
                }
                gSMessageImpl.m_replyToId = externalEntry.m_ClassName;
                gSMessageImpl.m_externalEntry = externalEntry;
                gSMessageImpl.m_replyToQueue = true;
                gSMessageImpl.setMessageToBeSent(false);
                if (e.isLoggable(Level.FINE)) {
                    double d2 = SystemTime.timeMillis() - l2;
                    e.fine("Session: " + this.a + "  |  prepareTime:  " + d2 + " |  JMSMessage: " + gSMessageImpl.toString() + "  |  extEntry.m_UID: " + externalEntry.m_UID + " | extEntry.m_className: " + externalEntry.m_ClassName);
                }
            }
            catch (JMSException jMSException) {
                if (!e.isLoggable(Level.SEVERE)) break block35;
                e.log(Level.SEVERE, jMSException.toString(), jMSException);
            }
        }
        return gSMessageImpl;
    }

    public static class 1 {
    }

    private class QueueEnumeration
    implements Enumeration {
        private GSIterator b;

        private QueueEnumeration(GSIterator gSIterator) {
            this.b = gSIterator;
        }

        public boolean hasMoreElements() {
            if (this.b == null) {
                return false;
            }
            return this.b.hasNext();
        }

        public Object nextElement() {
            if (this.b == null || !this.b.hasNext()) {
                throw new NoSuchElementException();
            }
            return GSQueueBrowserImpl.this.a((ExternalEntry)this.b.next());
        }

        public /* synthetic */ QueueEnumeration(GSIterator gSIterator, 1 var3_3) {
            this(gSIterator);
        }
    }
}

